/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.performance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.cnd.discovery.performance.PerformanceIssueDetector;

public class AnalyzeStat {
    private AnalyzeStat() {
    }

    static void process(TreeMap<String, AgregatedStat> gatherStat) {
        AnalyzeStat.upEmptyFolder(gatherStat);
        AnalyzeStat.getBigUnused(gatherStat);
        AnalyzeStat.groupByReadingSpeed(gatherStat);
        AnalyzeStat.dumpAll(gatherStat);
        AnalyzeStat.getSlowReading(gatherStat);
    }

    static List<Map.Entry<String, AgregatedStat>> getBigUnused(TreeMap<String, AgregatedStat> gatherStat) {
        ArrayList<Map.Entry<String, AgregatedStat>> orphan = new ArrayList<Map.Entry<String, AgregatedStat>>();
        ArrayList<Map.Entry<String, AgregatedStat>> list = new ArrayList<Map.Entry<String, AgregatedStat>>(gatherStat.entrySet());
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry next;
            Map.Entry entry = (Map.Entry)list.get(i);
            String path = (String)entry.getKey();
            AgregatedStat stat = (AgregatedStat)entry.getValue();
            if (stat.readNumber != 0 || stat.parseNumber != 0 || stat.itemTime / 1000000000L <= 10L || i + 1 >= list.size() || ((String)(next = (Map.Entry)list.get(i + 1)).getKey()).startsWith(path + "/") || ((String)next.getKey()).startsWith(path + "\\")) continue;
            AgregatedStat copy = new AgregatedStat();
            AnalyzeStat.mergeEntryes(copy, (AgregatedStat)entry.getValue());
            orphan.add(new MyEntry((String)entry.getKey(), copy));
        }
        list.clear();
        Collections.sort(orphan, new Comparator<Map.Entry<String, AgregatedStat>>(){

            @Override
            public int compare(Map.Entry<String, AgregatedStat> o1, Map.Entry<String, AgregatedStat> o2) {
                return (int)(o2.getValue().itemTime / 1000L / 1000L - o1.getValue().itemTime / 1000L / 1000L);
            }
        });
        return orphan;
    }

    static List<Map.Entry<String, AgregatedStat>> getSlowReading(TreeMap<String, AgregatedStat> gatherStat) {
        ArrayList<Map.Entry<String, AgregatedStat>> slow = new ArrayList<Map.Entry<String, AgregatedStat>>();
        ArrayList<Map.Entry<String, AgregatedStat>> list = new ArrayList<Map.Entry<String, AgregatedStat>>(gatherStat.entrySet());
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry next;
            Map.Entry entry = (Map.Entry)list.get(i);
            String path = (String)entry.getKey();
            AgregatedStat stat = (AgregatedStat)entry.getValue();
            if (stat.readTime / 1000000000L <= 10L || stat.readCPU <= 0L || stat.readTime / stat.readCPU <= 10L || i + 1 >= list.size() || ((String)(next = (Map.Entry)list.get(i + 1)).getKey()).startsWith(path + "/") || ((String)next.getKey()).startsWith(path + "\\")) continue;
            AgregatedStat copy = new AgregatedStat();
            AnalyzeStat.mergeEntryes(copy, (AgregatedStat)entry.getValue());
            slow.add(new MyEntry((String)entry.getKey(), copy));
        }
        list.clear();
        Collections.sort(slow, new Comparator<Map.Entry<String, AgregatedStat>>(){

            @Override
            public int compare(Map.Entry<String, AgregatedStat> o1, Map.Entry<String, AgregatedStat> o2) {
                int k1 = (int)(o1.getValue().readTime / o1.getValue().readCPU);
                int k2 = (int)(o2.getValue().readTime / o2.getValue().readCPU);
                return k2 - k1;
            }
        });
        return slow;
    }

    static void upEmptyFolder(TreeMap<String, AgregatedStat> gatherStat) {
        ArrayList<Map.Entry<String, AgregatedStat>> list = new ArrayList<Map.Entry<String, AgregatedStat>>(gatherStat.entrySet());
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry next;
            Map.Entry entry = (Map.Entry)list.get(i);
            String path = (String)entry.getKey();
            AgregatedStat stat = (AgregatedStat)entry.getValue();
            if (stat.readNumber != 0 || stat.parseNumber != 0) continue;
            boolean doAgregate = true;
            int nextItem = i;
            int addItem = 0;
            long addTime = 0L;
            long addCPU = 0L;
            long addUser = 0L;
            int j = i + 1;
            while (j < list.size() && (((String)(next = (Map.Entry)list.get(j)).getKey()).startsWith(path + "/") || ((String)next.getKey()).startsWith(path + "\\"))) {
                if (((AgregatedStat)next.getValue()).parseNumber == 0 && ((AgregatedStat)next.getValue()).readNumber == 0) {
                    addItem += ((AgregatedStat)next.getValue()).itemNumber;
                    addTime += ((AgregatedStat)next.getValue()).itemTime;
                    addCPU += ((AgregatedStat)next.getValue()).itemCPU;
                    addUser += ((AgregatedStat)next.getValue()).itemUser;
                } else {
                    doAgregate = false;
                    break;
                }
                nextItem = j++;
            }
            if (!doAgregate) continue;
            stat.itemNumber += addItem;
            stat.itemTime += addTime;
            stat.itemCPU += addCPU;
            stat.itemUser += addUser;
            for (j = i + 1; j <= nextItem; ++j) {
                next = (Map.Entry)list.get(j);
                gatherStat.remove(next.getKey());
            }
            i = nextItem;
        }
    }

    static void groupByReadingSpeed(TreeMap<String, AgregatedStat> gatherStat) {
        int start;
        do {
            start = gatherStat.size();
            AnalyzeStat.getGroupByReadingSpeedImpl(gatherStat);
        } while (gatherStat.size() != start);
    }

    private static void getGroupByReadingSpeedImpl(TreeMap<String, AgregatedStat> gatherStat) {
        ArrayList<Map.Entry<String, AgregatedStat>> list = new ArrayList<Map.Entry<String, AgregatedStat>>(gatherStat.entrySet());
        int i = 0;
        while (i < list.size()) {
            Map.Entry next;
            Map.Entry entry = (Map.Entry)list.get(i);
            String path = (String)entry.getKey();
            AgregatedStat stat = (AgregatedStat)entry.getValue();
            int segment = 0;
            boolean hasRoot = true;
            int j = i + 1;
            while (j < list.size() && (((String)(next = (Map.Entry)list.get(j)).getKey()).startsWith(path + "/") || ((String)next.getKey()).startsWith(path + "\\"))) {
                String subFolder = ((String)next.getKey()).substring(path.length() + 1);
                if (subFolder.indexOf(92) > 0 || subFolder.indexOf(47) > 0) {
                    segment = 0;
                    break;
                }
                segment = j++;
            }
            if (segment == 0) {
                int k = path.lastIndexOf(47);
                if (k < 0) {
                    k = path.lastIndexOf(92);
                }
                if (k > 0) {
                    Map.Entry next2;
                    String dir = path.substring(0, k);
                    if (i > 0 && (dir.equals(((Map.Entry)list.get(i - 1)).getKey()) || ((String)((Map.Entry)list.get(i - 1)).getKey()).startsWith(dir + "/") || ((String)((Map.Entry)list.get(i - 1)).getKey()).startsWith(dir + "\\"))) {
                        ++i;
                        continue;
                    }
                    int j2 = i;
                    while (j2 < list.size() && (((String)(next2 = (Map.Entry)list.get(j2)).getKey()).startsWith(dir + "/") || ((String)next2.getKey()).startsWith(dir + "\\"))) {
                        String subFolder = ((String)next2.getKey()).substring(dir.length() + 1);
                        if (subFolder.indexOf(92) > 0 || subFolder.indexOf(47) > 0) {
                            segment = 0;
                            break;
                        }
                        segment = j2++;
                    }
                    if (segment == i) {
                        ++i;
                        continue;
                    }
                    if (segment > 0) {
                        stat = new AgregatedStat();
                        gatherStat.put(dir, stat);
                        hasRoot = false;
                    }
                }
            }
            if (segment > 0) {
                Map.Entry next3;
                int j3;
                long time = 0L;
                long cpu = 0L;
                for (int j4 = i; j4 <= segment; ++j4) {
                    Map.Entry next4 = (Map.Entry)list.get(j4);
                    AgregatedStat value = (AgregatedStat)next4.getValue();
                    time += value.readTime;
                    cpu += value.readCPU;
                }
                long averigeRatio = 0L;
                if (time > 0L && cpu > 0L) {
                    averigeRatio = time / cpu;
                }
                boolean canMerge = true;
                if (averigeRatio > 0L) {
                    for (j3 = i; j3 <= segment; ++j3) {
                        long currentRatio;
                        next3 = (Map.Entry)list.get(j3);
                        AgregatedStat value = (AgregatedStat)next3.getValue();
                        if (value.readTime / 1000000000L <= 10L || value.readCPU <= 0L || averigeRatio / 3L < (currentRatio = value.readTime / value.readCPU) && currentRatio < averigeRatio * 3L) continue;
                        canMerge = false;
                        break;
                    }
                }
                if (canMerge) {
                    int n = j3 = hasRoot ? i + 1 : i;
                    while (j3 <= segment) {
                        next3 = (Map.Entry)list.get(j3);
                        AnalyzeStat.mergeEntryes(stat, (AgregatedStat)next3.getValue());
                        gatherStat.remove(next3.getKey());
                        ++j3;
                    }
                }
                i = segment;
            }
            ++i;
        }
    }

    private static void mergeEntryes(AgregatedStat stat, AgregatedStat from) {
        stat.itemNumber += from.itemNumber;
        stat.itemTime += from.itemTime;
        stat.itemCPU += from.itemCPU;
        stat.itemUser += from.itemUser;
        stat.readNumber += from.readNumber;
        stat.readBytes += from.readBytes;
        stat.readLines += from.readLines;
        stat.readTime += from.readTime;
        stat.readCPU += from.readCPU;
        stat.readUser += from.readUser;
        stat.parseNumber += from.parseNumber;
        stat.parseLines += from.parseLines;
        stat.parseTime += from.parseTime;
        stat.parseCPU += from.parseCPU;
        stat.parseUser += from.parseUser;
    }

    static void dumpAll(TreeMap<String, AgregatedStat> gatherStat) {
        if (!PerformanceIssueDetector.LOG.isLoggable(PerformanceIssueDetector.level)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Projects statistic\nitem\ttime\tCPU\tratio\tread\tlines\ttime\tCPU\tratio\tparse\tlines\ttime\tCPU\tratio\tfolder");
        for (Map.Entry<String, AgregatedStat> entry : gatherStat.entrySet()) {
            AgregatedStat value = entry.getValue();
            buf.append('\n');
            buf.append(PerformanceIssueDetector.format(value.itemNumber)).append('\t');
            buf.append(PerformanceIssueDetector.format(value.itemTime / 1000000000L)).append('\t');
            buf.append(PerformanceIssueDetector.format(value.itemCPU / 1000000000L)).append('\t');
            if (value.itemTime / 1000000000L > 10L && value.itemCPU > 0L) {
                buf.append(PerformanceIssueDetector.format(value.itemTime / value.itemCPU)).append('\t');
            } else {
                buf.append('-').append('\t');
            }
            buf.append(PerformanceIssueDetector.format(value.readNumber)).append('\t');
            buf.append(PerformanceIssueDetector.format(value.readLines)).append('\t');
            buf.append(PerformanceIssueDetector.format(value.readTime / 1000000000L)).append('\t');
            buf.append(PerformanceIssueDetector.format(value.readCPU / 1000000000L)).append('\t');
            if (value.readTime / 1000000000L > 10L && value.readCPU > 0L) {
                buf.append(PerformanceIssueDetector.format(value.readTime / value.readCPU)).append('\t');
            } else {
                buf.append('-').append('\t');
            }
            buf.append(PerformanceIssueDetector.format(value.parseNumber)).append('\t');
            buf.append(PerformanceIssueDetector.format(value.parseLines)).append('\t');
            buf.append(PerformanceIssueDetector.format(value.parseTime / 1000000000L)).append('\t');
            buf.append(PerformanceIssueDetector.format(value.parseCPU / 1000000000L)).append('\t');
            if (value.parseTime / 1000000000L > 10L && value.parseCPU > 0L) {
                buf.append(PerformanceIssueDetector.format(value.parseTime / value.parseCPU)).append('\t');
            } else {
                buf.append('-').append('\t');
            }
            buf.append(entry.getKey());
        }
        buf.append('\n');
        PerformanceIssueDetector.LOG.log(PerformanceIssueDetector.level, buf.toString());
    }

    private static final class MyEntry
    implements Map.Entry<String, AgregatedStat> {
        private final String key;
        private AgregatedStat value;

        MyEntry(String key, AgregatedStat value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public AgregatedStat getValue() {
            return this.value;
        }

        @Override
        public AgregatedStat setValue(AgregatedStat value) {
            AgregatedStat prev = this.value;
            this.value = value;
            return prev;
        }
    }

    static final class AgregatedStat {
        int itemNumber;
        long itemTime;
        long itemCPU;
        long itemUser;
        int readNumber;
        long readBytes;
        long readLines;
        long readTime;
        long readCPU;
        long readUser;
        int parseNumber;
        long parseLines;
        long parseTime;
        long parseCPU;
        long parseUser;

        AgregatedStat() {
        }
    }
}

