/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.ObjCRuntime;
import org.clang.basic.SanitizerKind;
import org.clang.basic.VersionTuple;
import org.clang.driver.Driver;
import org.clang.driver.ToolChain;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.MachO;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.option.Option;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_string_ostream;
import org.llvm.support.sys.path;

public class Darwin
extends MachO
implements Destructors.ClassWithDestructor {
    public boolean TargetInitialized = false;
    public DarwinPlatformKind TargetPlatform;
    public VersionTuple TargetVersion = new VersionTuple();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AddDeploymentTarget(DerivedArgList Args) {
        StringRef SDKName;
        JavaCleaner $c$;
        DarwinPlatformKind Platform;
        int StartVer;
        StringRef SDK;
        JavaCleaner $c$2;
        OptTable Opts = this.getDriver().getOpts();
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_isysroot.getValue()));
        if (A != null) {
            if (!this.getVFS().exists(new Twine(A.getValue()))) {
                JavaCleaner $c$3 = Native.$createJavaCleaner();
                try {
                    $c$3.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$3.track((Object)this.getDriver().Diag(408))), (char.ptr)A.getValue()));
                }
                finally {
                    $c$3.$destroy();
                }
            }
        } else {
            char.ptr env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"SDKROOT")));
            if (env != null && path.is_absolute((Twine)new Twine(env)) && this.getVFS().exists(new Twine(env)) && llvm.$noteq_StringRef((StringRef)new StringRef(env), (String)"/")) {
                Args.append(Args.MakeSeparateArg((Arg)null, Opts.getOption(new OptSpecifier(options.ID.OPT_isysroot.getValue())), new StringRef(env)));
            }
        }
        Arg OSXVersion = Args.getLastArg(new OptSpecifier(options.ID.OPT_mmacosx_version_min_EQ.getValue()));
        Arg iOSVersion = Args.getLastArg(new OptSpecifier(options.ID.OPT_miphoneos_version_min_EQ.getValue()));
        Arg TvOSVersion = Args.getLastArg(new OptSpecifier(options.ID.OPT_mtvos_version_min_EQ.getValue()));
        Arg WatchOSVersion = Args.getLastArg(new OptSpecifier(options.ID.OPT_mwatchos_version_min_EQ.getValue()));
        if (OSXVersion != null && (iOSVersion != null || TvOSVersion != null || WatchOSVersion != null)) {
            $c$2 = Native.$createJavaCleaner();
            try {
                $c$2.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$2.track((Object)this.getDriver().Diag(306))), (StringRef)new StringRef(OSXVersion.getAsString((ArgList)Args))), (StringRef)new StringRef((iOSVersion != null ? iOSVersion : (TvOSVersion != null ? TvOSVersion : WatchOSVersion)).getAsString((ArgList)Args))));
                WatchOSVersion = null;
                TvOSVersion = null;
                iOSVersion = null;
            }
            finally {
                $c$2.$destroy();
            }
        }
        if (iOSVersion != null && (TvOSVersion != null || WatchOSVersion != null)) {
            $c$2 = Native.$createJavaCleaner();
            try {
                $c$2.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$2.track((Object)this.getDriver().Diag(306))), (StringRef)new StringRef(iOSVersion.getAsString((ArgList)Args))), (StringRef)new StringRef((TvOSVersion != null ? TvOSVersion : WatchOSVersion).getAsString((ArgList)Args))));
                WatchOSVersion = null;
                TvOSVersion = null;
            }
            finally {
                $c$2.$destroy();
            }
        }
        if (TvOSVersion != null && WatchOSVersion != null) {
            $c$2 = Native.$createJavaCleaner();
            try {
                $c$2.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$2.track((Object)this.getDriver().Diag(306))), (StringRef)new StringRef(TvOSVersion.getAsString((ArgList)Args))), (StringRef)new StringRef(WatchOSVersion.getAsString((ArgList)Args))));
                WatchOSVersion = null;
            }
            finally {
                $c$2.$destroy();
            }
        }
        if (OSXVersion == null && iOSVersion == null && TvOSVersion == null && WatchOSVersion == null) {
            Option O;
            JavaCleaner $c$4;
            StringRef isysroot;
            Arg A2;
            std.string OSXTarget = new std.string();
            std.string iOSTarget = new std.string();
            std.string TvOSTarget = new std.string();
            std.string WatchOSTarget = new std.string();
            char.ptr env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"MACOSX_DEPLOYMENT_TARGET")));
            if (env != null) {
                OSXTarget.$assign(env);
            }
            if ((env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"IPHONEOS_DEPLOYMENT_TARGET")))) != null) {
                iOSTarget.$assign(env);
            }
            if ((env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"TVOS_DEPLOYMENT_TARGET")))) != null) {
                TvOSTarget.$assign(env);
            }
            if ((env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"WATCHOS_DEPLOYMENT_TARGET")))) != null) {
                WatchOSTarget.$assign(env);
            }
            if (OSXTarget.empty() && iOSTarget.empty() && WatchOSTarget.empty() && TvOSTarget.empty() && Args.hasArg(new OptSpecifier(options.ID.OPT_isysroot.getValue())) && (A2 = Args.getLastArg(new OptSpecifier(options.ID.OPT_isysroot.getValue()))) != null && Unsigned.$greater_uint((int)(SDK = Darwin.getSDKName(new StringRef(isysroot = new StringRef(A2.getValue())))).size(), (int)0)) {
                StartVer = SDK.find_first_of("0123456789");
                int EndVer = SDK.find_last_of("0123456789");
                if (StartVer != StringRef.npos && Unsigned.$greater_uint((int)EndVer, (int)StartVer)) {
                    StringRef Version = SDK.slice(StartVer, EndVer + 1);
                    if (SDK.startswith("iPhoneOS") || SDK.startswith("iPhoneSimulator")) {
                        iOSTarget.$assignMove(Version.$basic_string());
                    } else if (SDK.startswith("MacOSX")) {
                        OSXTarget.$assignMove(Version.$basic_string());
                    } else if (SDK.startswith("WatchOS") || SDK.startswith("WatchSimulator")) {
                        WatchOSTarget.$assignMove(Version.$basic_string());
                    } else if (SDK.startswith("AppleTVOS") || SDK.startswith("AppleTVSimulator")) {
                        TvOSTarget.$assignMove(Version.$basic_string());
                    }
                }
            }
            if (OSXTarget.empty() && iOSTarget.empty() && TvOSTarget.empty() && WatchOSTarget.empty()) {
                StringRef MachOArchName = this.getMachOArchName((ArgList)Args);
                uint.ref Major = NativePointer.create_uint$ref();
                uint.ref Minor = NativePointer.create_uint$ref();
                uint.ref Micro = NativePointer.create_uint$ref();
                if (llvm.$eq_StringRef((StringRef)MachOArchName, (String)"armv7") || llvm.$eq_StringRef((StringRef)MachOArchName, (String)"armv7s") || llvm.$eq_StringRef((StringRef)MachOArchName, (String)"arm64")) {
                    JavaCleaner $c$5 = Native.$createJavaCleaner();
                    try {
                        this.getTriple().getiOSVersion(Major, Minor, Micro);
                        $c$5.clean((Object)((raw_string_ostream)$c$5.track((Object)new raw_string_ostream(iOSTarget))).$out_uint(Major).$out_char((byte)46).$out_uint(Minor).$out_char((byte)46).$out_uint(Micro));
                    }
                    finally {
                        $c$5.$destroy();
                    }
                }
                if (llvm.$eq_StringRef((StringRef)MachOArchName, (String)"armv7k")) {
                    JavaCleaner $c$6 = Native.$createJavaCleaner();
                    try {
                        this.getTriple().getWatchOSVersion(Major, Minor, Micro);
                        $c$6.clean((Object)((raw_string_ostream)$c$6.track((Object)new raw_string_ostream(WatchOSTarget))).$out_uint(Major).$out_char((byte)46).$out_uint(Minor).$out_char((byte)46).$out_uint(Micro));
                    }
                    finally {
                        $c$6.$destroy();
                    }
                }
                if (llvm.$noteq_StringRef((StringRef)MachOArchName, (String)"armv6m") && llvm.$noteq_StringRef((StringRef)MachOArchName, (String)"armv7m") && llvm.$noteq_StringRef((StringRef)MachOArchName, (String)"armv7em")) {
                    JavaCleaner $c$7 = Native.$createJavaCleaner();
                    try {
                        if (!this.getTriple().getMacOSXVersion(Major, Minor, Micro)) {
                            $c$7.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$7.track((Object)this.getDriver().Diag(324))), (StringRef)this.getTriple().getOSName()));
                        }
                        $c$7.clean((Object)((raw_string_ostream)$c$7.track((Object)new raw_string_ostream(OSXTarget))).$out_uint(Major).$out_char((byte)46).$out_uint(Minor).$out_char((byte)46).$out_uint(Micro));
                    }
                    finally {
                        $c$7.$destroy();
                    }
                }
            }
            if (!(WatchOSTarget.empty() || iOSTarget.empty() && TvOSTarget.empty())) {
                $c$4 = Native.$createJavaCleaner();
                try {
                    $c$4.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$4.track((Object)this.getDriver().Diag(315))), (String)"WATCHOS_DEPLOYMENT_TARGET"), (char.ptr)(!iOSTarget.empty() ? NativePointer.$((String)"IPHONEOS_DEPLOYMENT_TARGET") : NativePointer.$((String)"TVOS_DEPLOYMENT_TARGET"))));
                }
                finally {
                    $c$4.$destroy();
                }
            }
            if (!TvOSTarget.empty() && !iOSTarget.empty()) {
                $c$4 = Native.$createJavaCleaner();
                try {
                    $c$4.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$4.track((Object)this.getDriver().Diag(315))), (String)"TVOS_DEPLOYMENT_TARGET"), (String)"IPHONEOS_DEPLOYMENT_TARGET"));
                }
                finally {
                    $c$4.$destroy();
                }
            }
            if (!(OSXTarget.empty() || iOSTarget.empty() && WatchOSTarget.empty() && TvOSTarget.empty())) {
                if (this.getTriple().getArch() == Triple.ArchType.arm || this.getTriple().getArch() == Triple.ArchType.aarch64 || this.getTriple().getArch() == Triple.ArchType.thumb) {
                    OSXTarget.$assign((CharSequence)"");
                } else {
                    iOSTarget.$assign(WatchOSTarget.$assign(TvOSTarget.$assign((CharSequence)"")));
                }
            }
            if (!OSXTarget.empty()) {
                O = Opts.getOption(new OptSpecifier(options.ID.OPT_mmacosx_version_min_EQ.getValue()));
                OSXVersion = Args.MakeJoinedArg((Arg)null, O, new StringRef(OSXTarget));
                Args.append(OSXVersion);
            } else if (!iOSTarget.empty()) {
                O = Opts.getOption(new OptSpecifier(options.ID.OPT_miphoneos_version_min_EQ.getValue()));
                iOSVersion = Args.MakeJoinedArg((Arg)null, O, new StringRef(iOSTarget));
                Args.append(iOSVersion);
            } else if (!TvOSTarget.empty()) {
                O = Opts.getOption(new OptSpecifier(options.ID.OPT_mtvos_version_min_EQ.getValue()));
                TvOSVersion = Args.MakeJoinedArg((Arg)null, O, new StringRef(TvOSTarget));
                Args.append(TvOSVersion);
            } else if (!WatchOSTarget.empty()) {
                O = Opts.getOption(new OptSpecifier(options.ID.OPT_mwatchos_version_min_EQ.getValue()));
                WatchOSVersion = Args.MakeJoinedArg((Arg)null, O, new StringRef(WatchOSTarget));
                Args.append(WatchOSVersion);
            }
        }
        if (OSXVersion != null) {
            Platform = DarwinPlatformKind.MacOS;
        } else if (iOSVersion != null) {
            Platform = DarwinPlatformKind.IPhoneOS;
        } else if (TvOSVersion != null) {
            Platform = DarwinPlatformKind.TvOS;
        } else if (WatchOSVersion != null) {
            Platform = DarwinPlatformKind.WatchOS;
        } else {
            throw new llvm_unreachable("Unable to infer Darwin variant");
        }
        uint.ref Major = NativePointer.create_uint$ref();
        uint.ref Minor = NativePointer.create_uint$ref();
        uint.ref Micro = NativePointer.create_uint$ref();
        bool.ref HadExtra = NativePointer.create_bool$ref();
        if (Platform == DarwinPlatformKind.MacOS) {
            assert (iOSVersion == null && TvOSVersion == null && WatchOSVersion == null) : "Unknown target platform!";
            if (!Driver.GetReleaseVersion(OSXVersion.getValue(), Major, Minor, Micro, HadExtra) || HadExtra.$deref() || Major.$deref() != 10 || Unsigned.$greatereq_uint((uint.ref)Minor, (int)100) || Unsigned.$greatereq_uint((uint.ref)Micro, (int)100)) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(338))), (StringRef)new StringRef(OSXVersion.getAsString((ArgList)Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
        } else if (Platform == DarwinPlatformKind.IPhoneOS) {
            assert (iOSVersion != null) : "Unknown target platform!";
            if (!Driver.GetReleaseVersion(iOSVersion.getValue(), Major, Minor, Micro, HadExtra) || HadExtra.$deref() || Unsigned.$greatereq_uint((uint.ref)Major, (int)10) || Unsigned.$greatereq_uint((uint.ref)Minor, (int)100) || Unsigned.$greatereq_uint((uint.ref)Micro, (int)100)) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(338))), (StringRef)new StringRef(iOSVersion.getAsString((ArgList)Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
        } else if (Platform == DarwinPlatformKind.TvOS) {
            if (!Driver.GetReleaseVersion(TvOSVersion.getValue(), Major, Minor, Micro, HadExtra) || HadExtra.$deref() || Unsigned.$greatereq_uint((uint.ref)Major, (int)10) || Unsigned.$greatereq_uint((uint.ref)Minor, (int)100) || Unsigned.$greatereq_uint((uint.ref)Micro, (int)100)) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(338))), (StringRef)new StringRef(TvOSVersion.getAsString((ArgList)Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
        } else if (Platform == DarwinPlatformKind.WatchOS) {
            if (!Driver.GetReleaseVersion(WatchOSVersion.getValue(), Major, Minor, Micro, HadExtra) || HadExtra.$deref() || Unsigned.$greatereq_uint((uint.ref)Major, (int)10) || Unsigned.$greatereq_uint((uint.ref)Minor, (int)100) || Unsigned.$greatereq_uint((uint.ref)Micro, (int)100)) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(338))), (StringRef)new StringRef(WatchOSVersion.getAsString((ArgList)Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
        } else {
            throw new llvm_unreachable("unknown kind of Darwin platform");
        }
        if (iOSVersion != null && (this.getTriple().getArch() == Triple.ArchType.x86 || this.getTriple().getArch() == Triple.ArchType.x86_64)) {
            Platform = DarwinPlatformKind.IPhoneOSSimulator;
        }
        if (TvOSVersion != null && (this.getTriple().getArch() == Triple.ArchType.x86 || this.getTriple().getArch() == Triple.ArchType.x86_64)) {
            Platform = DarwinPlatformKind.TvOSSimulator;
        }
        if (WatchOSVersion != null && (this.getTriple().getArch() == Triple.ArchType.x86 || this.getTriple().getArch() == Triple.ArchType.x86_64)) {
            Platform = DarwinPlatformKind.WatchOSSimulator;
        }
        this.setTarget(Platform, Major.$deref(), Minor.$deref(), Micro.$deref());
        Arg A3 = Args.getLastArg(new OptSpecifier(options.ID.OPT_isysroot.getValue()));
        if (A3 != null && Unsigned.$greater_uint((int)(SDK = Darwin.getSDKName(new StringRef(A3.getValue()))).size(), (int)0) && !(SDKName = SDK.slice(0, StartVer = SDK.find_first_of("0123456789"))).startswith(this.getPlatformFamily())) {
            JavaCleaner $c$8 = Native.$createJavaCleaner();
            try {
                $c$8.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$8.track((Object)this.getDriver().Diag(407))), (StringRef)SDKName), (StringRef)this.getPlatformFamily()));
            }
            finally {
                $c$8.$destroy();
            }
        }
    }

    public Darwin(Driver D, Triple Triple2, ArgList Args) {
        super(D, Triple2, Args);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public std.string ComputeEffectiveClangTriple(ArgList Args, types.ID InputType) {
        Triple Triple2 = new Triple(new Twine(this.ComputeLLVMTriple(Args, InputType)));
        if (!this.isTargetInitialized()) {
            return new std.string(Triple2.getTriple());
        }
        SmallString Str = new SmallString(16);
        if (this.isTargetWatchOSBased()) {
            Str.$addassign("watchos");
        } else if (this.isTargetTvOSBased()) {
            Str.$addassign("tvos");
        } else if (this.isTargetIOSBased()) {
            Str.$addassign("ios");
        } else {
            Str.$addassign("macosx");
        }
        Str.$addassign(new StringRef(this.getTargetVersion().getAsString()));
        Triple2.setOSName(Str.$StringRef());
        return new std.string(Triple2.getTriple());
    }

    @Override
    public void addMinVersionArgs(ArgList Args, ArgStringList CmdArgs) {
        VersionTuple TargetVersion = this.getTargetVersion();
        if (this.isTargetWatchOS()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-watchos_version_min"));
        } else if (this.isTargetWatchOSSimulator()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-watchos_simulator_version_min"));
        } else if (this.isTargetTvOS()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-tvos_version_min"));
        } else if (this.isTargetTvOSSimulator()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-tvos_simulator_version_min"));
        } else if (this.isTargetIOSSimulator()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-ios_simulator_version_min"));
        } else if (this.isTargetIOSBased()) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-iphoneos_version_min"));
        } else {
            assert (this.isTargetMacOS()) : "unexpected target";
            CmdArgs.push_back((Object)NativePointer.$((String)"-macosx_version_min"));
        }
        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(TargetVersion.getAsString())));
    }

    @Override
    public void addStartObjectFileArgs(ArgList Args, ArgStringList CmdArgs) {
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_dynamiclib.getValue()))) {
            if (!this.isTargetWatchOSBased() && !this.isTargetIOSSimulator()) {
                if (this.isTargetIPhoneOS()) {
                    if (this.isIPhoneOSVersionLT(3, 1)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-ldylib1.o"));
                    }
                } else if (this.isMacosxVersionLT(10, 5)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-ldylib1.o"));
                } else if (this.isMacosxVersionLT(10, 6)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-ldylib1.10.5.o"));
                }
            }
        } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_bundle.getValue()))) {
            if (!(Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) || this.isTargetWatchOSBased() || this.isTargetIOSSimulator())) {
                if (this.isTargetIPhoneOS()) {
                    if (this.isIPhoneOSVersionLT(3, 1)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lbundle1.o"));
                    }
                } else if (this.isMacosxVersionLT(10, 6)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lbundle1.o"));
                }
            }
        } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue())) && this.SupportsProfiling()) {
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_object.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_preload.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgcrt0.o"));
            } else {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lgcrt1.o"));
            }
            if (this.isTargetMacOS() && !this.isMacosxVersionLT(10, 8)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-no_new_main"));
            }
        } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_object.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_preload.getValue()))) {
            CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt0.o"));
        } else if (!this.isTargetWatchOSBased() && !this.isTargetIOSSimulator()) {
            if (this.isTargetIPhoneOS()) {
                if (this.getArch() != Triple.ArchType.aarch64) {
                    if (this.isIPhoneOSVersionLT(3, 1)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.o"));
                    } else if (this.isIPhoneOSVersionLT(6, 0)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.3.1.o"));
                    }
                }
            } else if (this.isMacosxVersionLT(10, 5)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.o"));
            } else if (this.isMacosxVersionLT(10, 6)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.10.5.o"));
            } else if (this.isMacosxVersionLT(10, 8)) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.10.6.o"));
            }
        }
        if (!this.isTargetIPhoneOS() && Args.hasArg(new OptSpecifier(options.ID.OPT_shared_libgcc.getValue())) && !this.isTargetWatchOS() && this.isMacosxVersionLT(10, 5)) {
            char.ptr Str = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.GetFilePath(NativePointer.$((String)"crt3.o")))));
            CmdArgs.push_back((Object)Str);
        }
    }

    @Override
    public boolean isKernelStatic() {
        return (!this.isTargetIPhoneOS() || this.isIPhoneOSVersionLT(6, 0)) && !this.isTargetWatchOS();
    }

    @Override
    public void addProfileRTLibs(ArgList Args, ArgStringList CmdArgs) {
        if (!Darwin.needsProfileRT(Args)) {
            return;
        }
        this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("libclang_rt.profile_"), (Twine)new Twine(this.getOSLibraryNameSuffix())), (Twine)new Twine(".a")).str()), true);
    }

    protected void setTarget(DarwinPlatformKind Platform, int Major, int Minor, int Micro) {
        if (this.TargetInitialized && this.TargetPlatform == Platform && VersionTuple.$eq_VersionTuple((VersionTuple)this.TargetVersion, (VersionTuple)new VersionTuple(Major, Minor, Micro))) {
            return;
        }
        assert (!this.TargetInitialized) : "Target already initialized!";
        this.TargetInitialized = true;
        this.TargetPlatform = Platform;
        this.TargetVersion.$assignMove(new VersionTuple(Major, Minor, Micro));
    }

    protected boolean isTargetIPhoneOS() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.TargetPlatform == DarwinPlatformKind.IPhoneOS || this.TargetPlatform == DarwinPlatformKind.TvOS;
    }

    protected boolean isTargetIOSSimulator() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.TargetPlatform == DarwinPlatformKind.IPhoneOSSimulator || this.TargetPlatform == DarwinPlatformKind.TvOSSimulator;
    }

    @Override
    public boolean isTargetIOSBased() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.isTargetIPhoneOS() || this.isTargetIOSSimulator();
    }

    protected boolean isTargetTvOS() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.TargetPlatform == DarwinPlatformKind.TvOS;
    }

    protected boolean isTargetTvOSSimulator() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.TargetPlatform == DarwinPlatformKind.TvOSSimulator;
    }

    protected boolean isTargetTvOSBased() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.TargetPlatform == DarwinPlatformKind.TvOS || this.TargetPlatform == DarwinPlatformKind.TvOSSimulator;
    }

    protected boolean isTargetWatchOS() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.TargetPlatform == DarwinPlatformKind.WatchOS;
    }

    protected boolean isTargetWatchOSSimulator() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.TargetPlatform == DarwinPlatformKind.WatchOSSimulator;
    }

    protected boolean isTargetWatchOSBased() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.TargetPlatform == DarwinPlatformKind.WatchOS || this.TargetPlatform == DarwinPlatformKind.WatchOSSimulator;
    }

    protected boolean isTargetMacOS() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return this.TargetPlatform == DarwinPlatformKind.MacOS;
    }

    protected boolean isTargetInitialized() {
        return this.TargetInitialized;
    }

    protected VersionTuple getTargetVersion() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return new VersionTuple(this.TargetVersion);
    }

    protected boolean isIPhoneOSVersionLT(int V0) {
        return this.isIPhoneOSVersionLT(V0, 0, 0);
    }

    protected boolean isIPhoneOSVersionLT(int V0, int V1) {
        return this.isIPhoneOSVersionLT(V0, V1, 0);
    }

    protected boolean isIPhoneOSVersionLT(int V0, int V1, int V2) {
        assert (this.isTargetIOSBased()) : "Unexpected call for non iOS target!";
        return VersionTuple.$less_VersionTuple((VersionTuple)this.TargetVersion, (VersionTuple)new VersionTuple(V0, V1, V2));
    }

    protected boolean isMacosxVersionLT(int V0) {
        return this.isMacosxVersionLT(V0, 0, 0);
    }

    protected boolean isMacosxVersionLT(int V0, int V1) {
        return this.isMacosxVersionLT(V0, V1, 0);
    }

    protected boolean isMacosxVersionLT(int V0, int V1, int V2) {
        assert (this.isTargetMacOS()) : "Unexpected call for non OS X target!";
        return VersionTuple.$less_VersionTuple((VersionTuple)this.TargetVersion, (VersionTuple)new VersionTuple(V0, V1, V2));
    }

    protected StringRef getPlatformFamily() {
        switch (this.TargetPlatform) {
            case MacOS: {
                return new StringRef("MacOSX");
            }
            case IPhoneOS: 
            case IPhoneOSSimulator: {
                return new StringRef("iPhone");
            }
            case TvOS: 
            case TvOSSimulator: {
                return new StringRef("AppleTV");
            }
            case WatchOS: 
            case WatchOSSimulator: {
                return new StringRef("Watch");
            }
        }
        throw new llvm_unreachable("Unsupported platform");
    }

    protected static StringRef getSDKName(StringRef isysroot) {
        path.const_iterator SDKDir = new path.const_iterator();
        path.const_iterator BeginSDK = path.begin((StringRef)isysroot);
        path.const_iterator EndSDK = path.end((StringRef)isysroot);
        path.const_iterator IT = new path.const_iterator(BeginSDK);
        while (IT.$noteq((Object)EndSDK)) {
            StringRef SDK = new StringRef(IT.$star());
            if (SDK.endswith(".sdk")) {
                return SDK.slice(0, SDK.size() - 4);
            }
            IT.$preInc();
        }
        return new StringRef(NativePointer.$EMPTY);
    }

    protected StringRef getOSLibraryNameSuffix() {
        switch (this.TargetPlatform) {
            case MacOS: {
                return new StringRef("osx");
            }
            case IPhoneOS: {
                return new StringRef("ios");
            }
            case IPhoneOSSimulator: {
                return new StringRef("iossim");
            }
            case TvOS: {
                return new StringRef("tvos");
            }
            case TvOSSimulator: {
                return new StringRef("tvossim");
            }
            case WatchOS: {
                return new StringRef("watchos");
            }
            case WatchOSSimulator: {
                return new StringRef("watchossim");
            }
        }
        throw new llvm_unreachable("Unsupported platform");
    }

    @Override
    public boolean isCrossCompiling() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DerivedArgList TranslateArgs(DerivedArgList Args, char.ptr BoundArch) {
        ToolChain.CXXStdlibType Type2;
        DerivedArgList DAL = super.TranslateArgs(Args, BoundArch);
        OptTable Opts = this.getDriver().getOpts();
        if (BoundArch == null) {
            return DAL;
        }
        this.AddDeploymentTarget(DAL);
        if (this.isTargetWatchOSBased() || this.isTargetIOSBased() && !this.isIPhoneOSVersionLT(6, 0)) {
            SmallVectorImpl.iterator it = DAL.begin();
            SmallVectorImpl.iterator ie = DAL.end();
            while (Native.$noteq_iter((abstract_iterator)it, (abstract_iterator)ie)) {
                Arg A = (Arg)it.$star();
                it.$preInc();
                if (A.getOption().getID() != options.ID.OPT_mkernel.getValue() && A.getOption().getID() != options.ID.OPT_fapple_kext.getValue()) continue;
                assert (Native.$noteq_iter((abstract_iterator)it, (abstract_iterator)ie)) : "unexpected argument translation";
                A = (Arg)it.$star();
                assert (A.getOption().getID() == options.ID.OPT_static.getValue()) : "missing expected -static argument";
                it = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)DAL.getArgs().erase(it));
            }
        }
        if (Args.getLastArg(new OptSpecifier(options.ID.OPT_stdlib_EQ.getValue())) == null && this.GetCXXStdlibType((ArgList)Args) == ToolChain.CXXStdlibType.CST_Libcxx) {
            DAL.AddJoinedArg((Arg)null, Opts.getOption(new OptSpecifier(options.ID.OPT_stdlib_EQ.getValue())), new StringRef("libc++"));
        }
        if ((Type2 = this.GetCXXStdlibType((ArgList)DAL)) == ToolChain.CXXStdlibType.CST_Libcxx) {
            StringRef where = new StringRef();
            if (this.isTargetIOSBased() && this.isIPhoneOSVersionLT(5, 0)) {
                where.$assignMove("iOS 5.0");
            }
            if (llvm.$noteq_StringRef((StringRef)where, (StringRef)new StringRef())) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(327))), (StringRef)where));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        return DAL;
    }

    @Override
    public ToolChain.CXXStdlibType GetDefaultCXXStdlibType() {
        if (this.isTargetMacOS() && !this.isMacosxVersionLT(10, 9) || this.isTargetIOSBased() && !this.isIPhoneOSVersionLT(7, 0) || this.isTargetWatchOSBased()) {
            return ToolChain.CXXStdlibType.CST_Libcxx;
        }
        return ToolChain.CXXStdlibType.CST_Libstdcxx;
    }

    @Override
    public ObjCRuntime getDefaultObjCRuntime(boolean isNonFragile) {
        if (this.isTargetWatchOSBased()) {
            return new ObjCRuntime(ObjCRuntime.Kind.WatchOS, this.TargetVersion);
        }
        if (this.isTargetIOSBased()) {
            return new ObjCRuntime(ObjCRuntime.Kind.iOS, this.TargetVersion);
        }
        if (isNonFragile) {
            return new ObjCRuntime(ObjCRuntime.Kind.MacOSX, this.TargetVersion);
        }
        return new ObjCRuntime(ObjCRuntime.Kind.FragileMacOSX, this.TargetVersion);
    }

    @Override
    public boolean hasBlocksRuntime() {
        if (this.isTargetWatchOSBased()) {
            return true;
        }
        if (this.isTargetIOSBased()) {
            return !this.isIPhoneOSVersionLT(3, 2);
        }
        assert (this.isTargetMacOS()) : "unexpected darwin target";
        return !this.isMacosxVersionLT(10, 6);
    }

    @Override
    public boolean UseObjCMixedDispatch() {
        return !this.isTargetMacOS() || !this.isMacosxVersionLT(10, 6);
    }

    @Override
    public int GetDefaultStackProtectorLevel(boolean KernelOrKext) {
        if (this.isTargetIOSBased() || this.isTargetWatchOSBased()) {
            return 1;
        }
        if (this.isTargetMacOS() && !this.isMacosxVersionLT(10, 6)) {
            return 1;
        }
        if (this.isTargetMacOS() && !this.isMacosxVersionLT(10, 5) && !KernelOrKext) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean SupportsObjCGC() {
        return this.isTargetMacOS();
    }

    @Override
    public void CheckObjCARC() {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (this.isTargetIOSBased() || this.isTargetWatchOSBased() || this.isTargetMacOS() && !this.isMacosxVersionLT(10, 6)) {
                return;
            }
            $c$.clean($c$.track((Object)this.getDriver().Diag(304)));
        }
        finally {
            $c$.$destroy();
        }
    }

    @Override
    public boolean UseSjLjExceptions(ArgList Args) {
        if (this.getTriple().getArch() != Triple.ArchType.arm && this.getTriple().getArch() != Triple.ArchType.thumb) {
            return false;
        }
        Triple Triple2 = new Triple(new Twine(this.ComputeLLVMTriple(Args)));
        return !Triple2.isWatchABI();
    }

    @Override
    public boolean SupportsEmbeddedBitcode() {
        assert (this.TargetInitialized) : "Target not initialized!";
        return !this.isTargetIPhoneOS() || !this.isIPhoneOSVersionLT(6, 0);
    }

    @Override
    public long getSupportedSanitizers() {
        boolean IsX86_64 = this.getTriple().getArch() == Triple.ArchType.x86_64;
        long Res = super.getSupportedSanitizers();
        Res |= SanitizerKind.Address;
        if (this.isTargetMacOS()) {
            if (!this.isMacosxVersionLT(10, 9)) {
                Res |= SanitizerKind.Vptr;
            }
            Res |= SanitizerKind.SafeStack;
            if (IsX86_64) {
                Res |= SanitizerKind.Thread;
            }
        } else if ((this.isTargetIOSSimulator() || this.isTargetTvOSSimulator()) && IsX86_64) {
            Res |= SanitizerKind.Thread;
        }
        return Res;
    }

    @Override
    public String toString() {
        return "TargetInitialized=" + this.TargetInitialized + ", TargetPlatform=" + (Object)((Object)this.TargetPlatform) + ", TargetVersion=" + this.TargetVersion + super.toString();
    }

    public static final class DarwinPlatformKind
    extends Enum<DarwinPlatformKind>
    implements Native.ComparableLower {
        public static final /* enum */ DarwinPlatformKind MacOS = new DarwinPlatformKind(0);
        public static final /* enum */ DarwinPlatformKind IPhoneOS = new DarwinPlatformKind(MacOS.getValue() + 1);
        public static final /* enum */ DarwinPlatformKind IPhoneOSSimulator = new DarwinPlatformKind(IPhoneOS.getValue() + 1);
        public static final /* enum */ DarwinPlatformKind TvOS = new DarwinPlatformKind(IPhoneOSSimulator.getValue() + 1);
        public static final /* enum */ DarwinPlatformKind TvOSSimulator = new DarwinPlatformKind(TvOS.getValue() + 1);
        public static final /* enum */ DarwinPlatformKind WatchOS = new DarwinPlatformKind(TvOSSimulator.getValue() + 1);
        public static final /* enum */ DarwinPlatformKind WatchOSSimulator = new DarwinPlatformKind(WatchOS.getValue() + 1);
        private final int value;
        private static final /* synthetic */ DarwinPlatformKind[] $VALUES;

        public static DarwinPlatformKind[] values() {
            return (DarwinPlatformKind[])$VALUES.clone();
        }

        public static DarwinPlatformKind valueOf(String name) {
            return Enum.valueOf(DarwinPlatformKind.class, name);
        }

        public static DarwinPlatformKind valueOf(int val) {
            DarwinPlatformKind out;
            DarwinPlatformKind darwinPlatformKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private DarwinPlatformKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((DarwinPlatformKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((DarwinPlatformKind)((Object)obj)).value);
        }

        static {
            $VALUES = new DarwinPlatformKind[]{MacOS, IPhoneOS, IPhoneOSSimulator, TvOS, TvOSSimulator, WatchOS, WatchOSSimulator};
        }

        private static final class Values {
            private static final DarwinPlatformKind[] VALUES;
            private static final DarwinPlatformKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (DarwinPlatformKind kind : DarwinPlatformKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new DarwinPlatformKind[min < 0 ? 1 - min : 0];
                VALUES = new DarwinPlatformKind[max >= 0 ? 1 + max : 0];
                for (DarwinPlatformKind kind : DarwinPlatformKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((DarwinPlatformKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((DarwinPlatformKind)kind).value] = kind;
                }
            }
        }
    }
}

