/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.PushDownTransformer;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PushDownRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PushDownRefactoring refactoring;
    private final TreePathHandle treePathHandle;

    public PushDownRefactoringPlugin(PushDownRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = refactoring.getSourceType();
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            default: 
        }
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController cc) throws IOException {
        this.fireProgressListenerStart(1, 4);
        try {
            cc.toPhase(JavaSource.Phase.RESOLVED);
            Problem precheckProblem = PushDownRefactoringPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)cc);
            if (precheckProblem != null) {
                Problem problem = precheckProblem;
                return problem;
            }
            this.fireProgressListenerStep();
            Element el = this.treePathHandle.resolveElement((CompilationInfo)cc);
            precheckProblem = JavaPluginUtils.isSourceElement(el, (CompilationInfo)cc);
            if (precheckProblem != null) {
                Problem problem = precheckProblem;
                return problem;
            }
            if (!(el instanceof TypeElement)) {
                Problem problem = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_InvalidSource", (Object)this.treePathHandle, (Object)el));
                return problem;
            }
            ElementHandle eh = ElementHandle.create((Element)((TypeElement)el));
            Set resources = cc.getClasspathInfo().getClassIndex().getResources(eh, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            if (resources.isEmpty()) {
                Problem problem = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDOwn_NoSubtype"));
                return problem;
            }
            this.fireProgressListenerStep();
            boolean hasMembers = false;
            for (Element element : el.getEnclosedElements()) {
                if (element.getKind() == ElementKind.CONSTRUCTOR) continue;
                hasMembers = true;
                break;
            }
            if (!hasMembers) {
                precheckProblem = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembers"));
            }
            this.fireProgressListenerStep();
            Problem problem = precheckProblem;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        if (this.refactoring.getMembers().length == 0) {
            return new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembersSelected"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles(TreePathHandle handle) {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        ClassIndex idx = cpInfo.getClassIndex();
        HashSet<FileObject> set = new HashSet<FileObject>();
        set.add(RefactoringUtils.getFileObject(handle));
        set.addAll(idx.getResources(handle.getElementHandle(), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS, ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        Set elements = idx.getElements(handle.getElementHandle(), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        for (ElementHandle type : elements) {
            set.addAll(idx.getResources(type, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.METHOD_REFERENCES, ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        }
        return set;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Set<FileObject> a = this.getRelevantFiles(this.treePathHandle);
        this.fireProgressListenerStart(3, a.size());
        PushDownTransformer pdt = new PushDownTransformer(this.refactoring.getMembers());
        Problem prob = this.createAndAddElements(a, new JavaRefactoringPlugin.TransformTask(this, pdt, this.treePathHandle), refactoringElements, this.refactoring);
        this.fireProgressListenerStop();
        return prob != null ? prob : pdt.getProblem();
    }
}

