/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.scope;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.spi.ui.ScopeProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public final class CurrentFileScopeProvider
extends ScopeProvider {
    private Scope scope;
    private ImageIcon icon;
    private String detail;

    public boolean initialize(Lookup context, AtomicBoolean cancel) {
        FileObject file = (FileObject)context.lookup(FileObject.class);
        if (file == null || file.isFolder()) {
            return false;
        }
        DataObject currentFileDo = null;
        try {
            currentFileDo = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        this.icon = currentFileDo != null ? new ImageIcon(currentFileDo.getNodeDelegate().getIcon(1)) : null;
        this.detail = file.getNameExt();
        this.scope = Scope.create(null, null, Arrays.asList(file));
        return true;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Icon getIcon() {
        return this.icon != null ? this.icon : super.getIcon();
    }

    public String getDetail() {
        return this.detail;
    }
}

