/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class SelectFilePanel
extends JPanel {
    private static final long serialVersionUID = 8464321687132132L;
    final List<FileObject> sourceRoots;
    private final DefaultListModel<FileObject> model;
    private DialogDescriptor dialogDescriptor;
    private NotificationLineSupport notificationLineSupport;
    private JLabel selectFileLabel;
    private JList<FileObject> selectFileList;
    private JScrollPane selectFileScrollPane;

    private SelectFilePanel(List<FileObject> sourceRoots, List<FileObject> files) {
        assert (EventQueue.isDispatchThread());
        assert (sourceRoots != null);
        assert (!sourceRoots.isEmpty());
        assert (files.size() > 1);
        this.sourceRoots = sourceRoots;
        this.initComponents();
        this.model = new DefaultListModel();
        for (FileObject fo : files) {
            assert (this.isParentOf(sourceRoots, fo)) : fo + " not underneath " + sourceRoots;
            this.model.addElement(fo);
        }
        this.selectFileList.setCellRenderer(new FileListCellRenderer());
        this.selectFileList.setModel(this.model);
        this.selectFileList.setSelectedIndex(0);
        this.selectFileList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectFilePanel.this.validateSelection();
            }
        });
    }

    public static FileObject open(List<FileObject> sourceRoots, List<FileObject> files) {
        SelectFilePanel panel = new SelectFilePanel(sourceRoots, files);
        panel.dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(SelectFilePanel.class, (String)"LBL_SelectFile"), true, 2, DialogDescriptor.OK_OPTION, null);
        panel.notificationLineSupport = panel.dialogDescriptor.createNotificationLineSupport();
        panel.validateSelection();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)panel.dialogDescriptor) == DialogDescriptor.OK_OPTION) {
            return panel.getSelectedFile();
        }
        return null;
    }

    private boolean isParentOf(List<FileObject> folders, FileObject file) {
        for (FileObject folder : folders) {
            if (!FileUtil.isParentOf((FileObject)folder, (FileObject)file)) continue;
            return true;
        }
        return false;
    }

    private FileObject getSelectedFile() {
        return this.selectFileList.getSelectedValue();
    }

    void validateSelection() {
        assert (this.notificationLineSupport != null);
        if (this.getSelectedFile() == null) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(SelectFilePanel.class, (String)"MSG_NoFileSelected"));
            this.dialogDescriptor.setValid(false);
            return;
        }
        this.notificationLineSupport.clearMessages();
        this.dialogDescriptor.setValid(true);
    }

    private void initComponents() {
        this.selectFileLabel = new JLabel();
        this.selectFileScrollPane = new JScrollPane();
        this.selectFileList = new JList();
        this.selectFileLabel.setLabelFor(this.selectFileList);
        Mnemonics.setLocalizedText((JLabel)this.selectFileLabel, (String)NbBundle.getMessage(SelectFilePanel.class, (String)"SelectFilePanel.selectFileLabel.text"));
        this.selectFileList.setSelectionMode(0);
        this.selectFileScrollPane.setViewportView(this.selectFileList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectFileScrollPane, -1, 280, Short.MAX_VALUE).addComponent(this.selectFileLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.selectFileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectFileScrollPane, -2, 85, -2)));
    }

    private final class FileListCellRenderer
    extends JLabel
    implements ListCellRenderer<FileObject>,
    UIResource {
        private static final long serialVersionUID = 987974324657654541L;

        public FileListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends FileObject> list, FileObject value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            assert (EventQueue.isDispatchThread());
            String relativePath = this.getRelativePath(SelectFilePanel.this.sourceRoots, value);
            assert (relativePath != null) : value + " not underneath any of: " + SelectFilePanel.this.sourceRoots;
            this.setText(relativePath);
            this.setToolTipText(relativePath);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }

        private String getRelativePath(List<FileObject> folders, FileObject file) {
            for (FileObject folder : folders) {
                String relativePath = FileUtil.getRelativePath((FileObject)folder, (FileObject)file);
                if (relativePath == null) continue;
                return folder.getNameExt() + "/" + relativePath;
            }
            return null;
        }
    }
}

