/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.broker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.broker.SubscriptionRegistry;
import org.springframework.util.MultiValueMap;

public abstract class AbstractSubscriptionRegistry
implements SubscriptionRegistry {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public final void registerSubscription(Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        if (!SimpMessageType.SUBSCRIBE.equals((Object)headers.getMessageType())) {
            this.logger.error((Object)("Expected SUBSCRIBE message: " + message));
            return;
        }
        String sessionId = headers.getSessionId();
        if (sessionId == null) {
            this.logger.error((Object)("Ignoring subscription. No sessionId in message: " + message));
            return;
        }
        String subscriptionId = headers.getSubscriptionId();
        if (subscriptionId == null) {
            this.logger.error((Object)("Ignoring subscription. No subscriptionId in message: " + message));
            return;
        }
        String destination = headers.getDestination();
        if (destination == null) {
            this.logger.error((Object)("Ignoring destination. No destination in message: " + message));
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding subscription id=" + headers.getSubscriptionId() + ", destination=" + headers.getDestination()));
        }
        this.addSubscriptionInternal(sessionId, subscriptionId, destination, message);
    }

    protected abstract void addSubscriptionInternal(String var1, String var2, String var3, Message<?> var4);

    @Override
    public final void unregisterSubscription(Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        if (!SimpMessageType.UNSUBSCRIBE.equals((Object)headers.getMessageType())) {
            this.logger.error((Object)("Expected UNSUBSCRIBE message: " + message));
            return;
        }
        String sessionId = headers.getSessionId();
        if (sessionId == null) {
            this.logger.error((Object)("Ignoring subscription. No sessionId in message: " + message));
            return;
        }
        String subscriptionId = headers.getSubscriptionId();
        if (subscriptionId == null) {
            this.logger.error((Object)("Ignoring subscription. No subscriptionId in message: " + message));
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unubscribe request: " + message));
        }
        this.removeSubscriptionInternal(sessionId, subscriptionId, message);
    }

    protected abstract void removeSubscriptionInternal(String var1, String var2, Message<?> var3);

    @Override
    public abstract void unregisterAllSubscriptions(String var1);

    @Override
    public final MultiValueMap<String, String> findSubscriptions(Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        if (!SimpMessageType.MESSAGE.equals((Object)headers.getMessageType())) {
            this.logger.trace((Object)("Ignoring message type " + (Object)((Object)headers.getMessageType())));
            return null;
        }
        String destination = headers.getDestination();
        if (destination == null) {
            this.logger.trace((Object)"Ignoring message, no destination");
            return null;
        }
        MultiValueMap<String, String> result = this.findSubscriptionsInternal(destination, message);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Found " + result.size() + " subscriptions for destination=" + headers.getDestination()));
        }
        return result;
    }

    protected abstract MultiValueMap<String, String> findSubscriptionsInternal(String var1, Message<?> var2);
}

