/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import java.awt.Image;
import org.netbeans.modules.cordova.platforms.api.ClientProjectUtilities;
import org.netbeans.modules.cordova.platforms.ios.Bundle;
import org.netbeans.modules.cordova.platforms.ios.IOSBrowser;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperImplementation;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperProvider;
import org.netbeans.modules.web.browser.spi.EnhancedBrowserFactory;
import org.openide.awt.HtmlBrowser;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public abstract class IOSBrowserFactory
implements EnhancedBrowserFactory,
HtmlBrowser.Factory,
BrowserURLMapperProvider {
    private BrowserURLMapperImplementation urlMapper = ClientProjectUtilities.createMobileBrowserURLMapper();

    public BrowserFamilyId getBrowserFamilyId() {
        return BrowserFamilyId.IOS;
    }

    public boolean canCreateHtmlBrowserImpl() {
        return Utilities.isMac();
    }

    public BrowserURLMapperImplementation getBrowserURLMapper() {
        return this.urlMapper;
    }

    public static class DeviceDefault
    extends IOSBrowserFactory {
        public String getDisplayName() {
            return Bundle.LBL_DeviceDefault();
        }

        public HtmlBrowser.Impl createHtmlBrowserImpl() {
            return new IOSBrowser(IOSBrowser.Kind.IOS_DEVICE_DEFAULT);
        }

        public String getId() {
            return IOSBrowser.Kind.IOS_DEVICE_DEFAULT.toString();
        }

        public boolean hasNetBeansIntegration() {
            return true;
        }

        public Image getIconImage(boolean small) {
            return ImageUtilities.loadImage((String)("org/netbeans/modules/cordova/platforms/ios/iosdevice" + (small ? "16.png" : ".png")), (boolean)false);
        }
    }

    public static class EmulatorDefault
    extends IOSBrowserFactory {
        public String getDisplayName() {
            return Bundle.LBL_SimulatorDefault();
        }

        public HtmlBrowser.Impl createHtmlBrowserImpl() {
            return new IOSBrowser(IOSBrowser.Kind.IOS_SIMULATOR_DEFAULT);
        }

        public String getId() {
            return IOSBrowser.Kind.IOS_SIMULATOR_DEFAULT.toString();
        }

        public boolean hasNetBeansIntegration() {
            return true;
        }

        public Image getIconImage(boolean small) {
            return ImageUtilities.loadImage((String)("org/netbeans/modules/cordova/platforms/ios/iossimulator" + (small ? "16.png" : ".png")), (boolean)false);
        }
    }
}

