/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.ElementAnalyzer;
import org.openide.util.NbBundle;

public class CtorAnalyzer
implements ElementAnalyzer {
    @Override
    public void analyze(Element element, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        ExecutableElement ctor = (ExecutableElement)element;
        List<? extends VariableElement> parameters = ctor.getParameters();
        for (VariableElement variableElement : parameters) {
            if (cancel.get()) {
                return;
            }
            boolean isDisposer = AnnotationUtil.hasAnnotation(variableElement, "javax.enterprise.inject.Disposes", result.getInfo());
            boolean isObserver = AnnotationUtil.hasAnnotation(variableElement, "javax.enterprise.event.Observes", result.getInfo());
            if (!isDisposer && !isObserver) continue;
            result.requireCdiEnabled(element);
            String annotation = isDisposer ? "Disposes" : "Observes";
            result.addError(element, NbBundle.getMessage(CtorAnalyzer.class, (String)"ERR_BadAnnotationParamCtor", (Object)annotation));
            break;
        }
    }
}

