/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.awt.EventQueue;
import java.util.ArrayList;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SvnFileNode {
    private final VCSFileProxy file;
    private final VCSFileProxy normalizedFile;
    private FileObject fileObject;
    private String relativePath;
    private String copy;
    private boolean copyScanned;
    private Boolean fileFlag;
    private String mimeType;

    public SvnFileNode(VCSFileProxy file) {
        this.file = file;
        VCSFileProxy norm = file.normalizeFile();
        FileInformation fi = Subversion.getInstance().getStatusCache().getStatus(file);
        FileInformation fiNorm = Subversion.getInstance().getStatusCache().getStatus(norm);
        if (fi.getStatus() != fiNorm.getStatus()) {
            norm = null;
        }
        this.normalizedFile = norm;
    }

    public String getName() {
        return this.file.getName();
    }

    public FileInformation getInformation() {
        return Subversion.getInstance().getStatusCache().getStatus(this.file);
    }

    public VCSFileProxy getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof SvnFileNode && this.file.equals((Object)((SvnFileNode)o).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public FileObject getFileObject() {
        if (this.fileObject == null && this.normalizedFile != null) {
            this.fileObject = this.normalizedFile.toFileObject();
        }
        return this.fileObject;
    }

    public Object[] getLookupObjects() {
        ArrayList<Object> list = new ArrayList<Object>(2);
        list.add(this.file);
        FileObject fo = this.getFileObject();
        if (fo != null) {
            list.add(fo);
        }
        return list.toArray(new Object[list.size()]);
    }

    public String getLocation() {
        if (this.relativePath == null) {
            Context context = new Context(this.file);
            try {
                assert (!EventQueue.isDispatchThread());
                this.relativePath = SvnModuleConfig.getDefault(context.getFileSystem()).isRepositoryPathPrefixed() ? SvnUtils.decodeToString(SvnUtils.getRepositoryUrl(this.getFile())) : SvnUtils.getRelativePath(this.getFile());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(context, ex, false, false);
            }
            if (this.relativePath == null) {
                this.relativePath = NbBundle.getMessage(SvnFileNode.class, (String)"SvnFileNode.relativePath.unknown");
            }
        }
        return this.relativePath;
    }

    public String getCopy() {
        if (!this.copyScanned) {
            assert (!EventQueue.isDispatchThread());
            this.copy = SvnUtils.getCopy(this.getFile());
            this.copyScanned = true;
        }
        return this.copy;
    }

    public boolean isFile() {
        if (this.fileFlag == null) {
            this.fileFlag = this.file.isFile();
        }
        return this.fileFlag;
    }

    public String getMimeType() {
        if (this.isFile() && this.mimeType == null) {
            this.mimeType = SvnUtils.getMimeType(this.normalizedFile == null ? this.file.normalizeFile() : this.normalizedFile);
        }
        return this.mimeType;
    }

    public void initializeProperties() {
        this.getLocation();
        this.getCopy();
        this.isFile();
        this.getMimeType();
        this.getInformation().getEntry(this.file);
    }
}

