/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.client.cli.Parser;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class CommitCommand
extends SvnCommand {
    private final boolean keepLocks;
    private final boolean recursive;
    private final String message;
    private final VCSFileProxy[] files;
    private long revision = SVNRevision.INVALID_REVISION.getNumber();

    public CommitCommand(FileSystem fileSystem, VCSFileProxy[] files, boolean keepLocks, boolean recursive, String message) {
        super(fileSystem);
        this.keepLocks = keepLocks;
        this.recursive = recursive;
        this.message = message;
        this.files = files;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.COMMIT;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("commit");
        if (this.keepLocks) {
            arguments.add("--no-unlock");
        }
        if (!this.recursive) {
            arguments.add("-N");
        }
        arguments.addMessage(this.message);
        arguments.addFileArguments(this.files);
        this.setCommandWorkingDirectory(this.files);
    }

    public long getRevision() {
        return this.revision;
    }

    @Override
    protected void notify(Parser.Line line) {
        if (line.getRevision() != -1L) {
            this.revision = line.getRevision();
        }
    }
}

