/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.subversion.remote.api.SVNConflictDescriptor;
import org.netbeans.modules.subversion.remote.api.SVNConflictVersion;

class ConflictDescriptionParser {
    private final List<ParserConflictDescriptor> conflicts = new LinkedList<ParserConflictDescriptor>();
    private static final String TOKEN_CONFLICT = "conflict";
    private static final String TOKEN_VERSION = "version";
    private static final char DELIMITER_SPACE = ' ';
    private static final char DELIMITER_OPEN_BRACKET = '(';
    private static final char DELIMITER_CLOSING_BRACKET = ')';
    private static final Logger LOG = Logger.getLogger(ConflictDescriptionParser.class.getName());

    private ConflictDescriptionParser() {
    }

    static ConflictDescriptionParser parseDescription(String description) {
        ConflictDescriptionParser parser = new ConflictDescriptionParser();
        try {
            parser.parse(description);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error parsing: " + description, ex);
        }
        return parser;
    }

    List<ParserConflictDescriptor> getConflicts() {
        return this.conflicts;
    }

    private void parse(String description) throws IOException {
        StringReader sr = new StringReader(description);
        if (sr.read() == 40) {
            while (true) {
                int c;
                if ((c = sr.read()) != -1 && c != 40 && c != 41) {
                    continue;
                }
                if (c == 41) break;
                if (c != 40) {
                    throw new IOException("Error parsing description: " + description);
                }
                ParserConflictDescriptor conflict = this.readConflict(sr);
                this.conflicts.add(conflict);
            }
        }
    }

    private ParserConflictDescriptor readConflict(Reader input) throws IOException {
        ParserConflictDescriptor conflict = null;
        String startToken = this.readToken(input, ' ');
        if (!TOKEN_CONFLICT.equals(startToken)) {
            throw new IOException("token 'conflict' expected");
        }
        String fileName = this.readString(input);
        String nodeKind = this.readToken(input, ' ');
        String operation = this.readToken(input, ' ');
        String action = this.readToken(input, ' ');
        String reason = this.readToken(input, ' ');
        SVNConflictVersion versionLeft = this.readVersion(input);
        SVNConflictVersion versionRight = this.readVersion(input);
        conflict = new ParserConflictDescriptor(fileName, null, SVNConflictDescriptor.Action.fromString(action), SVNConflictDescriptor.Reason.fromString(reason), SVNConflictDescriptor.Operation.fromString(operation), versionLeft, versionRight);
        this.readUntil(input, ')');
        return conflict;
    }

    private String readString(Reader input) throws IOException {
        String s = this.readToken(input, ' ');
        if (Character.isDigit(s.charAt(0))) {
            try {
                int len = Integer.parseInt(s);
                s = this.readToken(input, len);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Unexpected token, should be a number: " + s, ex);
            }
        }
        return s;
    }

    private String readToken(Reader input, int len) throws IOException {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)input.read());
        }
        return sb.toString();
    }

    private String readToken(Reader input, char delimiter) throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = this.skip(input, ' ');
        sb.append((char)c);
        while ((c = input.read()) != -1 && c != delimiter) {
            if (c == -1) {
                throw new IOException("Unexpected end of input");
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    private SVNConflictVersion readVersion(Reader input) throws IOException {
        long pegRevision;
        String url;
        SVNConflictVersion version = null;
        this.readUntil(input, '(');
        String startToken = this.readToken(input, ' ');
        if (TOKEN_VERSION.equals(startToken)) {
            url = this.readString(input);
            String s = this.readString(input);
            try {
                pegRevision = Long.parseLong(s);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Unexpected token, should be a number: " + s, ex);
            }
        } else {
            throw new IOException("token 'version' expected");
        }
        String repoPath = this.readString(input);
        String nodeKind = this.readToken(input, ')');
        version = new SVNConflictVersion(url, pegRevision, repoPath, SVNConflictVersion.NodeKind.fromString(nodeKind));
        return version;
    }

    private void readUntil(Reader input, char breakpoint) throws IOException {
        int c;
        while ((c = input.read()) != -1 && c != breakpoint) {
        }
        if (c == -1) {
            throw new IOException("Unexpected end of input");
        }
    }

    private int skip(Reader input, char characterToSkip) throws IOException {
        int c;
        while ((c = input.read()) == characterToSkip) {
        }
        return c;
    }

    static final class ParserConflictDescriptor
    extends SVNConflictDescriptor {
        private final String fileName;

        private ParserConflictDescriptor(String fileName, String path, SVNConflictDescriptor.Action action, SVNConflictDescriptor.Reason reason, SVNConflictDescriptor.Operation operation, SVNConflictVersion left, SVNConflictVersion right) {
            super(path, action, reason, operation, left, right);
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

