/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.parser;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class SvnWcUtils {
    static final String ENTRIES = "entries";
    private static final String PROPS = "props";
    private static final String PROPS_BASE = "prop-base";

    public static VCSFileProxy getSvnFile(VCSFileProxy file, String svnFileName) {
        VCSFileProxy svnFile = VCSFileProxy.createFileProxy((VCSFileProxy)file, (String)(".svn/" + svnFileName));
        if (VCSFileProxySupport.canRead((VCSFileProxy)svnFile)) {
            return svnFile;
        }
        return null;
    }

    public static VCSFileProxy getPropertiesFile(VCSFileProxy file, boolean base) {
        if (file.isFile()) {
            if (base) {
                return SvnWcUtils.getSvnFile(file.getParentFile(), "prop-base/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(base));
            }
            return SvnWcUtils.getSvnFile(file.getParentFile(), "props/" + file.getName() + SvnWcUtils.getPropFileNameSuffix(base));
        }
        return SvnWcUtils.getSvnFile(file, base ? "dir-prop-base" : "dir-props");
    }

    private static String getPropFileNameSuffix(boolean base) {
        if (base) {
            return ".svn-base";
        }
        return ".svn-work";
    }

    public static VCSFileProxy getTextBaseFile(VCSFileProxy file) throws IOException {
        return SvnWcUtils.getSvnFile(file.getParentFile(), "text-base/" + file.getName() + ".svn-base");
    }

    public static Date parseSvnDate(String inputValue) throws ParseException {
        Date returnValue = null;
        if (inputValue != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            int idx = inputValue.lastIndexOf(46);
            if (idx > 0) {
                idx = idx + 4 > inputValue.length() ? inputValue.length() : idx + 4;
                inputValue = inputValue.substring(0, idx) + "Z";
            }
            returnValue = dateFormat.parse(inputValue);
        }
        return returnValue;
    }

    static VCSFileProxy getEntriesFile(VCSFileProxy file) throws IOException {
        return SvnWcUtils.getSvnFile(!file.isDirectory() ? file.getParentFile() : file, ENTRIES);
    }
}

