/**
 * The select element allows the selection of an option. The contained options can be directly accessed through the select element as a collection. See the SELECT element definition in HTML 4.01.
 */
var HTMLSelectElement = {
}
/**
 * The ordinal index of the selected option, starting from 0. The value -1 is returned if no element is selected. If multiple options are selected, the index of the first selected option is returned.
 * @syntax hTMLSelectElement.selectedIndex
 * @returns {Number} 
 */
HTMLSelectElement.prototype.selectedIndex = new Number();

/**
 * Remove an element from the collection of OPTION elements for this SELECT. Does nothing if no element has the given index.
 * @syntax hTMLSelectElement.remove(index)
 * @param {Number} index The index of the item to remove, starting from 0.
 * @returns {undefined} 
 */
HTMLSelectElement.prototype.remove = function(index) {};

/**
 * Returns the FORM element containing this control. Returns null if this control is not within the context of a form.
 * @syntax hTMLSelectElement.form
 * @returns {HTMLFormElement} 
 */
HTMLSelectElement.prototype.form = new HTMLFormElement();

/**
 * Index that represents the element's position in the tabbing order. See the tabindex attribute definition in HTML 4.01.
 * @syntax hTMLSelectElement.tabIndex
 * @returns {Number} 
 */
HTMLSelectElement.prototype.tabIndex = new Number();

/**
 * Removes keyboard focus from this element.
 * @syntax hTMLSelectElement.blur()
 * @returns {undefined} 
 */
HTMLSelectElement.prototype.blur = function() {};

/**
 * The type of this form control. This is the string "select-multiple" when the multiple attribute is true and the string "select-one" when false.
 * @syntax hTMLSelectElement.type
 * @returns {String} 
 */
HTMLSelectElement.prototype.type = new String();

/**
 * Add a new element to the collection of OPTION elements for this SELECT. This method is the equivalent of the appendChild method of the Node interface if the before parameter is null. It is equivalent to the insertBefore method on the parent of before in all other cases. This method may have no effect if the new element is not an OPTION or an OPTGROUP.
 * @syntax hTMLSelectElement.add(element, before)
 * @param {HTMLElement} element The element to add.
 * @param {HTMLElement} before The element to insert before, or null for the tail of the list.
 * @returns {undefined} 
 */
HTMLSelectElement.prototype.add = function(element,  before) {};

/**
 * Number of visible rows. See the size attribute definition in HTML 4.01.
 * @syntax hTMLSelectElement.size
 * @returns {Number} 
 */
HTMLSelectElement.prototype.size = new Number();

/**
 * Form control or object name when submitted with a form. See the name attribute definition in HTML 4.01.
 * @syntax hTMLSelectElement.name
 * @returns {String} 
 */
HTMLSelectElement.prototype.name = new String();

/**
 * The number of options in this SELECT. Exceptions on setting DOMException NOT_SUPPORTED_ERR: if setting the length is not allowed by the implementation.
 * @syntax hTMLSelectElement.length
 * @returns {Number} 
 */
HTMLSelectElement.prototype.length = new Number();

/**
 * The current form control value (i.e. the value of the currently selected option), if multiple options are selected this is the value of the first selected option.
 * @syntax hTMLSelectElement.value
 * @returns {String} 
 */
HTMLSelectElement.prototype.value = new String();

/**
 * Gives keyboard focus to this element.
 * @syntax hTMLSelectElement.focus()
 * @returns {undefined} 
 */
HTMLSelectElement.prototype.focus = function() {};

/**
 * If true, multiple OPTION elements may be selected in this SELECT. See the multiple attribute definition in HTML 4.01.
 * @syntax hTMLSelectElement.multiple
 * @returns {boolean} 
 */
HTMLSelectElement.prototype.multiple = new boolean();

/**
 * The control is unavailable in this context. See the disabled attribute definition in HTML 4.01.
 * @syntax hTMLSelectElement.disabled
 * @returns {boolean} 
 */
HTMLSelectElement.prototype.disabled = new boolean();

/**
 * The collection of OPTION elements contained by this element.
 * @syntax hTMLSelectElement.options
 * @returns {HTMLOptionsCollection} 
 */
HTMLSelectElement.prototype.options = new HTMLOptionsCollection();

/**
 * Represents the HTMLSelectElement prototype object.
 * @syntax HTMLSelectElement.prototype
 * @static
 */
HTMLSelectElement.prototype;

