package org.clank.support.aliases;

import org.clank.support.Converted;
import org.clank.support.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.NativeMemory.*;


//<editor-fold defaultstate="collapsed" desc="template">
@Converted(kind = Converted.Kind.DUMMY, source = "${SPUTNIK}/modules/org.clank.java/src/org/clank/support/aliases/templates/memory.tpl")
//</editor-fold>
public interface ${FILE_NAME}${CLASS_SUFFIX} extends memory {
    
    /**
     * Gets value from memory at the given index
     * 
     * @param index
     * @return value
     */        
    ${Tp} $at(int index);
    
    /**
     * Replaces value in memory at the given index
     * 
     * @param value - new value
     * @return value
     */
    ${Tp} $set(int index, ${Tp} value);

    /**
     * modify value in memory at the given index (i.e. 'x[10] += value' in C++)
     * 
     * @param value - value
     * @return value
     */
    ${Tp} $set$andassign(int index, ${Tp} value); // "&="
    ${Tp} $set$xorassign(int index, ${Tp} value); // "^="
    ${Tp} $set$orassign(int index, ${Tp} value); // "|=" 
    ${ADDITIONAL_MODIFY_VALUE_SECTION_START}
    ${Tp} $set$addassign(int index, ${Tp} value); // "+=" 
    ${Tp} $set$minusassign(int index, ${Tp} value); // "-="
    ${Tp} $set$starassign(int index, ${Tp} value); // "*="    
    ${Tp} $set$slashassign(int index, ${Tp} value); // "/="
    ${Tp} $set$modassign(int index, ${Tp} value); // "%=" 
    ${Tp} $set$lshiftassign(int index, ${Tp} value); // "<<="
    ${Tp} $set$rshiftassign(int index, ${Tp} value); // ">>="    
    ${Tp} $set$postInc(int index); // "x++"    
    ${Tp} $set$postDec(int index); // "x--"    
    ${Tp} $set$preInc(int index); // "++x"    
    ${Tp} $set$preDec(int index); // "--x"    
    ${ADDITIONAL_MODIFY_VALUE_SECTION_END}
}