/**
 * @since ECMAScript6
 */
var Reflect = {
}
/**
 * @since ECMAScript6
 * @syntax Reflect.getOwnPropertyDescriptor(target, propertyKey)
 * @param {Object} target
 * @param {String} propertyKey
 * @returns {Object}
 * @static
 */
Reflect.getOwnPropertyDescriptor = function(target, propertyKey) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.set(target, propertyKey, value[, receiver])
 * @param {Object} target
 * @param {String} propertyKey
 * @param {String} value
 * @param {String} receiver
 * @returns {Boolean}
 * @static
 */
Reflect.set = function(target, propertyKey, value) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.getPrototypeOf(target)
 * @param {Object} target
 * @returns {Boolean}
 * @static
 */
Reflect.getPrototypeOf = function(target) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.isExtensible(target)
 * @param {Object} target
 * @returns {Boolean}
 * @static
 */
Reflect.isExtensible = function(target) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.setPrototypeOf(target, prototype)
 * @param {Object} target
 * @param {Object} prototype
 * @returns {Boolean}
 * @static
 */
Reflect.setPrototypeOf = function(target, prototype) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.construct(target, argumentsList[, newTarget])
 * @param {String} target
 * @param {Object} argumentsList
 * @param {String} newTarget
 * @returns {Boolean}
 * @static
 */
Reflect.construct = function(target, argumentsList) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.get(target, propertyKey[, receiver])
 * @param {Object} target
 * @param {String} propertyKey
 * @param {String} receiver
 * @returns {Object}
 * @static
 */
Reflect.get = function(target, propertyKey) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.preventExtensions(target)
 * @param {Object} target
 * @returns {Boolean}
 * @static
 */
Reflect.preventExtensions = function(target) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.deleteProperty(target, propertyKey)
 * @param {Object} target
 * @param {String} propertyKey
 * @returns {Boolean}
 * @static
 */
Reflect.deleteProperty = function(target, propertyKey) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.defineProperty(target, propertyKey, attributes)
 * @param {Object} target
 * @param {String} propertyKey
 * @param {String} attributes
 * @returns {Boolean}
 * @static
 */
Reflect.defineProperty = function(target, propertyKey, attributes) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.ownKeys(target)
 * @param {Object} target
 * @returns {Array}
 * @static
 */
Reflect.ownKeys = function(target) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.has(target, propertyKey)
 * @param {Object} target
 * @param {String} propertyKey
 * @returns {Boolean}
 * @static
 */
Reflect.has = function(target, propertyKey) {};

/**
 * @since ECMAScript6
 * @syntax Reflect.apply(target, thisArgument, argumentsList)
 * @param {String} target
 * @param {String} thisArgument
 * @param {Object} argumentsList
 * @returns {undefined}
 * @static
 */
Reflect.apply = function(target, thisArgument, argumentsList) {};

/**
 * Represents the Reflect prototype object.
 * @syntax Reflect.prototype
 * @static
 */
Reflect.prototype;

