/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.regex;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import edu.washington.cs.knowitall.regex.Expression;
import edu.washington.cs.knowitall.regex.FiniteAutomaton;
import edu.washington.cs.knowitall.regex.Match;
import edu.washington.cs.knowitall.regex.RegularExpressionParser;
import edu.washington.cs.knowitall.regex.RegularExpressionParsers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public class RegularExpression<E>
implements Predicate<List<E>> {
    public final List<Expression<E>> expressions;
    public final FiniteAutomaton.Automaton<E> auto;

    public RegularExpression(List<Expression<E>> expressions) {
        this.expressions = expressions;
        this.auto = RegularExpression.build(this.expressions);
    }

    public static <E> RegularExpression<E> compile(List<Expression<E>> expressions) {
        return new RegularExpression<E>(expressions);
    }

    public static <E> RegularExpression<E> compile(String expression, final Function<String, Expression.BaseExpression<E>> factoryDelegate) {
        return new RegularExpressionParser<E>(){

            @Override
            public Expression.BaseExpression<E> factory(String token) {
                return (Expression.BaseExpression)factoryDelegate.apply((Object)token);
            }
        }.parse(expression);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegularExpression)) {
            return false;
        }
        RegularExpression expression = (RegularExpression)other;
        return this.toString().equals(expression.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        ArrayList<String> expressions = new ArrayList<String>(this.expressions.size());
        for (Expression<E> expr : this.expressions) {
            expressions.add(expr.toString());
        }
        return Joiner.on((String)" ").join(expressions);
    }

    public static <E> FiniteAutomaton.Automaton<E> build(List<Expression<E>> exprs) {
        Expression.MatchingGroup<E> group = new Expression.MatchingGroup<E>(exprs);
        return group.build();
    }

    public boolean apply(List<E> tokens) {
        return this.find(tokens) != null;
    }

    public boolean matches(List<E> tokens) {
        Match<E> match = this.lookingAt(tokens, 0);
        return match != null && match.endIndex() == tokens.size();
    }

    public Match<E> find(List<E> tokens) {
        return this.find(tokens, 0);
    }

    public Match<E> find(List<E> tokens, int start) {
        for (int i = start; i <= tokens.size() - this.auto.minMatchingLength(); ++i) {
            Match<E> match = this.lookingAt(tokens, i);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public Match<E> lookingAt(List<E> tokens) {
        return this.lookingAt(tokens, 0);
    }

    public Match<E> lookingAt(List<E> tokens, int start) {
        return this.auto.lookingAt(tokens, start);
    }

    public Match<E> match(List<E> tokens) {
        Match<E> match = this.lookingAt(tokens);
        if (match != null && match.endIndex() == tokens.size()) {
            return match;
        }
        return null;
    }

    public List<Match<E>> findAll(List<E> tokens) {
        Match<E> match;
        ArrayList<Match<Match<E>>> results = new ArrayList<Match<Match<E>>>();
        int start = 0;
        do {
            if ((match = this.find(tokens, start)) == null) continue;
            start = match.endIndex();
            if (match.isEmpty()) continue;
            results.add(match);
        } while (match != null);
        return results;
    }

    public static void main(String[] args) {
        Scanner scan = new Scanner(System.in);
        RegularExpression<String> regex = RegularExpressionParsers.word.parse(args[0]);
        System.out.println("regex: " + regex);
        System.out.println();
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            System.out.println("contains: " + regex.apply(Arrays.asList(line.split("\\s+"))));
            System.out.println("matches:  " + regex.matches(Arrays.asList(line.split("\\s+"))));
            System.out.println();
        }
        scan.close();
    }
}

