/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 \u001c*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001cB!\b\u0002\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u0013J\b\u0010\u001b\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kotlin/jupyter/core/util/ExecutedOnceBackgroundTask;", "T", "Lcom/intellij/openapi/Disposable;", "restartOnErrorAttemptsCount", "", "action", "Lkotlin/Function0;", "<init>", "(ILkotlin/jvm/functions/Function0;)V", "_action", "_bgTask", "Lcom/intellij/openapi/progress/util/BackgroundTaskUtil$BackgroundTask;", "_result", "", "_wasStarted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "_completedSuccessfully", "", "startIfNotStarted", "", "start", "join", "isCompletedSuccessfully", "()Z", "result", "getResult", "()Ljava/lang/Object;", "dispose", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nthreading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 threading.kt\ncom/intellij/kotlin/jupyter/core/util/ExecutedOnceBackgroundTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,175:1\n14#2:176\n*S KotlinDebug\n*F\n+ 1 threading.kt\ncom/intellij/kotlin/jupyter/core/util/ExecutedOnceBackgroundTask\n*L\n87#1:176\n*E\n"})
public final class ExecutedOnceBackgroundTask<T>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int restartOnErrorAttemptsCount;
    @Nullable
    private Function0<? extends T> _action;
    @Nullable
    private BackgroundTaskUtil.BackgroundTask<T> _bgTask;
    @Nullable
    private volatile Object _result;
    @NotNull
    private final AtomicBoolean _wasStarted;
    private volatile boolean _completedSuccessfully;
    @NotNull
    private static final Logger LOG;

    private ExecutedOnceBackgroundTask(int restartOnErrorAttemptsCount, Function0<? extends T> action) {
        this.restartOnErrorAttemptsCount = restartOnErrorAttemptsCount;
        this._action = action;
        this._wasStarted = new AtomicBoolean(false);
    }

    /* synthetic */ ExecutedOnceBackgroundTask(int n, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n, function0);
    }

    public final void startIfNotStarted() {
        if (!this._wasStarted.compareAndSet(false, true)) {
            return;
        }
        this.start();
    }

    private final void start() {
        Function0<? extends T> function0 = this._action;
        if (function0 == null) {
            throw new IllegalStateException("Task was already executed".toString());
        }
        Function0<? extends T> action = function0;
        BackgroundTaskUtil.BackgroundTask backgroundTask = BackgroundTaskUtil.submitTask((Executor)AppExecutorUtil.getAppExecutorService(), (Disposable)this, () -> ExecutedOnceBackgroundTask.start$lambda$0(action));
        Intrinsics.checkNotNullExpressionValue((Object)backgroundTask, (String)"submitTask(...)");
        BackgroundTaskUtil.BackgroundTask bgTask = backgroundTask;
        bgTask.getFuture().whenComplete((arg_0, arg_1) -> ExecutedOnceBackgroundTask.start$lambda$2((arg_0, arg_1) -> ExecutedOnceBackgroundTask.start$lambda$1(this, arg_0, arg_1), arg_0, arg_1));
        this._bgTask = bgTask;
    }

    public final void join() {
        BackgroundTaskUtil.BackgroundTask<T> backgroundTask = this._bgTask;
        if (backgroundTask == null) {
            return;
        }
        BackgroundTaskUtil.BackgroundTask<T> bgTask = backgroundTask;
        bgTask.awaitCompletion();
    }

    public final boolean isCompletedSuccessfully() {
        return this._completedSuccessfully;
    }

    public final T getResult() {
        boolean bl = this._completedSuccessfully;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return (T)this._result;
    }

    public void dispose() {
        BackgroundTaskUtil.BackgroundTask<T> backgroundTask = this._bgTask;
        if (backgroundTask != null) {
            backgroundTask.cancel();
        }
        this._bgTask = null;
        this._action = null;
    }

    private static final Object start$lambda$0(Function0 $tmp0) {
        return $tmp0.invoke();
    }

    private static final Unit start$lambda$1(ExecutedOnceBackgroundTask this$0, Object result2, Throwable exception) {
        if (exception != null) {
            LOG.warn("Background task failed, attempts left: " + this$0.restartOnErrorAttemptsCount, exception);
            if (this$0.restartOnErrorAttemptsCount > 0) {
                this$0.restartOnErrorAttemptsCount += -1;
                int cfr_ignored_0 = this$0.restartOnErrorAttemptsCount;
                this$0.start();
                return Unit.INSTANCE;
            }
        } else {
            this$0._result = result2;
            this$0._completedSuccessfully = true;
        }
        this$0._action = null;
        this$0._bgTask = null;
        return Unit.INSTANCE;
    }

    private static final void start$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public /* synthetic */ ExecutedOnceBackgroundTask(int restartOnErrorAttemptsCount, Function0 action, DefaultConstructorMarker $constructor_marker) {
        this(restartOnErrorAttemptsCount, action);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExecutedOnceBackgroundTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u0004\b\u0001\u0010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kotlin/jupyter/core/util/ExecutedOnceBackgroundTask$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/intellij/kotlin/jupyter/core/util/ExecutedOnceBackgroundTask;", "T", "restartOnErrorAttemptsCount", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "action", "Lkotlin/Function0;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> ExecutedOnceBackgroundTask<T> create(int restartOnErrorAttemptsCount, @NotNull Disposable parentDisposable, @NotNull Function0<? extends T> action) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            ExecutedOnceBackgroundTask task = new ExecutedOnceBackgroundTask(restartOnErrorAttemptsCount, action, null);
            Disposer.register((Disposable)parentDisposable, (Disposable)task);
            return task;
        }

        public static /* synthetic */ ExecutedOnceBackgroundTask create$default(Companion companion, int n, Disposable disposable, Function0 function0, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.create(n, disposable, function0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

