/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.k1.scriptingSupport;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.kotlin.jupyter.core.scriptingSupport.IndexAwareScriptDefinitionsLoadRequestor;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerPerFileService;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.scriptingSupport.listeners.ScriptingSupportUpdateEventsListener;
import com.intellij.kotlin.jupyter.core.scriptingSupport.listeners.ScriptingSupportUpdateEventsListenerKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.LoggingKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.SourceCode;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.k1.ScriptClassRootsUpdater;
import org.jetbrains.kotlin.idea.core.script.k1.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.ScriptingSupport;
import org.jetbrains.kotlin.idea.core.script.k1.ucache.ScriptClassRootsBuilder;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u00112\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020\u0011*\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport;", "Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/ScriptingSupport;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "compilerService", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/JupyterCompilerService;", "editorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "getEditorManager", "()Lcom/intellij/openapi/fileEditor/FileEditorManager;", "indexAwareScriptDefinitionsRequestor", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/IndexAwareScriptDefinitionsLoadRequestor;", "scriptingSupportPublisher", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/listeners/ScriptingSupportUpdateEventsListener;", "afterUpdate", "", "onUpdateException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onTrivialUpdate", "collectConfigurations", "builder", "Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsBuilder;", "getConfigurationImmediately", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isApplicable", "", "isConfigurationLoadingInProgress", "Lorg/jetbrains/kotlin/psi/KtFile;", "addRootsFromNotebooks", "notebooks", "", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Companion", "intellij.kotlin.jupyter.k1"})
@SourceDebugExtension(value={"SMAP\nJupyterKtScriptingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterKtScriptingSupport.kt\ncom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n11546#2,9:140\n13472#2:149\n13473#2:151\n11555#2:152\n11546#2,9:156\n13472#2:165\n13473#2:167\n11555#2:168\n1#3:150\n1#3:166\n1#3:182\n774#4:153\n865#4,2:154\n774#4:169\n865#4,2:170\n1617#4,9:172\n1869#4:181\n1870#4:183\n1626#4:184\n774#4:185\n865#4,2:186\n1563#4:188\n1634#4,3:189\n1563#4:192\n1634#4,3:193\n1869#4,2:196\n14#5:198\n*S KotlinDebug\n*F\n+ 1 JupyterKtScriptingSupport.kt\ncom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport\n*L\n63#1:140,9\n63#1:149\n63#1:151\n63#1:152\n66#1:156,9\n66#1:165\n66#1:167\n66#1:168\n63#1:150\n66#1:166\n70#1:182\n65#1:153\n65#1:154,2\n69#1:169\n69#1:170,2\n70#1:172,9\n70#1:181\n70#1:183\n70#1:184\n71#1:185\n71#1:186,2\n97#1:188\n97#1:189,3\n98#1:192\n98#1:193,3\n102#1:196,2\n112#1:198\n*E\n"})
public final class JupyterKtScriptingSupport
implements ScriptingSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JupyterCompilerService compilerService;
    @NotNull
    private final IndexAwareScriptDefinitionsLoadRequestor indexAwareScriptDefinitionsRequestor;
    @NotNull
    private final ScriptingSupportUpdateEventsListener scriptingSupportPublisher;
    @NotNull
    private static final Logger LOG;

    public JupyterKtScriptingSupport(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.compilerService = JupyterCompilerService.Companion.getInstance(this.project);
        this.indexAwareScriptDefinitionsRequestor = new IndexAwareScriptDefinitionsLoadRequestor(this.project);
        this.scriptingSupportPublisher = (ScriptingSupportUpdateEventsListener)this.project.getMessageBus().syncPublisher(ScriptingSupportUpdateEventsListenerKt.getSCRIPTING_SUPPORT_TOPIC());
    }

    private final FileEditorManager getEditorManager() {
        return FileEditorManager.getInstance((Project)this.project);
    }

    public void afterUpdate() {
        try {
            ScriptingSupportUpdateEventsListener.afterUpdate$default(this.scriptingSupportPublisher, null, 1, null);
            this.indexAwareScriptDefinitionsRequestor.reloadDefinitions();
        }
        catch (Exception ex) {
            if (ex instanceof ProcessCanceledException) {
                this.indexAwareScriptDefinitionsRequestor.reloadDefinitions();
            }
            LOG.warn("Post-update: error occurred during reloading of script configurations", (Throwable)ex);
        }
    }

    public void onUpdateException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.scriptingSupportPublisher.onUpdateException(exception);
    }

    public void onTrivialUpdate() {
        this.scriptingSupportPublisher.onTrivialUpdate();
    }

    /*
     * WARNING - void declaration
     */
    public void collectConfigurations(@NotNull ScriptClassRootsBuilder builder) {
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$filterTo$iv$iv2;
        Collection $this$filter$iv2;
        VirtualFile it$iv$iv;
        VirtualFile it;
        void $this$mapNotNullTo$iv$iv2;
        FileEditor[] editors;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        FileEditor[] fileEditorArray = this.getEditorManager();
        if (fileEditorArray == null || (fileEditorArray = fileEditorArray.getAllEditors()) == null) {
            return;
        }
        Object $this$mapNotNull$iv2 = editors = fileEditorArray;
        boolean $i$f$mapNotNull = false;
        FileEditor[] fileEditorArray2 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            it = element$iv$iv;
            boolean bl2 = false;
            JupyterFileEditor jupyterFileEditor = it instanceof JupyterFileEditor ? (JupyterFileEditor)it : null;
            if ((jupyterFileEditor != null ? jupyterFileEditor.getNotebookFile() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv2 = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            VirtualFile it2 = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(it2.getFileType() instanceof JupyterFileType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        if ($this$filter$iv2.isEmpty()) {
            void $this$mapNotNullTo$iv$iv3;
            boolean bl = false;
            FileEditor[] $this$mapNotNull$iv3 = editors;
            boolean $i$f$mapNotNull2 = false;
            FileEditor[] $i$f$filterTo2 = $this$mapNotNull$iv3;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv3;
            boolean $i$f$forEach2 = false;
            int element$iv$iv = ((void)$this$forEach$iv$iv$iv2).length;
            for (int element$iv$iv$iv = 0; element$iv$iv$iv < element$iv$iv; ++element$iv$iv$iv) {
                VirtualFile it$iv$iv2;
                void element$iv$iv$iv2;
                void element$iv$iv2 = element$iv$iv$iv2 = $this$forEach$iv$iv$iv2[element$iv$iv$iv];
                boolean bl4 = false;
                void it3 = element$iv$iv2;
                boolean bl5 = false;
                VirtualFile virtualFile = it3.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile);
                if ((backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getFile() : null) == null) continue;
                it$iv$iv2 = it$iv$iv2;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            collection = (List)destination$iv$iv2;
        } else {
            collection = $this$filter$iv2;
        }
        List openFiles = (List)collection;
        Iterable bl = openFiles;
        boolean $i$f$filter2 = false;
        void $i$f$mapNotNull2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it4 = (VirtualFile)element$iv$iv;
            boolean bl7 = false;
            if (!(it4.getFileType() instanceof JupyterFileType)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$mapNotNull3 = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo3 = false;
        void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        BackedNotebookVirtualFile it4 = $this$forEach$iv$iv$iv3.iterator();
        while (it4.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it4.next();
            boolean bl8 = false;
            it = (VirtualFile)element$iv$iv;
            boolean bl9 = false;
            if (BackedNotebookVirtualFile.Companion.takeIfBacked(it) == null) continue;
            boolean bl10 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv3;
        $i$f$filter2 = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it4 = (BackedNotebookVirtualFile)element$iv$iv;
            boolean bl11 = false;
            if (!IsKotlinNotebookKt.isKotlinNotebook(it4.getFile())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List notebookFiles = (List)destination$iv$iv3;
        this.addRootsFromNotebooks(builder, notebookFiles);
    }

    @Nullable
    public ScriptCompilationConfigurationWrapper getConfigurationImmediately(@NotNull VirtualFile file) {
        ScriptCompilationConfigurationWrapper conf;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof VirtualFileWindow)) {
            return null;
        }
        PsiFile psiFile = UtilKt.findPsiFile(file, this.project);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof KtFile)) {
            return null;
        }
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics = Companion.getDefaultConfiguration((KtFile)psiFile2);
        Object object = conf = resultWithDiagnostics != null ? (ScriptCompilationConfigurationWrapper)ErrorHandlingKt.valueOrNull(resultWithDiagnostics) : null;
        if (conf == null) {
            Attachment[] attachmentArray = new Attachment[]{new Attachment(((KtFile)psiFile2).getName(), ((KtFile)psiFile2).getText())};
            LoggingKt.errorWithAttachments(LOG, "Can't retrieve fast configuration", attachmentArray);
        }
        return conf;
    }

    public boolean isApplicable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)this.compilerService.getFileSuffix(), (boolean)false, (int)2, null);
    }

    public boolean isConfigurationLoadingInProgress(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JupyterKtScriptingSupport.Companion.getUpdater(this.project).isTransactionAboutToHappen();
    }

    private final void addRootsFromNotebooks(ScriptClassRootsBuilder $this$addRootsFromNotebooks, Collection<? extends BackedNotebookVirtualFile> notebooks) {
        for (BackedNotebookVirtualFile backedNotebookVirtualFile : notebooks) {
            File it;
            boolean bl;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            JupyterCompilerPerFileService notebookService = JupyterCompilerService.Companion.getForFile($this$addRootsFromNotebooks.getProject(), backedNotebookVirtualFile);
            Iterable iterable = notebookService.getCurrentClasspath();
            ScriptClassRootsBuilder scriptClassRootsBuilder = $this$addRootsFromNotebooks;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                collection.add(it.getAbsolutePath());
            }
            scriptClassRootsBuilder.addTemplateClassesRoots((Collection)((List)destination$iv$iv));
            $this$map$iv = notebookService.getCurrentSourceRoots();
            scriptClassRootsBuilder = $this$addRootsFromNotebooks;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (File)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                collection.add(it.getAbsolutePath());
            }
            scriptClassRootsBuilder.addSources((Collection)((List)destination$iv$iv));
            $this$addRootsFromNotebooks.warnAboutDependenciesExistence(false);
            try {
                Iterable $this$forEach$iv = notebookService.scripts();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    VirtualFile file = (VirtualFile)pair.component1();
                    ScriptCompilationConfigurationWrapper conf = (ScriptCompilationConfigurationWrapper)pair.component2();
                    $this$addRootsFromNotebooks.add(file, conf);
                }
            }
            catch (Throwable e) {
                if (e instanceof ProcessCanceledException) {
                    throw e;
                }
                LOG.error("Notebook injected scripts can't be obtained. Notebook: [" + backedNotebookVirtualFile + "]", e);
            }
            $this$addRootsFromNotebooks.warnAboutDependenciesExistence(true);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JupyterKtScriptingSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getUpdater", "Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptClassRootsUpdater;", "project", "Lcom/intellij/openapi/project/Project;", "updateSynchronously", "", "getDefaultConfiguration", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationResult;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "intellij.kotlin.jupyter.k1"})
    @SourceDebugExtension(value={"SMAP\nJupyterKtScriptingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterKtScriptingSupport.kt\ncom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport$Companion\n+ 2 ScriptClassRootsUpdater.kt\norg/jetbrains/kotlin/idea/core/script/k1/ScriptClassRootsUpdater\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,139:1\n162#2,5:140\n125#3:145\n*S KotlinDebug\n*F\n+ 1 JupyterKtScriptingSupport.kt\ncom/intellij/kotlin/jupyter/k1/scriptingSupport/JupyterKtScriptingSupport$Companion\n*L\n118#1:140,5\n125#1:145\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ScriptClassRootsUpdater getUpdater(Project project) {
            return ScriptConfigurationManager.Companion.getInstance(project).getUpdater();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void updateSynchronously(@NotNull Project project) {
            ScriptClassRootsUpdater updater;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ScriptClassRootsUpdater this_$iv = updater = this.getUpdater(project);
            boolean $i$f$update = false;
            try {
                boolean bl = false;
                updater.invalidate(true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.commit();
            }
        }

        @Nullable
        public final ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getDefaultConfiguration(@NotNull KtFile psiFile) {
            VirtualFileWindow virtualFile;
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 != null) {
                VirtualFile $this$safeAs$iv = virtualFile2;
                boolean $i$f$safeAs = false;
                VirtualFile virtualFile3 = $this$safeAs$iv;
                if (!(virtualFile3 instanceof VirtualFileWindow)) {
                    virtualFile3 = null;
                }
                v2 = (VirtualFileWindow)virtualFile3;
            } else {
                v2 = virtualFile = null;
            }
            if (virtualFile == null) {
                LOG.error("Can't retrieve virtual file window for " + psiFile);
                return null;
            }
            VirtualFile virtualFile4 = virtualFile.getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"getDelegate(...)");
            VirtualFile notebookVirtualFile = virtualFile4;
            BackedNotebookVirtualFile notebookFile = UtilKt.toBackedNotebookFile(notebookVirtualFile);
            Project project = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            JupyterCompilerPerFileService compilerService = JupyterCompilerService.Companion.getForFile(project, notebookFile);
            KtFileScriptSource sourceCode = new KtFileScriptSource(psiFile, null, 2, null);
            return compilerService.provideDefaultConfiguration((SourceCode)sourceCode);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

