/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RegExpGroupImpl
extends RegExpElementImpl
implements RegExpGroup {
    public RegExpGroupImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpGroup(this);
    }

    @Override
    @NotNull
    public RegExpPattern getPattern() {
        ASTNode node = this.getNode().findChildByType(RegExpElementTypes.PATTERN);
        assert (node != null);
        RegExpPattern regExpPattern = (RegExpPattern)node.getPsi();
        if (regExpPattern == null) {
            RegExpGroupImpl.$$$reportNull$$$0(0);
        }
        return regExpPattern;
    }

    @Override
    public boolean isCapturing() {
        RegExpGroup.Type type = this.getType();
        return type == RegExpGroup.Type.CAPTURING_GROUP || type == RegExpGroup.Type.NAMED_GROUP || type == RegExpGroup.Type.QUOTED_NAMED_GROUP || type == RegExpGroup.Type.PYTHON_NAMED_GROUP;
    }

    @Override
    public boolean isAnyNamedGroup() {
        RegExpGroup.Type type = this.getType();
        return type == RegExpGroup.Type.NAMED_GROUP || type == RegExpGroup.Type.QUOTED_NAMED_GROUP || type == RegExpGroup.Type.PYTHON_NAMED_GROUP;
    }

    @Override
    public RegExpGroup.Type getType() {
        IElementType elementType = this.getNode().getFirstChildNode().getElementType();
        if (elementType == RegExpTT.GROUP_BEGIN) {
            return RegExpGroup.Type.CAPTURING_GROUP;
        }
        if (elementType == RegExpTT.RUBY_NAMED_GROUP) {
            return RegExpGroup.Type.NAMED_GROUP;
        }
        if (elementType == RegExpTT.PYTHON_NAMED_GROUP) {
            return RegExpGroup.Type.PYTHON_NAMED_GROUP;
        }
        if (elementType == RegExpTT.RUBY_QUOTED_NAMED_GROUP) {
            return RegExpGroup.Type.QUOTED_NAMED_GROUP;
        }
        if (elementType == RegExpTT.ATOMIC_GROUP) {
            return RegExpGroup.Type.ATOMIC;
        }
        if (elementType == RegExpTT.NON_CAPT_GROUP) {
            return RegExpGroup.Type.NON_CAPTURING;
        }
        if (elementType == RegExpTT.SET_OPTIONS) {
            return RegExpGroup.Type.OPTIONS;
        }
        if (elementType == RegExpTT.POS_LOOKAHEAD) {
            return RegExpGroup.Type.POSITIVE_LOOKAHEAD;
        }
        if (elementType == RegExpTT.NEG_LOOKAHEAD) {
            return RegExpGroup.Type.NEGATIVE_LOOKAHEAD;
        }
        if (elementType == RegExpTT.POS_LOOKBEHIND) {
            return RegExpGroup.Type.POSITIVE_LOOKBEHIND;
        }
        if (elementType == RegExpTT.NEG_LOOKBEHIND) {
            return RegExpGroup.Type.NEGATIVE_LOOKBEHIND;
        }
        if (elementType == RegExpTT.PCRE_BRANCH_RESET) {
            return RegExpGroup.Type.PCRE_BRANCH_RESET;
        }
        throw new AssertionError();
    }

    public static boolean isPcreConditionalGroup(ASTNode node) {
        return node != null && node.findChildByType(RegExpTT.PCRE_CONDITIONS) != null;
    }

    public static boolean isPcreDefine(ASTNode node) {
        return node != null && node.findChildByType(RegExpTT.PCRE_DEFINE) != null;
    }

    @Override
    public String getGroupName() {
        ASTNode nameNode = this.getNode().findChildByType(RegExpTT.NAME);
        return nameNode != null ? nameNode.getText() : null;
    }

    public String getName() {
        return this.getGroupName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            RegExpGroupImpl.$$$reportNull$$$0(1);
        }
        throw new IncorrectOperationException();
    }

    public int getTextOffset() {
        return this.getFirstChild().getNextSibling().getTextOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/psi/impl/RegExpGroupImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/psi/impl/RegExpGroupImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

