/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\rJ.\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\rR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u001a\u0010\r\u00a8\u0006\u001c"}, d2={"Lio/ktor/http/HttpProtocolVersion;", "", "", "name", "", "major", "minor", "<init>", "(Ljava/lang/String;II)V", "toString", "()Ljava/lang/String;", "component1", "component2", "()I", "component3", "copy", "(Ljava/lang/String;II)Lio/ktor/http/HttpProtocolVersion;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "Ljava/lang/String;", "getName", "I", "getMajor", "getMinor", "Companion", "ktor-http"})
public final class HttpProtocolVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int major;
    private final int minor;
    @NotNull
    private static final HttpProtocolVersion HTTP_2_0 = new HttpProtocolVersion("HTTP", 2, 0);
    @NotNull
    private static final HttpProtocolVersion HTTP_1_1 = new HttpProtocolVersion("HTTP", 1, 1);
    @NotNull
    private static final HttpProtocolVersion HTTP_1_0 = new HttpProtocolVersion("HTTP", 1, 0);
    @NotNull
    private static final HttpProtocolVersion SPDY_3 = new HttpProtocolVersion("SPDY", 3, 0);
    @NotNull
    private static final HttpProtocolVersion QUIC = new HttpProtocolVersion("QUIC", 1, 0);

    public HttpProtocolVersion(@NotNull String name, int major, int minor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.major = major;
        this.minor = minor;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    @NotNull
    public String toString() {
        return this.name + '/' + this.major + '.' + this.minor;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.major;
    }

    public final int component3() {
        return this.minor;
    }

    @NotNull
    public final HttpProtocolVersion copy(@NotNull String name, int major, int minor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new HttpProtocolVersion(name, major, minor);
    }

    public static /* synthetic */ HttpProtocolVersion copy$default(HttpProtocolVersion httpProtocolVersion, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = httpProtocolVersion.name;
        }
        if ((n3 & 2) != 0) {
            n = httpProtocolVersion.major;
        }
        if ((n3 & 4) != 0) {
            n2 = httpProtocolVersion.minor;
        }
        return httpProtocolVersion.copy(string, n, n2);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.major);
        result2 = result2 * 31 + Integer.hashCode(this.minor);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpProtocolVersion)) {
            return false;
        }
        HttpProtocolVersion httpProtocolVersion = (HttpProtocolVersion)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)httpProtocolVersion.name)) {
            return false;
        }
        if (this.major != httpProtocolVersion.major) {
            return false;
        }
        return this.minor == httpProtocolVersion.minor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0015\u0010\u0013R\u0017\u0010\u0016\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u0018\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0019\u0010\u0013R\u0017\u0010\u001a\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0011\u001a\u0004\b\u001b\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lio/ktor/http/HttpProtocolVersion$Companion;", "", "<init>", "()V", "", "name", "", "major", "minor", "Lio/ktor/http/HttpProtocolVersion;", "fromValue", "(Ljava/lang/String;II)Lio/ktor/http/HttpProtocolVersion;", "", "value", "parse", "(Ljava/lang/CharSequence;)Lio/ktor/http/HttpProtocolVersion;", "HTTP_2_0", "Lio/ktor/http/HttpProtocolVersion;", "getHTTP_2_0", "()Lio/ktor/http/HttpProtocolVersion;", "HTTP_1_1", "getHTTP_1_1", "HTTP_1_0", "getHTTP_1_0", "SPDY_3", "getSPDY_3", "QUIC", "getQUIC", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpProtocolVersion getHTTP_2_0() {
            return HTTP_2_0;
        }

        @NotNull
        public final HttpProtocolVersion getHTTP_1_1() {
            return HTTP_1_1;
        }

        @NotNull
        public final HttpProtocolVersion getHTTP_1_0() {
            return HTTP_1_0;
        }

        @NotNull
        public final HttpProtocolVersion getSPDY_3() {
            return SPDY_3;
        }

        @NotNull
        public final HttpProtocolVersion getQUIC() {
            return QUIC;
        }

        @NotNull
        public final HttpProtocolVersion fromValue(@NotNull String name, int major, int minor) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Intrinsics.areEqual((Object)name, (Object)"HTTP") && major == 1 && minor == 0 ? this.getHTTP_1_0() : (Intrinsics.areEqual((Object)name, (Object)"HTTP") && major == 1 && minor == 1 ? this.getHTTP_1_1() : (Intrinsics.areEqual((Object)name, (Object)"HTTP") && major == 2 && minor == 0 ? this.getHTTP_2_0() : new HttpProtocolVersion(name, major, minor)));
        }

        @NotNull
        public final HttpProtocolVersion parse(@NotNull CharSequence value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object object = new String[]{"/", "."};
            Object it = object = StringsKt.split$default((CharSequence)value, (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            if (!(it.size() == 3)) {
                boolean bl2 = false;
                String string = "Failed to parse HttpProtocolVersion. Expected format: protocol/major.minor, but actual: " + value;
                throw new IllegalStateException(string.toString());
            }
            Object object2 = object;
            String protocol = (String)object2.get(0);
            String major = (String)object2.get(1);
            String minor = (String)object2.get(2);
            return this.fromValue(protocol, Integer.parseInt(major), Integer.parseInt(minor));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

