/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.catboostOld;

import com.jetbrains.ml.tools.model.catboostOld.InconsistentMetadataException;
import com.jetbrains.ml.tools.model.catboostOld.ModelReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/JavaResourcesModelReader;", "Lcom/jetbrains/ml/tools/model/catboostOld/ModelReader;", "metadataHolder", "Ljava/lang/Class;", "metadataRelativePath", "Ljava/nio/file/Path;", "binaryRelativePath", "(Ljava/lang/Class;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "openModelBinaryStream", "Ljava/io/InputStream;", "readBinaryFeatures", "", "readCategoricalFeatures", "readFeatureOrder", "", "readFloatFeatures", "readKnownFeatures", "readResourceContent", "fileName", "readVersion", "ml-tools"})
@SourceDebugExtension(value={"SMAP\nJavaResourcesModelReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaResourcesModelReader.kt\ncom/jetbrains/ml/tools/model/catboostOld/JavaResourcesModelReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public class JavaResourcesModelReader
implements ModelReader {
    @NotNull
    private final Class<?> metadataHolder;
    @NotNull
    private final Path metadataRelativePath;
    @NotNull
    private final Path binaryRelativePath;

    public JavaResourcesModelReader(@NotNull Class<?> metadataHolder, @NotNull Path metadataRelativePath, @NotNull Path binaryRelativePath) {
        Intrinsics.checkNotNullParameter(metadataHolder, (String)"metadataHolder");
        Intrinsics.checkNotNullParameter((Object)metadataRelativePath, (String)"metadataRelativePath");
        Intrinsics.checkNotNullParameter((Object)binaryRelativePath, (String)"binaryRelativePath");
        this.metadataHolder = metadataHolder;
        this.metadataRelativePath = metadataRelativePath;
        this.binaryRelativePath = binaryRelativePath;
    }

    @Override
    @NotNull
    public String readBinaryFeatures() {
        return this.readResourceContent("binary.json");
    }

    @Override
    @NotNull
    public String readFloatFeatures() {
        return this.readResourceContent("float.json");
    }

    @Override
    @NotNull
    public String readCategoricalFeatures() {
        return this.readResourceContent("categorical.json");
    }

    @Override
    @NotNull
    public String readKnownFeatures() {
        return this.readResourceContent("all_features.json");
    }

    @Override
    @NotNull
    public List<String> readFeatureOrder() {
        return StringsKt.lines((CharSequence)this.readResourceContent("features_order.txt"));
    }

    @Override
    @Nullable
    public String readVersion() {
        String versionFile = "version.txt";
        if (this.metadataHolder.getClassLoader().getResource(this.metadataRelativePath + "/" + versionFile) != null) {
            return ((Object)StringsKt.trim((CharSequence)this.readResourceContent(versionFile))).toString();
        }
        URL uRL = this.metadataHolder.getClassLoader().getResource(this.metadataRelativePath + "/binary.json");
        if (uRL == null) {
            return null;
        }
        URL resource = uRL;
        String string = resource.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFile(...)");
        String result = StringsKt.substringAfterLast((String)StringsKt.substringBeforeLast((String)string, (String)".jar!", (String)""), (String)"-", (String)"");
        return StringsKt.isBlank((CharSequence)result) ? null : result;
    }

    @Override
    @NotNull
    public InputStream openModelBinaryStream() {
        InputStream fileStream;
        Path path = this.binaryRelativePath.resolve("model.bin");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
        Path resource = path;
        InputStream inputStream = fileStream = this.metadataHolder.getClassLoader().getResourceAsStream(((Object)resource).toString());
        if (inputStream == null) {
            throw new InconsistentMetadataException("File stream not found: " + resource + ". Resources holder: " + this.metadataHolder.getName());
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readResourceContent(String fileName) {
        InputStream fileStream;
        Path path = this.metadataRelativePath.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
        Path resource = path;
        Closeable closeable = this.metadataHolder.getClassLoader().getResourceAsStream(((Object)resource).toString());
        if (closeable == null) {
            throw new InconsistentMetadataException("Metadata file not found: " + resource + ". Resources holder: " + this.metadataHolder.getName());
        }
        closeable = fileStream = closeable;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }
}

