/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.api.feature.storage;

import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureComputationPolicy;
import com.jetbrains.ml.api.feature.FeatureDeclaration;
import com.jetbrains.ml.api.feature.FeatureDeclarator;
import com.jetbrains.ml.api.feature.FeatureDeclaratorKt;
import com.jetbrains.ml.api.feature.FeatureFilter;
import com.jetbrains.ml.api.feature.storage.ExistingFeaturesPolicy;
import com.jetbrains.ml.api.feature.storage.FeatureCache;
import com.jetbrains.ml.api.feature.storage.FeatureStorageView;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0015\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J.\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00130\u0004R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/ml/api/feature/storage/FeatureStorage;", "Lcom/jetbrains/ml/api/feature/FeatureDeclarator;", "Lcom/jetbrains/ml/api/feature/storage/FeatureStorageView;", "cacheFactory", "Lkotlin/Function0;", "Lcom/jetbrains/ml/api/feature/storage/FeatureCache;", "(Lkotlin/jvm/functions/Function0;)V", "cache", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getFeatures", "", "Lcom/jetbrains/ml/api/feature/Feature;", "instance", "", "filter", "Lcom/jetbrains/ml/api/feature/FeatureFilter;", "", "instances", "", "putFeatures", "", "key", "addToExisting", "Lcom/jetbrains/ml/api/feature/storage/ExistingFeaturesPolicy;", "lazyFeatures", "Companion", "ml-api"})
@SourceDebugExtension(value={"SMAP\nFeatureStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureStorage.kt\ncom/jetbrains/ml/api/feature/storage/FeatureStorage\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n453#2:47\n403#2:48\n453#2:53\n403#2:54\n1238#3,4:49\n1238#3,4:55\n*S KotlinDebug\n*F\n+ 1 FeatureStorage.kt\ncom/jetbrains/ml/api/feature/storage/FeatureStorage\n*L\n29#1:47\n29#1:48\n30#1:53\n30#1:54\n29#1:49,4\n30#1:55,4\n*E\n"})
public abstract class FeatureStorage
implements FeatureDeclarator,
FeatureStorageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final FeatureCache cache;

    public FeatureStorage(@NotNull Function0<? extends FeatureCache> cacheFactory) {
        Intrinsics.checkNotNullParameter(cacheFactory, (String)"cacheFactory");
        this.lock = new ReentrantReadWriteLock();
        this.cache = (FeatureCache)cacheFactory.invoke();
    }

    public /* synthetic */ FeatureStorage(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        this((Function0<? extends FeatureCache>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putFeatures(@NotNull Object key, @NotNull ExistingFeaturesPolicy addToExisting, @NotNull Function0<? extends Collection<? extends Feature>> lazyFeatures) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)addToExisting, (String)"addToExisting");
        Intrinsics.checkNotNullParameter(lazyFeatures, (String)"lazyFeatures");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            List<Feature> cleanFeatures = FeatureDeclaratorKt.selectFeatureList(this, (Collection)lazyFeatures.invoke(), null);
            this.cache.put(key, (Collection<? extends Feature>)cleanFeatures, (Function2<? super Map<String, Feature>, ? super Collection<? extends Feature>, Unit>)((Function2)addToExisting));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public static /* synthetic */ void putFeatures$default(FeatureStorage featureStorage, Object object, ExistingFeaturesPolicy existingFeaturesPolicy, Function0 function0, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: putFeatures");
        }
        if ((n & 1) != 0) {
            object = Unit.INSTANCE;
        }
        if ((n & 2) != 0) {
            existingFeaturesPolicy = ExistingFeaturesPolicy.Companion.getREPLACE();
        }
        featureStorage.putFeatures(object, existingFeaturesPolicy, (Function0<? extends Collection<? extends Feature>>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<Object, List<Feature>> getFeatures(@NotNull Collection<? extends Object> instances, @NotNull FeatureFilter filter) {
        Map map;
        Intrinsics.checkNotNullParameter(instances, (String)"instances");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<Feature> list;
            Map.Entry it;
            Map map2;
            Object k;
            Map.Entry it$iv$iv;
            boolean bl;
            Map map3;
            Map $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv;
            boolean bl2 = false;
            Map<Object, List<Feature>> map4 = this.cache.get(instances);
            boolean $i$f$mapValues = false;
            void var7_9 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map3 = destination$iv$iv;
                bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map2 = map3;
                boolean bl3 = false;
                list = FeatureFilter.Companion.filterWith((Collection)it.getValue(), filter);
                map2.put(k, list);
            }
            $this$mapValues$iv = destination$iv$iv;
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map3 = destination$iv$iv;
                bl = false;
                it = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map2 = map3;
                boolean bl4 = false;
                list = FeatureDeclaratorKt.selectFeatureList(this, (Collection)it.getValue(), filter);
                map2.put(k, list);
            }
            map = destination$iv$iv;
        }
        finally {
            readLock.unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Feature> getFeatures(@NotNull Object instance, @NotNull FeatureFilter filter) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            List features = (List)MapsKt.getValue(this.cache.get(CollectionsKt.listOf((Object)instance)), (Object)instance);
            List<Feature> list = FeatureDeclaratorKt.selectFeatureList(this, (Collection<? extends Feature>)FeatureFilter.Companion.filterWith(features, filter), filter);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    @NotNull
    public FeatureComputationPolicy getFeatureComputationPolicy() {
        return FeatureDeclarator.DefaultImpls.getFeatureComputationPolicy(this);
    }

    @Override
    public boolean couldContainAcceptedFeatures(@NotNull FeatureFilter filter) {
        return FeatureDeclarator.DefaultImpls.couldContainAcceptedFeatures(this, filter);
    }

    public FeatureStorage() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u00042\u001a\u0010\u0005\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\"\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/ml/api/feature/storage/FeatureStorage$Companion;", "", "()V", "of", "Lcom/jetbrains/ml/api/feature/storage/FeatureStorage;", "declarations", "", "Lcom/jetbrains/ml/api/feature/FeatureDeclaration;", "([Lcom/jetbrains/ml/api/feature/FeatureDeclaration;)Lcom/jetbrains/ml/api/feature/storage/FeatureStorage;", "", "ml-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FeatureStorage of(@NotNull List<? extends FeatureDeclaration<?>> declarations) {
            Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
            return new FeatureStorage(declarations){
                @NotNull
                private final List<FeatureDeclaration<?>> featureDeclarations;
                {
                    this.featureDeclarations = $declarations;
                }

                @NotNull
                public List<FeatureDeclaration<?>> getFeatureDeclarations() {
                    return this.featureDeclarations;
                }
            };
        }

        @NotNull
        public final FeatureStorage of(FeatureDeclaration<?> ... declarations) {
            Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
            return this.of(ArraysKt.toList((Object[])declarations));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

