/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.split.frontend;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookCefHealthManager;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.split.frontend.JupyterNotebookFrontend;
import com.intellij.jupyter.split.frontend.JupyterProtocolStructureViewBuilder;
import com.intellij.jupyter.split.frontend.RemoteOutputsUpdaterFrontService;
import com.intellij.jupyter.split.frontend.webview.FrontendJupyterWebViewClient;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeListenerAdapter;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import com.intellij.notebooks.visualization.ui.EditorNotebook;
import com.intellij.notebooks.visualization.ui.EditorNotebookKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.BeFileEditorModel;
import com.jetbrains.rd.ide.model.FileEditorModel;
import com.jetbrains.rd.ide.model.NotebookFileEditorModel;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.fileEditors.FrontendDefaultFileEditor;
import com.jetbrains.rdclient.fileEditors.FrontendDefaultFileEditorProvider;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorModelHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/split/frontend/JupyterFrontendEditorModelHandler;", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorModelHandler;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "model", "Lcom/jetbrains/rd/ide/model/FileEditorModel;", "createEditorWithProvider", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.jupyter.split.frontend"})
public final class JupyterFrontendEditorModelHandler
implements FrontendFileEditorModelHandler,
Disposable.Default {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileEditorModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof NotebookFileEditorModel && Intrinsics.areEqual((Object)file.getExtension(), (Object)JupyterFileType.INSTANCE.getDefaultExtension());
    }

    @NotNull
    public FileEditorWithProvider createEditorWithProvider(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull VirtualFile file, @NotNull FileEditorModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        FrontendDefaultFileEditorProvider provider = new FrontendDefaultFileEditorProvider(model.getProvider());
        NotebookFileEditorModel editorModel = (NotebookFileEditorModel)model;
        Editor editor = FrontendTextControlHostKt.toEditor((TextControlId)((NotebookFileEditorModel)model).getEditorId());
        FrontendDefaultFileEditor fileEditor = new FrontendDefaultFileEditor(file, lifetime, (BeFileEditorModel)editorModel, (StructureViewBuilder)new JupyterProtocolStructureViewBuilder(editor));
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)editor);
        Intrinsics.checkNotNull((Object)jupyterNotebook);
        JupyterNotebookFrontend frontendNotebook = new JupyterNotebookFrontend(jupyterNotebook);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        EditorUtil.disposeWithEditor((Editor)editor, (Disposable)disposable2);
        BackedNotebookVirtualFile.Companion.createWithNotebook(file, (JupyterNotebook)frontendNotebook, disposable2);
        NotebookEditorModeListenerAdapter.Companion.setupForEditor(editor);
        NotebookCefHealthManager.Companion.install((FileEditor)fileEditor, editor);
        EditorNotebook editorNotebook = EditorNotebookKt.getNotebook((Editor)editor);
        if (editorNotebook != null) {
            EditorNotebook notebook = editorNotebook;
            boolean bl = false;
            notebook.addCellEventsListener((Disposable)notebook, new EditorCellEventListener(editor){
                final /* synthetic */ Editor $editor;
                {
                    this.$editor = $editor;
                }

                public void onEditorCellEvents(List<? extends EditorCellEventListener.EditorCellEvent> events) {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    RemoteOutputsUpdaterFrontService.Companion.getInstance().updateWaitingOutputs(this.$editor);
                }
            });
        }
        RemoteOutputsUpdaterFrontService.Companion.getInstance().onEditorCreated(editor);
        FrontendJupyterWebViewClient.Companion.getOrCreate(editor).init();
        return new FileEditorWithProvider((FileEditor)fileEditor, (FileEditorProvider)provider);
    }
}

