/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jbonlymac;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.ultimate.jbonlymac.CompiledMethod;
import com.intellij.profiler.ultimate.jbonlymac.InlinedMethods;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRange;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRangeWithData;
import com.intellij.profiler.ultimate.jbonlymac.MemoryRangesStorage;
import com.intellij.profiler.ultimate.jbonlymac.SingleMethod;
import com.intellij.profiler.ultimate.model.BaseJavaCall;
import com.intellij.profiler.ultimate.model.JavaCachingStackElementReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\n\u001a\u0004\u0018\u00010\u0004*\f\u0012\u0004\u0012\u00020\u00040\tj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a$\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u00040\tj\u0002`\u000b*\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0000\u001a\u001e\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00040\tj\u0002`\u000b*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u0018\b\u0000\u0010\b\"\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0012\u0004\u0012\u00020\u00040\t\u00a8\u0006\u0018"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "parseCompiledMethod", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangeWithData;", "Lcom/intellij/profiler/ultimate/jbonlymac/CompiledMethod;", "Lcom/intellij/profiler/ultimate/model/JavaCachingStackElementReader;", "line", "", "CompiledMethodsStorage", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRangesStorage;", "findBestReplace", "Lcom/intellij/profiler/ultimate/jbonlymac/CompiledMethodsStorage;", "addr", "", "buildCompiledMethodsStorage", "lines", "Lkotlin/sequences/Sequence;", "readCompiledMethodsStorage", "file", "Ljava/io/File;", "inMemoryRange", "", "range", "Lcom/intellij/profiler/ultimate/jbonlymac/MemoryRange;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nCompiledMethodsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompiledMethodsStorage.kt\ncom/intellij/profiler/ultimate/jbonlymac/CompiledMethodsStorageKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,145:1\n1563#2:146\n1634#2,3:147\n774#2:150\n865#2,2:151\n2423#2,14:153\n1321#3,2:167\n14#4:169\n*S KotlinDebug\n*F\n+ 1 CompiledMethodsStorage.kt\ncom/intellij/profiler/ultimate/jbonlymac/CompiledMethodsStorageKt\n*L\n38#1:146\n38#1:147,3\n46#1:150\n46#1:151,2\n46#1:153,14\n50#1:167,2\n12#1:169\n*E\n"})
public final class CompiledMethodsStorageKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MemoryRangeWithData<CompiledMethod> parseCompiledMethod(@NotNull JavaCachingStackElementReader $this$parseCompiledMethod, @NotNull String line) {
        CompiledMethod compiledMethod;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$parseCompiledMethod), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String start2 = StringsKt.substringBefore$default((String)line, (char)' ', null, (int)2, null);
        String string = line.substring(start2.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String length = StringsKt.substringBefore$default((String)string, (char)' ', null, (int)2, null);
        String string2 = line.substring(start2.length() + 1 + length.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String[] stringArray = new String[]{"->"};
        List methods = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (methods.size() > 1) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = CollectionsKt.drop((Iterable)methods, (int)1);
            BaseJavaCall baseJavaCall = JavaCachingStackElementReader.parseJavaMethodCall$default($this$parseCompiledMethod, (String)CollectionsKt.first((List)methods), false, 2, null);
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add($this$parseCompiledMethod.parseJavaMethodCall((String)it, true));
            }
            List list = (List)destination$iv$iv;
            BaseJavaCall baseJavaCall2 = baseJavaCall;
            compiledMethod = new InlinedMethods(baseJavaCall2, list);
        } else {
            compiledMethod = new SingleMethod($this$parseCompiledMethod.parseJavaCall((String)CollectionsKt.first((List)methods)));
        }
        CompiledMethod method = compiledMethod;
        return new MemoryRangeWithData<CompiledMethod>(UtilsKt.parseHexLong((String)start2), Long.parseLong(length), method);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CompiledMethod findBestReplace(@NotNull MemoryRangesStorage<? extends CompiledMethod> $this$findBestReplace, long addr) {
        Object v0;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$findBestReplace, (String)"<this>");
        Iterable $this$filter$iv = $this$findBestReplace.getRangesAddressBelongsTo(addr);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MemoryRangeWithData it = (MemoryRangeWithData)element$iv$iv;
            boolean bl = false;
            if (!CompiledMethodsStorageKt.inMemoryRange(addr, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                MemoryRangeWithData it = (MemoryRangeWithData)minElem$iv;
                boolean bl = false;
                long minValue$iv = it.getLength();
                do {
                    Object e$iv = iterator$iv.next();
                    MemoryRangeWithData it2 = (MemoryRangeWithData)e$iv;
                    $i$a$-minByOrNull-CompiledMethodsStorageKt$findBestReplace$2 = false;
                    long v$iv = it2.getLength();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        MemoryRangeWithData memoryRangeWithData = v0;
        return memoryRangeWithData != null ? (CompiledMethod)memoryRangeWithData.getData() : null;
    }

    @NotNull
    public static final MemoryRangesStorage<CompiledMethod> buildCompiledMethodsStorage(@NotNull JavaCachingStackElementReader $this$buildCompiledMethodsStorage, @NotNull Sequence<String> lines) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$buildCompiledMethodsStorage), (String)"<this>");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        List compiledMethods = new ArrayList();
        Sequence<String> $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            try {
                ((Collection)compiledMethods).add(CompiledMethodsStorageKt.parseCompiledMethod($this$buildCompiledMethodsStorage, line));
            }
            catch (Exception e) {
                LOG.info("while parsing `" + line + "`", (Throwable)e);
            }
        }
        return new MemoryRangesStorage<CompiledMethod>(compiledMethods, 0, 2, null);
    }

    @NotNull
    public static final MemoryRangesStorage<CompiledMethod> readCompiledMethodsStorage(@NotNull JavaCachingStackElementReader $this$readCompiledMethodsStorage, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$readCompiledMethodsStorage), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = file;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file2;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), charset);
        return CompiledMethodsStorageKt.buildCompiledMethodsStorage($this$readCompiledMethodsStorage, (Sequence<String>)TextStreamsKt.lineSequence((BufferedReader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n))));
    }

    public static final boolean inMemoryRange(long $this$inMemoryRange, @NotNull MemoryRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return range.getStart() <= $this$inMemoryRange && $this$inMemoryRange < range.getEnd();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MemoryRangesStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

