/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions.insert;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdater;
import com.intellij.jupyter.core.core.impl.actions.JupyterActonUpdaterKt;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesEditorUtils;
import com.intellij.jupyter.core.core.impl.actions.RequiresCellViewUpdate;
import com.intellij.jupyter.core.core.impl.actions.insert.NotebookInsertCellActionKt;
import com.intellij.jupyter.core.jupyter.actions.ActionDestination;
import com.intellij.jupyter.core.jupyter.helper.JupyterMarkdownHelperKt;
import com.intellij.notebooks.ui.editor.actions.JupyterEditorAction;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorMode;
import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookEditorModeKt;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/insert/NotebookInsertCellAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/notebooks/ui/editor/actions/JupyterEditorAction;", "Lcom/intellij/jupyter/core/core/impl/actions/RequiresCellViewUpdate;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "cellType", "Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "customHeader", "", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;Ljava/lang/String;)V", "getCellType", "()Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "getCustomHeader", "()Ljava/lang/String;", "actionUpdater", "Lcom/intellij/jupyter/core/core/impl/actions/JupyterActonUpdater;", "forceInsertDirection", "Lcom/intellij/jupyter/core/jupyter/actions/ActionDestination;", "getForceInsertDirection", "()Lcom/intellij/jupyter/core/jupyter/actions/ActionDestination;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "onCellInserted", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "createActionUpdater", "intellij.jupyter.core"})
public class NotebookInsertCellAction
extends DumbAwareAction
implements JupyterEditorAction,
RequiresCellViewUpdate,
ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    private final NotebookCellLines.CellType cellType;
    @Nullable
    private final String customHeader;
    @NotNull
    private final JupyterActonUpdater actionUpdater;
    @Nullable
    private final ActionDestination forceInsertDirection;

    public NotebookInsertCellAction(@NotNull NotebookCellLines.CellType cellType, @Nullable String customHeader) {
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        this.cellType = cellType;
        this.customHeader = customHeader;
        this.actionUpdater = this.createActionUpdater();
    }

    public /* synthetic */ NotebookInsertCellAction(NotebookCellLines.CellType cellType, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(cellType, string);
    }

    @NotNull
    protected NotebookCellLines.CellType getCellType() {
        return this.cellType;
    }

    @Nullable
    protected String getCustomHeader() {
        return this.customHeader;
    }

    @Nullable
    protected ActionDestination getForceInsertDirection() {
        return this.forceInsertDirection;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        JupyterActonUpdater.update$default(this.actionUpdater, this, event, null, 4, null);
        Boolean bl = (Boolean)event.getData(NotebookDataContext.INSTANCE.getSHOW_TEXT());
        if (bl == null) {
            return;
        }
        boolean showText = bl;
        event.getPresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)showText);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        ActionDestination direction;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        NotebookEditorModeKt.setMode((Editor)((Editor)editor), (NotebookEditorMode)NotebookEditorMode.EDIT);
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)editor);
        if (notebookCellInlayManager == null) {
            return;
        }
        NotebookCellInlayManager inlayManager = notebookCellInlayManager;
        Object object = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)editor);
        if (object == null || (object = object.makeCell("", this.getCellType(), this.getCustomHeader())) == null) {
            return;
        }
        Object cellText = object;
        DataContext dataContext2 = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext2);
        int currentCellInterval = interval != null ? interval.getOrdinal() : inlayManager.getCells().size();
        ActionDestination dataContextDirection = !Intrinsics.areEqual((Object)event.getDataContext().getData(NotebookDataContext.INSTANCE.getNOTEBOOK_CELL_INSERT_ABOVE()), (Object)true) ? ActionDestination.DOWN : ActionDestination.UP;
        ActionDestination actionDestination = this.getForceInsertDirection();
        if (actionDestination == null) {
            actionDestination = dataContextDirection;
        }
        int newCellOrdinal = (direction = actionDestination) == ActionDestination.UP ? currentCellInterval : currentCellInterval + 1;
        NotebookInsertCellActionKt.addNewCell(event, (String)cellText, newCellOrdinal, (Function1<? super NotebookCellLines.Interval, Unit>)((Function1)arg_0 -> NotebookInsertCellAction.actionPerformed$lambda$0(this, editor, inlayManager, arg_0)));
        Object[] objectArray = new Integer[]{newCellOrdinal - 1, newCellOrdinal};
        this.updateAffectedCells((Editor)editor, CollectionsKt.listOf((Object[])objectArray));
        FeatureUsageTracker.getInstance().triggerFeatureUsed("jupyter.add.cell");
    }

    protected void onCellInserted(@NotNull EditorImpl editor, @NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
    }

    @NotNull
    public JupyterActonUpdater createActionUpdater() {
        return JupyterActonUpdaterKt.getJupyterActionUpdater().derive((Function1<? super JupyterActonUpdater.Builder, Unit>)((Function1)arg_0 -> NotebookInsertCellAction.createActionUpdater$lambda$3(this, arg_0)));
    }

    private static final Unit actionPerformed$lambda$0(NotebookInsertCellAction this$0, EditorImpl $editor, NotebookCellInlayManager $inlayManager, NotebookCellLines.Interval cellInterval) {
        Intrinsics.checkNotNullParameter((Object)cellInterval, (String)"cellInterval");
        this$0.onCellInserted($editor, cellInterval);
        EditorCell editorCell = $inlayManager.getCell(cellInterval.getOrdinal());
        JupyterMarkdownHelperKt.setMarkdownRendered(editorCell, false);
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)$editor));
        if (notebookCellSelectionModel != null) {
            notebookCellSelectionModel.selectSingleCell(cellInterval);
        }
        NotebookCellLinesEditorUtils.INSTANCE.scrollTo((Editor)$editor, cellInterval.getLines().getFirst(), ScrollType.MAKE_VISIBLE);
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createActionUpdater$lambda$3$lambda$2(NotebookInsertCellAction this$0, JupyterEditorAction action, AnActionEvent event) {
        EditorImpl editorImpl;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl2 = NotebookDataContext.INSTANCE.getNotebookEditor(dataContext);
        if (editorImpl2 == null) return false;
        EditorImpl it = editorImpl = editorImpl2;
        boolean bl = false;
        if (!NotebookCellSelectionModelProviderKt.getHasCellSelectionModelSupport((Editor)((Editor)it))) return false;
        NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)it);
        if (notebookCellLinesEditHelper == null) return false;
        String string = notebookCellLinesEditHelper.makeCell("", this$0.getCellType(), this$0.getCustomHeader());
        if (string == null) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        EditorImpl editorImpl3 = editorImpl;
        if (editorImpl3 == null) return false;
        return true;
    }

    private static final Unit createActionUpdater$lambda$3(NotebookInsertCellAction this$0, JupyterActonUpdater.Builder $this$derive) {
        Intrinsics.checkNotNullParameter((Object)$this$derive, (String)"$this$derive");
        $this$derive.addEnabledAndVisibleProvider((Function2<? super JupyterEditorAction, ? super AnActionEvent, Boolean>)((Function2)(arg_0, arg_1) -> NotebookInsertCellAction.createActionUpdater$lambda$3$lambda$2(this$0, arg_0, arg_1)));
        return Unit.INSTANCE;
    }
}

