/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.lang;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.JupyterLangUtilKt;
import org.jetbrains.plugins.notebooks.psi.jupyter.JupyterSqlLanguageProviderKt;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData;", "", "language", "Lcom/intellij/lang/Language;", "jupyterCellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "cellType", "Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "headerSuffix", "", "<init>", "(Lcom/intellij/lang/Language;Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;Ljava/lang/String;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getJupyterCellType", "()Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "getCellType", "()Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "getHeaderSuffix", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.jupyter.core"})
public final class JupyterLangData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language language;
    @NotNull
    private final JupyterCellType jupyterCellType;
    @NotNull
    private final NotebookCellLines.CellType cellType;
    @Nullable
    private final String headerSuffix;
    @NotNull
    private static final JupyterLangData rawData;
    @NotNull
    private static final JupyterLangData dataWranglerCellData;

    public JupyterLangData(@NotNull Language language, @NotNull JupyterCellType jupyterCellType, @NotNull NotebookCellLines.CellType cellType, @Nullable String headerSuffix) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)jupyterCellType, (String)"jupyterCellType");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        this.language = language;
        this.jupyterCellType = jupyterCellType;
        this.cellType = cellType;
        this.headerSuffix = headerSuffix;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final JupyterCellType getJupyterCellType() {
        return this.jupyterCellType;
    }

    @NotNull
    public final NotebookCellLines.CellType getCellType() {
        return this.cellType;
    }

    @Nullable
    public final String getHeaderSuffix() {
        return this.headerSuffix;
    }

    @NotNull
    public final Language component1() {
        return this.language;
    }

    @NotNull
    public final JupyterCellType component2() {
        return this.jupyterCellType;
    }

    @NotNull
    public final NotebookCellLines.CellType component3() {
        return this.cellType;
    }

    @Nullable
    public final String component4() {
        return this.headerSuffix;
    }

    @NotNull
    public final JupyterLangData copy(@NotNull Language language, @NotNull JupyterCellType jupyterCellType, @NotNull NotebookCellLines.CellType cellType, @Nullable String headerSuffix) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)jupyterCellType, (String)"jupyterCellType");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        return new JupyterLangData(language, jupyterCellType, cellType, headerSuffix);
    }

    public static /* synthetic */ JupyterLangData copy$default(JupyterLangData jupyterLangData, Language language, JupyterCellType jupyterCellType, NotebookCellLines.CellType cellType, String string, int n, Object object) {
        if ((n & 1) != 0) {
            language = jupyterLangData.language;
        }
        if ((n & 2) != 0) {
            jupyterCellType = jupyterLangData.jupyterCellType;
        }
        if ((n & 4) != 0) {
            cellType = jupyterLangData.cellType;
        }
        if ((n & 8) != 0) {
            string = jupyterLangData.headerSuffix;
        }
        return jupyterLangData.copy(language, jupyterCellType, cellType, string);
    }

    @NotNull
    public String toString() {
        return "JupyterLangData(language=" + this.language + ", jupyterCellType=" + this.jupyterCellType + ", cellType=" + this.cellType + ", headerSuffix=" + this.headerSuffix + ")";
    }

    public int hashCode() {
        int result = this.language.hashCode();
        result = result * 31 + this.jupyterCellType.hashCode();
        result = result * 31 + this.cellType.hashCode();
        result = result * 31 + (this.headerSuffix == null ? 0 : this.headerSuffix.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JupyterLangData)) {
            return false;
        }
        JupyterLangData jupyterLangData = (JupyterLangData)other;
        if (!Intrinsics.areEqual((Object)this.language, (Object)jupyterLangData.language)) {
            return false;
        }
        if (this.jupyterCellType != jupyterLangData.jupyterCellType) {
            return false;
        }
        if (this.cellType != jupyterLangData.cellType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.headerSuffix, (Object)jupyterLangData.headerSuffix);
    }

    static {
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
        rawData = new JupyterLangData((Language)plainTextLanguage, JupyterCellType.RAW, NotebookCellLines.CellType.RAW, "raw");
        PlainTextLanguage plainTextLanguage2 = PlainTextLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage2, (String)"INSTANCE");
        dataWranglerCellData = new JupyterLangData((Language)plainTextLanguage2, JupyterCellType.DATA_INPUT, NotebookCellLines.CellType.CODE, "data_wrangler");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\u0005H\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData$Companion;", "", "<init>", "()V", "rawData", "Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData;", "getRawData", "()Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData;", "getMarkdownData", "getHtmlData", "getHeadingData", "getSqlDataOrNull", "getCodeData", "notebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "getDataImportCellData", "dataWranglerCellData", "getAvailableLangData", "", "getDataByJupyterCellType", "cellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterLangData getRawData() {
            return rawData;
        }

        private final JupyterLangData getMarkdownData() {
            return new JupyterLangData(JupyterLangUtilKt.getMarkdownLanguage(), JupyterCellType.MARKDOWN, NotebookCellLines.CellType.MARKDOWN, "md");
        }

        private final JupyterLangData getHtmlData() {
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
            return new JupyterLangData((Language)plainTextLanguage, JupyterCellType.HTML, NotebookCellLines.CellType.RAW, "html");
        }

        private final JupyterLangData getHeadingData() {
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
            return new JupyterLangData((Language)plainTextLanguage, JupyterCellType.HEADING, NotebookCellLines.CellType.RAW, "heading");
        }

        private final JupyterLangData getSqlDataOrNull() {
            Language language = JupyterSqlLanguageProviderKt.getSqlLanguageOrNull();
            if (language == null) {
                return null;
            }
            Language language2 = language;
            return new JupyterLangData(language2, JupyterCellType.SQL, NotebookCellLines.CellType.CODE, "sql");
        }

        private final JupyterLangData getCodeData(BackedNotebookVirtualFile notebook) {
            Language language = JupyterCellLinesProvider.Util.INSTANCE.getDefaultCodeLanguage(notebook.getNotebook());
            return new JupyterLangData(language, JupyterCellType.CODE, NotebookCellLines.CellType.CODE, null);
        }

        private final JupyterLangData getDataImportCellData(BackedNotebookVirtualFile notebook) {
            Language language = JupyterCellLinesProvider.Util.INSTANCE.getDefaultCodeLanguage(notebook.getNotebook());
            return new JupyterLangData(language, JupyterCellType.DATA_INPUT, NotebookCellLines.CellType.CODE, "data_input");
        }

        @NotNull
        public final List<JupyterLangData> getAvailableLangData(@NotNull BackedNotebookVirtualFile notebook) {
            Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
            Object[] objectArray = new JupyterLangData[]{this.getCodeData(notebook), this.getSqlDataOrNull(), this.getMarkdownData(), this.getRawData(), dataWranglerCellData, this.getHeadingData(), this.getHtmlData()};
            return CollectionsKt.listOfNotNull((Object[])objectArray);
        }

        @Nullable
        public final JupyterLangData getDataByJupyterCellType(@NotNull BackedNotebookVirtualFile notebook, @NotNull JupyterCellType cellType) {
            Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
            Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
            return switch (WhenMappings.$EnumSwitchMapping$0[cellType.ordinal()]) {
                case 1 -> this.getRawData();
                case 2 -> this.getHtmlData();
                case 3 -> this.getHeadingData();
                case 4 -> this.getMarkdownData();
                case 5 -> this.getSqlDataOrNull();
                case 6 -> this.getDataImportCellData(notebook);
                case 7 -> this.getCodeData(notebook);
                case 8 -> this.getCodeData(notebook);
                case 9, 10, 11 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JupyterCellType.values().length];
                try {
                    nArray[JupyterCellType.RAW.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.HTML.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.HEADING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.MARKDOWN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.SQL.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.DATA_INPUT.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.CODE.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.DATA_WRANGLER.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.MAGIC.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.UNDEFINED.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JupyterCellType.CODE_OR_MAGIC.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

