/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterAttachments;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadata;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputsBase;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookCellSchema;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0005H\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u001aH\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010$\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011H\u0016J \u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0005H\u0002J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchemaBase;", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchema;", "<init>", "()V", "cellOutputsFieldName", "", "cellAttachmentsFieldName", "cellMetadataFieldName", "cellTypeFieldName", "cellExecutionCountFieldName", "getCellExecutionCountFieldName", "()Ljava/lang/String;", "cellOutputsHiddenFieldName", "cellLevelFieldName", "getCellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "setCellType", "", "value", "retrieveSource", "source", "Lcom/fasterxml/jackson/databind/JsonNode;", "adaptSource", "getCellMetadata", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadata;", "setCellMetadata", "getExecutionCount", "", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;)Ljava/lang/Integer;", "setExecutionCount", "", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/lang/Integer;)Z", "getOutput", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputs;", "setOutput", "getAttachments", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterAttachments;", "swapCellsData", "firstNode", "secondNode", "swap", "first", "second", "property", "setOutputIfAbsent", "arrayNode", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "revalidateCell", "getLevel", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookCellSchemaBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookCellSchemaBase.kt\ncom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchemaBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1#2:150\n4154#3:151\n4254#3,2:152\n827#4:154\n855#4,2:155\n1869#4,2:157\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookCellSchemaBase.kt\ncom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchemaBase\n*L\n47#1:151\n47#1:152,2\n51#1:154\n51#1:155,2\n52#1:157,2\n*E\n"})
public abstract class JupyterNotebookCellSchemaBase
implements JupyterNotebookCellSchema {
    @NotNull
    private final String cellOutputsFieldName;
    @NotNull
    private final String cellAttachmentsFieldName;
    @NotNull
    private final String cellMetadataFieldName;
    @NotNull
    private final String cellTypeFieldName;
    @NotNull
    private final String cellOutputsHiddenFieldName;
    @NotNull
    private final String cellLevelFieldName;

    public JupyterNotebookCellSchemaBase() {
        this.cellOutputsFieldName = "outputs";
        this.cellAttachmentsFieldName = "attachments";
        this.cellMetadataFieldName = "metadata";
        this.cellTypeFieldName = "cell_type";
        this.cellOutputsHiddenFieldName = "outputs_hidden";
        this.cellLevelFieldName = "level";
    }

    @NotNull
    protected abstract String getCellExecutionCountFieldName();

    @Override
    @NotNull
    public JupyterCellType getCellType(@NotNull ObjectNode json) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                object = json.get(this.cellTypeFieldName);
                if (object == null || (object = object.asText()) == null) break block2;
                String string = ((String)object).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                object = string;
                if (string == null) break block2;
                Object it = object;
                boolean bl = false;
                JupyterCellType jupyterCellType = JupyterCellType.Companion.valueOfOrNull((String)it);
                object = jupyterCellType;
                if (jupyterCellType != null) break block3;
            }
            object = JupyterCellType.UNDEFINED;
        }
        return object;
    }

    @Override
    public void setCellType(@NotNull ObjectNode json, @NotNull JupyterCellType value) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        json.put(this.cellTypeFieldName, string);
    }

    @NotNull
    protected final String retrieveSource(@NotNull JsonNode source) {
        String string;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String result = source.isArray() ? CollectionsKt.joinToString$default((Iterable)((Iterable)((ArrayNode)source)), (CharSequence)"", null, null, (int)0, null, JupyterNotebookCellSchemaBase::retrieveSource$lambda$1, (int)30, null) : source.asText();
        LineSeparator detectSeparators = StringUtil.detectSeparators((CharSequence)result);
        if (detectSeparators != null && detectSeparators != LineSeparator.LF) {
            String string2 = StringUtil.convertLineSeparators((String)result);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertLineSeparators(...)");
        } else {
            Intrinsics.checkNotNull((Object)result);
            string = StringsKt.replace$default((String)result, (String)"\r", (String)"", (boolean)false, (int)4, null);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final JsonNode adaptSource(@NotNull String source) {
        JsonNode jsonNode;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String[] stringArray = StringUtil.splitByLinesKeepSeparators((String)source);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLinesKeepSeparators(...)");
        Object[] $this$filterNot$iv = stringArray;
        boolean $i$f$filterNot = false;
        Object[] objectArray = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (void element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sourceList = (List)destination$iv$iv;
        if (sourceList.size() > 1) {
            void $this$forEach$iv;
            void $this$filterNotTo$iv$iv2;
            Iterable $this$filterNot$iv2;
            ArrayNode arrayNode;
            ArrayNode array = arrayNode = JupyterJsonKt.getJackson().createArrayNode();
            boolean bl = false;
            Iterable $i$f$filterNotTo2 = sourceList;
            boolean $i$f$filterNot2 = false;
            Iterator iterator = $this$filterNot$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo3 = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (((CharSequence)it).length() == 0) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterNot$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                array.add(it);
            }
            var3_2 = arrayNode;
            Intrinsics.checkNotNull((Object)var3_2);
            jsonNode = (JsonNode)var3_2;
        } else {
            var3_2 = TextNode.valueOf((String)(sourceList.size() == 1 ? (String)sourceList.get(0) : ""));
            Intrinsics.checkNotNull((Object)var3_2);
            jsonNode = (JsonNode)var3_2;
        }
        return jsonNode;
    }

    @Override
    @NotNull
    public JupyterMetadata getCellMetadata(@NotNull ObjectNode json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return new JupyterMetadata(json, this.cellMetadataFieldName, true, null, null, 24, null);
    }

    @Override
    public void setCellMetadata(@NotNull ObjectNode json, @Nullable JupyterMetadata value) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (value == null) {
            json.remove(this.cellMetadataFieldName);
        } else {
            JsonNode jsonNode = json.get(this.cellMetadataFieldName);
            ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
            if (arrayNode == null) {
                arrayNode = json.putArray(this.cellMetadataFieldName);
            }
            ArrayNode node = arrayNode;
            node.removeAll();
            value.copyTo(new JupyterMetadata(json, this.cellMetadataFieldName, false, null, null, 28, null));
        }
    }

    @Override
    @Nullable
    public Integer getExecutionCount(@NotNull ObjectNode json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNode jsonNode = json.get(this.getCellExecutionCountFieldName());
        return jsonNode != null ? Integer.valueOf(jsonNode.asInt()) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setExecutionCount(@NotNull ObjectNode json, @Nullable Integer value) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNode oldValue = json.get(this.getCellExecutionCountFieldName());
        if (oldValue != null || value == null) {
            JsonNode jsonNode = oldValue;
            if (jsonNode == null) return false;
            if (!jsonNode.isValueNode()) return false;
            boolean bl = true;
            if (!bl) return false;
            Integer n = value;
            if (n != null) {
                if (oldValue.asInt() == n.intValue()) return false;
            }
        }
        JsonNode jsonNode = value != null ? (JsonNode)json.put(this.getCellExecutionCountFieldName(), value.intValue()) : json.remove(this.getCellExecutionCountFieldName());
        return true;
    }

    @Override
    @Nullable
    public JupyterOutputs getOutput(@NotNull ObjectNode json) {
        JupyterOutputsBase jupyterOutputsBase;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNode jsonNode = json.get(this.cellOutputsFieldName);
        ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
        if (arrayNode != null) {
            ArrayNode it = arrayNode;
            boolean bl = false;
            jupyterOutputsBase = new JupyterOutputsBase(it, this.getOutputSchema());
        } else {
            jupyterOutputsBase = null;
        }
        return jupyterOutputsBase;
    }

    @Override
    public void setOutput(@NotNull ObjectNode json, @Nullable JupyterOutputs value) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (value == null) {
            v0 = (Iterable)json.remove(this.cellOutputsFieldName);
        } else {
            JsonNode jsonNode = json.get(this.cellOutputsFieldName);
            ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
            if (arrayNode == null) {
                arrayNode = json.putArray(this.cellOutputsFieldName);
            }
            ArrayNode node = arrayNode;
            node.removeAll();
            Intrinsics.checkNotNull((Object)node);
            v0 = value.copyTo(new JupyterOutputsBase(node, this.getOutputSchema()));
        }
    }

    @Override
    @NotNull
    public JupyterAttachments getAttachments(@NotNull ObjectNode json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return new JupyterAttachments((JsonNode)json, this.cellAttachmentsFieldName);
    }

    @Override
    public void swapCellsData(@NotNull ObjectNode firstNode, @NotNull ObjectNode secondNode) {
        Intrinsics.checkNotNullParameter((Object)firstNode, (String)"firstNode");
        Intrinsics.checkNotNullParameter((Object)secondNode, (String)"secondNode");
        this.swap(firstNode, secondNode, this.cellOutputsFieldName);
        this.swap(firstNode, secondNode, this.getCellExecutionCountFieldName());
        this.swap(firstNode, secondNode, this.cellMetadataFieldName);
    }

    private final void swap(ObjectNode first, ObjectNode second, String property) {
        JsonNode f = first.get(property);
        JsonNode s = second.get(property);
        first.set(property, s);
        second.set(property, f);
    }

    @Override
    public void setOutputIfAbsent(@NotNull ObjectNode json, @NotNull ArrayNode arrayNode) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)arrayNode, (String)"arrayNode");
        json.putIfAbsent(this.cellOutputsFieldName, (JsonNode)json.arrayNode());
    }

    @Override
    public void revalidateCell(@NotNull ObjectNode json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCellType(json).ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (json.has(this.cellOutputsFieldName)) break;
                json.putArray(this.cellOutputsFieldName);
                break;
            }
            case 6: {
                if (!json.has(this.getCellExecutionCountFieldName()) && !json.has(this.cellOutputsFieldName)) break;
                json.remove(this.getCellExecutionCountFieldName());
                json.remove(this.cellOutputsFieldName);
                break;
            }
            default: {
                json.remove(this.cellOutputsHiddenFieldName);
            }
        }
    }

    @Override
    public int getLevel(@NotNull ObjectNode json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNode jsonNode = json.get(this.cellLevelFieldName);
        return jsonNode != null ? jsonNode.asInt() : 1;
    }

    private static final CharSequence retrieveSource$lambda$1(JsonNode it) {
        String string = it.asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterCellType.values().length];
            try {
                nArray[JupyterCellType.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.SQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.DATA_INPUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.DATA_WRANGLER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.CODE_OR_MAGIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterCellType.MARKDOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

