/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.formatting.number;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0002J\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/number/Arithmetic;", "", "()V", "add", "Lkotlin/Pair;", "", "", "a", "b", "carryOnRound", "number", "round", "precision", "", "commons"})
@SourceDebugExtension(value={"SMAP\nArithmetic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Arithmetic.kt\norg/jetbrains/letsPlot/commons/formatting/number/Arithmetic\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,66:1\n1247#2,2:67\n*S KotlinDebug\n*F\n+ 1 Arithmetic.kt\norg/jetbrains/letsPlot/commons/formatting/number/Arithmetic\n*L\n60#1:67,2\n*E\n"})
public final class Arithmetic {
    @NotNull
    public static final Arithmetic INSTANCE = new Arithmetic();

    private Arithmetic() {
    }

    @NotNull
    public final Pair<String, Boolean> add(@NotNull String a2, @NotNull String b2) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        int maxLength = Math.max(a2.length(), b2.length());
        IntProgression range = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)0, (int)maxLength)));
        int deltaA = a2.length() - maxLength;
        int deltaB = b2.length() - maxLength;
        int carry = 0;
        char[] result2 = new char[maxLength];
        int i = range.getFirst();
        int n = range.getLast();
        int n2 = range.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                Character c = StringsKt.getOrNull((CharSequence)a2, (int)(i + deltaA));
                int va = c != null ? CharsKt.digitToInt((char)c.charValue()) : 0;
                Character c2 = StringsKt.getOrNull((CharSequence)b2, (int)(i + deltaB));
                int vb = c2 != null ? CharsKt.digitToInt((char)c2.charValue()) : 0;
                int sum = va + vb + carry;
                result2[i] = (char)(48 + sum % 10);
                carry = sum / 10;
                if (i == n) break;
                i += n2;
            }
        }
        return carry == 0 ? TuplesKt.to((Object)StringsKt.concatToString((char[])result2), (Object)false) : TuplesKt.to((Object)('1' + StringsKt.concatToString((char[])result2)), (Object)true);
    }

    @NotNull
    public final Pair<String, Boolean> round(@NotNull String number, int precision) {
        Pair pair2;
        boolean significantCarryFlag;
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        String trailingPart = StringsKt.takeLast((String)number, (int)(number.length() - precision));
        String significantPart = StringsKt.take((String)number, (int)precision);
        boolean trailingCarryFlag = this.carryOnRound(trailingPart);
        Pair<String, Boolean> pair3 = ((CharSequence)significantPart).length() == 0 ? TuplesKt.to((Object)"", (Object)trailingCarryFlag) : this.add(significantPart, trailingCarryFlag ? "1" : "0");
        String roundedSignificantPart = (String)pair3.component1();
        boolean bl = significantCarryFlag = ((Boolean)pair3.component2()).booleanValue();
        if (bl) {
            pair2 = TuplesKt.to((Object)StringsKt.drop((String)roundedSignificantPart, (int)1), (Object)true);
        } else if (!bl) {
            pair2 = TuplesKt.to((Object)roundedSignificantPart, (Object)false);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair2;
    }

    private final boolean carryOnRound(String number) {
        switch (number.length()) {
            case 0: {
                return false;
            }
            case 1: {
                return Intrinsics.compare((int)StringsKt.single((CharSequence)number), (int)53) >= 0;
            }
        }
        if (Intrinsics.compare((int)StringsKt.first((CharSequence)number), (int)53) >= 0) {
            return true;
        }
        if (StringsKt.first((CharSequence)number) == '5') {
            boolean bl;
            block8: {
                Sequence $this$any$iv = SequencesKt.drop((Sequence)StringsKt.asSequence((CharSequence)number), (int)1);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    char it = ((Character)element$iv).charValue();
                    boolean bl2 = false;
                    if (!(Intrinsics.compare((int)it, (int)48) > 0)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }
}

