/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.frame;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.PolarAxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.coord.PolarCoordinateSystem;
import org.jetbrains.letsPlot.core.plot.builder.frame.DummyTransientState;
import org.jetbrains.letsPlot.core.plot.builder.frame.FrameOfReferenceBase;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.GridComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.PolarAxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgCircleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001c\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#H\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0018\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0010\u0010+\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0018\u0010-\u001a\u00020%2\u0006\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0010\u0010.\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0010\u0010/\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001bH\u0016J$\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203012\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0005H\u0002J\u0010\u00107\u001a\u00020%2\u0006\u00108\u001a\u00020\u001bH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/PolarFrameOfReference;", "Lorg/jetbrains/letsPlot/core/plot/builder/frame/FrameOfReferenceBase;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "hScaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "vScaleBreaks", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "coord", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "flipAxis", "", "(Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Z)V", "getCoord", "()Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "transientState", "Lorg/jetbrains/letsPlot/core/plot/builder/frame/DummyTransientState;", "getTransientState", "()Lorg/jetbrains/letsPlot/core/plot/builder/frame/DummyTransientState;", "buildGeomComponent", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "layer", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "createPanelElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "block", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgShape;", "", "doDrawHAxis", "parent", "doDrawHGrid", "gridTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "doDrawPanelBorder", "doDrawVAxis", "doDrawVGrid", "doFillBkgr", "doStrokeBkgr", "prepareAxisData", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;", "axisInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "scaleBreaks", "setClip", "element", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPolarFrameOfReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolarFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/PolarFrameOfReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1855#2,2:224\n1855#2,2:226\n*S KotlinDebug\n*F\n+ 1 PolarFrameOfReference.kt\norg/jetbrains/letsPlot/core/plot/builder/frame/PolarFrameOfReference\n*L\n58#1:224,2\n83#1:226,2\n*E\n"})
public final class PolarFrameOfReference
extends FrameOfReferenceBase {
    @NotNull
    private final ScaleBreaks hScaleBreaks;
    @NotNull
    private final ScaleBreaks vScaleBreaks;
    @NotNull
    private final PolarCoordinateSystem coord;
    @NotNull
    private final DummyTransientState transientState;

    public PolarFrameOfReference(@NotNull PlotContext plotContext, @NotNull ScaleBreaks hScaleBreaks, @NotNull ScaleBreaks vScaleBreaks, @NotNull DoubleRectangle adjustedDomain, @NotNull PolarCoordinateSystem coord, @NotNull TileLayoutInfo layoutInfo, @NotNull GeomMarginsLayout marginsLayout, @NotNull Theme theme, boolean flipAxis) {
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        Intrinsics.checkNotNullParameter((Object)hScaleBreaks, (String)"hScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)vScaleBreaks, (String)"vScaleBreaks");
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(plotContext, adjustedDomain, layoutInfo, marginsLayout, theme, flipAxis);
        this.hScaleBreaks = hScaleBreaks;
        this.vScaleBreaks = vScaleBreaks;
        this.coord = coord;
        this.transientState = new DummyTransientState();
    }

    @Override
    @NotNull
    protected PolarCoordinateSystem getCoord() {
        return this.coord;
    }

    @Override
    @NotNull
    public DummyTransientState getTransientState() {
        return this.transientState;
    }

    @Override
    public void doDrawVAxis(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.getLayoutInfo().getAxisInfos().getLeft(), this.getLayoutInfo().getAxisInfos().getRight()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            Pair<AxisComponent.TickLabelAdjustments, PolarAxisUtil.PolarBreaksData> pair2 = this.prepareAxisData(axisInfo, this.vScaleBreaks);
            AxisComponent.TickLabelAdjustments labelAdjustments = (AxisComponent.TickLabelAdjustments)pair2.component1();
            PolarAxisUtil.PolarBreaksData breaksData = (PolarAxisUtil.PolarBreaksData)pair2.component2();
            PolarAxisComponent axisComponent = new PolarAxisComponent(axisInfo.getAxisLength(), axisInfo.getOrientation(), breaksData, labelAdjustments, this.getVAxisTheme(), !this.getLayoutInfo().getVAxisShown());
            DoubleVector axisOrigin = this.getMarginsLayout().toAxisOrigin(this.getLayoutInfo().getGeomInnerBounds(), axisInfo.getOrientation(), this.getCoord().isPolar(), this.getTheme().panel().inset());
            axisComponent.moveTo(axisOrigin);
            parent.add(axisComponent);
        }
    }

    @Override
    public void doDrawHAxis(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object[] objectArray = new AxisLayoutInfo[]{this.getLayoutInfo().getAxisInfos().getTop(), this.getLayoutInfo().getAxisInfos().getBottom()};
        Iterable $this$forEach$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AxisLayoutInfo axisInfo = (AxisLayoutInfo)element$iv;
            boolean bl = false;
            Pair<AxisComponent.TickLabelAdjustments, PolarAxisUtil.PolarBreaksData> pair2 = this.prepareAxisData(axisInfo, this.hScaleBreaks);
            AxisComponent.TickLabelAdjustments labelAdjustments = (AxisComponent.TickLabelAdjustments)pair2.component1();
            PolarAxisUtil.PolarBreaksData breaksData = (PolarAxisUtil.PolarBreaksData)pair2.component2();
            PolarAxisComponent axisComponent = new PolarAxisComponent(axisInfo.getAxisLength(), axisInfo.getOrientation(), breaksData, labelAdjustments, this.getHAxisTheme(), !this.getLayoutInfo().getHAxisShown());
            DoubleVector axisOrigin = this.getMarginsLayout().toAxisOrigin(this.getLayoutInfo().getGeomContentBounds(), axisInfo.getOrientation(), this.getCoord().isPolar(), this.getTheme().panel().inset());
            axisComponent.moveTo(axisOrigin);
            parent.add(axisComponent);
        }
    }

    @Override
    public void doDrawHGrid(@NotNull PanelGridTheme gridTheme, @NotNull SvgComponent parent) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)gridTheme, (String)"gridTheme");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            AxisLayoutInfo axisLayoutInfo = this.getLayoutInfo().getAxisInfos().getLeft();
            if (axisLayoutInfo == null) {
                axisLayoutInfo = this.getLayoutInfo().getAxisInfos().getRight();
            }
            if (axisLayoutInfo == null) break block1;
            AxisLayoutInfo axisInfo = axisLayoutInfo;
            boolean bl = false;
            PolarAxisUtil.PolarBreaksData breaksData = (PolarAxisUtil.PolarBreaksData)this.prepareAxisData(axisInfo, this.vScaleBreaks).component2();
            GridComponent gridComponent = new GridComponent(breaksData.getMajorGrid(), breaksData.getMinorGrid(), true, false, this.getLayoutInfo().getGeomContentBounds(), gridTheme, this.getTheme().panel());
            DoubleVector gridOrigin = this.getLayoutInfo().getGeomContentBounds().getOrigin();
            gridComponent.moveTo(gridOrigin);
            parent.add(gridComponent);
        }
    }

    @Override
    public void doDrawVGrid(@NotNull PanelGridTheme gridTheme, @NotNull SvgComponent parent) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)gridTheme, (String)"gridTheme");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            AxisLayoutInfo axisLayoutInfo = this.getLayoutInfo().getAxisInfos().getTop();
            if (axisLayoutInfo == null) {
                axisLayoutInfo = this.getLayoutInfo().getAxisInfos().getBottom();
            }
            if (axisLayoutInfo == null) break block1;
            AxisLayoutInfo axisInfo = axisLayoutInfo;
            boolean bl = false;
            PolarAxisUtil.PolarBreaksData breaksData = (PolarAxisUtil.PolarBreaksData)this.prepareAxisData(axisInfo, this.hScaleBreaks).component2();
            GridComponent gridComponent = new GridComponent(breaksData.getMajorGrid(), breaksData.getMinorGrid(), false, false, this.getLayoutInfo().getGeomContentBounds(), gridTheme, this.getTheme().panel());
            DoubleVector gridOrigin = this.getLayoutInfo().getGeomContentBounds().getOrigin();
            gridComponent.moveTo(gridOrigin);
            parent.add(gridComponent);
        }
    }

    @Override
    public void doFillBkgr(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgNode fillBkgr2 = this.createPanelElement((Function1<? super SvgShape, Unit>)((Function1)new Function1<SvgShape, Unit>(this){
            final /* synthetic */ PolarFrameOfReference this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull SvgShape it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.fillColor().set(this.this$0.getTheme().panel().rectFill());
            }
        }));
        parent.add(fillBkgr2);
    }

    @Override
    public void doStrokeBkgr(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgNode strokeBkgr2 = this.createPanelElement((Function1<? super SvgShape, Unit>)((Function1)new Function1<SvgShape, Unit>(this){
            final /* synthetic */ PolarFrameOfReference this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull SvgShape it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.strokeColor().set(this.this$0.getTheme().panel().rectColor());
                it.strokeWidth().set(this.this$0.getTheme().panel().rectStrokeWidth());
                StrokeDashArraySupport.INSTANCE.apply(it, this.this$0.getTheme().panel().rectStrokeWidth(), this.this$0.getTheme().panel().rectLineType());
                it.fillOpacity().set(0.0);
            }
        }));
        parent.add(strokeBkgr2);
    }

    @Override
    public void doDrawPanelBorder(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        SvgNode border2 = this.createPanelElement((Function1<? super SvgShape, Unit>)((Function1)new Function1<SvgShape, Unit>(this){
            final /* synthetic */ PolarFrameOfReference this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull SvgShape it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.strokeColor().set(this.this$0.getTheme().panel().borderColor());
                it.strokeWidth().set(this.this$0.getTheme().panel().borderWidth());
                StrokeDashArraySupport.INSTANCE.apply(it, this.this$0.getTheme().panel().borderWidth(), this.this$0.getTheme().panel().borderLineType());
                it.fillOpacity().set(0.0);
            }
        }));
        parent.add(border2);
    }

    private final SvgNode createPanelElement(Function1<? super SvgShape, Unit> block) {
        SvgGraphicsElement svgGraphicsElement;
        boolean bl = this.getCoord().getTransformBkgr();
        if (bl) {
            SvgCircleElement svgCircleElement;
            SvgCircleElement $this$createPanelElement_u24lambda_u244 = svgCircleElement = new SvgCircleElement();
            boolean bl2 = false;
            $this$createPanelElement_u24lambda_u244.cx().set(this.getLayoutInfo().getGeomContentBounds().getCenter().getX());
            $this$createPanelElement_u24lambda_u244.cy().set(this.getLayoutInfo().getGeomContentBounds().getCenter().getY());
            $this$createPanelElement_u24lambda_u244.r().set(this.getLayoutInfo().getGeomContentBounds().getWidth() / (double)2 / 1.15);
            svgGraphicsElement = svgCircleElement;
        } else if (!bl) {
            svgGraphicsElement = new SvgRectElement(this.getLayoutInfo().getGeomInnerBounds());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        SvgRectElement shape = svgGraphicsElement;
        block.invoke((Object)shape);
        return shape;
    }

    private final Pair<AxisComponent.TickLabelAdjustments, PolarAxisUtil.PolarBreaksData> prepareAxisData(AxisLayoutInfo axisInfo, ScaleBreaks scaleBreaks) {
        AxisComponent.TickLabelAdjustments labelAdjustments = new AxisComponent.TickLabelAdjustments(axisInfo.getOrientation(), axisInfo.getTickLabelHorizontalAnchor(), axisInfo.getTickLabelVerticalAnchor(), axisInfo.getTickLabelRotationAngle(), null, axisInfo.getTickLabelAdditionalOffsets(), 16, null);
        PolarAxisUtil.PolarBreaksData breaksData = PolarAxisUtil.INSTANCE.breaksData(scaleBreaks, this.getCoord(), this.getAdjustedDomain(), this.getFlipAxis(), axisInfo.getOrientation(), labelAdjustments);
        return new Pair((Object)labelAdjustments, (Object)breaksData);
    }

    @Override
    @NotNull
    public SvgComponent buildGeomComponent(@NotNull GeomLayer layer, @NotNull GeomTargetCollector targetCollector) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
        return this.buildGeom(layer, targetCollector);
    }

    @Override
    public void setClip(@NotNull SvgComponent element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        double r = this.getLayoutInfo().getGeomContentBounds().getDimension().getX() / (double)2;
        element.clipCircle(this.getLayoutInfo().getGeomContentBounds().getCenter(), r / 1.15);
    }
}

