/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.figure.plot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReferenceProvider;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotAssemblerUtil;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxesLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendsBlockInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.plot.PlotFigureLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.LiveMapAxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.LiveMapTileLayoutProvider;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B_\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\nH\u0002J\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001dJ\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001dR\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/plot/PlotFigureLayouter;", "", "frameProviderByTile", "", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReferenceProvider;", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "containsLiveMap", "", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "legendBoxInfos", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxInfo;", "title", "", "subtitle", "caption", "(Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;ZLorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "axisEnabled", "flipAxis", "hAxisTitle", "legendsBlockInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendsBlockInfo;", "vAxisTitle", "createFigureLayoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/plot/PlotFigureLayoutInfo;", "figurePreferredSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plotLayoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo;", "createLiveMapPlotLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayout;", "createPlotLayout", "insideOut", "layoutByGeomSize", "geomSize", "layoutByOuterSize", "outerSize", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotFigureLayouter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotFigureLayouter.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/figure/plot/PlotFigureLayouter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1549#2:209\n1620#2,3:210\n1549#2:213\n1620#2,3:214\n*S KotlinDebug\n*F\n+ 1 PlotFigureLayouter.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/figure/plot/PlotFigureLayouter\n*L\n92#1:209\n92#1:210,3\n112#1:213\n112#1:214,3\n*E\n"})
public final class PlotFigureLayouter {
    @NotNull
    private final List<FrameOfReferenceProvider> frameProviderByTile;
    @NotNull
    private final PlotFacets facets;
    @NotNull
    private final CoordProvider coordProvider;
    private final boolean containsLiveMap;
    @NotNull
    private final Theme theme;
    @Nullable
    private String title;
    @Nullable
    private String subtitle;
    @Nullable
    private String caption;
    private final boolean flipAxis;
    @Nullable
    private final String hAxisTitle;
    @Nullable
    private final String vAxisTitle;
    private final boolean axisEnabled;
    @NotNull
    private final LegendsBlockInfo legendsBlockInfo;

    public PlotFigureLayouter(@NotNull List<? extends FrameOfReferenceProvider> frameProviderByTile, @NotNull PlotFacets facets, @NotNull CoordProvider coordProvider, boolean containsLiveMap, @NotNull Theme theme, @NotNull List<? extends LegendBoxInfo> legendBoxInfos, @Nullable String title, @Nullable String subtitle, @Nullable String caption) {
        Intrinsics.checkNotNullParameter(frameProviderByTile, (String)"frameProviderByTile");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter(legendBoxInfos, (String)"legendBoxInfos");
        this.frameProviderByTile = frameProviderByTile;
        this.facets = facets;
        this.coordProvider = coordProvider;
        this.containsLiveMap = containsLiveMap;
        this.theme = theme;
        this.title = title;
        this.subtitle = subtitle;
        this.caption = caption;
        this.flipAxis = this.coordProvider.getFlipped();
        this.hAxisTitle = this.frameProviderByTile.get(0).getHAxisLabel();
        this.vAxisTitle = this.frameProviderByTile.get(0).getVAxisLabel();
        this.axisEnabled = !this.containsLiveMap;
        LegendTheme legendTheme = this.theme.legend();
        this.legendsBlockInfo = LegendBoxesLayoutUtil.INSTANCE.arrangeLegendBoxes(legendBoxInfos, legendTheme);
    }

    @NotNull
    public final PlotFigureLayoutInfo layoutByOuterSize(@NotNull DoubleVector outerSize) {
        Intrinsics.checkNotNullParameter((Object)outerSize, (String)"outerSize");
        DoubleVector plotPreferredSize = PlotLayoutUtil.INSTANCE.subtractTitlesAndLegends$plot_builder(outerSize, this.title, this.subtitle, this.caption, this.hAxisTitle, this.vAxisTitle, this.axisEnabled, this.legendsBlockInfo, this.theme, this.flipAxis);
        PlotLayout plotLayout = this.createPlotLayout(false);
        PlotLayoutInfo layoutInfo = plotLayout.doLayout(plotPreferredSize, this.coordProvider);
        return this.createFigureLayoutInfo(outerSize, layoutInfo);
    }

    @NotNull
    public final PlotFigureLayoutInfo layoutByGeomSize(@NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        PlotLayout plotLayout = this.createPlotLayout(true);
        PlotLayoutInfo layoutInfo = plotLayout.doLayout(geomSize, this.coordProvider);
        return this.createFigureLayoutInfo(null, layoutInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final PlotLayout createPlotLayout(boolean insideOut) {
        PlotLayout plotLayout;
        if (this.containsLiveMap) {
            plotLayout = this.createLiveMapPlotLayout();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.frameProviderByTile;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FrameOfReferenceProvider frameOfReferenceProvider = (FrameOfReferenceProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.createTileLayoutProvider());
            }
            List layoutProviderByTile = (List)destination$iv$iv;
            plotLayout = PlotAssemblerUtil.INSTANCE.createPlotLayout(layoutProviderByTile, insideOut, this.facets, this.theme.facets(), this.theme.horizontalAxis(this.flipAxis), this.theme.verticalAxis(this.flipAxis), this.theme.plot());
        }
        return plotLayout;
    }

    /*
     * WARNING - void declaration
     */
    private final PlotLayout createLiveMapPlotLayout() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.frameProviderByTile;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FrameOfReferenceProvider frameOfReferenceProvider = (FrameOfReferenceProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LiveMapTileLayoutProvider());
        }
        List layoutProviderByTile = (List)destination$iv$iv;
        return PlotAssemblerUtil.INSTANCE.createPlotLayout(layoutProviderByTile, false, this.facets, this.theme.facets(), new LiveMapAxisTheme(), new LiveMapAxisTheme(), this.theme.plot());
    }

    private final PlotFigureLayoutInfo createFigureLayoutInfo(DoubleVector figurePreferredSize, PlotLayoutInfo plotLayoutInfo) {
        DoubleRectangle doubleRectangle;
        DoubleVector plotSize2 = plotLayoutInfo.getSize();
        DoubleVector figureLayoutedSize = PlotLayoutUtil.INSTANCE.addTitlesAndLegends$plot_builder(plotSize2, this.title, this.subtitle, this.caption, this.hAxisTitle, this.vAxisTitle, this.axisEnabled, this.legendsBlockInfo, this.theme, this.flipAxis);
        if (figurePreferredSize == null) {
            doubleRectangle = new DoubleRectangle(DoubleVector.Companion.getZERO(), figureLayoutedSize);
        } else {
            Thickness plotLayoutMargins = this.theme.plot().layoutMargins();
            DoubleRectangle figurePreferredBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), figurePreferredSize);
            DoubleVector figureOverallSize = figureLayoutedSize.add(new DoubleVector(plotLayoutMargins.getWidth(), plotLayoutMargins.getHeight()));
            DoubleVector delta = figurePreferredBounds.getCenter().subtract(new DoubleRectangle(figurePreferredBounds.getOrigin(), figureOverallSize).getCenter());
            DoubleVector deltaApplied = new DoubleVector(Math.max(0.0, delta.getX()), Math.max(0.0, delta.getY()));
            DoubleVector plotOuterOrigin = figurePreferredBounds.getOrigin().add(deltaApplied).add(new DoubleVector(plotLayoutMargins.getLeft(), plotLayoutMargins.getTop()));
            doubleRectangle = new DoubleRectangle(plotOuterOrigin, figureLayoutedSize);
        }
        DoubleRectangle figureLayoutedBounds = doubleRectangle;
        PlotFigureLayouter it = this;
        boolean bl = false;
        DoubleVector titleSizeDelta = PlotLayoutUtil.INSTANCE.titleSizeDelta$plot_builder(this.title, this.subtitle, this.theme.plot());
        DoubleVector captionSizeDelta = PlotLayoutUtil.INSTANCE.captionSizeDelta$plot_builder(this.caption, this.theme.plot());
        DoubleRectangle figureBoundsWithoutTitleAndCaption = new DoubleRectangle(figureLayoutedBounds.getOrigin().add(titleSizeDelta), figureLayoutedBounds.getDimension().subtract(titleSizeDelta).subtract(captionSizeDelta));
        DoubleVector plotOrigin = figureBoundsWithoutTitleAndCaption.getOrigin().add(PlotLayoutUtil.INSTANCE.legendBlockLeftTopDelta$plot_builder(this.legendsBlockInfo, this.theme.legend())).add(PlotLayoutUtil.INSTANCE.axisTitlesOriginOffset$plot_builder((Pair<String, ? extends LabelSpec>)TuplesKt.to((Object)this.hAxisTitle, (Object)PlotLabelSpecFactory.INSTANCE.axisTitle(this.theme.horizontalAxis(this.flipAxis))), (Pair<String, ? extends LabelSpec>)TuplesKt.to((Object)this.vAxisTitle, (Object)PlotLabelSpecFactory.INSTANCE.axisTitle(this.theme.verticalAxis(this.flipAxis))), plotLayoutInfo.getHasTopAxisTitle(), plotLayoutInfo.getHasLeftAxisTitle(), this.axisEnabled, PlotLayoutUtil.INSTANCE.axisMarginDimensions$plot_builder(this.theme, this.flipAxis)));
        DoubleRectangle geomAreaBounds = PlotLayoutUtil.INSTANCE.overallGeomBounds$plot_builder(plotLayoutInfo).add(plotOrigin);
        DoubleVector doubleVector = figurePreferredSize;
        if (doubleVector == null) {
            doubleVector = figureLayoutedBounds.getDimension();
        }
        return new PlotFigureLayoutInfo(figureLayoutedBounds, figureBoundsWithoutTitleAndCaption, plotOrigin, geomAreaBounds, doubleVector, plotLayoutInfo, this.legendsBlockInfo);
    }
}

