/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.api.libraries;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResource;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceFallbacksBundle;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceLocation;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourcePathType;
import org.jetbrains.kotlinx.jupyter.api.libraries.ResourceType;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u001b\u0010\u0011\u001a\u0017\u0012\b\u0012\u00060\u0013R\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\u0002\b\u0014J+\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u001b\u0010\u0011\u001a\u0017\u0012\b\u0012\u00060\u0013R\u00020\u0000\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/api/libraries/ResourcesBuilder;", "", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;)V", "logger", "Lorg/slf4j/Logger;", "resources", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResource;", "Lkotlin/collections/ArrayList;", "getResources$api", "()Ljava/util/ArrayList;", "css", "", "name", "", "block", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ResourcesBuilder$BundleBuilder;", "Lkotlin/ExtensionFunctionType;", "js", "BundleBuilder", "api"})
public final class ResourcesBuilder {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ArrayList<LibraryResource> resources;

    public ResourcesBuilder(@NotNull KernelLoggerFactory loggerFactory) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory, Reflection.getOrCreateKotlinClass(this.getClass()));
        this.resources = new ArrayList();
    }

    @NotNull
    public final ArrayList<LibraryResource> getResources$api() {
        return this.resources;
    }

    public final void js(@NotNull String name, @NotNull Function1<? super BundleBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Object object = new BundleBuilder();
        block.invoke(object);
        ArrayList<ResourceFallbacksBundle> bundles = object.getBundles$api();
        object = ResourceType.JS;
        this.resources.add(new LibraryResource((List<ResourceFallbacksBundle>)bundles, (ResourceType)((Object)object), name));
    }

    public final void css(@NotNull String name, @NotNull Function1<? super BundleBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Object object = new BundleBuilder();
        block.invoke(object);
        ArrayList<ResourceFallbacksBundle> bundles = object.getBundles$api();
        object = ResourceType.CSS;
        this.resources.add(new LibraryResource((List<ResourceFallbacksBundle>)bundles, (ResourceType)((Object)object), name));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ0\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013R$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/jupyter/api/libraries/ResourcesBuilder$BundleBuilder;", "", "(Lorg/jetbrains/kotlinx/jupyter/api/libraries/ResourcesBuilder;)V", "bundles", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ResourceFallbacksBundle;", "Lkotlin/collections/ArrayList;", "getBundles$api", "()Ljava/util/ArrayList;", "checkLocalPath", "", "localPath", "", "classPath", "local", "url", "localFallBack", "classpathFallBack", "embed", "", "api"})
    public final class BundleBuilder {
        @NotNull
        private final ArrayList<ResourceFallbacksBundle> bundles = new ArrayList();

        @NotNull
        public final ArrayList<ResourceFallbacksBundle> getBundles$api() {
            return this.bundles;
        }

        private final void checkLocalPath(String localPath) {
            if (!new File(localPath).exists()) {
                ResourcesBuilder.this.logger.warn("A resource with local file path '" + localPath + "' not found.");
            }
        }

        public final void url(@NotNull String url, @Nullable String localFallBack, @Nullable String classpathFallBack, boolean embed) {
            String it;
            List list;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            List $this$url_u24lambda_u242 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (embed) {
                $this$url_u24lambda_u242.add(new ResourceLocation(url, ResourcePathType.URL_EMBEDDED));
            } else {
                $this$url_u24lambda_u242.add(new ResourceLocation(url, ResourcePathType.URL));
            }
            String string = localFallBack;
            if (string != null) {
                it = string;
                boolean bl2 = false;
                this.checkLocalPath(localFallBack);
                $this$url_u24lambda_u242.add(new ResourceLocation(localFallBack, ResourcePathType.LOCAL_PATH));
            }
            String string2 = classpathFallBack;
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                $this$url_u24lambda_u242.add(new ResourceLocation(classpathFallBack, ResourcePathType.CLASSPATH_PATH));
            }
            List list2 = CollectionsKt.build((List)list);
            ResourceFallbacksBundle libraryResource = new ResourceFallbacksBundle(list2);
            this.bundles.add(libraryResource);
        }

        public static /* synthetic */ void url$default(BundleBuilder bundleBuilder, String string, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            bundleBuilder.url(string, string2, string3, bl);
        }

        public final void local(@NotNull String localPath) {
            Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
            this.checkLocalPath(localPath);
            this.bundles.add(new ResourceFallbacksBundle(CollectionsKt.listOf((Object)new ResourceLocation(localPath, ResourcePathType.LOCAL_PATH))));
        }

        public final void classPath(@NotNull String classPath) {
            Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
            this.bundles.add(new ResourceFallbacksBundle(CollectionsKt.listOf((Object)new ResourceLocation(classPath, ResourcePathType.CLASSPATH_PATH))));
        }
    }
}

