/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.debugger.streams.psi.ChainDetector;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/debugger/streams/psi/impl/InheritanceBasedChainDetector;", "Lcom/intellij/debugger/streams/psi/ChainDetector;", "baseClassName", "", "<init>", "(Ljava/lang/String;)V", "isTerminationCall", "", "callExpression", "Lcom/intellij/psi/PsiMethodCallExpression;", "isIntermediateCall", "isStreamType", "type", "Lcom/intellij/psi/PsiType;", "Lcom/intellij/psi/PsiClass;", "isStatic", "Lcom/intellij/psi/PsiMethod;", "intellij.java.debugger.streams"})
public final class InheritanceBasedChainDetector
implements ChainDetector {
    @NotNull
    private final String baseClassName;

    public InheritanceBasedChainDetector(@NotNull String baseClassName) {
        Intrinsics.checkNotNullParameter((Object)baseClassName, (String)"baseClassName");
        this.baseClassName = baseClassName;
    }

    @Override
    public boolean isTerminationCall(@NotNull PsiMethodCallExpression callExpression) {
        PsiElement psiElement;
        PsiType qualifierType;
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        PsiMethod psiMethod = callExpression.resolveMethod();
        if (psiMethod == null) {
            return false;
        }
        PsiMethod method = psiMethod;
        PsiExpression psiExpression = callExpression.getMethodExpression().getQualifierExpression();
        Object object = qualifierType = psiExpression != null ? psiExpression.getType() : null;
        return (this.isStreamType(qualifierType) || this.isStreamType((psiElement = method.getParent()) instanceof PsiClass ? (PsiClass)psiElement : null)) && !this.isStreamType(method.getReturnType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isIntermediateCall(@NotNull PsiMethodCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        PsiMethod psiMethod = callExpression.resolveMethod();
        if (psiMethod == null) {
            return false;
        }
        PsiMethod method = psiMethod;
        if (this.isStatic(method)) return false;
        PsiElement psiElement = method.getParent();
        if (!this.isStreamType(psiElement instanceof PsiClass ? (PsiClass)psiElement : null)) return false;
        PsiMethod psiMethod2 = callExpression.resolveMethod();
        if (!this.isStreamType((PsiType)(psiMethod2 != null ? psiMethod2.getReturnType() : null))) return false;
        return true;
    }

    private final boolean isStreamType(PsiType type) {
        return InheritanceUtil.isInheritor((PsiType)type, (String)this.baseClassName);
    }

    private final boolean isStreamType(PsiClass type) {
        return InheritanceUtil.isInheritor((PsiClass)type, (String)this.baseClassName);
    }

    private final boolean isStatic(PsiMethod $this$isStatic) {
        return $this$isStatic.hasModifier(JvmModifier.STATIC);
    }
}

