package TDS::Navigator::Daily;
# $Id: Daily.pm,v 1.10 2000/12/08 02:02:32 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $Template $HrefTemplateDynamic $HrefTemplateStatic);

use DateTime::Date;

use TDS::Navigator::Base;

@ISA = qw(TDS::Navigator::Base);

attributes qw();

{
#    $HrefTemplateDynamic = "%path?%year%0m%{0d}";
    $HrefTemplateDynamic = "TsDiary.cgi?%year%0m%0d";
    $HrefTemplateStatic = "d%year%0m%part.%suffix\#%0d";
}

################################################################
sub initialize($)
{
    my $self = shift;
    $self->use_accesskey(1);
    $self->SUPER::initialize;
}
sub AsPrev ($$)
{
    my ($self, $label, $q) = @_;

    my $d = new DateTime::Date(year=>$self->year,
			       month=>$self->month,
			       day=>$self->day);
    $d -= '1D';
    my $params = $d->GetParams;
    $params->{accesskey} = "1";
    return $self->AsHTML($label, $params);
}
sub AsNext ($$)
{
    my ($self, $label) = @_;

    my $d = new DateTime::Date(year=>$self->year,
			       month=>$self->month,
			       day=>$self->day);
    $d += '1D';
#    my $filename = sprintf("%s/%04d/%02d/%02d.tdf",
#			   GetDiaryDir(),
#			   $d->year, $d->month, $d->
    my $nohref;
    if ($d > $TDS::Status->start_time){
	$nohref = 1;
    }
    my $params = $d->GetParams;
    $params->{accesskey} = "3";    
    return $self->AsHTML($label, $params, $nohref);
}
sub AsThis ($$)
{
    my ($self, $label) = @_;

    my $d = new DateTime::Date(year=>$self->year,
			       month=>$self->month,
			       day=>$self->day);
    return $self->AsHTML($label, $d->GetParams);
}


1;
