require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_TTY_H_)) {
    eval 'sub _SYS_TTY_H_ () {1;}' unless defined(&_SYS_TTY_H_);
    require 'sys/termios.ph';
    require 'sys/select.ph';
    require 'sys/selinfo.ph';
    require 'sys/mutex.ph';
    require 'sys/condvar.ph';
    require 'sys/queue.ph';
    require 'sys/callout.ph';
    eval("sub TTYSIG_PG1 () { 0; }") unless defined(&TTYSIG_PG1);
    eval("sub TTYSIG_PG2 () { 1; }") unless defined(&TTYSIG_PG2);
    eval("sub TTYSIG_LEADER () { 2; }") unless defined(&TTYSIG_LEADER);
    eval("sub TTYSIG_COUNT () { 3; }") unless defined(&TTYSIG_COUNT);
    if(defined(&TTY_ALLOW_PRIVATE)) {
	eval 'sub t_cc () { ($t_termios->{c_cc});}' unless defined(&t_cc);
    }
    eval 'sub t_cflag () { ($t_termios->{c_cflag});}' unless defined(&t_cflag);
    eval 'sub t_iflag () { ($t_termios->{c_iflag});}' unless defined(&t_iflag);
    eval 'sub t_ispeed () { ($t_termios->{c_ispeed});}' unless defined(&t_ispeed);
    eval 'sub t_lflag () { ($t_termios->{c_lflag});}' unless defined(&t_lflag);
    eval 'sub t_oflag () { ($t_termios->{c_oflag});}' unless defined(&t_oflag);
    eval 'sub t_ospeed () { ($t_termios->{c_ospeed});}' unless defined(&t_ospeed);
    eval 'sub TTIPRI () {25;}' unless defined(&TTIPRI);
    eval 'sub TTOPRI () {26;}' unless defined(&TTOPRI);
    eval 'sub TTMASK () {15;}' unless defined(&TTMASK);
    eval 'sub OBUFSIZ () {100;}' unless defined(&OBUFSIZ);
    eval 'sub TTYHOG () { ($tp->{t_qsize});}' unless defined(&TTYHOG);
    if(defined(&_KERNEL)) {
	eval 'sub TTMAXHIWAT () { &roundup( ($tp->{t_qsize}) << 1, 64);}' unless defined(&TTMAXHIWAT);
	eval 'sub TTMINHIWAT () { &roundup( ($tp->{t_qsize}) >> 3, 64);}' unless defined(&TTMINHIWAT);
	eval 'sub TTMAXLOWAT () {( ($tp->{t_qsize}) >> 2);}' unless defined(&TTMAXLOWAT);
	eval 'sub TTMINLOWAT () {( ($tp->{t_qsize}) >> 5);}' unless defined(&TTMINLOWAT);
	eval 'sub TTROUND () {64;}' unless defined(&TTROUND);
	eval 'sub TTDIALOUT_MASK () {0x80000;}' unless defined(&TTDIALOUT_MASK);
	eval 'sub TTCALLUNIT_MASK () {0x40000;}' unless defined(&TTCALLUNIT_MASK);
	eval 'sub TTUNIT_MASK () {0x3ffff;}' unless defined(&TTUNIT_MASK);
	eval 'sub TTDIALOUT {
	    my($d) = @_;
    	    eval q(( &minor($d) &  &TTDIALOUT_MASK));
	}' unless defined(&TTDIALOUT);
	eval 'sub TTCALLUNIT {
	    my($d) = @_;
    	    eval q(( &minor($d) &  &TTCALLUNIT_MASK));
	}' unless defined(&TTCALLUNIT);
	eval 'sub TTUNIT {
	    my($d) = @_;
    	    eval q(( &minor($d) &  &TTUNIT_MASK));
	}' unless defined(&TTUNIT);
    }
    eval 'sub TS_SIGINFO () {0x1;}' unless defined(&TS_SIGINFO);
    eval 'sub TS_ASYNC () {0x2;}' unless defined(&TS_ASYNC);
    eval 'sub TS_BUSY () {0x4;}' unless defined(&TS_BUSY);
    eval 'sub TS_CARR_ON () {0x8;}' unless defined(&TS_CARR_ON);
    eval 'sub TS_DIALOUT () {0x10;}' unless defined(&TS_DIALOUT);
    eval 'sub TS_FLUSH () {0x20;}' unless defined(&TS_FLUSH);
    eval 'sub TS_ISOPEN () {0x40;}' unless defined(&TS_ISOPEN);
    eval 'sub TS_TBLOCK () {0x80;}' unless defined(&TS_TBLOCK);
    eval 'sub TS_TIMEOUT () {0x100;}' unless defined(&TS_TIMEOUT);
    eval 'sub TS_TTSTOP () {0x200;}' unless defined(&TS_TTSTOP);
    eval 'sub TS_XCLUDE () {0x400;}' unless defined(&TS_XCLUDE);
    eval 'sub TS_BKSL () {0x800;}' unless defined(&TS_BKSL);
    eval 'sub TS_CNTTB () {0x1000;}' unless defined(&TS_CNTTB);
    eval 'sub TS_ERASE () {0x2000;}' unless defined(&TS_ERASE);
    eval 'sub TS_LNCH () {0x4000;}' unless defined(&TS_LNCH);
    eval 'sub TS_TYPEN () {0x8000;}' unless defined(&TS_TYPEN);
    eval 'sub TS_LOCAL () {( &TS_BKSL |  &TS_CNTTB |  &TS_ERASE |  &TS_LNCH |  &TS_TYPEN);}' unless defined(&TS_LOCAL);
    eval 'sub TS_KERN_ONLY () {0x10000;}' unless defined(&TS_KERN_ONLY);
    eval 'sub TS_CANCEL () {0x20000;}' unless defined(&TS_CANCEL);
    eval 'sub ORDINARY () {0;}' unless defined(&ORDINARY);
    eval 'sub CONTROL () {1;}' unless defined(&CONTROL);
    eval 'sub BACKSPACE () {2;}' unless defined(&BACKSPACE);
    eval 'sub NEWLINE () {3;}' unless defined(&NEWLINE);
    eval 'sub TAB () {4;}' unless defined(&TAB);
    eval 'sub VTAB () {5;}' unless defined(&VTAB);
    eval 'sub RETURN () {6;}' unless defined(&RETURN);
    eval 'sub DMSET () {0;}' unless defined(&DMSET);
    eval 'sub DMBIS () {1;}' unless defined(&DMBIS);
    eval 'sub DMBIC () {2;}' unless defined(&DMBIC);
    eval 'sub DMGET () {3;}' unless defined(&DMGET);
    eval 'sub TTY_CHARMASK () {0xff;}' unless defined(&TTY_CHARMASK);
    eval 'sub TTY_QUOTE () {0x100;}' unless defined(&TTY_QUOTE);
    eval 'sub TTY_ERRORMASK () {0xff000000;}' unless defined(&TTY_ERRORMASK);
    eval 'sub TTY_FE () {0x1000000;}' unless defined(&TTY_FE);
    eval 'sub TTY_PE () {0x2000000;}' unless defined(&TTY_PE);
    eval 'sub isctty {
        my($p, $tp) = @_;
	    eval q((($p)-> &p_session == ($tp)-> &t_session  && ($p)-> &p_lflag &  &PL_CONTROLT));
    }' unless defined(&isctty);
    eval 'sub isbackground {
        my($p, $tp) = @_;
	    eval q(( &isctty(($p), ($tp))  && ($p)-> &p_pgrp != ($tp)-> &t_pgrp));
    }' unless defined(&isbackground);
    if(defined(&_KERNEL)) {
    }
}
1;
