/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.util.IGVMouseInputAdapter;
import org.broad.igv.ui.util.UIUtilities;

public abstract class LegendPanel
extends JPanel {
    protected TrackType type;
    private MouseInputListener mouseListener = new IGVMouseInputAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            LegendPanel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void igvMouseClicked(MouseEvent e) {
            LegendPanel.this.edit();
        }
    };
    private WaitCursorManager.CursorToken token;

    public LegendPanel() {
        this.addMouseListener(this.mouseListener);
        UIUtilities.invokeOnEventThread(() -> this.setToolTipText("Click this item bring up its editor"));
    }

    protected abstract void resetPreferencesToDefault();

    protected void showResetDisplay() {
        try {
            this.reloadPreferences();
        }
        finally {
            IGV.getInstance().resetStatusMessage();
        }
    }

    public void setTrackType(TrackType type) {
        this.type = type;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (PreferencesManager.getPreferences().getAntiAliasing()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.paintLegend((Graphics2D)g);
    }

    protected abstract void paintLegend(Graphics2D var1);

    public abstract void edit();

    protected abstract void reloadPreferences();

    protected abstract void persistResetPreferences();
}

