require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DEV_PCI_PCIREG_H_)) {
    eval 'sub _DEV_PCI_PCIREG_H_ () {1;}' unless defined(&_DEV_PCI_PCIREG_H_);
    eval 'sub PCI_CONF_SIZE () {0x100;}' unless defined(&PCI_CONF_SIZE);
    eval 'sub PCI_EXTCONF_SIZE () {0x1000;}' unless defined(&PCI_EXTCONF_SIZE);
    eval 'sub PCI_ID_REG () {0x;}' unless defined(&PCI_ID_REG);
    eval 'sub PCI_VENDOR_SHIFT () {0;}' unless defined(&PCI_VENDOR_SHIFT);
    eval 'sub PCI_VENDOR_MASK () {0xffff;}' unless defined(&PCI_VENDOR_MASK);
    eval 'sub PCI_VENDOR {
        my($id) = @_;
	    eval q(((($id) >>  &PCI_VENDOR_SHIFT) &  &PCI_VENDOR_MASK));
    }' unless defined(&PCI_VENDOR);
    eval 'sub PCI_PRODUCT_SHIFT () {16;}' unless defined(&PCI_PRODUCT_SHIFT);
    eval 'sub PCI_PRODUCT_MASK () {0xffff;}' unless defined(&PCI_PRODUCT_MASK);
    eval 'sub PCI_PRODUCT {
        my($id) = @_;
	    eval q(((($id) >>  &PCI_PRODUCT_SHIFT) &  &PCI_PRODUCT_MASK));
    }' unless defined(&PCI_PRODUCT);
    eval 'sub PCI_ID_CODE {
        my($vid,$pid) = @_;
	    eval q((((($vid) &  &PCI_VENDOR_MASK) <<  &PCI_VENDOR_SHIFT) | ((($pid) &  &PCI_PRODUCT_MASK) <<  &PCI_PRODUCT_SHIFT)));
    }' unless defined(&PCI_ID_CODE);
    eval 'sub PCI_COMMAND_STATUS_REG () {0x4;}' unless defined(&PCI_COMMAND_STATUS_REG);
    eval 'sub PCI_COMMAND_SHIFT () {0;}' unless defined(&PCI_COMMAND_SHIFT);
    eval 'sub PCI_COMMAND_MASK () {0xffff;}' unless defined(&PCI_COMMAND_MASK);
    eval 'sub PCI_STATUS_SHIFT () {16;}' unless defined(&PCI_STATUS_SHIFT);
    eval 'sub PCI_STATUS_MASK () {0xffff;}' unless defined(&PCI_STATUS_MASK);
    eval 'sub PCI_COMMAND_STATUS_CODE {
        my($cmd,$stat) = @_;
	    eval q((((($cmd) &  &PCI_COMMAND_MASK) <<  &PCI_COMMAND_SHIFT) | ((($stat) &  &PCI_STATUS_MASK) <<  &PCI_STATUS_SHIFT)));
    }' unless defined(&PCI_COMMAND_STATUS_CODE);
    eval 'sub PCI_COMMAND_IO_ENABLE () {0x1;}' unless defined(&PCI_COMMAND_IO_ENABLE);
    eval 'sub PCI_COMMAND_MEM_ENABLE () {0x2;}' unless defined(&PCI_COMMAND_MEM_ENABLE);
    eval 'sub PCI_COMMAND_MASTER_ENABLE () {0x4;}' unless defined(&PCI_COMMAND_MASTER_ENABLE);
    eval 'sub PCI_COMMAND_SPECIAL_ENABLE () {0x8;}' unless defined(&PCI_COMMAND_SPECIAL_ENABLE);
    eval 'sub PCI_COMMAND_INVALIDATE_ENABLE () {0x10;}' unless defined(&PCI_COMMAND_INVALIDATE_ENABLE);
    eval 'sub PCI_COMMAND_PALETTE_ENABLE () {0x20;}' unless defined(&PCI_COMMAND_PALETTE_ENABLE);
    eval 'sub PCI_COMMAND_PARITY_ENABLE () {0x40;}' unless defined(&PCI_COMMAND_PARITY_ENABLE);
    eval 'sub PCI_COMMAND_STEPPING_ENABLE () {0x80;}' unless defined(&PCI_COMMAND_STEPPING_ENABLE);
    eval 'sub PCI_COMMAND_SERR_ENABLE () {0x100;}' unless defined(&PCI_COMMAND_SERR_ENABLE);
    eval 'sub PCI_COMMAND_BACKTOBACK_ENABLE () {0x200;}' unless defined(&PCI_COMMAND_BACKTOBACK_ENABLE);
    eval 'sub PCI_COMMAND_INTERRUPT_DISABLE () {0x400;}' unless defined(&PCI_COMMAND_INTERRUPT_DISABLE);
    eval 'sub PCI_STATUS_IMMD_READNESS () { &__BIT(0+16);}' unless defined(&PCI_STATUS_IMMD_READNESS);
    eval 'sub PCI_STATUS_INT_STATUS () {0x80000;}' unless defined(&PCI_STATUS_INT_STATUS);
    eval 'sub PCI_STATUS_CAPLIST_SUPPORT () {0x100000;}' unless defined(&PCI_STATUS_CAPLIST_SUPPORT);
    eval 'sub PCI_STATUS_66MHZ_SUPPORT () {0x200000;}' unless defined(&PCI_STATUS_66MHZ_SUPPORT);
    eval 'sub PCI_STATUS_UDF_SUPPORT () {0x400000;}' unless defined(&PCI_STATUS_UDF_SUPPORT);
    eval 'sub PCI_STATUS_BACKTOBACK_SUPPORT () {0x800000;}' unless defined(&PCI_STATUS_BACKTOBACK_SUPPORT);
    eval 'sub PCI_STATUS_PARITY_ERROR () {0x1000000;}' unless defined(&PCI_STATUS_PARITY_ERROR);
    eval 'sub PCI_STATUS_DEVSEL_FAST () {0x;}' unless defined(&PCI_STATUS_DEVSEL_FAST);
    eval 'sub PCI_STATUS_DEVSEL_MEDIUM () {0x2000000;}' unless defined(&PCI_STATUS_DEVSEL_MEDIUM);
    eval 'sub PCI_STATUS_DEVSEL_SLOW () {0x4000000;}' unless defined(&PCI_STATUS_DEVSEL_SLOW);
    eval 'sub PCI_STATUS_DEVSEL_MASK () {0x6000000;}' unless defined(&PCI_STATUS_DEVSEL_MASK);
    eval 'sub PCI_STATUS_TARGET_TARGET_ABORT () {0x8000000;}' unless defined(&PCI_STATUS_TARGET_TARGET_ABORT);
    eval 'sub PCI_STATUS_MASTER_TARGET_ABORT () {0x10000000;}' unless defined(&PCI_STATUS_MASTER_TARGET_ABORT);
    eval 'sub PCI_STATUS_MASTER_ABORT () {0x20000000;}' unless defined(&PCI_STATUS_MASTER_ABORT);
    eval 'sub PCI_STATUS_SPECIAL_ERROR () {0x40000000;}' unless defined(&PCI_STATUS_SPECIAL_ERROR);
    eval 'sub PCI_STATUS_PARITY_DETECT () {0x80000000;}' unless defined(&PCI_STATUS_PARITY_DETECT);
    eval 'sub PCI_CLASS_REG () {0x8;}' unless defined(&PCI_CLASS_REG);
    eval 'sub PCI_CLASS_SHIFT () {24;}' unless defined(&PCI_CLASS_SHIFT);
    eval 'sub PCI_CLASS_MASK () {0xff;}' unless defined(&PCI_CLASS_MASK);
    eval 'sub PCI_CLASS {
        my($cr) = @_;
	    eval q(((($cr) >>  &PCI_CLASS_SHIFT) &  &PCI_CLASS_MASK));
    }' unless defined(&PCI_CLASS);
    eval 'sub PCI_SUBCLASS_SHIFT () {16;}' unless defined(&PCI_SUBCLASS_SHIFT);
    eval 'sub PCI_SUBCLASS_MASK () {0xff;}' unless defined(&PCI_SUBCLASS_MASK);
    eval 'sub PCI_SUBCLASS {
        my($cr) = @_;
	    eval q(((($cr) >>  &PCI_SUBCLASS_SHIFT) &  &PCI_SUBCLASS_MASK));
    }' unless defined(&PCI_SUBCLASS);
    eval 'sub PCI_INTERFACE_SHIFT () {8;}' unless defined(&PCI_INTERFACE_SHIFT);
    eval 'sub PCI_INTERFACE_MASK () {0xff;}' unless defined(&PCI_INTERFACE_MASK);
    eval 'sub PCI_INTERFACE {
        my($cr) = @_;
	    eval q(((($cr) >>  &PCI_INTERFACE_SHIFT) &  &PCI_INTERFACE_MASK));
    }' unless defined(&PCI_INTERFACE);
    eval 'sub PCI_REVISION_SHIFT () {0;}' unless defined(&PCI_REVISION_SHIFT);
    eval 'sub PCI_REVISION_MASK () {0xff;}' unless defined(&PCI_REVISION_MASK);
    eval 'sub PCI_REVISION {
        my($cr) = @_;
	    eval q(((($cr) >>  &PCI_REVISION_SHIFT) &  &PCI_REVISION_MASK));
    }' unless defined(&PCI_REVISION);
    eval 'sub PCI_CLASS_CODE {
        my($mainclass, $subclass, $interface) = @_;
	    eval q((((($mainclass) &  &PCI_CLASS_MASK) <<  &PCI_CLASS_SHIFT) | ((($subclass) &  &PCI_SUBCLASS_MASK) <<  &PCI_SUBCLASS_SHIFT) | ((($interface) &  &PCI_INTERFACE_MASK) <<  &PCI_INTERFACE_SHIFT)));
    }' unless defined(&PCI_CLASS_CODE);
    eval 'sub PCI_CLASS_PREHISTORIC () {0x;}' unless defined(&PCI_CLASS_PREHISTORIC);
    eval 'sub PCI_CLASS_MASS_STORAGE () {0x1;}' unless defined(&PCI_CLASS_MASS_STORAGE);
    eval 'sub PCI_CLASS_NETWORK () {0x2;}' unless defined(&PCI_CLASS_NETWORK);
    eval 'sub PCI_CLASS_DISPLAY () {0x3;}' unless defined(&PCI_CLASS_DISPLAY);
    eval 'sub PCI_CLASS_MULTIMEDIA () {0x4;}' unless defined(&PCI_CLASS_MULTIMEDIA);
    eval 'sub PCI_CLASS_MEMORY () {0x5;}' unless defined(&PCI_CLASS_MEMORY);
    eval 'sub PCI_CLASS_BRIDGE () {0x6;}' unless defined(&PCI_CLASS_BRIDGE);
    eval 'sub PCI_CLASS_COMMUNICATIONS () {0x7;}' unless defined(&PCI_CLASS_COMMUNICATIONS);
    eval 'sub PCI_CLASS_SYSTEM () {0x8;}' unless defined(&PCI_CLASS_SYSTEM);
    eval 'sub PCI_CLASS_INPUT () {0x9;}' unless defined(&PCI_CLASS_INPUT);
    eval 'sub PCI_CLASS_DOCK () {0xa;}' unless defined(&PCI_CLASS_DOCK);
    eval 'sub PCI_CLASS_PROCESSOR () {0xb;}' unless defined(&PCI_CLASS_PROCESSOR);
    eval 'sub PCI_CLASS_SERIALBUS () {0xc;}' unless defined(&PCI_CLASS_SERIALBUS);
    eval 'sub PCI_CLASS_WIRELESS () {0xd;}' unless defined(&PCI_CLASS_WIRELESS);
    eval 'sub PCI_CLASS_I2O () {0xe;}' unless defined(&PCI_CLASS_I2O);
    eval 'sub PCI_CLASS_SATCOM () {0xf;}' unless defined(&PCI_CLASS_SATCOM);
    eval 'sub PCI_CLASS_CRYPTO () {0x10;}' unless defined(&PCI_CLASS_CRYPTO);
    eval 'sub PCI_CLASS_DASP () {0x11;}' unless defined(&PCI_CLASS_DASP);
    eval 'sub PCI_CLASS_ACCEL () {0x12;}' unless defined(&PCI_CLASS_ACCEL);
    eval 'sub PCI_CLASS_INSTRUMENT () {0x13;}' unless defined(&PCI_CLASS_INSTRUMENT);
    eval 'sub PCI_CLASS_UNDEFINED () {0xff;}' unless defined(&PCI_CLASS_UNDEFINED);
    eval 'sub PCI_SUBCLASS_PREHISTORIC_MISC () {0x;}' unless defined(&PCI_SUBCLASS_PREHISTORIC_MISC);
    eval 'sub PCI_SUBCLASS_PREHISTORIC_VGA () {0x1;}' unless defined(&PCI_SUBCLASS_PREHISTORIC_VGA);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_SCSI () {0x;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_SCSI);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_IDE () {0x1;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_IDE);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_FLOPPY () {0x2;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_FLOPPY);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_IPI () {0x3;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_IPI);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_RAID () {0x4;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_RAID);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_ATA () {0x5;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_ATA);
    eval 'sub PCI_INTERFACE_ATA_SINGLEDMA () {0x20;}' unless defined(&PCI_INTERFACE_ATA_SINGLEDMA);
    eval 'sub PCI_INTERFACE_ATA_CHAINEDDMA () {0x30;}' unless defined(&PCI_INTERFACE_ATA_CHAINEDDMA);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_SATA () {0x6;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_SATA);
    eval 'sub PCI_INTERFACE_SATA_VND () {0x;}' unless defined(&PCI_INTERFACE_SATA_VND);
    eval 'sub PCI_INTERFACE_SATA_AHCI10 () {0x1;}' unless defined(&PCI_INTERFACE_SATA_AHCI10);
    eval 'sub PCI_INTERFACE_SATA_SSBI () {0x2;}' unless defined(&PCI_INTERFACE_SATA_SSBI);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_SAS () {0x7;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_SAS);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_NVM () {0x8;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_NVM);
    eval 'sub PCI_INTERFACE_NVM_VND () {0x;}' unless defined(&PCI_INTERFACE_NVM_VND);
    eval 'sub PCI_INTERFACE_NVM_NVMHCI10 () {0x1;}' unless defined(&PCI_INTERFACE_NVM_NVMHCI10);
    eval 'sub PCI_INTERFACE_NVM_NVME_IO () {0x2;}' unless defined(&PCI_INTERFACE_NVM_NVME_IO);
    eval 'sub PCI_INTERFACE_NVM_NVME_ADMIN () {0x3;}' unless defined(&PCI_INTERFACE_NVM_NVME_ADMIN);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_UFS () {0x9;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_UFS);
    eval 'sub PCI_INTERFACE_UFS_VND () {0x;}' unless defined(&PCI_INTERFACE_UFS_VND);
    eval 'sub PCI_INTERFACE_UFS_UFSHCI () {0x1;}' unless defined(&PCI_INTERFACE_UFS_UFSHCI);
    eval 'sub PCI_SUBCLASS_MASS_STORAGE_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_MASS_STORAGE_MISC);
    eval 'sub PCI_SUBCLASS_NETWORK_ETHERNET () {0x;}' unless defined(&PCI_SUBCLASS_NETWORK_ETHERNET);
    eval 'sub PCI_SUBCLASS_NETWORK_TOKENRING () {0x1;}' unless defined(&PCI_SUBCLASS_NETWORK_TOKENRING);
    eval 'sub PCI_SUBCLASS_NETWORK_FDDI () {0x2;}' unless defined(&PCI_SUBCLASS_NETWORK_FDDI);
    eval 'sub PCI_SUBCLASS_NETWORK_ATM () {0x3;}' unless defined(&PCI_SUBCLASS_NETWORK_ATM);
    eval 'sub PCI_SUBCLASS_NETWORK_ISDN () {0x4;}' unless defined(&PCI_SUBCLASS_NETWORK_ISDN);
    eval 'sub PCI_SUBCLASS_NETWORK_WORLDFIP () {0x5;}' unless defined(&PCI_SUBCLASS_NETWORK_WORLDFIP);
    eval 'sub PCI_SUBCLASS_NETWORK_PCIMGMULTICOMP () {0x6;}' unless defined(&PCI_SUBCLASS_NETWORK_PCIMGMULTICOMP);
    eval 'sub PCI_SUBCLASS_NETWORK_INFINIBAND () {0x7;}' unless defined(&PCI_SUBCLASS_NETWORK_INFINIBAND);
    eval 'sub PCI_SUBCLASS_NETWORK_HFC () {0x8;}' unless defined(&PCI_SUBCLASS_NETWORK_HFC);
    eval 'sub PCI_SUBCLASS_NETWORK_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_NETWORK_MISC);
    eval 'sub PCI_SUBCLASS_DISPLAY_VGA () {0x;}' unless defined(&PCI_SUBCLASS_DISPLAY_VGA);
    eval 'sub PCI_INTERFACE_VGA_VGA () {0x;}' unless defined(&PCI_INTERFACE_VGA_VGA);
    eval 'sub PCI_INTERFACE_VGA_8514 () {0x1;}' unless defined(&PCI_INTERFACE_VGA_8514);
    eval 'sub PCI_SUBCLASS_DISPLAY_XGA () {0x1;}' unless defined(&PCI_SUBCLASS_DISPLAY_XGA);
    eval 'sub PCI_SUBCLASS_DISPLAY_3D () {0x2;}' unless defined(&PCI_SUBCLASS_DISPLAY_3D);
    eval 'sub PCI_SUBCLASS_DISPLAY_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_DISPLAY_MISC);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_VIDEO () {0x;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_VIDEO);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_AUDIO () {0x1;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_AUDIO);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_TELEPHONY () {0x2;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_TELEPHONY);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_HDAUDIO () {0x3;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_HDAUDIO);
    eval 'sub PCI_INTERFACE_HDAUDIO () {0x;}' unless defined(&PCI_INTERFACE_HDAUDIO);
    eval 'sub PCI_INTERFACE_HDAUDIO_VND () {0x80;}' unless defined(&PCI_INTERFACE_HDAUDIO_VND);
    eval 'sub PCI_SUBCLASS_MULTIMEDIA_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_MULTIMEDIA_MISC);
    eval 'sub PCI_SUBCLASS_MEMORY_RAM () {0x;}' unless defined(&PCI_SUBCLASS_MEMORY_RAM);
    eval 'sub PCI_SUBCLASS_MEMORY_FLASH () {0x1;}' unless defined(&PCI_SUBCLASS_MEMORY_FLASH);
    eval 'sub PCI_SUBCLASS_MEMORY_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_MEMORY_MISC);
    eval 'sub PCI_SUBCLASS_BRIDGE_HOST () {0x;}' unless defined(&PCI_SUBCLASS_BRIDGE_HOST);
    eval 'sub PCI_SUBCLASS_BRIDGE_ISA () {0x1;}' unless defined(&PCI_SUBCLASS_BRIDGE_ISA);
    eval 'sub PCI_SUBCLASS_BRIDGE_EISA () {0x2;}' unless defined(&PCI_SUBCLASS_BRIDGE_EISA);
    eval 'sub PCI_SUBCLASS_BRIDGE_MC () {0x3;}' unless defined(&PCI_SUBCLASS_BRIDGE_MC);
    eval 'sub PCI_SUBCLASS_BRIDGE_PCI () {0x4;}' unless defined(&PCI_SUBCLASS_BRIDGE_PCI);
    eval 'sub PCI_INTERFACE_BRIDGE_PCI_PCI () {0x;}' unless defined(&PCI_INTERFACE_BRIDGE_PCI_PCI);
    eval 'sub PCI_INTERFACE_BRIDGE_PCI_SUBDEC () {0x1;}' unless defined(&PCI_INTERFACE_BRIDGE_PCI_SUBDEC);
    eval 'sub PCI_SUBCLASS_BRIDGE_PCMCIA () {0x5;}' unless defined(&PCI_SUBCLASS_BRIDGE_PCMCIA);
    eval 'sub PCI_SUBCLASS_BRIDGE_NUBUS () {0x6;}' unless defined(&PCI_SUBCLASS_BRIDGE_NUBUS);
    eval 'sub PCI_SUBCLASS_BRIDGE_CARDBUS () {0x7;}' unless defined(&PCI_SUBCLASS_BRIDGE_CARDBUS);
    eval 'sub PCI_SUBCLASS_BRIDGE_RACEWAY () {0x8;}' unless defined(&PCI_SUBCLASS_BRIDGE_RACEWAY);
    eval 'sub PCI_SUBCLASS_BRIDGE_STPCI () {0x9;}' unless defined(&PCI_SUBCLASS_BRIDGE_STPCI);
    eval 'sub PCI_INTERFACE_STPCI_PRIMARY () {0x40;}' unless defined(&PCI_INTERFACE_STPCI_PRIMARY);
    eval 'sub PCI_INTERFACE_STPCI_SECONDARY () {0x80;}' unless defined(&PCI_INTERFACE_STPCI_SECONDARY);
    eval 'sub PCI_SUBCLASS_BRIDGE_INFINIBAND () {0xa;}' unless defined(&PCI_SUBCLASS_BRIDGE_INFINIBAND);
    eval 'sub PCI_SUBCLASS_BRIDGE_ADVSW () {0xb;}' unless defined(&PCI_SUBCLASS_BRIDGE_ADVSW);
    eval 'sub PCI_INTERFACE_ADVSW_CUSTOM () {0x;}' unless defined(&PCI_INTERFACE_ADVSW_CUSTOM);
    eval 'sub PCI_INTERFACE_ADVSW_ASISIG () {0x1;}' unless defined(&PCI_INTERFACE_ADVSW_ASISIG);
    eval 'sub PCI_SUBCLASS_BRIDGE_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_BRIDGE_MISC);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_SERIAL () {0x;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_SERIAL);
    eval 'sub PCI_INTERFACE_SERIAL_XT () {0x;}' unless defined(&PCI_INTERFACE_SERIAL_XT);
    eval 'sub PCI_INTERFACE_SERIAL_16450 () {0x1;}' unless defined(&PCI_INTERFACE_SERIAL_16450);
    eval 'sub PCI_INTERFACE_SERIAL_16550 () {0x2;}' unless defined(&PCI_INTERFACE_SERIAL_16550);
    eval 'sub PCI_INTERFACE_SERIAL_16650 () {0x3;}' unless defined(&PCI_INTERFACE_SERIAL_16650);
    eval 'sub PCI_INTERFACE_SERIAL_16750 () {0x4;}' unless defined(&PCI_INTERFACE_SERIAL_16750);
    eval 'sub PCI_INTERFACE_SERIAL_16850 () {0x5;}' unless defined(&PCI_INTERFACE_SERIAL_16850);
    eval 'sub PCI_INTERFACE_SERIAL_16950 () {0x6;}' unless defined(&PCI_INTERFACE_SERIAL_16950);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_PARALLEL () {0x1;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_PARALLEL);
    eval 'sub PCI_INTERFACE_PARALLEL () {0x;}' unless defined(&PCI_INTERFACE_PARALLEL);
    eval 'sub PCI_INTERFACE_PARALLEL_BIDIRECTIONAL () {0x1;}' unless defined(&PCI_INTERFACE_PARALLEL_BIDIRECTIONAL);
    eval 'sub PCI_INTERFACE_PARALLEL_ECP1X () {0x2;}' unless defined(&PCI_INTERFACE_PARALLEL_ECP1X);
    eval 'sub PCI_INTERFACE_PARALLEL_IEEE1284_CNTRL () {0x3;}' unless defined(&PCI_INTERFACE_PARALLEL_IEEE1284_CNTRL);
    eval 'sub PCI_INTERFACE_PARALLEL_IEEE1284_TGT () {0xfe;}' unless defined(&PCI_INTERFACE_PARALLEL_IEEE1284_TGT);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_MPSERIAL () {0x2;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_MPSERIAL);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_MODEM () {0x3;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_MODEM);
    eval 'sub PCI_INTERFACE_MODEM () {0x;}' unless defined(&PCI_INTERFACE_MODEM);
    eval 'sub PCI_INTERFACE_MODEM_HAYES16450 () {0x1;}' unless defined(&PCI_INTERFACE_MODEM_HAYES16450);
    eval 'sub PCI_INTERFACE_MODEM_HAYES16550 () {0x2;}' unless defined(&PCI_INTERFACE_MODEM_HAYES16550);
    eval 'sub PCI_INTERFACE_MODEM_HAYES16650 () {0x3;}' unless defined(&PCI_INTERFACE_MODEM_HAYES16650);
    eval 'sub PCI_INTERFACE_MODEM_HAYES16750 () {0x4;}' unless defined(&PCI_INTERFACE_MODEM_HAYES16750);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_GPIB () {0x4;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_GPIB);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_SMARTCARD () {0x5;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_SMARTCARD);
    eval 'sub PCI_SUBCLASS_COMMUNICATIONS_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_COMMUNICATIONS_MISC);
    eval 'sub PCI_SUBCLASS_SYSTEM_PIC () {0x;}' unless defined(&PCI_SUBCLASS_SYSTEM_PIC);
    eval 'sub PCI_INTERFACE_PIC_8259 () {0x;}' unless defined(&PCI_INTERFACE_PIC_8259);
    eval 'sub PCI_INTERFACE_PIC_ISA () {0x1;}' unless defined(&PCI_INTERFACE_PIC_ISA);
    eval 'sub PCI_INTERFACE_PIC_EISA () {0x2;}' unless defined(&PCI_INTERFACE_PIC_EISA);
    eval 'sub PCI_INTERFACE_PIC_IOAPIC () {0x10;}' unless defined(&PCI_INTERFACE_PIC_IOAPIC);
    eval 'sub PCI_INTERFACE_PIC_IOXAPIC () {0x20;}' unless defined(&PCI_INTERFACE_PIC_IOXAPIC);
    eval 'sub PCI_SUBCLASS_SYSTEM_DMA () {0x1;}' unless defined(&PCI_SUBCLASS_SYSTEM_DMA);
    eval 'sub PCI_INTERFACE_DMA_8237 () {0x;}' unless defined(&PCI_INTERFACE_DMA_8237);
    eval 'sub PCI_INTERFACE_DMA_ISA () {0x1;}' unless defined(&PCI_INTERFACE_DMA_ISA);
    eval 'sub PCI_INTERFACE_DMA_EISA () {0x2;}' unless defined(&PCI_INTERFACE_DMA_EISA);
    eval 'sub PCI_SUBCLASS_SYSTEM_TIMER () {0x2;}' unless defined(&PCI_SUBCLASS_SYSTEM_TIMER);
    eval 'sub PCI_INTERFACE_TIMER_8254 () {0x;}' unless defined(&PCI_INTERFACE_TIMER_8254);
    eval 'sub PCI_INTERFACE_TIMER_ISA () {0x1;}' unless defined(&PCI_INTERFACE_TIMER_ISA);
    eval 'sub PCI_INTERFACE_TIMER_EISA () {0x2;}' unless defined(&PCI_INTERFACE_TIMER_EISA);
    eval 'sub PCI_INTERFACE_TIMER_HPET () {0x3;}' unless defined(&PCI_INTERFACE_TIMER_HPET);
    eval 'sub PCI_SUBCLASS_SYSTEM_RTC () {0x3;}' unless defined(&PCI_SUBCLASS_SYSTEM_RTC);
    eval 'sub PCI_INTERFACE_RTC_GENERIC () {0x;}' unless defined(&PCI_INTERFACE_RTC_GENERIC);
    eval 'sub PCI_INTERFACE_RTC_ISA () {0x1;}' unless defined(&PCI_INTERFACE_RTC_ISA);
    eval 'sub PCI_SUBCLASS_SYSTEM_PCIHOTPLUG () {0x4;}' unless defined(&PCI_SUBCLASS_SYSTEM_PCIHOTPLUG);
    eval 'sub PCI_SUBCLASS_SYSTEM_SDHC () {0x5;}' unless defined(&PCI_SUBCLASS_SYSTEM_SDHC);
    eval 'sub PCI_SUBCLASS_SYSTEM_IOMMU () {0x6;}' unless defined(&PCI_SUBCLASS_SYSTEM_IOMMU);
    eval 'sub PCI_SUBCLASS_SYSTEM_RCEC () {0x7;}' unless defined(&PCI_SUBCLASS_SYSTEM_RCEC);
    eval 'sub PCI_SUBCLASS_SYSTEM_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_SYSTEM_MISC);
    eval 'sub PCI_SUBCLASS_INPUT_KEYBOARD () {0x;}' unless defined(&PCI_SUBCLASS_INPUT_KEYBOARD);
    eval 'sub PCI_SUBCLASS_INPUT_DIGITIZER () {0x1;}' unless defined(&PCI_SUBCLASS_INPUT_DIGITIZER);
    eval 'sub PCI_SUBCLASS_INPUT_MOUSE () {0x2;}' unless defined(&PCI_SUBCLASS_INPUT_MOUSE);
    eval 'sub PCI_SUBCLASS_INPUT_SCANNER () {0x3;}' unless defined(&PCI_SUBCLASS_INPUT_SCANNER);
    eval 'sub PCI_SUBCLASS_INPUT_GAMEPORT () {0x4;}' unless defined(&PCI_SUBCLASS_INPUT_GAMEPORT);
    eval 'sub PCI_INTERFACE_GAMEPORT_GENERIC () {0x;}' unless defined(&PCI_INTERFACE_GAMEPORT_GENERIC);
    eval 'sub PCI_INTERFACE_GAMEPORT_LEGACY () {0x10;}' unless defined(&PCI_INTERFACE_GAMEPORT_LEGACY);
    eval 'sub PCI_SUBCLASS_INPUT_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_INPUT_MISC);
    eval 'sub PCI_SUBCLASS_DOCK_GENERIC () {0x;}' unless defined(&PCI_SUBCLASS_DOCK_GENERIC);
    eval 'sub PCI_SUBCLASS_DOCK_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_DOCK_MISC);
    eval 'sub PCI_SUBCLASS_PROCESSOR_386 () {0x;}' unless defined(&PCI_SUBCLASS_PROCESSOR_386);
    eval 'sub PCI_SUBCLASS_PROCESSOR_486 () {0x1;}' unless defined(&PCI_SUBCLASS_PROCESSOR_486);
    eval 'sub PCI_SUBCLASS_PROCESSOR_PENTIUM () {0x2;}' unless defined(&PCI_SUBCLASS_PROCESSOR_PENTIUM);
    eval 'sub PCI_SUBCLASS_PROCESSOR_ALPHA () {0x10;}' unless defined(&PCI_SUBCLASS_PROCESSOR_ALPHA);
    eval 'sub PCI_SUBCLASS_PROCESSOR_POWERPC () {0x20;}' unless defined(&PCI_SUBCLASS_PROCESSOR_POWERPC);
    eval 'sub PCI_SUBCLASS_PROCESSOR_MIPS () {0x30;}' unless defined(&PCI_SUBCLASS_PROCESSOR_MIPS);
    eval 'sub PCI_SUBCLASS_PROCESSOR_COPROC () {0x40;}' unless defined(&PCI_SUBCLASS_PROCESSOR_COPROC);
    eval 'sub PCI_SUBCLASS_PROCESSOR_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_PROCESSOR_MISC);
    eval 'sub PCI_SUBCLASS_SERIALBUS_FIREWIRE () {0x;}' unless defined(&PCI_SUBCLASS_SERIALBUS_FIREWIRE);
    eval 'sub PCI_INTERFACE_IEEE1394_FIREWIRE () {0x;}' unless defined(&PCI_INTERFACE_IEEE1394_FIREWIRE);
    eval 'sub PCI_INTERFACE_IEEE1394_OPENHCI () {0x10;}' unless defined(&PCI_INTERFACE_IEEE1394_OPENHCI);
    eval 'sub PCI_SUBCLASS_SERIALBUS_ACCESS () {0x1;}' unless defined(&PCI_SUBCLASS_SERIALBUS_ACCESS);
    eval 'sub PCI_SUBCLASS_SERIALBUS_SSA () {0x2;}' unless defined(&PCI_SUBCLASS_SERIALBUS_SSA);
    eval 'sub PCI_SUBCLASS_SERIALBUS_USB () {0x3;}' unless defined(&PCI_SUBCLASS_SERIALBUS_USB);
    eval 'sub PCI_INTERFACE_USB_UHCI () {0x;}' unless defined(&PCI_INTERFACE_USB_UHCI);
    eval 'sub PCI_INTERFACE_USB_OHCI () {0x10;}' unless defined(&PCI_INTERFACE_USB_OHCI);
    eval 'sub PCI_INTERFACE_USB_EHCI () {0x20;}' unless defined(&PCI_INTERFACE_USB_EHCI);
    eval 'sub PCI_INTERFACE_USB_XHCI () {0x30;}' unless defined(&PCI_INTERFACE_USB_XHCI);
    eval 'sub PCI_INTERFACE_USB_USB4HCI () {0x40;}' unless defined(&PCI_INTERFACE_USB_USB4HCI);
    eval 'sub PCI_INTERFACE_USB_OTHERHC () {0x80;}' unless defined(&PCI_INTERFACE_USB_OTHERHC);
    eval 'sub PCI_INTERFACE_USB_DEVICE () {0xfe;}' unless defined(&PCI_INTERFACE_USB_DEVICE);
    eval 'sub PCI_SUBCLASS_SERIALBUS_FIBER () {0x4;}' unless defined(&PCI_SUBCLASS_SERIALBUS_FIBER);
    eval 'sub PCI_SUBCLASS_SERIALBUS_SMBUS () {0x5;}' unless defined(&PCI_SUBCLASS_SERIALBUS_SMBUS);
    eval 'sub PCI_SUBCLASS_SERIALBUS_INFINIBAND () {0x6;}' unless defined(&PCI_SUBCLASS_SERIALBUS_INFINIBAND);
    eval 'sub PCI_SUBCLASS_SERIALBUS_IPMI () {0x7;}' unless defined(&PCI_SUBCLASS_SERIALBUS_IPMI);
    eval 'sub PCI_INTERFACE_IPMI_SMIC () {0x;}' unless defined(&PCI_INTERFACE_IPMI_SMIC);
    eval 'sub PCI_INTERFACE_IPMI_KBD () {0x1;}' unless defined(&PCI_INTERFACE_IPMI_KBD);
    eval 'sub PCI_INTERFACE_IPMI_BLOCKXFER () {0x2;}' unless defined(&PCI_INTERFACE_IPMI_BLOCKXFER);
    eval 'sub PCI_SUBCLASS_SERIALBUS_SERCOS () {0x8;}' unless defined(&PCI_SUBCLASS_SERIALBUS_SERCOS);
    eval 'sub PCI_SUBCLASS_SERIALBUS_CANBUS () {0x9;}' unless defined(&PCI_SUBCLASS_SERIALBUS_CANBUS);
    eval 'sub PCI_SUBCLASS_SERIALBUS_MIPI_I3C () {0xa;}' unless defined(&PCI_SUBCLASS_SERIALBUS_MIPI_I3C);
    eval 'sub PCI_SUBCLASS_SERIALBUS_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_SERIALBUS_MISC);
    eval 'sub PCI_SUBCLASS_WIRELESS_IRDA () {0x;}' unless defined(&PCI_SUBCLASS_WIRELESS_IRDA);
    eval 'sub PCI_SUBCLASS_WIRELESS_CONSUMERIR () {0x1;}' unless defined(&PCI_SUBCLASS_WIRELESS_CONSUMERIR);
    eval 'sub PCI_INTERFACE_CONSUMERIR () {0x;}' unless defined(&PCI_INTERFACE_CONSUMERIR);
    eval 'sub PCI_INTERFACE_UWB () {0x10;}' unless defined(&PCI_INTERFACE_UWB);
    eval 'sub PCI_SUBCLASS_WIRELESS_RF () {0x10;}' unless defined(&PCI_SUBCLASS_WIRELESS_RF);
    eval 'sub PCI_SUBCLASS_WIRELESS_BLUETOOTH () {0x11;}' unless defined(&PCI_SUBCLASS_WIRELESS_BLUETOOTH);
    eval 'sub PCI_SUBCLASS_WIRELESS_BROADBAND () {0x12;}' unless defined(&PCI_SUBCLASS_WIRELESS_BROADBAND);
    eval 'sub PCI_SUBCLASS_WIRELESS_802_11A () {0x20;}' unless defined(&PCI_SUBCLASS_WIRELESS_802_11A);
    eval 'sub PCI_SUBCLASS_WIRELESS_802_11B () {0x21;}' unless defined(&PCI_SUBCLASS_WIRELESS_802_11B);
    eval 'sub PCI_SUBCLASS_WIRELESS_CELL () {0x40;}' unless defined(&PCI_SUBCLASS_WIRELESS_CELL);
    eval 'sub PCI_SUBCLASS_WIRELESS_CELL_E () {0x41;}' unless defined(&PCI_SUBCLASS_WIRELESS_CELL_E);
    eval 'sub PCI_SUBCLASS_WIRELESS_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_WIRELESS_MISC);
    eval 'sub PCI_SUBCLASS_I2O_STANDARD () {0x;}' unless defined(&PCI_SUBCLASS_I2O_STANDARD);
    eval 'sub PCI_INTERFACE_I2O_FIFOAT40 () {0x;}' unless defined(&PCI_INTERFACE_I2O_FIFOAT40);
    eval 'sub PCI_SUBCLASS_I2O_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_I2O_MISC);
    eval 'sub PCI_SUBCLASS_SATCOM_TV () {0x1;}' unless defined(&PCI_SUBCLASS_SATCOM_TV);
    eval 'sub PCI_SUBCLASS_SATCOM_AUDIO () {0x2;}' unless defined(&PCI_SUBCLASS_SATCOM_AUDIO);
    eval 'sub PCI_SUBCLASS_SATCOM_VOICE () {0x3;}' unless defined(&PCI_SUBCLASS_SATCOM_VOICE);
    eval 'sub PCI_SUBCLASS_SATCOM_DATA () {0x4;}' unless defined(&PCI_SUBCLASS_SATCOM_DATA);
    eval 'sub PCI_SUBCLASS_SATCOM_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_SATCOM_MISC);
    eval 'sub PCI_SUBCLASS_CRYPTO_NETCOMP () {0x;}' unless defined(&PCI_SUBCLASS_CRYPTO_NETCOMP);
    eval 'sub PCI_SUBCLASS_CRYPTO_ENTERTAINMENT () {0x10;}' unless defined(&PCI_SUBCLASS_CRYPTO_ENTERTAINMENT);
    eval 'sub PCI_SUBCLASS_CRYPTO_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_CRYPTO_MISC);
    eval 'sub PCI_SUBCLASS_DASP_DPIO () {0x;}' unless defined(&PCI_SUBCLASS_DASP_DPIO);
    eval 'sub PCI_SUBCLASS_DASP_TIMEFREQ () {0x1;}' unless defined(&PCI_SUBCLASS_DASP_TIMEFREQ);
    eval 'sub PCI_SUBCLASS_DASP_SYNC () {0x10;}' unless defined(&PCI_SUBCLASS_DASP_SYNC);
    eval 'sub PCI_SUBCLASS_DASP_MGMT () {0x20;}' unless defined(&PCI_SUBCLASS_DASP_MGMT);
    eval 'sub PCI_SUBCLASS_DASP_MISC () {0x80;}' unless defined(&PCI_SUBCLASS_DASP_MISC);
    eval 'sub PCI_BHLC_REG () {0xc;}' unless defined(&PCI_BHLC_REG);
    eval 'sub PCI_BIST_SHIFT () {24;}' unless defined(&PCI_BIST_SHIFT);
    eval 'sub PCI_BIST_MASK () {0xff;}' unless defined(&PCI_BIST_MASK);
    eval 'sub PCI_BIST {
        my($bhlcr) = @_;
	    eval q(((($bhlcr) >>  &PCI_BIST_SHIFT) &  &PCI_BIST_MASK));
    }' unless defined(&PCI_BIST);
    eval 'sub PCI_HDRTYPE_SHIFT () {16;}' unless defined(&PCI_HDRTYPE_SHIFT);
    eval 'sub PCI_HDRTYPE_MASK () {0xff;}' unless defined(&PCI_HDRTYPE_MASK);
    eval 'sub PCI_HDRTYPE {
        my($bhlcr) = @_;
	    eval q(((($bhlcr) >>  &PCI_HDRTYPE_SHIFT) &  &PCI_HDRTYPE_MASK));
    }' unless defined(&PCI_HDRTYPE);
    eval 'sub PCI_HDRTYPE_TYPE {
        my($bhlcr) = @_;
	    eval q(( &PCI_HDRTYPE($bhlcr) & 0x7f));
    }' unless defined(&PCI_HDRTYPE_TYPE);
    eval 'sub PCI_HDRTYPE_MULTIFN {
        my($bhlcr) = @_;
	    eval q((( &PCI_HDRTYPE($bhlcr) & 0x80) != 0));
    }' unless defined(&PCI_HDRTYPE_MULTIFN);
    eval 'sub PCI_LATTIMER_SHIFT () {8;}' unless defined(&PCI_LATTIMER_SHIFT);
    eval 'sub PCI_LATTIMER_MASK () {0xff;}' unless defined(&PCI_LATTIMER_MASK);
    eval 'sub PCI_LATTIMER {
        my($bhlcr) = @_;
	    eval q(((($bhlcr) >>  &PCI_LATTIMER_SHIFT) &  &PCI_LATTIMER_MASK));
    }' unless defined(&PCI_LATTIMER);
    eval 'sub PCI_CACHELINE_SHIFT () {0;}' unless defined(&PCI_CACHELINE_SHIFT);
    eval 'sub PCI_CACHELINE_MASK () {0xff;}' unless defined(&PCI_CACHELINE_MASK);
    eval 'sub PCI_CACHELINE {
        my($bhlcr) = @_;
	    eval q(((($bhlcr) >>  &PCI_CACHELINE_SHIFT) &  &PCI_CACHELINE_MASK));
    }' unless defined(&PCI_CACHELINE);
    eval 'sub PCI_BHLC_CODE {
        my($bist,$type,$multi,$latency,$cacheline) = @_;
	    eval q((((($bist) &  &PCI_BIST_MASK) <<  &PCI_BIST_SHIFT) | ((($type) &  &PCI_HDRTYPE_MASK) <<  &PCI_HDRTYPE_SHIFT) | ((($multi)?0x80:0) <<  &PCI_HDRTYPE_SHIFT) | ((($latency) &  &PCI_LATTIMER_MASK) <<  &PCI_LATTIMER_SHIFT) | ((($cacheline) &  &PCI_CACHELINE_MASK) <<  &PCI_CACHELINE_SHIFT)));
    }' unless defined(&PCI_BHLC_CODE);
    eval 'sub PCI_HDRTYPE_DEVICE () {0;}' unless defined(&PCI_HDRTYPE_DEVICE);
    eval 'sub PCI_HDRTYPE_PPB () {1;}' unless defined(&PCI_HDRTYPE_PPB);
    eval 'sub PCI_HDRTYPE_PCB () {2;}' unless defined(&PCI_HDRTYPE_PCB);
    eval 'sub PCI_HDRTYPE_EP () {0;}' unless defined(&PCI_HDRTYPE_EP);
    eval 'sub PCI_HDRTYPE_RC () {1;}' unless defined(&PCI_HDRTYPE_RC);
    eval 'sub PCI_MAPREG_START () {0x10;}' unless defined(&PCI_MAPREG_START);
    eval 'sub PCI_MAPREG_END () {0x28;}' unless defined(&PCI_MAPREG_END);
    eval 'sub PCI_MAPREG_ROM () {0x30;}' unless defined(&PCI_MAPREG_ROM);
    eval 'sub PCI_MAPREG_PPB_END () {0x18;}' unless defined(&PCI_MAPREG_PPB_END);
    eval 'sub PCI_MAPREG_PCB_END () {0x14;}' unless defined(&PCI_MAPREG_PCB_END);
    eval 'sub PCI_BAR0 () {0x10;}' unless defined(&PCI_BAR0);
    eval 'sub PCI_BAR1 () {0x14;}' unless defined(&PCI_BAR1);
    eval 'sub PCI_BAR2 () {0x18;}' unless defined(&PCI_BAR2);
    eval 'sub PCI_BAR3 () {0x1c;}' unless defined(&PCI_BAR3);
    eval 'sub PCI_BAR4 () {0x20;}' unless defined(&PCI_BAR4);
    eval 'sub PCI_BAR5 () {0x24;}' unless defined(&PCI_BAR5);
    eval 'sub PCI_BAR {
        my($__n) = @_;
	    eval q(( &PCI_MAPREG_START + 4* ($__n)));
    }' unless defined(&PCI_BAR);
    eval 'sub PCI_MAPREG_TYPE {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_TYPE_MASK));
    }' unless defined(&PCI_MAPREG_TYPE);
    eval 'sub PCI_MAPREG_TYPE_MASK () {0x1;}' unless defined(&PCI_MAPREG_TYPE_MASK);
    eval 'sub PCI_MAPREG_TYPE_MEM () {0x;}' unless defined(&PCI_MAPREG_TYPE_MEM);
    eval 'sub PCI_MAPREG_TYPE_ROM () {0x;}' unless defined(&PCI_MAPREG_TYPE_ROM);
    eval 'sub PCI_MAPREG_TYPE_IO () {0x1;}' unless defined(&PCI_MAPREG_TYPE_IO);
    eval 'sub PCI_MAPREG_ROM_ENABLE () {0x1;}' unless defined(&PCI_MAPREG_ROM_ENABLE);
    eval 'sub PCI_MAPREG_MEM_TYPE {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_MEM_TYPE_MASK));
    }' unless defined(&PCI_MAPREG_MEM_TYPE);
    eval 'sub PCI_MAPREG_MEM_TYPE_MASK () {0x6;}' unless defined(&PCI_MAPREG_MEM_TYPE_MASK);
    eval 'sub PCI_MAPREG_MEM_TYPE_32BIT () {0x;}' unless defined(&PCI_MAPREG_MEM_TYPE_32BIT);
    eval 'sub PCI_MAPREG_MEM_TYPE_32BIT_1M () {0x2;}' unless defined(&PCI_MAPREG_MEM_TYPE_32BIT_1M);
    eval 'sub PCI_MAPREG_MEM_TYPE_64BIT () {0x4;}' unless defined(&PCI_MAPREG_MEM_TYPE_64BIT);
    eval 'sub PCI_MAPREG_MEM_PREFETCHABLE {
        my($mr) = @_;
	    eval q(((($mr) &  &PCI_MAPREG_MEM_PREFETCHABLE_MASK) != 0));
    }' unless defined(&PCI_MAPREG_MEM_PREFETCHABLE);
    eval 'sub PCI_MAPREG_MEM_PREFETCHABLE_MASK () {0x8;}' unless defined(&PCI_MAPREG_MEM_PREFETCHABLE_MASK);
    eval 'sub PCI_MAPREG_MEM_ADDR {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_MEM_ADDR_MASK));
    }' unless defined(&PCI_MAPREG_MEM_ADDR);
    eval 'sub PCI_MAPREG_MEM_SIZE {
        my($mr) = @_;
	    eval q(( &PCI_MAPREG_MEM_ADDR($mr) & - &PCI_MAPREG_MEM_ADDR($mr)));
    }' unless defined(&PCI_MAPREG_MEM_SIZE);
    eval 'sub PCI_MAPREG_MEM_ADDR_MASK () {0xfffffff0;}' unless defined(&PCI_MAPREG_MEM_ADDR_MASK);
    eval 'sub PCI_MAPREG_MEM64_ADDR {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_MEM64_ADDR_MASK));
    }' unless defined(&PCI_MAPREG_MEM64_ADDR);
    eval 'sub PCI_MAPREG_MEM64_SIZE {
        my($mr) = @_;
	    eval q(( &PCI_MAPREG_MEM64_ADDR($mr) & - &PCI_MAPREG_MEM64_ADDR($mr)));
    }' unless defined(&PCI_MAPREG_MEM64_SIZE);
    eval 'sub PCI_MAPREG_MEM64_ADDR_MASK () {1.84467440737096e+19;}' unless defined(&PCI_MAPREG_MEM64_ADDR_MASK);
    eval 'sub PCI_MAPREG_IO_ADDR {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_IO_ADDR_MASK));
    }' unless defined(&PCI_MAPREG_IO_ADDR);
    eval 'sub PCI_MAPREG_IO_SIZE {
        my($mr) = @_;
	    eval q(( &PCI_MAPREG_IO_ADDR($mr) & - &PCI_MAPREG_IO_ADDR($mr)));
    }' unless defined(&PCI_MAPREG_IO_SIZE);
    eval 'sub PCI_MAPREG_IO_ADDR_MASK () {0xfffffffc;}' unless defined(&PCI_MAPREG_IO_ADDR_MASK);
    eval 'sub PCI_MAPREG_ROM_ADDR {
        my($mr) = @_;
	    eval q((($mr) &  &PCI_MAPREG_ROM_ADDR_MASK));
    }' unless defined(&PCI_MAPREG_ROM_ADDR);
    eval 'sub PCI_MAPREG_ROM_VALID_STAT () { &__BITS(3, 1);}' unless defined(&PCI_MAPREG_ROM_VALID_STAT);
    eval 'sub PCI_MAPREG_ROM_VSTAT_NOTSUPP () {0x;}' unless defined(&PCI_MAPREG_ROM_VSTAT_NOTSUPP);
    eval 'sub PCI_MAPREG_ROM_VSTAT_INPROG () {0x1;}' unless defined(&PCI_MAPREG_ROM_VSTAT_INPROG);
    eval 'sub PCI_MAPREG_ROM_VSTAT_VPASS () {0x2;}' unless defined(&PCI_MAPREG_ROM_VSTAT_VPASS);
    eval 'sub PCI_MAPREG_ROM_VSTAT_VPASSTRUST () {0x3;}' unless defined(&PCI_MAPREG_ROM_VSTAT_VPASSTRUST);
    eval 'sub PCI_MAPREG_ROM_VSTAT_VFAIL () {0x4;}' unless defined(&PCI_MAPREG_ROM_VSTAT_VFAIL);
    eval 'sub PCI_MAPREG_ROM_VSTAT_VFAILUNTRUST () {0x5;}' unless defined(&PCI_MAPREG_ROM_VSTAT_VFAILUNTRUST);
    eval 'sub PCI_MAPREG_ROM_VSTAT_WPASS () {0x6;}' unless defined(&PCI_MAPREG_ROM_VSTAT_WPASS);
    eval 'sub PCI_MAPREG_ROM_VSTAT_WPASSTRUST () {0x7;}' unless defined(&PCI_MAPREG_ROM_VSTAT_WPASSTRUST);
    eval 'sub PCI_MAPREG_ROM_VALID_DETAIL () { &__BITS(7, 4);}' unless defined(&PCI_MAPREG_ROM_VALID_DETAIL);
    eval 'sub PCI_MAPREG_ROM_ADDR_MASK () { &__BITS(31, 11);}' unless defined(&PCI_MAPREG_ROM_ADDR_MASK);
    eval 'sub PCI_MAPREG_SIZE_TO_MASK {
        my($size) = @_;
	    eval q((-($size)));
    }' unless defined(&PCI_MAPREG_SIZE_TO_MASK);
    eval 'sub PCI_MAPREG_NUM {
        my($offset) = @_;
	    eval q(((($offset)- &PCI_MAPREG_START)/4));
    }' unless defined(&PCI_MAPREG_NUM);
    eval 'sub PCI_CARDBUS_CIS_REG () {0x28;}' unless defined(&PCI_CARDBUS_CIS_REG);
    eval 'sub PCI_SUBSYS_ID_REG () {0x2c;}' unless defined(&PCI_SUBSYS_ID_REG);
    eval 'sub PCI_SUBSYS_VENDOR_MASK () { &__BITS(15, 0);}' unless defined(&PCI_SUBSYS_VENDOR_MASK);
    eval 'sub PCI_SUBSYS_ID_MASK () { &__BITS(31, 16);}' unless defined(&PCI_SUBSYS_ID_MASK);
    eval 'sub PCI_SUBSYS_VENDOR {
        my($__subsys_id) = @_;
	    eval q( &__SHIFTOUT($__subsys_id,  &PCI_SUBSYS_VENDOR_MASK));
    }' unless defined(&PCI_SUBSYS_VENDOR);
    eval 'sub PCI_SUBSYS_ID {
        my($__subsys_id) = @_;
	    eval q( &__SHIFTOUT($__subsys_id,  &PCI_SUBSYS_ID_MASK));
    }' unless defined(&PCI_SUBSYS_ID);
    eval 'sub PCI_CAPLISTPTR_REG () {0x34;}' unless defined(&PCI_CAPLISTPTR_REG);
    eval 'sub PCI_CARDBUS_CAPLISTPTR_REG () {0x14;}' unless defined(&PCI_CARDBUS_CAPLISTPTR_REG);
    eval 'sub PCI_CAPLIST_PTR {
        my($cpr) = @_;
	    eval q((($cpr) & 0xff));
    }' unless defined(&PCI_CAPLIST_PTR);
    eval 'sub PCI_CAPLIST_NEXT {
        my($cr) = @_;
	    eval q(((($cr) >> 8) & 0xff));
    }' unless defined(&PCI_CAPLIST_NEXT);
    eval 'sub PCI_CAPLIST_CAP {
        my($cr) = @_;
	    eval q((($cr) & 0xff));
    }' unless defined(&PCI_CAPLIST_CAP);
    eval 'sub PCI_CAP_RESERVED0 () {0x;}' unless defined(&PCI_CAP_RESERVED0);
    eval 'sub PCI_CAP_PWRMGMT () {0x1;}' unless defined(&PCI_CAP_PWRMGMT);
    eval 'sub PCI_CAP_AGP () {0x2;}' unless defined(&PCI_CAP_AGP);
    eval 'sub PCI_CAP_VPD () {0x3;}' unless defined(&PCI_CAP_VPD);
    eval 'sub PCI_CAP_SLOTID () {0x4;}' unless defined(&PCI_CAP_SLOTID);
    eval 'sub PCI_CAP_MSI () {0x5;}' unless defined(&PCI_CAP_MSI);
    eval 'sub PCI_CAP_CPCI_HOTSWAP () {0x6;}' unless defined(&PCI_CAP_CPCI_HOTSWAP);
    eval 'sub PCI_CAP_PCIX () {0x7;}' unless defined(&PCI_CAP_PCIX);
    eval 'sub PCI_CAP_LDT () {0x8;}' unless defined(&PCI_CAP_LDT);
    eval 'sub PCI_CAP_VENDSPEC () {0x9;}' unless defined(&PCI_CAP_VENDSPEC);
    eval 'sub PCI_CAP_DEBUGPORT () {0xa;}' unless defined(&PCI_CAP_DEBUGPORT);
    eval 'sub PCI_CAP_CPCI_RSRCCTL () {0xb;}' unless defined(&PCI_CAP_CPCI_RSRCCTL);
    eval 'sub PCI_CAP_HOTPLUG () {0xc;}' unless defined(&PCI_CAP_HOTPLUG);
    eval 'sub PCI_CAP_SUBVENDOR () {0xd;}' unless defined(&PCI_CAP_SUBVENDOR);
    eval 'sub PCI_CAP_AGP8 () {0xe;}' unless defined(&PCI_CAP_AGP8);
    eval 'sub PCI_CAP_SECURE () {0xf;}' unless defined(&PCI_CAP_SECURE);
    eval 'sub PCI_CAP_PCIEXPRESS () {0x10;}' unless defined(&PCI_CAP_PCIEXPRESS);
    eval 'sub PCI_CAP_MSIX () {0x11;}' unless defined(&PCI_CAP_MSIX);
    eval 'sub PCI_CAP_SATA () {0x12;}' unless defined(&PCI_CAP_SATA);
    eval 'sub PCI_CAP_PCIAF () {0x13;}' unless defined(&PCI_CAP_PCIAF);
    eval 'sub PCI_CAP_EA () {0x14;}' unless defined(&PCI_CAP_EA);
    eval 'sub PCI_CAP_FPB () {0x15;}' unless defined(&PCI_CAP_FPB);
    eval 'sub PCI_PMCR () {0x2;}' unless defined(&PCI_PMCR);
    eval 'sub PCI_PMCR_SHIFT () {16;}' unless defined(&PCI_PMCR_SHIFT);
    eval 'sub PCI_PMCR_VERSION_MASK () {0x7;}' unless defined(&PCI_PMCR_VERSION_MASK);
    eval 'sub PCI_PMCR_VERSION_10 () {0x1;}' unless defined(&PCI_PMCR_VERSION_10);
    eval 'sub PCI_PMCR_VERSION_11 () {0x2;}' unless defined(&PCI_PMCR_VERSION_11);
    eval 'sub PCI_PMCR_VERSION_12 () {0x3;}' unless defined(&PCI_PMCR_VERSION_12);
    eval 'sub PCI_PMCR_PME_CLOCK () {0x8;}' unless defined(&PCI_PMCR_PME_CLOCK);
    eval 'sub PCI_PMCR_DSI () {0x20;}' unless defined(&PCI_PMCR_DSI);
    eval 'sub PCI_PMCR_AUXCUR_MASK () {0x1c0;}' unless defined(&PCI_PMCR_AUXCUR_MASK);
    eval 'sub PCI_PMCR_AUXCUR_0 () {0x;}' unless defined(&PCI_PMCR_AUXCUR_0);
    eval 'sub PCI_PMCR_AUXCUR_55 () {0x40;}' unless defined(&PCI_PMCR_AUXCUR_55);
    eval 'sub PCI_PMCR_AUXCUR_100 () {0x80;}' unless defined(&PCI_PMCR_AUXCUR_100);
    eval 'sub PCI_PMCR_AUXCUR_160 () {0xc0;}' unless defined(&PCI_PMCR_AUXCUR_160);
    eval 'sub PCI_PMCR_AUXCUR_220 () {0x100;}' unless defined(&PCI_PMCR_AUXCUR_220);
    eval 'sub PCI_PMCR_AUXCUR_270 () {0x140;}' unless defined(&PCI_PMCR_AUXCUR_270);
    eval 'sub PCI_PMCR_AUXCUR_320 () {0x180;}' unless defined(&PCI_PMCR_AUXCUR_320);
    eval 'sub PCI_PMCR_AUXCUR_375 () {0x1c0;}' unless defined(&PCI_PMCR_AUXCUR_375);
    eval 'sub PCI_PMCR_D1SUPP () {0x200;}' unless defined(&PCI_PMCR_D1SUPP);
    eval 'sub PCI_PMCR_D2SUPP () {0x400;}' unless defined(&PCI_PMCR_D2SUPP);
    eval 'sub PCI_PMCR_PME_D0 () {0x800;}' unless defined(&PCI_PMCR_PME_D0);
    eval 'sub PCI_PMCR_PME_D1 () {0x1000;}' unless defined(&PCI_PMCR_PME_D1);
    eval 'sub PCI_PMCR_PME_D2 () {0x2000;}' unless defined(&PCI_PMCR_PME_D2);
    eval 'sub PCI_PMCR_PME_D3HOT () {0x4000;}' unless defined(&PCI_PMCR_PME_D3HOT);
    eval 'sub PCI_PMCR_PME_D3COLD () {0x8000;}' unless defined(&PCI_PMCR_PME_D3COLD);
    eval 'sub PCI_PMCSR () {0x4;}' unless defined(&PCI_PMCSR);
    eval 'sub PCI_PMCSR_STATE_MASK () {0x3;}' unless defined(&PCI_PMCSR_STATE_MASK);
    eval 'sub PCI_PMCSR_STATE_D0 () {0x;}' unless defined(&PCI_PMCSR_STATE_D0);
    eval 'sub PCI_PMCSR_STATE_D1 () {0x1;}' unless defined(&PCI_PMCSR_STATE_D1);
    eval 'sub PCI_PMCSR_STATE_D2 () {0x2;}' unless defined(&PCI_PMCSR_STATE_D2);
    eval 'sub PCI_PMCSR_STATE_D3 () {0x3;}' unless defined(&PCI_PMCSR_STATE_D3);
    eval 'sub PCI_PMCSR_NO_SOFTRST () {0x8;}' unless defined(&PCI_PMCSR_NO_SOFTRST);
    eval 'sub PCI_PMCSR_PME_EN () {0x100;}' unless defined(&PCI_PMCSR_PME_EN);
    eval 'sub PCI_PMCSR_DATASEL_MASK () {0x1e00;}' unless defined(&PCI_PMCSR_DATASEL_MASK);
    eval 'sub PCI_PMCSR_DATASCL_MASK () {0x6000;}' unless defined(&PCI_PMCSR_DATASCL_MASK);
    eval 'sub PCI_PMCSR_PME_STS () {0x8000;}' unless defined(&PCI_PMCSR_PME_STS);
    eval 'sub PCI_PMCSR_B2B3_SUPPORT () {0x400000;}' unless defined(&PCI_PMCSR_B2B3_SUPPORT);
    eval 'sub PCI_PMCSR_BPCC_EN () {0x800000;}' unless defined(&PCI_PMCSR_BPCC_EN);
    eval 'sub PCI_PMCSR_DATA () {0xff000000;}' unless defined(&PCI_PMCSR_DATA);
    eval 'sub PCI_CAP_AGP_MAJOR {
        my($cr) = @_;
	    eval q(((($cr) >> 20) & 0xf));
    }' unless defined(&PCI_CAP_AGP_MAJOR);
    eval 'sub PCI_CAP_AGP_MINOR {
        my($cr) = @_;
	    eval q(((($cr) >> 16) & 0xf));
    }' unless defined(&PCI_CAP_AGP_MINOR);
    eval 'sub PCI_AGP_STATUS () {0x4;}' unless defined(&PCI_AGP_STATUS);
    eval 'sub PCI_AGP_COMMAND () {0x8;}' unless defined(&PCI_AGP_COMMAND);
    eval 'sub AGP_MODE_RQ () { &__BITS(31, 24);}' unless defined(&AGP_MODE_RQ);
    eval 'sub AGP_MODE_ARQSZ () { &__BITS(15, 13);}' unless defined(&AGP_MODE_ARQSZ);
    eval 'sub AGP_MODE_CAL () { &__BITS(12, 10);}' unless defined(&AGP_MODE_CAL);
    eval 'sub AGP_MODE_SBA () { &__BIT(9);}' unless defined(&AGP_MODE_SBA);
    eval 'sub AGP_MODE_AGP () { &__BIT(8);}' unless defined(&AGP_MODE_AGP);
    eval 'sub AGP_MODE_HTRANS () { &__BIT(6);}' unless defined(&AGP_MODE_HTRANS);
    eval 'sub AGP_MODE_4G () { &__BIT(5);}' unless defined(&AGP_MODE_4G);
    eval 'sub AGP_MODE_FW () { &__BIT(4);}' unless defined(&AGP_MODE_FW);
    eval 'sub AGP_MODE_MODE_3 () { &__BIT(3);}' unless defined(&AGP_MODE_MODE_3);
    eval 'sub AGP_MODE_RATE () { &__BITS(2, 0);}' unless defined(&AGP_MODE_RATE);
    eval 'sub AGP_MODE_V2_RATE_1x () {0x1;}' unless defined(&AGP_MODE_V2_RATE_1x);
    eval 'sub AGP_MODE_V2_RATE_2x () {0x2;}' unless defined(&AGP_MODE_V2_RATE_2x);
    eval 'sub AGP_MODE_V2_RATE_4x () {0x4;}' unless defined(&AGP_MODE_V2_RATE_4x);
    eval 'sub AGP_MODE_V3_RATE_4x () {0x1;}' unless defined(&AGP_MODE_V3_RATE_4x);
    eval 'sub AGP_MODE_V3_RATE_8x () {0x2;}' unless defined(&AGP_MODE_V3_RATE_8x);
    eval 'sub AGP_MODE_V3_RATE_RSVD () {0x4;}' unless defined(&AGP_MODE_V3_RATE_RSVD);
    eval 'sub PCI_VPD_ADDRESS_MASK () {0x7fff;}' unless defined(&PCI_VPD_ADDRESS_MASK);
    eval 'sub PCI_VPD_ADDRESS_SHIFT () {16;}' unless defined(&PCI_VPD_ADDRESS_SHIFT);
    eval 'sub PCI_VPD_ADDRESS {
        my($ofs) = @_;
	    eval q(((($ofs) &  &PCI_VPD_ADDRESS_MASK) <<  &PCI_VPD_ADDRESS_SHIFT));
    }' unless defined(&PCI_VPD_ADDRESS);
    eval 'sub PCI_VPD_DATAREG {
        my($ofs) = @_;
	    eval q((($ofs) + 4));
    }' unless defined(&PCI_VPD_DATAREG);
    eval 'sub PCI_VPD_OPFLAG () {0x80000000;}' unless defined(&PCI_VPD_OPFLAG);
    eval 'sub PCI_MSI_CTL () {0x;}' unless defined(&PCI_MSI_CTL);
    eval 'sub PCI_MSI_MADDR () {0x4;}' unless defined(&PCI_MSI_MADDR);
    eval 'sub PCI_MSI_MADDR64_LO () {0x4;}' unless defined(&PCI_MSI_MADDR64_LO);
    eval 'sub PCI_MSI_MADDR64_HI () {0x8;}' unless defined(&PCI_MSI_MADDR64_HI);
    eval 'sub PCI_MSI_MDATA () {0x8;}' unless defined(&PCI_MSI_MDATA);
    eval 'sub PCI_MSI_MDATA64 () {0xc;}' unless defined(&PCI_MSI_MDATA64);
    eval 'sub PCI_MSI_MASK () {0xc;}' unless defined(&PCI_MSI_MASK);
    eval 'sub PCI_MSI_MASK64 () {0x10;}' unless defined(&PCI_MSI_MASK64);
    eval 'sub PCI_MSI_PENDING () {0x10;}' unless defined(&PCI_MSI_PENDING);
    eval 'sub PCI_MSI_PENDING64 () {0x14;}' unless defined(&PCI_MSI_PENDING64);
    eval 'sub PCI_MSI_CTL_MASK () { &__BITS(31, 16);}' unless defined(&PCI_MSI_CTL_MASK);
    eval 'sub PCI_MSI_CTL_EXTMDATA_EN () { &__SHIFTIN( &__BIT(10),  &PCI_MSI_CTL_MASK);}' unless defined(&PCI_MSI_CTL_EXTMDATA_EN);
    eval 'sub PCI_MSI_CTL_EXTMDATA_CAP () { &__SHIFTIN( &__BIT(9),  &PCI_MSI_CTL_MASK);}' unless defined(&PCI_MSI_CTL_EXTMDATA_CAP);
    eval 'sub PCI_MSI_CTL_PERVEC_MASK () { &__SHIFTIN( &__BIT(8),  &PCI_MSI_CTL_MASK);}' unless defined(&PCI_MSI_CTL_PERVEC_MASK);
    eval 'sub PCI_MSI_CTL_64BIT_ADDR () { &__SHIFTIN( &__BIT(7),  &PCI_MSI_CTL_MASK);}' unless defined(&PCI_MSI_CTL_64BIT_ADDR);
    eval 'sub PCI_MSI_CTL_MME_MASK () { &__SHIFTIN( &__BITS(6, 4),  &PCI_MSI_CTL_MASK);}' unless defined(&PCI_MSI_CTL_MME_MASK);
    eval 'sub PCI_MSI_CTL_MME {
        my($reg) = @_;
	    eval q( &__SHIFTOUT($reg,  &PCI_MSI_CTL_MME_MASK));
    }' unless defined(&PCI_MSI_CTL_MME);
    eval 'sub PCI_MSI_CTL_MMC_MASK () { &__SHIFTIN( &__BITS(3, 1),  &PCI_MSI_CTL_MASK);}' unless defined(&PCI_MSI_CTL_MMC_MASK);
    eval 'sub PCI_MSI_CTL_MMC {
        my($reg) = @_;
	    eval q( &__SHIFTOUT($reg,  &PCI_MSI_CTL_MMC_MASK));
    }' unless defined(&PCI_MSI_CTL_MMC);
    eval 'sub PCI_MSI_CTL_MSI_ENABLE () { &__SHIFTIN( &__BIT(0),  &PCI_MSI_CTL_MASK);}' unless defined(&PCI_MSI_CTL_MSI_ENABLE);
    eval 'sub PCI_MSI_MAX_VECTORS () {32;}' unless defined(&PCI_MSI_MAX_VECTORS);
    eval 'sub PCIX_CMD () {0x;}' unless defined(&PCIX_CMD);
    eval 'sub PCIX_CMD_PERR_RECOVER () {0x10000;}' unless defined(&PCIX_CMD_PERR_RECOVER);
    eval 'sub PCIX_CMD_RELAXED_ORDER () {0x20000;}' unless defined(&PCIX_CMD_RELAXED_ORDER);
    eval 'sub PCIX_CMD_BYTECNT_MASK () {0xc0000;}' unless defined(&PCIX_CMD_BYTECNT_MASK);
    eval 'sub PCIX_CMD_BYTECNT_SHIFT () {18;}' unless defined(&PCIX_CMD_BYTECNT_SHIFT);
    eval 'sub PCIX_CMD_BYTECNT {
        my($reg) = @_;
	    eval q((512<< ((($reg) &  &PCIX_CMD_BYTECNT_MASK) >>  &PCIX_CMD_BYTECNT_SHIFT)));
    }' unless defined(&PCIX_CMD_BYTECNT);
    eval 'sub PCIX_CMD_BCNT_512 () {0x;}' unless defined(&PCIX_CMD_BCNT_512);
    eval 'sub PCIX_CMD_BCNT_1024 () {0x40000;}' unless defined(&PCIX_CMD_BCNT_1024);
    eval 'sub PCIX_CMD_BCNT_2048 () {0x80000;}' unless defined(&PCIX_CMD_BCNT_2048);
    eval 'sub PCIX_CMD_BCNT_4096 () {0xc0000;}' unless defined(&PCIX_CMD_BCNT_4096);
    eval 'sub PCIX_CMD_SPLTRANS_MASK () {0x700000;}' unless defined(&PCIX_CMD_SPLTRANS_MASK);
    eval 'sub PCIX_CMD_SPLTRANS_SHIFT () {20;}' unless defined(&PCIX_CMD_SPLTRANS_SHIFT);
    eval 'sub PCIX_CMD_SPLTRANS_1 () {0x;}' unless defined(&PCIX_CMD_SPLTRANS_1);
    eval 'sub PCIX_CMD_SPLTRANS_2 () {0x100000;}' unless defined(&PCIX_CMD_SPLTRANS_2);
    eval 'sub PCIX_CMD_SPLTRANS_3 () {0x200000;}' unless defined(&PCIX_CMD_SPLTRANS_3);
    eval 'sub PCIX_CMD_SPLTRANS_4 () {0x300000;}' unless defined(&PCIX_CMD_SPLTRANS_4);
    eval 'sub PCIX_CMD_SPLTRANS_8 () {0x400000;}' unless defined(&PCIX_CMD_SPLTRANS_8);
    eval 'sub PCIX_CMD_SPLTRANS_12 () {0x500000;}' unless defined(&PCIX_CMD_SPLTRANS_12);
    eval 'sub PCIX_CMD_SPLTRANS_16 () {0x600000;}' unless defined(&PCIX_CMD_SPLTRANS_16);
    eval 'sub PCIX_CMD_SPLTRANS_32 () {0x700000;}' unless defined(&PCIX_CMD_SPLTRANS_32);
    eval 'sub PCIX_STATUS () {0x4;}' unless defined(&PCIX_STATUS);
    eval 'sub PCIX_STATUS_FN_MASK () {0x7;}' unless defined(&PCIX_STATUS_FN_MASK);
    eval 'sub PCIX_STATUS_DEV_MASK () {0xf8;}' unless defined(&PCIX_STATUS_DEV_MASK);
    eval 'sub PCIX_STATUS_DEV_SHIFT () {3;}' unless defined(&PCIX_STATUS_DEV_SHIFT);
    eval 'sub PCIX_STATUS_BUS_MASK () {0xff00;}' unless defined(&PCIX_STATUS_BUS_MASK);
    eval 'sub PCIX_STATUS_BUS_SHIFT () {8;}' unless defined(&PCIX_STATUS_BUS_SHIFT);
    eval 'sub PCIX_STATUS_FN {
        my($val) = @_;
	    eval q((($val) &  &PCIX_STATUS_FN_MASK));
    }' unless defined(&PCIX_STATUS_FN);
    eval 'sub PCIX_STATUS_DEV {
        my($val) = @_;
	    eval q(((($val) &  &PCIX_STATUS_DEV_MASK) >>  &PCIX_STATUS_DEV_SHIFT));
    }' unless defined(&PCIX_STATUS_DEV);
    eval 'sub PCIX_STATUS_BUS {
        my($val) = @_;
	    eval q(((($val) &  &PCIX_STATUS_BUS_MASK) >>  &PCIX_STATUS_BUS_SHIFT));
    }' unless defined(&PCIX_STATUS_BUS);
    eval 'sub PCIX_STATUS_64BIT () {0x10000;}' unless defined(&PCIX_STATUS_64BIT);
    eval 'sub PCIX_STATUS_133 () {0x20000;}' unless defined(&PCIX_STATUS_133);
    eval 'sub PCIX_STATUS_SPLDISC () {0x40000;}' unless defined(&PCIX_STATUS_SPLDISC);
    eval 'sub PCIX_STATUS_SPLUNEX () {0x80000;}' unless defined(&PCIX_STATUS_SPLUNEX);
    eval 'sub PCIX_STATUS_DEVCPLX () {0x100000;}' unless defined(&PCIX_STATUS_DEVCPLX);
    eval 'sub PCIX_STATUS_MAXB_MASK () {0x600000;}' unless defined(&PCIX_STATUS_MAXB_MASK);
    eval 'sub PCIX_STATUS_MAXB_SHIFT () {21;}' unless defined(&PCIX_STATUS_MAXB_SHIFT);
    eval 'sub PCIX_STATUS_MAXB_512 () {0x;}' unless defined(&PCIX_STATUS_MAXB_512);
    eval 'sub PCIX_STATUS_MAXB_1024 () {0x200000;}' unless defined(&PCIX_STATUS_MAXB_1024);
    eval 'sub PCIX_STATUS_MAXB_2048 () {0x400000;}' unless defined(&PCIX_STATUS_MAXB_2048);
    eval 'sub PCIX_STATUS_MAXB_4096 () {0x600000;}' unless defined(&PCIX_STATUS_MAXB_4096);
    eval 'sub PCIX_STATUS_MAXST_MASK () {0x3800000;}' unless defined(&PCIX_STATUS_MAXST_MASK);
    eval 'sub PCIX_STATUS_MAXST_SHIFT () {23;}' unless defined(&PCIX_STATUS_MAXST_SHIFT);
    eval 'sub PCIX_STATUS_MAXST_1 () {0x;}' unless defined(&PCIX_STATUS_MAXST_1);
    eval 'sub PCIX_STATUS_MAXST_2 () {0x800000;}' unless defined(&PCIX_STATUS_MAXST_2);
    eval 'sub PCIX_STATUS_MAXST_3 () {0x1000000;}' unless defined(&PCIX_STATUS_MAXST_3);
    eval 'sub PCIX_STATUS_MAXST_4 () {0x1800000;}' unless defined(&PCIX_STATUS_MAXST_4);
    eval 'sub PCIX_STATUS_MAXST_8 () {0x2000000;}' unless defined(&PCIX_STATUS_MAXST_8);
    eval 'sub PCIX_STATUS_MAXST_12 () {0x2800000;}' unless defined(&PCIX_STATUS_MAXST_12);
    eval 'sub PCIX_STATUS_MAXST_16 () {0x3000000;}' unless defined(&PCIX_STATUS_MAXST_16);
    eval 'sub PCIX_STATUS_MAXST_32 () {0x3800000;}' unless defined(&PCIX_STATUS_MAXST_32);
    eval 'sub PCIX_STATUS_MAXRS_MASK () {0x1c000000;}' unless defined(&PCIX_STATUS_MAXRS_MASK);
    eval 'sub PCIX_STATUS_MAXRS_SHIFT () {26;}' unless defined(&PCIX_STATUS_MAXRS_SHIFT);
    eval 'sub PCIX_STATUS_MAXRS_1K () {0x;}' unless defined(&PCIX_STATUS_MAXRS_1K);
    eval 'sub PCIX_STATUS_MAXRS_2K () {0x4000000;}' unless defined(&PCIX_STATUS_MAXRS_2K);
    eval 'sub PCIX_STATUS_MAXRS_4K () {0x8000000;}' unless defined(&PCIX_STATUS_MAXRS_4K);
    eval 'sub PCIX_STATUS_MAXRS_8K () {0xc000000;}' unless defined(&PCIX_STATUS_MAXRS_8K);
    eval 'sub PCIX_STATUS_MAXRS_16K () {0x10000000;}' unless defined(&PCIX_STATUS_MAXRS_16K);
    eval 'sub PCIX_STATUS_MAXRS_32K () {0x14000000;}' unless defined(&PCIX_STATUS_MAXRS_32K);
    eval 'sub PCIX_STATUS_MAXRS_64K () {0x18000000;}' unless defined(&PCIX_STATUS_MAXRS_64K);
    eval 'sub PCIX_STATUS_MAXRS_128K () {0x1c000000;}' unless defined(&PCIX_STATUS_MAXRS_128K);
    eval 'sub PCIX_STATUS_SCERR () {0x20000000;}' unless defined(&PCIX_STATUS_SCERR);
    eval 'sub PCIX_STATUS_266 () {0x40000000;}' unless defined(&PCIX_STATUS_266);
    eval 'sub PCIX_STATUS_533 () {0x80000000;}' unless defined(&PCIX_STATUS_533);
    eval 'sub PCIX_BRIDGE_2ND_STATUS () {0x;}' unless defined(&PCIX_BRIDGE_2ND_STATUS);
    eval 'sub PCIX_BRIDGE_ST_64BIT () {0x10000;}' unless defined(&PCIX_BRIDGE_ST_64BIT);
    eval 'sub PCIX_BRIDGE_ST_133 () {0x20000;}' unless defined(&PCIX_BRIDGE_ST_133);
    eval 'sub PCIX_BRIDGE_ST_SPLDISC () {0x40000;}' unless defined(&PCIX_BRIDGE_ST_SPLDISC);
    eval 'sub PCIX_BRIDGE_ST_SPLUNEX () {0x80000;}' unless defined(&PCIX_BRIDGE_ST_SPLUNEX);
    eval 'sub PCIX_BRIDGE_ST_SPLOVRN () {0x100000;}' unless defined(&PCIX_BRIDGE_ST_SPLOVRN);
    eval 'sub PCIX_BRIDGE_ST_SPLRQDL () {0x200000;}' unless defined(&PCIX_BRIDGE_ST_SPLRQDL);
    eval 'sub PCIX_BRIDGE_2NDST_CLKF () {0x3c00000;}' unless defined(&PCIX_BRIDGE_2NDST_CLKF);
    eval 'sub PCIX_BRIDGE_2NDST_CLKF_SHIFT () {22;}' unless defined(&PCIX_BRIDGE_2NDST_CLKF_SHIFT);
    eval 'sub PCIX_BRIDGE_2NDST_VER_MASK () {0x30000000;}' unless defined(&PCIX_BRIDGE_2NDST_VER_MASK);
    eval 'sub PCIX_BRIDGE_2NDST_VER_SHIFT () {28;}' unless defined(&PCIX_BRIDGE_2NDST_VER_SHIFT);
    eval 'sub PCIX_BRIDGE_ST_266 () {0x40000000;}' unless defined(&PCIX_BRIDGE_ST_266);
    eval 'sub PCIX_BRIDGE_ST_533 () {0x80000000;}' unless defined(&PCIX_BRIDGE_ST_533);
    eval 'sub PCIX_BRIDGE_PRI_STATUS () {0x4;}' unless defined(&PCIX_BRIDGE_PRI_STATUS);
    eval 'sub PCIX_BRIDGE_UP_STCR () {0x8;}' unless defined(&PCIX_BRIDGE_UP_STCR);
    eval 'sub PCIX_BRIDGE_DOWN_STCR () {0xc;}' unless defined(&PCIX_BRIDGE_DOWN_STCR);
    eval 'sub PCIX_BRIDGE_STCAP () {0xffff;}' unless defined(&PCIX_BRIDGE_STCAP);
    eval 'sub PCIX_BRIDGE_STCLIM () {0xffff0000;}' unless defined(&PCIX_BRIDGE_STCLIM);
    eval 'sub PCIX_BRIDGE_STCLIM_SHIFT () {16;}' unless defined(&PCIX_BRIDGE_STCLIM_SHIFT);
    eval 'sub PCI_HT_CMD () {0x;}' unless defined(&PCI_HT_CMD);
    eval 'sub PCI_HT_CMD_MASK () { &__BITS(31, 16);}' unless defined(&PCI_HT_CMD_MASK);
    eval 'sub PCI_HT_CAP {
        my($cr) = @_;
	    eval q((((($cr) >> 27) < 0x8) ? ((($cr) >> 27) & 0x1c) : ((($cr) >> 27) & 0x1f)));
    }' unless defined(&PCI_HT_CAP);
    eval 'sub PCI_HT_CAPMASK () { &__BITS(31, 27);}' unless defined(&PCI_HT_CAPMASK);
    eval 'sub PCI_HT_CAP_SLAVE () {0 &b00000;}' unless defined(&PCI_HT_CAP_SLAVE);
    eval 'sub PCI_HT_CAP_HOST () {0 &b00100;}' unless defined(&PCI_HT_CAP_HOST);
    eval 'sub PCI_HT_CAP_SWITCH () {0 &b01000;}' unless defined(&PCI_HT_CAP_SWITCH);
    eval 'sub PCI_HT_CAP_INTERRUPT () {0 &b10000;}' unless defined(&PCI_HT_CAP_INTERRUPT);
    eval 'sub PCI_HT_CAP_REVID () {0 &b10001;}' unless defined(&PCI_HT_CAP_REVID);
    eval 'sub PCI_HT_CAP_UNITID_CLUMP () {0 &b10010;}' unless defined(&PCI_HT_CAP_UNITID_CLUMP);
    eval 'sub PCI_HT_CAP_EXTCNFSPACE () {0 &b10011;}' unless defined(&PCI_HT_CAP_EXTCNFSPACE);
    eval 'sub PCI_HT_CAP_ADDRMAP () {0 &b10100;}' unless defined(&PCI_HT_CAP_ADDRMAP);
    eval 'sub PCI_HT_CAP_MSIMAP () {0 &b10101;}' unless defined(&PCI_HT_CAP_MSIMAP);
    eval 'sub PCI_HT_CAP_DIRECTROUTE () {0 &b10110;}' unless defined(&PCI_HT_CAP_DIRECTROUTE);
    eval 'sub PCI_HT_CAP_VCSET () {0 &b10111;}' unless defined(&PCI_HT_CAP_VCSET);
    eval 'sub PCI_HT_CAP_RETRYMODE () {0 &b11000;}' unless defined(&PCI_HT_CAP_RETRYMODE);
    eval 'sub PCI_HT_CAP_X86ENCODE () {0 &b11001;}' unless defined(&PCI_HT_CAP_X86ENCODE);
    eval 'sub PCI_HT_CAP_GEN3 () {0 &b11010;}' unless defined(&PCI_HT_CAP_GEN3);
    eval 'sub PCI_HT_CAP_FLE () {0 &b11011;}' unless defined(&PCI_HT_CAP_FLE);
    eval 'sub PCI_HT_CAP_PM () {0 &b11100;}' unless defined(&PCI_HT_CAP_PM);
    eval 'sub PCI_HT_CAP_HIGHNODECNT () {0 &b11101;}' unless defined(&PCI_HT_CAP_HIGHNODECNT);
    eval 'sub PCI_HT_MSI_ENABLED () { &__BIT(16);}' unless defined(&PCI_HT_MSI_ENABLED);
    eval 'sub PCI_HT_MSI_FIXED () { &__BIT(17);}' unless defined(&PCI_HT_MSI_FIXED);
    eval 'sub PCI_HT_MSI_ADDR_LO () {0x4;}' unless defined(&PCI_HT_MSI_ADDR_LO);
    eval 'sub PCI_HT_MSI_ADDR_LO_MASK () { &__BITS(31, 20);}' unless defined(&PCI_HT_MSI_ADDR_LO_MASK);
    eval 'sub PCI_HT_MSI_FIXED_ADDR () {0xfee00000;}' unless defined(&PCI_HT_MSI_FIXED_ADDR);
    eval 'sub PCI_HT_MSI_ADDR_HI () {0x8;}' unless defined(&PCI_HT_MSI_ADDR_HI);
    eval 'sub PCI_VENDORSPECIFIC () {0x2;}' unless defined(&PCI_VENDORSPECIFIC);
    eval 'sub PCI_VENDORSPECIFIC_SHIFT () {16;}' unless defined(&PCI_VENDORSPECIFIC_SHIFT);
    eval 'sub PCI_DEBUG_BASER () {0x;}' unless defined(&PCI_DEBUG_BASER);
    eval 'sub PCI_DEBUG_BASER_SHIFT () {16;}' unless defined(&PCI_DEBUG_BASER_SHIFT);
    eval 'sub PCI_DEBUG_PORTOFF_SHIFT () {16;}' unless defined(&PCI_DEBUG_PORTOFF_SHIFT);
    eval 'sub PCI_DEBUG_PORTOFF_MASK () {0x1fff0000;}' unless defined(&PCI_DEBUG_PORTOFF_MASK);
    eval 'sub PCI_DEBUG_BARNUM_SHIFT () {29;}' unless defined(&PCI_DEBUG_BARNUM_SHIFT);
    eval 'sub PCI_DEBUG_BARNUM_MASK () {0xe0000000;}' unless defined(&PCI_DEBUG_BARNUM_MASK);
    eval 'sub PCI_CAP_SUBSYS_ID () {0x4;}' unless defined(&PCI_CAP_SUBSYS_ID);
    eval 'sub PCI_SECURE_CAP () {0x;}' unless defined(&PCI_SECURE_CAP);
    eval 'sub PCI_SECURE_CAP_TYPE () { &__BITS(18, 16);}' unless defined(&PCI_SECURE_CAP_TYPE);
    eval 'sub PCI_SECURE_CAP_TYPE_IOMMU () {0x3;}' unless defined(&PCI_SECURE_CAP_TYPE_IOMMU);
    eval 'sub PCI_SECURE_CAP_REV () { &__BITS(23, 19);}' unless defined(&PCI_SECURE_CAP_REV);
    eval 'sub PCI_SECURE_CAP_REV_IOMMU () {0x1;}' unless defined(&PCI_SECURE_CAP_REV_IOMMU);
    eval 'sub PCI_SECURE_CAP_IOTLBSUP () { &__BIT(24);}' unless defined(&PCI_SECURE_CAP_IOTLBSUP);
    eval 'sub PCI_SECURE_CAP_HTTUNNEL () { &__BIT(25);}' unless defined(&PCI_SECURE_CAP_HTTUNNEL);
    eval 'sub PCI_SECURE_CAP_NPCACHE () { &__BIT(26);}' unless defined(&PCI_SECURE_CAP_NPCACHE);
    eval 'sub PCI_SECURE_CAP_EFRSUP () { &__BIT(27);}' unless defined(&PCI_SECURE_CAP_EFRSUP);
    eval 'sub PCI_SECURE_CAP_EXT () { &__BIT(28);}' unless defined(&PCI_SECURE_CAP_EXT);
    eval 'sub PCI_SECURE_IOMMU_BAL () {0x4;}' unless defined(&PCI_SECURE_IOMMU_BAL);
    eval 'sub PCI_SECURE_IOMMU_BAL_EN () { &__BIT(0);}' unless defined(&PCI_SECURE_IOMMU_BAL_EN);
    eval 'sub PCI_SECURE_IOMMU_BAL_L () { &__BITS(18, 14);}' unless defined(&PCI_SECURE_IOMMU_BAL_L);
    eval 'sub PCI_SECURE_IOMMU_BAL_H () { &__BITS(31, 19);}' unless defined(&PCI_SECURE_IOMMU_BAL_H);
    eval 'sub PCI_SECURE_IOMMU_BAH () {0x8;}' unless defined(&PCI_SECURE_IOMMU_BAH);
    eval 'sub PCI_SECURE_IOMMU_RANGE () {0xc;}' unless defined(&PCI_SECURE_IOMMU_RANGE);
    eval 'sub PCI_SECURE_IOMMU_RANGE_UNITID () { &__BITS(4, 0);}' unless defined(&PCI_SECURE_IOMMU_RANGE_UNITID);
    eval 'sub PCI_SECURE_IOMMU_RANGE_RNGVALID () { &__BIT(7);}' unless defined(&PCI_SECURE_IOMMU_RANGE_RNGVALID);
    eval 'sub PCI_SECURE_IOMMU_RANGE_BUSNUM () { &__BITS(15, 8);}' unless defined(&PCI_SECURE_IOMMU_RANGE_BUSNUM);
    eval 'sub PCI_SECURE_IOMMU_RANGE_FIRSTDEV () { &__BITS(23, 16);}' unless defined(&PCI_SECURE_IOMMU_RANGE_FIRSTDEV);
    eval 'sub PCI_SECURE_IOMMU_RANGE_LASTDEV () { &__BITS(31, 24);}' unless defined(&PCI_SECURE_IOMMU_RANGE_LASTDEV);
    eval 'sub PCI_SECURE_IOMMU_MISC0 () {0x10;}' unless defined(&PCI_SECURE_IOMMU_MISC0);
    eval 'sub PCI_SECURE_IOMMU_MISC0_MSINUM () { &__BITS(4, 0);}' unless defined(&PCI_SECURE_IOMMU_MISC0_MSINUM);
    eval 'sub PCI_SECURE_IOMMU_MISC0_GVASIZE () { &__BITS(7, 5);}' unless defined(&PCI_SECURE_IOMMU_MISC0_GVASIZE);
    eval 'sub PCI_SECURE_IOMMU_MISC0_GVASIZE_48B () {0x2;}' unless defined(&PCI_SECURE_IOMMU_MISC0_GVASIZE_48B);
    eval 'sub PCI_SECURE_IOMMU_MISC0_PASIZE () { &__BITS(14, 8);}' unless defined(&PCI_SECURE_IOMMU_MISC0_PASIZE);
    eval 'sub PCI_SECURE_IOMMU_MISC0_VASIZE () { &__BITS(21, 15);}' unless defined(&PCI_SECURE_IOMMU_MISC0_VASIZE);
    eval 'sub PCI_SECURE_IOMMU_MISC0_ATSRESV () { &__BIT(22);}' unless defined(&PCI_SECURE_IOMMU_MISC0_ATSRESV);
    eval 'sub PCI_SECURE_IOMMU_MISC0_MISNPPR () { &__BITS(31, 27);}' unless defined(&PCI_SECURE_IOMMU_MISC0_MISNPPR);
    eval 'sub PCI_SECURE_IOMMU_MISC1 () {0x14;}' unless defined(&PCI_SECURE_IOMMU_MISC1);
    eval 'sub PCI_SECURE_IOMMU_MISC1_MSINUM () { &__BITS(4, 0);}' unless defined(&PCI_SECURE_IOMMU_MISC1_MSINUM);
    eval 'sub PCIE_XCAP () {0x;}' unless defined(&PCIE_XCAP);
    eval 'sub PCIE_XCAP_MASK () { &__BITS(31, 16);}' unless defined(&PCIE_XCAP_MASK);
    eval 'sub PCIE_XCAP_VER_MASK () { &__SHIFTIN( &__BITS(3, 0),  &PCIE_XCAP_MASK);}' unless defined(&PCIE_XCAP_VER_MASK);
    eval 'sub PCIE_XCAP_VER {
        my($x) = @_;
	    eval q( &__SHIFTOUT(($x),  &PCIE_XCAP_VER_MASK));
    }' unless defined(&PCIE_XCAP_VER);
    eval 'sub PCIE_XCAP_VER_1 () {1;}' unless defined(&PCIE_XCAP_VER_1);
    eval 'sub PCIE_XCAP_VER_2 () {2;}' unless defined(&PCIE_XCAP_VER_2);
    eval 'sub PCIE_XCAP_TYPE_MASK () { &__SHIFTIN( &__BITS(7, 4),  &PCIE_XCAP_MASK);}' unless defined(&PCIE_XCAP_TYPE_MASK);
    eval 'sub PCIE_XCAP_TYPE {
        my($x) = @_;
	    eval q( &__SHIFTOUT(($x),  &PCIE_XCAP_TYPE_MASK));
    }' unless defined(&PCIE_XCAP_TYPE);
    eval 'sub PCIE_XCAP_TYPE_PCIE_DEV () {0x;}' unless defined(&PCIE_XCAP_TYPE_PCIE_DEV);
    eval 'sub PCIE_XCAP_TYPE_PCI_DEV () {0x1;}' unless defined(&PCIE_XCAP_TYPE_PCI_DEV);
    eval 'sub PCIE_XCAP_TYPE_RP () {0x4;}' unless defined(&PCIE_XCAP_TYPE_RP);
    eval 'sub PCIE_XCAP_TYPE_UP () {0x5;}' unless defined(&PCIE_XCAP_TYPE_UP);
    eval 'sub PCIE_XCAP_TYPE_DOWN () {0x6;}' unless defined(&PCIE_XCAP_TYPE_DOWN);
    eval 'sub PCIE_XCAP_TYPE_PCIE2PCI () {0x7;}' unless defined(&PCIE_XCAP_TYPE_PCIE2PCI);
    eval 'sub PCIE_XCAP_TYPE_PCI2PCIE () {0x8;}' unless defined(&PCIE_XCAP_TYPE_PCI2PCIE);
    eval 'sub PCIE_XCAP_TYPE_RCIEP () {0x9;}' unless defined(&PCIE_XCAP_TYPE_RCIEP);
    eval 'sub PCIE_XCAP_TYPE_RC_EVNTC () {0xa;}' unless defined(&PCIE_XCAP_TYPE_RC_EVNTC);
    eval 'sub PCIE_XCAP_SI () { &__SHIFTIN( &__BIT(8),  &PCIE_XCAP_MASK);}' unless defined(&PCIE_XCAP_SI);
    eval 'sub PCIE_XCAP_IRQ () { &__SHIFTIN( &__BITS(13, 9),  &PCIE_XCAP_MASK);}' unless defined(&PCIE_XCAP_IRQ);
    eval 'sub PCIE_DCAP () {0x4;}' unless defined(&PCIE_DCAP);
    eval 'sub PCIE_DCAP_MAX_PAYLOAD () { &__BITS(2, 0);}' unless defined(&PCIE_DCAP_MAX_PAYLOAD);
    eval 'sub PCIE_DCAP_PHANTOM_FUNCS () { &__BITS(4, 3);}' unless defined(&PCIE_DCAP_PHANTOM_FUNCS);
    eval 'sub PCIE_DCAP_EXT_TAG_FIELD () { &__BIT(5);}' unless defined(&PCIE_DCAP_EXT_TAG_FIELD);
    eval 'sub PCIE_DCAP_L0S_LATENCY () { &__BITS(8, 6);}' unless defined(&PCIE_DCAP_L0S_LATENCY);
    eval 'sub PCIE_DCAP_L1_LATENCY () { &__BITS(11, 9);}' unless defined(&PCIE_DCAP_L1_LATENCY);
    eval 'sub PCIE_DCAP_ATTN_BUTTON () { &__BIT(12);}' unless defined(&PCIE_DCAP_ATTN_BUTTON);
    eval 'sub PCIE_DCAP_ATTN_IND () { &__BIT(13);}' unless defined(&PCIE_DCAP_ATTN_IND);
    eval 'sub PCIE_DCAP_PWR_IND () { &__BIT(14);}' unless defined(&PCIE_DCAP_PWR_IND);
    eval 'sub PCIE_DCAP_ROLE_ERR_RPT () { &__BIT(15);}' unless defined(&PCIE_DCAP_ROLE_ERR_RPT);
    eval 'sub PCIE_DCAP_SLOT_PWR_LIM_VAL () { &__BITS(25, 18);}' unless defined(&PCIE_DCAP_SLOT_PWR_LIM_VAL);
    eval 'sub PCIE_DCAP_SLOT_PWR_LIM_SCALE () { &__BITS(27, 26);}' unless defined(&PCIE_DCAP_SLOT_PWR_LIM_SCALE);
    eval 'sub PCIE_DCAP_FLR () { &__BIT(28);}' unless defined(&PCIE_DCAP_FLR);
    eval 'sub PCIE_DCSR () {0x8;}' unless defined(&PCIE_DCSR);
    eval 'sub PCIE_DCSR_ENA_COR_ERR () { &__BIT(0);}' unless defined(&PCIE_DCSR_ENA_COR_ERR);
    eval 'sub PCIE_DCSR_ENA_NFER () { &__BIT(1);}' unless defined(&PCIE_DCSR_ENA_NFER);
    eval 'sub PCIE_DCSR_ENA_FER () { &__BIT(2);}' unless defined(&PCIE_DCSR_ENA_FER);
    eval 'sub PCIE_DCSR_ENA_URR () { &__BIT(3);}' unless defined(&PCIE_DCSR_ENA_URR);
    eval 'sub PCIE_DCSR_ENA_RELAX_ORD () { &__BIT(4);}' unless defined(&PCIE_DCSR_ENA_RELAX_ORD);
    eval 'sub PCIE_DCSR_MAX_PAYLOAD () { &__BITS(7, 5);}' unless defined(&PCIE_DCSR_MAX_PAYLOAD);
    eval 'sub PCIE_DCSR_EXT_TAG_FIELD () { &__BIT(8);}' unless defined(&PCIE_DCSR_EXT_TAG_FIELD);
    eval 'sub PCIE_DCSR_PHANTOM_FUNCS () { &__BIT(9);}' unless defined(&PCIE_DCSR_PHANTOM_FUNCS);
    eval 'sub PCIE_DCSR_AUX_POWER_PM () { &__BIT(10);}' unless defined(&PCIE_DCSR_AUX_POWER_PM);
    eval 'sub PCIE_DCSR_ENA_NO_SNOOP () { &__BIT(11);}' unless defined(&PCIE_DCSR_ENA_NO_SNOOP);
    eval 'sub PCIE_DCSR_MAX_READ_REQ () { &__BITS(14, 12);}' unless defined(&PCIE_DCSR_MAX_READ_REQ);
    eval 'sub PCIE_DCSR_BRDG_CFG_RETRY () { &__BIT(15);}' unless defined(&PCIE_DCSR_BRDG_CFG_RETRY);
    eval 'sub PCIE_DCSR_INITIATE_FLR () { &__BIT(15);}' unless defined(&PCIE_DCSR_INITIATE_FLR);
    eval 'sub PCIE_DCSR_CED () { &__BIT(0+ 16);}' unless defined(&PCIE_DCSR_CED);
    eval 'sub PCIE_DCSR_NFED () { &__BIT(1+ 16);}' unless defined(&PCIE_DCSR_NFED);
    eval 'sub PCIE_DCSR_FED () { &__BIT(2+ 16);}' unless defined(&PCIE_DCSR_FED);
    eval 'sub PCIE_DCSR_URD () { &__BIT(3+ 16);}' unless defined(&PCIE_DCSR_URD);
    eval 'sub PCIE_DCSR_AUX_PWR () { &__BIT(4+ 16);}' unless defined(&PCIE_DCSR_AUX_PWR);
    eval 'sub PCIE_DCSR_TRANSACTION_PND () { &__BIT(5+ 16);}' unless defined(&PCIE_DCSR_TRANSACTION_PND);
    eval 'sub PCIE_DCSR_EMGPWRREDD () { &__BIT(6+ 16);}' unless defined(&PCIE_DCSR_EMGPWRREDD);
    eval 'sub PCIE_LCAP () {0xc;}' unless defined(&PCIE_LCAP);
    eval 'sub PCIE_LCAP_MAX_SPEED () { &__BITS(3, 0);}' unless defined(&PCIE_LCAP_MAX_SPEED);
    eval 'sub PCIE_LCAP_MAX_SPEED_2 () {1;}' unless defined(&PCIE_LCAP_MAX_SPEED_2);
    eval 'sub PCIE_LCAP_MAX_SPEED_5 () {2;}' unless defined(&PCIE_LCAP_MAX_SPEED_5);
    eval 'sub PCIE_LCAP_MAX_SPEED_8 () {3;}' unless defined(&PCIE_LCAP_MAX_SPEED_8);
    eval 'sub PCIE_LCAP_MAX_SPEED_16 () {4;}' unless defined(&PCIE_LCAP_MAX_SPEED_16);
    eval 'sub PCIE_LCAP_MAX_SPEED_32 () {5;}' unless defined(&PCIE_LCAP_MAX_SPEED_32);
    eval 'sub PCIE_LCAP_MAX_SPEED_64 () {6;}' unless defined(&PCIE_LCAP_MAX_SPEED_64);
    eval 'sub PCIE_LCAP_MAX_WIDTH () { &__BITS(9, 4);}' unless defined(&PCIE_LCAP_MAX_WIDTH);
    eval 'sub PCIE_LCAP_ASPM () { &__BITS(11, 10);}' unless defined(&PCIE_LCAP_ASPM);
    eval 'sub PCIE_LCAP_L0S_EXIT () { &__BITS(14, 12);}' unless defined(&PCIE_LCAP_L0S_EXIT);
    eval 'sub PCIE_LCAP_L1_EXIT () { &__BITS(17, 15);}' unless defined(&PCIE_LCAP_L1_EXIT);
    eval 'sub PCIE_LCAP_CLOCK_PM () { &__BIT(18);}' unless defined(&PCIE_LCAP_CLOCK_PM);
    eval 'sub PCIE_LCAP_SURPRISE_DOWN () { &__BIT(19);}' unless defined(&PCIE_LCAP_SURPRISE_DOWN);
    eval 'sub PCIE_LCAP_DL_ACTIVE () { &__BIT(20);}' unless defined(&PCIE_LCAP_DL_ACTIVE);
    eval 'sub PCIE_LCAP_LINK_BW_NOTIFY () { &__BIT(21);}' unless defined(&PCIE_LCAP_LINK_BW_NOTIFY);
    eval 'sub PCIE_LCAP_ASPM_COMPLIANCE () { &__BIT(22);}' unless defined(&PCIE_LCAP_ASPM_COMPLIANCE);
    eval 'sub PCIE_LCAP_PORT () { &__BITS(31, 24);}' unless defined(&PCIE_LCAP_PORT);
    eval 'sub PCIE_LCSR () {0x10;}' unless defined(&PCIE_LCSR);
    eval 'sub PCIE_LCSR_ASPM_L0S () { &__BIT(0);}' unless defined(&PCIE_LCSR_ASPM_L0S);
    eval 'sub PCIE_LCSR_ASPM_L1 () { &__BIT(1);}' unless defined(&PCIE_LCSR_ASPM_L1);
    eval 'sub PCIE_LCSR_RCB () { &__BIT(3);}' unless defined(&PCIE_LCSR_RCB);
    eval 'sub PCIE_LCSR_LINK_DIS () { &__BIT(4);}' unless defined(&PCIE_LCSR_LINK_DIS);
    eval 'sub PCIE_LCSR_RETRAIN () { &__BIT(5);}' unless defined(&PCIE_LCSR_RETRAIN);
    eval 'sub PCIE_LCSR_COMCLKCFG () { &__BIT(6);}' unless defined(&PCIE_LCSR_COMCLKCFG);
    eval 'sub PCIE_LCSR_EXTNDSYNC () { &__BIT(7);}' unless defined(&PCIE_LCSR_EXTNDSYNC);
    eval 'sub PCIE_LCSR_ENCLKPM () { &__BIT(8);}' unless defined(&PCIE_LCSR_ENCLKPM);
    eval 'sub PCIE_LCSR_HAWD () { &__BIT(9);}' unless defined(&PCIE_LCSR_HAWD);
    eval 'sub PCIE_LCSR_LBMIE () { &__BIT(10);}' unless defined(&PCIE_LCSR_LBMIE);
    eval 'sub PCIE_LCSR_LABIE () { &__BIT(11);}' unless defined(&PCIE_LCSR_LABIE);
    eval 'sub PCIE_LCSR_DRSSGNL () { &__BITS(15, 14);}' unless defined(&PCIE_LCSR_DRSSGNL);
    eval 'sub PCIE_LCSR_LINKSPEED () { &__BITS(19, 16);}' unless defined(&PCIE_LCSR_LINKSPEED);
    eval 'sub PCIE_LCSR_NLW () { &__BITS(25, 20);}' unless defined(&PCIE_LCSR_NLW);
    eval 'sub PCIE_LCSR_LINKTRAIN_ERR () { &__BIT(10+ 16);}' unless defined(&PCIE_LCSR_LINKTRAIN_ERR);
    eval 'sub PCIE_LCSR_LINKTRAIN () { &__BIT(11+ 16);}' unless defined(&PCIE_LCSR_LINKTRAIN);
    eval 'sub PCIE_LCSR_SLOTCLKCFG () { &__BIT(12+ 16);}' unless defined(&PCIE_LCSR_SLOTCLKCFG);
    eval 'sub PCIE_LCSR_DLACTIVE () { &__BIT(13+ 16);}' unless defined(&PCIE_LCSR_DLACTIVE);
    eval 'sub PCIE_LCSR_LINK_BW_MGMT () { &__BIT(14+ 16);}' unless defined(&PCIE_LCSR_LINK_BW_MGMT);
    eval 'sub PCIE_LCSR_LINK_AUTO_BW () { &__BIT(15+ 16);}' unless defined(&PCIE_LCSR_LINK_AUTO_BW);
    eval 'sub PCIE_SLCAP () {0x14;}' unless defined(&PCIE_SLCAP);
    eval 'sub PCIE_SLCAP_ABP () { &__BIT(0);}' unless defined(&PCIE_SLCAP_ABP);
    eval 'sub PCIE_SLCAP_PCP () { &__BIT(1);}' unless defined(&PCIE_SLCAP_PCP);
    eval 'sub PCIE_SLCAP_MSP () { &__BIT(2);}' unless defined(&PCIE_SLCAP_MSP);
    eval 'sub PCIE_SLCAP_AIP () { &__BIT(3);}' unless defined(&PCIE_SLCAP_AIP);
    eval 'sub PCIE_SLCAP_PIP () { &__BIT(4);}' unless defined(&PCIE_SLCAP_PIP);
    eval 'sub PCIE_SLCAP_HPS () { &__BIT(5);}' unless defined(&PCIE_SLCAP_HPS);
    eval 'sub PCIE_SLCAP_HPC () { &__BIT(6);}' unless defined(&PCIE_SLCAP_HPC);
    eval 'sub PCIE_SLCAP_SPLV () { &__BITS(14, 7);}' unless defined(&PCIE_SLCAP_SPLV);
    eval 'sub PCIE_SLCAP_SPLS () { &__BITS(16, 15);}' unless defined(&PCIE_SLCAP_SPLS);
    eval 'sub PCIE_SLCAP_EIP () { &__BIT(17);}' unless defined(&PCIE_SLCAP_EIP);
    eval 'sub PCIE_SLCAP_NCCS () { &__BIT(18);}' unless defined(&PCIE_SLCAP_NCCS);
    eval 'sub PCIE_SLCAP_PSN () { &__BITS(31, 19);}' unless defined(&PCIE_SLCAP_PSN);
    eval 'sub PCIE_SLCSR () {0x18;}' unless defined(&PCIE_SLCSR);
    eval 'sub PCIE_SLCSR_ABE () { &__BIT(0);}' unless defined(&PCIE_SLCSR_ABE);
    eval 'sub PCIE_SLCSR_PFE () { &__BIT(1);}' unless defined(&PCIE_SLCSR_PFE);
    eval 'sub PCIE_SLCSR_MSE () { &__BIT(2);}' unless defined(&PCIE_SLCSR_MSE);
    eval 'sub PCIE_SLCSR_PDE () { &__BIT(3);}' unless defined(&PCIE_SLCSR_PDE);
    eval 'sub PCIE_SLCSR_CCE () { &__BIT(4);}' unless defined(&PCIE_SLCSR_CCE);
    eval 'sub PCIE_SLCSR_HPE () { &__BIT(5);}' unless defined(&PCIE_SLCSR_HPE);
    eval 'sub PCIE_SLCSR_AIC () { &__BITS(7, 6);}' unless defined(&PCIE_SLCSR_AIC);
    eval 'sub PCIE_SLCSR_PIC () { &__BITS(9, 8);}' unless defined(&PCIE_SLCSR_PIC);
    eval 'sub PCIE_SLCSR_IND_ON () {0x1;}' unless defined(&PCIE_SLCSR_IND_ON);
    eval 'sub PCIE_SLCSR_IND_BLINK () {0x2;}' unless defined(&PCIE_SLCSR_IND_BLINK);
    eval 'sub PCIE_SLCSR_IND_OFF () {0x3;}' unless defined(&PCIE_SLCSR_IND_OFF);
    eval 'sub PCIE_SLCSR_PCC () { &__BIT(10);}' unless defined(&PCIE_SLCSR_PCC);
    eval 'sub PCIE_SLCSR_EIC () { &__BIT(11);}' unless defined(&PCIE_SLCSR_EIC);
    eval 'sub PCIE_SLCSR_DLLSCE () { &__BIT(12);}' unless defined(&PCIE_SLCSR_DLLSCE);
    eval 'sub PCIE_SLCSR_AUTOSPLDIS () { &__BIT(13);}' unless defined(&PCIE_SLCSR_AUTOSPLDIS);
    eval 'sub PCIE_SLCSR_ABP () { &__BIT(0+ 16);}' unless defined(&PCIE_SLCSR_ABP);
    eval 'sub PCIE_SLCSR_PFD () { &__BIT(1+ 16);}' unless defined(&PCIE_SLCSR_PFD);
    eval 'sub PCIE_SLCSR_MSC () { &__BIT(2+ 16);}' unless defined(&PCIE_SLCSR_MSC);
    eval 'sub PCIE_SLCSR_PDC () { &__BIT(3+ 16);}' unless defined(&PCIE_SLCSR_PDC);
    eval 'sub PCIE_SLCSR_CC () { &__BIT(4+ 16);}' unless defined(&PCIE_SLCSR_CC);
    eval 'sub PCIE_SLCSR_MS () { &__BIT(5+ 16);}' unless defined(&PCIE_SLCSR_MS);
    eval 'sub PCIE_SLCSR_PDS () { &__BIT(6+ 16);}' unless defined(&PCIE_SLCSR_PDS);
    eval 'sub PCIE_SLCSR_EIS () { &__BIT(7+ 16);}' unless defined(&PCIE_SLCSR_EIS);
    eval 'sub PCIE_SLCSR_LACS () { &__BIT(8+ 16);}' unless defined(&PCIE_SLCSR_LACS);
    eval 'sub PCIE_RCR () {0x1c;}' unless defined(&PCIE_RCR);
    eval 'sub PCIE_RCR_SERR_CER () { &__BIT(0);}' unless defined(&PCIE_RCR_SERR_CER);
    eval 'sub PCIE_RCR_SERR_NFER () { &__BIT(1);}' unless defined(&PCIE_RCR_SERR_NFER);
    eval 'sub PCIE_RCR_SERR_FER () { &__BIT(2);}' unless defined(&PCIE_RCR_SERR_FER);
    eval 'sub PCIE_RCR_PME_IE () { &__BIT(3);}' unless defined(&PCIE_RCR_PME_IE);
    eval 'sub PCIE_RCR_CRS_SVE () { &__BIT(4);}' unless defined(&PCIE_RCR_CRS_SVE);
    eval 'sub PCIE_RCR_CRS_SV () { &__BIT(16);}' unless defined(&PCIE_RCR_CRS_SV);
    eval 'sub PCIE_RSR () {0x20;}' unless defined(&PCIE_RSR);
    eval 'sub PCIE_RSR_PME_REQESTER () { &__BITS(15, 0);}' unless defined(&PCIE_RSR_PME_REQESTER);
    eval 'sub PCIE_RSR_PME_STAT () { &__BIT(16);}' unless defined(&PCIE_RSR_PME_STAT);
    eval 'sub PCIE_RSR_PME_PEND () { &__BIT(17);}' unless defined(&PCIE_RSR_PME_PEND);
    eval 'sub PCIE_DCAP2 () {0x24;}' unless defined(&PCIE_DCAP2);
    eval 'sub PCIE_DCAP2_COMPT_RANGE () { &__BITS(3,0);}' unless defined(&PCIE_DCAP2_COMPT_RANGE);
    eval 'sub PCIE_DCAP2_COMPT_DIS () { &__BIT(4);}' unless defined(&PCIE_DCAP2_COMPT_DIS);
    eval 'sub PCIE_DCAP2_ARI_FWD () { &__BIT(5);}' unless defined(&PCIE_DCAP2_ARI_FWD);
    eval 'sub PCIE_DCAP2_ATOM_ROUT () { &__BIT(6);}' unless defined(&PCIE_DCAP2_ATOM_ROUT);
    eval 'sub PCIE_DCAP2_32ATOM () { &__BIT(7);}' unless defined(&PCIE_DCAP2_32ATOM);
    eval 'sub PCIE_DCAP2_64ATOM () { &__BIT(8);}' unless defined(&PCIE_DCAP2_64ATOM);
    eval 'sub PCIE_DCAP2_128CAS () { &__BIT(9);}' unless defined(&PCIE_DCAP2_128CAS);
    eval 'sub PCIE_DCAP2_NO_ROPR_PASS () { &__BIT(10);}' unless defined(&PCIE_DCAP2_NO_ROPR_PASS);
    eval 'sub PCIE_DCAP2_LTR_MEC () { &__BIT(11);}' unless defined(&PCIE_DCAP2_LTR_MEC);
    eval 'sub PCIE_DCAP2_TPH_COMP () { &__BITS(13, 12);}' unless defined(&PCIE_DCAP2_TPH_COMP);
    eval 'sub PCIE_DCAP2_LNSYSCLS () { &__BITS(15, 14);}' unless defined(&PCIE_DCAP2_LNSYSCLS);
    eval 'sub PCIE_DCAP2_TBT_COMP () { &__BIT(16);}' unless defined(&PCIE_DCAP2_TBT_COMP);
    eval 'sub PCIE_DCAP2_TBT_REQ () { &__BIT(17);}' unless defined(&PCIE_DCAP2_TBT_REQ);
    eval 'sub PCIE_DCAP2_OBFF () { &__BITS(19, 18);}' unless defined(&PCIE_DCAP2_OBFF);
    eval 'sub PCIE_DCAP2_EXTFMT_FLD () { &__BIT(20);}' unless defined(&PCIE_DCAP2_EXTFMT_FLD);
    eval 'sub PCIE_DCAP2_EETLP_PREF () { &__BIT(21);}' unless defined(&PCIE_DCAP2_EETLP_PREF);
    eval 'sub PCIE_DCAP2_MAX_EETLP () { &__BITS(23, 22);}' unless defined(&PCIE_DCAP2_MAX_EETLP);
    eval 'sub PCIE_DCAP2_EMGPWRRED () { &__BITS(25, 24);}' unless defined(&PCIE_DCAP2_EMGPWRRED);
    eval 'sub PCIE_DCAP2_EMGPWRRED_INI () { &__BIT(26);}' unless defined(&PCIE_DCAP2_EMGPWRRED_INI);
    eval 'sub PCIE_DCAP2_FRS () { &__BIT(31);}' unless defined(&PCIE_DCAP2_FRS);
    eval 'sub PCIE_DCSR2 () {0x28;}' unless defined(&PCIE_DCSR2);
    eval 'sub PCIE_DCSR2_COMPT_VAL () { &__BITS(3, 0);}' unless defined(&PCIE_DCSR2_COMPT_VAL);
    eval 'sub PCIE_DCSR2_COMPT_DIS () { &__BIT(4);}' unless defined(&PCIE_DCSR2_COMPT_DIS);
    eval 'sub PCIE_DCSR2_ARI_FWD () { &__BIT(5);}' unless defined(&PCIE_DCSR2_ARI_FWD);
    eval 'sub PCIE_DCSR2_ATOM_REQ () { &__BIT(6);}' unless defined(&PCIE_DCSR2_ATOM_REQ);
    eval 'sub PCIE_DCSR2_ATOM_EBLK () { &__BIT(7);}' unless defined(&PCIE_DCSR2_ATOM_EBLK);
    eval 'sub PCIE_DCSR2_IDO_REQ () { &__BIT(8);}' unless defined(&PCIE_DCSR2_IDO_REQ);
    eval 'sub PCIE_DCSR2_IDO_COMP () { &__BIT(9);}' unless defined(&PCIE_DCSR2_IDO_COMP);
    eval 'sub PCIE_DCSR2_LTR_MEC () { &__BIT(10);}' unless defined(&PCIE_DCSR2_LTR_MEC);
    eval 'sub PCIE_DCSR2_EMGPWRRED_REQ () { &__BIT(11);}' unless defined(&PCIE_DCSR2_EMGPWRRED_REQ);
    eval 'sub PCIE_DCSR2_TBT_REQ () { &__BIT(12);}' unless defined(&PCIE_DCSR2_TBT_REQ);
    eval 'sub PCIE_DCSR2_OBFF_EN () { &__BITS(14, 13);}' unless defined(&PCIE_DCSR2_OBFF_EN);
    eval 'sub PCIE_DCSR2_EETLP () { &__BIT(15);}' unless defined(&PCIE_DCSR2_EETLP);
    eval 'sub PCIE_LCAP2 () {0x2c;}' unless defined(&PCIE_LCAP2);
    eval 'sub PCIE_LCAP2_SUP_LNKSV () { &__BITS(7, 1);}' unless defined(&PCIE_LCAP2_SUP_LNKSV);
    eval 'sub PCIE_LCAP2_SUP_LNKS2 () { &__BIT(1);}' unless defined(&PCIE_LCAP2_SUP_LNKS2);
    eval 'sub PCIE_LCAP2_SUP_LNKS5 () { &__BIT(2);}' unless defined(&PCIE_LCAP2_SUP_LNKS5);
    eval 'sub PCIE_LCAP2_SUP_LNKS8 () { &__BIT(3);}' unless defined(&PCIE_LCAP2_SUP_LNKS8);
    eval 'sub PCIE_LCAP2_SUP_LNKS16 () { &__BIT(4);}' unless defined(&PCIE_LCAP2_SUP_LNKS16);
    eval 'sub PCIE_LCAP2_SUP_LNKS32 () { &__BIT(5);}' unless defined(&PCIE_LCAP2_SUP_LNKS32);
    eval 'sub PCIE_LCAP2_SUP_LNKS64 () { &__BIT(6);}' unless defined(&PCIE_LCAP2_SUP_LNKS64);
    eval 'sub PCIE_LCAP2_CROSSLNK () { &__BIT(8);}' unless defined(&PCIE_LCAP2_CROSSLNK);
    eval 'sub PCIE_LCAP2_LOWSKPOS_GENSUPPSV () { &__BITS(15, 9);}' unless defined(&PCIE_LCAP2_LOWSKPOS_GENSUPPSV);
    eval 'sub PCIE_LCAP2_LOWSKPOS_RECSUPPSV () { &__BITS(22, 16);}' unless defined(&PCIE_LCAP2_LOWSKPOS_RECSUPPSV);
    eval 'sub PCIE_LCAP2_RETIMERPD () { &__BIT(23);}' unless defined(&PCIE_LCAP2_RETIMERPD);
    eval 'sub PCIE_LCAP2_DRS () { &__BIT(31);}' unless defined(&PCIE_LCAP2_DRS);
    eval 'sub PCIE_LCSR2 () {0x30;}' unless defined(&PCIE_LCSR2);
    eval 'sub PCIE_LCSR2_TGT_LSPEED () { &__BITS(3, 0);}' unless defined(&PCIE_LCSR2_TGT_LSPEED);
    eval 'sub PCIE_LCSR2_ENT_COMPL () { &__BIT(4);}' unless defined(&PCIE_LCSR2_ENT_COMPL);
    eval 'sub PCIE_LCSR2_HW_AS_DIS () { &__BIT(5);}' unless defined(&PCIE_LCSR2_HW_AS_DIS);
    eval 'sub PCIE_LCSR2_SEL_DEEMP () { &__BIT(6);}' unless defined(&PCIE_LCSR2_SEL_DEEMP);
    eval 'sub PCIE_LCSR2_TX_MARGIN () { &__BITS(9, 7);}' unless defined(&PCIE_LCSR2_TX_MARGIN);
    eval 'sub PCIE_LCSR2_EN_MCOMP () { &__BIT(10);}' unless defined(&PCIE_LCSR2_EN_MCOMP);
    eval 'sub PCIE_LCSR2_COMP_SOS () { &__BIT(11);}' unless defined(&PCIE_LCSR2_COMP_SOS);
    eval 'sub PCIE_LCSR2_COMP_DEEMP () { &__BITS(15, 12);}' unless defined(&PCIE_LCSR2_COMP_DEEMP);
    eval 'sub PCIE_LCSR2_DEEMP_LVL () { &__BIT(0+ 16);}' unless defined(&PCIE_LCSR2_DEEMP_LVL);
    eval 'sub PCIE_LCSR2_EQ_COMPL () { &__BIT(1+ 16);}' unless defined(&PCIE_LCSR2_EQ_COMPL);
    eval 'sub PCIE_LCSR2_EQP1_SUC () { &__BIT(2+ 16);}' unless defined(&PCIE_LCSR2_EQP1_SUC);
    eval 'sub PCIE_LCSR2_EQP2_SUC () { &__BIT(3+ 16);}' unless defined(&PCIE_LCSR2_EQP2_SUC);
    eval 'sub PCIE_LCSR2_EQP3_SUC () { &__BIT(4+ 16);}' unless defined(&PCIE_LCSR2_EQP3_SUC);
    eval 'sub PCIE_LCSR2_LNKEQ_REQ () { &__BIT(5+ 16);}' unless defined(&PCIE_LCSR2_LNKEQ_REQ);
    eval 'sub PCIE_LCSR2_RETIMERPD () { &__BIT(6+ 16);}' unless defined(&PCIE_LCSR2_RETIMERPD);
    eval 'sub PCIE_LCSR2_DSCOMPN () { &__BITS(30, 28);}' unless defined(&PCIE_LCSR2_DSCOMPN);
    eval 'sub PCIE_DSCOMPN_DOWN_NOTDETERM () {0x;}' unless defined(&PCIE_DSCOMPN_DOWN_NOTDETERM);
    eval 'sub PCIE_DSCOMPN_DOWN_NOTPRES () {0x1;}' unless defined(&PCIE_DSCOMPN_DOWN_NOTPRES);
    eval 'sub PCIE_DSCOMPN_DOWN_PRES () {0x2;}' unless defined(&PCIE_DSCOMPN_DOWN_PRES);
    eval 'sub PCIE_DSCOMPN_UP_PRES () {0x4;}' unless defined(&PCIE_DSCOMPN_UP_PRES);
    eval 'sub PCIE_DSCOMPN_UP_PRES_DRS () {0x5;}' unless defined(&PCIE_DSCOMPN_UP_PRES_DRS);
    eval 'sub PCIE_LCSR2_DRSRCV () { &__BIT(15+ 16);}' unless defined(&PCIE_LCSR2_DRSRCV);
    eval 'sub PCIE_SLCAP2 () {0x34;}' unless defined(&PCIE_SLCAP2);
    eval 'sub PCIE_SLCSR2 () {0x38;}' unless defined(&PCIE_SLCSR2);
    eval 'sub PCIE_HAS_LINKREGS {
        my($type) = @_;
	    eval q(((($type) !=  &PCIE_XCAP_TYPE_RCIEP)  && (($type) !=  &PCIE_XCAP_TYPE_RC_EVNTC)));
    }' unless defined(&PCIE_HAS_LINKREGS);
    eval 'sub PCIE_HAS_ROOTREGS {
        my($type) = @_;
	    eval q(((($type) ==  &PCIE_XCAP_TYPE_RP) || (($type) ==  &PCIE_XCAP_TYPE_RC_EVNTC)));
    }' unless defined(&PCIE_HAS_ROOTREGS);
    eval 'sub PCI_MSIX_CTL () {0x;}' unless defined(&PCI_MSIX_CTL);
    eval 'sub PCI_MSIX_CTL_ENABLE () {0x80000000;}' unless defined(&PCI_MSIX_CTL_ENABLE);
    eval 'sub PCI_MSIX_CTL_FUNCMASK () {0x40000000;}' unless defined(&PCI_MSIX_CTL_FUNCMASK);
    eval 'sub PCI_MSIX_CTL_TBLSIZE_MASK () {0x7ff0000;}' unless defined(&PCI_MSIX_CTL_TBLSIZE_MASK);
    eval 'sub PCI_MSIX_CTL_TBLSIZE_SHIFT () {16;}' unless defined(&PCI_MSIX_CTL_TBLSIZE_SHIFT);
    eval 'sub PCI_MSIX_CTL_TBLSIZE {
        my($ofs) = @_;
	    eval q((((($ofs) &  &PCI_MSIX_CTL_TBLSIZE_MASK) >>  &PCI_MSIX_CTL_TBLSIZE_SHIFT) + 1));
    }' unless defined(&PCI_MSIX_CTL_TBLSIZE);
    eval 'sub PCI_MSIX_TBLOFFSET () {0x4;}' unless defined(&PCI_MSIX_TBLOFFSET);
    eval 'sub PCI_MSIX_TBLOFFSET_MASK () { &__BITS(31, 3);}' unless defined(&PCI_MSIX_TBLOFFSET_MASK);
    eval 'sub PCI_MSIX_TBLBIR_MASK () { &__BITS(2, 0);}' unless defined(&PCI_MSIX_TBLBIR_MASK);
    eval 'sub PCI_MSIX_PBAOFFSET () {0x8;}' unless defined(&PCI_MSIX_PBAOFFSET);
    eval 'sub PCI_MSIX_PBAOFFSET_MASK () { &__BITS(31, 3);}' unless defined(&PCI_MSIX_PBAOFFSET_MASK);
    eval 'sub PCI_MSIX_PBABIR_MASK () { &__BITS(2, 0);}' unless defined(&PCI_MSIX_PBABIR_MASK);
    eval 'sub PCI_MSIX_TABLE_ENTRY_SIZE () {16;}' unless defined(&PCI_MSIX_TABLE_ENTRY_SIZE);
    eval 'sub PCI_MSIX_TABLE_ENTRY_ADDR_LO () {0x;}' unless defined(&PCI_MSIX_TABLE_ENTRY_ADDR_LO);
    eval 'sub PCI_MSIX_TABLE_ENTRY_ADDR_HI () {0x4;}' unless defined(&PCI_MSIX_TABLE_ENTRY_ADDR_HI);
    eval 'sub PCI_MSIX_TABLE_ENTRY_DATA () {0x8;}' unless defined(&PCI_MSIX_TABLE_ENTRY_DATA);
    eval 'sub PCI_MSIX_TABLE_ENTRY_VECTCTL () {0xc;}' unless defined(&PCI_MSIX_TABLE_ENTRY_VECTCTL);
    eval 'sub PCI_MSIX_VECTCTL_MASK () { &__BIT(0);}' unless defined(&PCI_MSIX_VECTCTL_MASK);
    eval 'sub PCI_MSIX_VECTCTL_STLO () { &__BITS(23, 16);}' unless defined(&PCI_MSIX_VECTCTL_STLO);
    eval 'sub PCI_MSIX_VECTCTL_STUP () { &__BITS(31, 24);}' unless defined(&PCI_MSIX_VECTCTL_STUP);
    eval 'sub PCI_MSIX_MAX_VECTORS () {2048;}' unless defined(&PCI_MSIX_MAX_VECTORS);
    eval 'sub PCI_SATA_REV () {0x;}' unless defined(&PCI_SATA_REV);
    eval 'sub PCI_SATA_REV_MINOR () { &__BITS(19, 16);}' unless defined(&PCI_SATA_REV_MINOR);
    eval 'sub PCI_SATA_REV_MAJOR () { &__BITS(23, 20);}' unless defined(&PCI_SATA_REV_MAJOR);
    eval 'sub PCI_SATA_BAR () {0x4;}' unless defined(&PCI_SATA_BAR);
    eval 'sub PCI_SATA_BAR_SPEC () { &__BITS(3, 0);}' unless defined(&PCI_SATA_BAR_SPEC);
    eval 'sub PCI_SATA_BAR_INCONF () { &__BITS(3, 0);}' unless defined(&PCI_SATA_BAR_INCONF);
    eval 'sub PCI_SATA_BAR_NUM {
        my($x) = @_;
	    eval q(( &__SHIFTOUT(($x),  &PCI_SATA_BAR_SPEC) - 4));
    }' unless defined(&PCI_SATA_BAR_NUM);
    eval 'sub PCI_SATA_BAR_OFFSET () { &__BITS(23, 4);}' unless defined(&PCI_SATA_BAR_OFFSET);
    eval 'sub PCI_AFCAPR () {0x;}' unless defined(&PCI_AFCAPR);
    eval 'sub PCI_AFCAPR_MASK () { &__BITS(31, 24);}' unless defined(&PCI_AFCAPR_MASK);
    eval 'sub PCI_AF_LENGTH () { &__BITS(23, 16);}' unless defined(&PCI_AF_LENGTH);
    eval 'sub PCI_AF_TP_CAP () { &__BIT(24);}' unless defined(&PCI_AF_TP_CAP);
    eval 'sub PCI_AF_FLR_CAP () { &__BIT(25);}' unless defined(&PCI_AF_FLR_CAP);
    eval 'sub PCI_AFCSR () {0x4;}' unless defined(&PCI_AFCSR);
    eval 'sub PCI_AFCR_INITIATE_FLR () { &__BIT(0);}' unless defined(&PCI_AFCR_INITIATE_FLR);
    eval 'sub PCI_AFSR_TP () { &__BIT(8);}' unless defined(&PCI_AFSR_TP);
    eval 'sub PCI_INTERRUPT_REG () {0x3c;}' unless defined(&PCI_INTERRUPT_REG);
    eval 'sub PCI_MAX_LAT_SHIFT () {24;}' unless defined(&PCI_MAX_LAT_SHIFT);
    eval 'sub PCI_MAX_LAT_MASK () {0xff;}' unless defined(&PCI_MAX_LAT_MASK);
    eval 'sub PCI_MAX_LAT {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_MAX_LAT_SHIFT) &  &PCI_MAX_LAT_MASK));
    }' unless defined(&PCI_MAX_LAT);
    eval 'sub PCI_MIN_GNT_SHIFT () {16;}' unless defined(&PCI_MIN_GNT_SHIFT);
    eval 'sub PCI_MIN_GNT_MASK () {0xff;}' unless defined(&PCI_MIN_GNT_MASK);
    eval 'sub PCI_MIN_GNT {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_MIN_GNT_SHIFT) &  &PCI_MIN_GNT_MASK));
    }' unless defined(&PCI_MIN_GNT);
    eval 'sub PCI_INTERRUPT_GRANT_SHIFT () {24;}' unless defined(&PCI_INTERRUPT_GRANT_SHIFT);
    eval 'sub PCI_INTERRUPT_GRANT_MASK () {0xff;}' unless defined(&PCI_INTERRUPT_GRANT_MASK);
    eval 'sub PCI_INTERRUPT_GRANT {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_INTERRUPT_GRANT_SHIFT) &  &PCI_INTERRUPT_GRANT_MASK));
    }' unless defined(&PCI_INTERRUPT_GRANT);
    eval 'sub PCI_INTERRUPT_LATENCY_SHIFT () {16;}' unless defined(&PCI_INTERRUPT_LATENCY_SHIFT);
    eval 'sub PCI_INTERRUPT_LATENCY_MASK () {0xff;}' unless defined(&PCI_INTERRUPT_LATENCY_MASK);
    eval 'sub PCI_INTERRUPT_LATENCY {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_INTERRUPT_LATENCY_SHIFT) &  &PCI_INTERRUPT_LATENCY_MASK));
    }' unless defined(&PCI_INTERRUPT_LATENCY);
    eval 'sub PCI_INTERRUPT_PIN_SHIFT () {8;}' unless defined(&PCI_INTERRUPT_PIN_SHIFT);
    eval 'sub PCI_INTERRUPT_PIN_MASK () {0xff;}' unless defined(&PCI_INTERRUPT_PIN_MASK);
    eval 'sub PCI_INTERRUPT_PIN {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_INTERRUPT_PIN_SHIFT) &  &PCI_INTERRUPT_PIN_MASK));
    }' unless defined(&PCI_INTERRUPT_PIN);
    eval 'sub PCI_INTERRUPT_LINE_SHIFT () {0;}' unless defined(&PCI_INTERRUPT_LINE_SHIFT);
    eval 'sub PCI_INTERRUPT_LINE_MASK () {0xff;}' unless defined(&PCI_INTERRUPT_LINE_MASK);
    eval 'sub PCI_INTERRUPT_LINE {
        my($icr) = @_;
	    eval q(((($icr) >>  &PCI_INTERRUPT_LINE_SHIFT) &  &PCI_INTERRUPT_LINE_MASK));
    }' unless defined(&PCI_INTERRUPT_LINE);
    eval 'sub PCI_INTERRUPT_CODE {
        my($lat,$gnt,$pin,$line) = @_;
	    eval q((((($lat) &PCI_INTERRUPT_LATENCY_MASK)<< &PCI_INTERRUPT_LATENCY_SHIFT)| ((($gnt) &PCI_INTERRUPT_GRANT_MASK) << &PCI_INTERRUPT_GRANT_SHIFT) | ((($pin) &PCI_INTERRUPT_PIN_MASK) << &PCI_INTERRUPT_PIN_SHIFT) | ((($line) &PCI_INTERRUPT_LINE_MASK) << &PCI_INTERRUPT_LINE_SHIFT)));
    }' unless defined(&PCI_INTERRUPT_CODE);
    eval 'sub PCI_INTERRUPT_PIN_NONE () {0x;}' unless defined(&PCI_INTERRUPT_PIN_NONE);
    eval 'sub PCI_INTERRUPT_PIN_A () {0x1;}' unless defined(&PCI_INTERRUPT_PIN_A);
    eval 'sub PCI_INTERRUPT_PIN_B () {0x2;}' unless defined(&PCI_INTERRUPT_PIN_B);
    eval 'sub PCI_INTERRUPT_PIN_C () {0x3;}' unless defined(&PCI_INTERRUPT_PIN_C);
    eval 'sub PCI_INTERRUPT_PIN_D () {0x4;}' unless defined(&PCI_INTERRUPT_PIN_D);
    eval 'sub PCI_INTERRUPT_PIN_MAX () {0x4;}' unless defined(&PCI_INTERRUPT_PIN_MAX);
    eval 'sub PCI_BRIDGE_BUS_REG () {0x18;}' unless defined(&PCI_BRIDGE_BUS_REG);
    eval 'sub PCI_BRIDGE_BUS_PRIMARY () { &__BITS(0, 7);}' unless defined(&PCI_BRIDGE_BUS_PRIMARY);
    eval 'sub PCI_BRIDGE_BUS_SECONDARY () { &__BITS(8, 15);}' unless defined(&PCI_BRIDGE_BUS_SECONDARY);
    eval 'sub PCI_BRIDGE_BUS_SUBORDINATE () { &__BITS(16, 23);}' unless defined(&PCI_BRIDGE_BUS_SUBORDINATE);
    eval 'sub PCI_BRIDGE_BUS_SEC_LATTIMER () { &__BITS(24, 31);}' unless defined(&PCI_BRIDGE_BUS_SEC_LATTIMER);
    eval 'sub PCI_BRIDGE_BUS_NUM_PRIMARY {
        my($reg) = @_;
	    eval q((( &uint32_t) &__SHIFTOUT(($reg),  &PCI_BRIDGE_BUS_PRIMARY)));
    }' unless defined(&PCI_BRIDGE_BUS_NUM_PRIMARY);
    eval 'sub PCI_BRIDGE_BUS_NUM_SECONDARY {
        my($reg) = @_;
	    eval q((( &uint32_t) &__SHIFTOUT(($reg),  &PCI_BRIDGE_BUS_SECONDARY)));
    }' unless defined(&PCI_BRIDGE_BUS_NUM_SECONDARY);
    eval 'sub PCI_BRIDGE_BUS_NUM_SUBORDINATE {
        my($reg) = @_;
	    eval q((( &uint32_t) &__SHIFTOUT(($reg),  &PCI_BRIDGE_BUS_SUBORDINATE)));
    }' unless defined(&PCI_BRIDGE_BUS_NUM_SUBORDINATE);
    eval 'sub PCI_BRIDGE_BUS_SEC_LATTIMER_VAL {
        my($reg) = @_;
	    eval q((( &uint32_t) &__SHIFTOUT(($reg),  &PCI_BRIDGE_BUS_SEC_LATTIMER)));
    }' unless defined(&PCI_BRIDGE_BUS_SEC_LATTIMER_VAL);
    eval 'sub PCI_BRIDGE_IO_MIN () {0x1000;}' unless defined(&PCI_BRIDGE_IO_MIN);
    eval 'sub PCI_BRIDGE_MEM_MIN () {0x100000;}' unless defined(&PCI_BRIDGE_MEM_MIN);
    eval 'sub PCI_BRIDGE_STATIO_REG () {0x1c;}' unless defined(&PCI_BRIDGE_STATIO_REG);
    eval 'sub PCI_BRIDGE_STATIO_IOBASE () { &__BITS(0, 7);}' unless defined(&PCI_BRIDGE_STATIO_IOBASE);
    eval 'sub PCI_BRIDGE_STATIO_IOLIMIT () { &__BITS(8, 15);}' unless defined(&PCI_BRIDGE_STATIO_IOLIMIT);
    eval 'sub PCI_BRIDGE_STATIO_STATUS () { &__BITS(16, 31);}' unless defined(&PCI_BRIDGE_STATIO_STATUS);
    eval 'sub PCI_BRIDGE_STATIO_IOADDR () {0xf0;}' unless defined(&PCI_BRIDGE_STATIO_IOADDR);
    eval 'sub PCI_BRIDGE_STATIO_IOADDR_TYPE () {0xf;}' unless defined(&PCI_BRIDGE_STATIO_IOADDR_TYPE);
    eval 'sub PCI_BRIDGE_STATIO_IOADDR_32 () {0x1;}' unless defined(&PCI_BRIDGE_STATIO_IOADDR_32);
    eval 'sub PCI_BRIDGE_STATIO_IOBASE_ADDR {
        my($reg) = @_;
	    eval q((( &__SHIFTOUT(($reg),  &PCI_BRIDGE_STATIO_IOBASE) &  &PCI_BRIDGE_STATIO_IOADDR) << 8));
    }' unless defined(&PCI_BRIDGE_STATIO_IOBASE_ADDR);
    eval 'sub PCI_BRIDGE_STATIO_IOLIMIT_ADDR {
        my($reg) = @_;
	    eval q(((( &__SHIFTOUT(($reg),  &PCI_BRIDGE_STATIO_IOLIMIT) &  &PCI_BRIDGE_STATIO_IOADDR) << 8) | ( &PCI_BRIDGE_IO_MIN - 1)));
    }' unless defined(&PCI_BRIDGE_STATIO_IOLIMIT_ADDR);
    eval 'sub PCI_BRIDGE_IO_32BITS {
        my($reg) = @_;
	    eval q(((($reg) &  &PCI_BRIDGE_STATIO_IOADDR_TYPE) ==  &PCI_BRIDGE_STATIO_IOADDR_32));
    }' unless defined(&PCI_BRIDGE_IO_32BITS);
    eval 'sub PCI_BRIDGE_MEMORY_REG () {0x20;}' unless defined(&PCI_BRIDGE_MEMORY_REG);
    eval 'sub PCI_BRIDGE_MEMORY_BASE () { &__BITS(0, 15);}' unless defined(&PCI_BRIDGE_MEMORY_BASE);
    eval 'sub PCI_BRIDGE_MEMORY_LIMIT () { &__BITS(16, 31);}' unless defined(&PCI_BRIDGE_MEMORY_LIMIT);
    eval 'sub PCI_BRIDGE_MEMORY_ADDR () {0xfff0;}' unless defined(&PCI_BRIDGE_MEMORY_ADDR);
    eval 'sub PCI_BRIDGE_MEMORY_BASE_ADDR {
        my($reg) = @_;
	    eval q((( &__SHIFTOUT(($reg),  &PCI_BRIDGE_MEMORY_BASE) &  &PCI_BRIDGE_MEMORY_ADDR) << 16));
    }' unless defined(&PCI_BRIDGE_MEMORY_BASE_ADDR);
    eval 'sub PCI_BRIDGE_MEMORY_LIMIT_ADDR {
        my($reg) = @_;
	    eval q(((( &__SHIFTOUT(($reg),  &PCI_BRIDGE_MEMORY_LIMIT) &  &PCI_BRIDGE_MEMORY_ADDR) << 16) | 0xfffff));
    }' unless defined(&PCI_BRIDGE_MEMORY_LIMIT_ADDR);
    eval 'sub PCI_BRIDGE_PREFETCHMEM_REG () {0x24;}' unless defined(&PCI_BRIDGE_PREFETCHMEM_REG);
    eval 'sub PCI_BRIDGE_PREFETCHMEM_BASE () { &__BITS(0, 15);}' unless defined(&PCI_BRIDGE_PREFETCHMEM_BASE);
    eval 'sub PCI_BRIDGE_PREFETCHMEM_LIMIT () { &__BITS(16, 31);}' unless defined(&PCI_BRIDGE_PREFETCHMEM_LIMIT);
    eval 'sub PCI_BRIDGE_PREFETCHMEM_ADDR () {0xfff0;}' unless defined(&PCI_BRIDGE_PREFETCHMEM_ADDR);
    eval 'sub PCI_BRIDGE_PREFETCHMEM_BASE_ADDR {
        my($reg) = @_;
	    eval q((( &__SHIFTOUT(($reg),  &PCI_BRIDGE_PREFETCHMEM_BASE) &  &PCI_BRIDGE_PREFETCHMEM_ADDR) << 16));
    }' unless defined(&PCI_BRIDGE_PREFETCHMEM_BASE_ADDR);
    eval 'sub PCI_BRIDGE_PREFETCHMEM_LIMIT_ADDR {
        my($reg) = @_;
	    eval q(((( &__SHIFTOUT(($reg),  &PCI_BRIDGE_PREFETCHMEM_LIMIT) &  &PCI_BRIDGE_PREFETCHMEM_ADDR) << 16) | 0xfffff));
    }' unless defined(&PCI_BRIDGE_PREFETCHMEM_LIMIT_ADDR);
    eval 'sub PCI_BRIDGE_PREFETCHMEM_64BITS {
        my($reg) = @_;
	    eval q((($reg) & 0xf));
    }' unless defined(&PCI_BRIDGE_PREFETCHMEM_64BITS);
    eval 'sub PCI_BRIDGE_PREFETCHBASEUP32_REG () {0x28;}' unless defined(&PCI_BRIDGE_PREFETCHBASEUP32_REG);
    eval 'sub PCI_BRIDGE_PREFETCHLIMITUP32_REG () {0x2c;}' unless defined(&PCI_BRIDGE_PREFETCHLIMITUP32_REG);
    eval 'sub PCI_BRIDGE_IOHIGH_REG () {0x30;}' unless defined(&PCI_BRIDGE_IOHIGH_REG);
    eval 'sub PCI_BRIDGE_IOHIGH_BASE () { &__BITS(0, 15);}' unless defined(&PCI_BRIDGE_IOHIGH_BASE);
    eval 'sub PCI_BRIDGE_IOHIGH_LIMIT () { &__BITS(16, 31);}' unless defined(&PCI_BRIDGE_IOHIGH_LIMIT);
    eval 'sub PCI_BRIDGE_EXPROMADDR_REG () {0x38;}' unless defined(&PCI_BRIDGE_EXPROMADDR_REG);
    eval 'sub PCI_BRIDGE_CONTROL_REG () {0x3c;}' unless defined(&PCI_BRIDGE_CONTROL_REG);
    eval 'sub PCI_BRIDGE_CONTROL () { &__BITS(16, 31);}' unless defined(&PCI_BRIDGE_CONTROL);
    eval 'sub PCI_BRIDGE_CONTROL_PERE () { &__BIT(16);}' unless defined(&PCI_BRIDGE_CONTROL_PERE);
    eval 'sub PCI_BRIDGE_CONTROL_SERR () { &__BIT(17);}' unless defined(&PCI_BRIDGE_CONTROL_SERR);
    eval 'sub PCI_BRIDGE_CONTROL_ISA () { &__BIT(18);}' unless defined(&PCI_BRIDGE_CONTROL_ISA);
    eval 'sub PCI_BRIDGE_CONTROL_VGA () { &__BIT(19);}' unless defined(&PCI_BRIDGE_CONTROL_VGA);
    eval 'sub PCI_BRIDGE_CONTROL_VGA16 () { &__BIT(20);}' unless defined(&PCI_BRIDGE_CONTROL_VGA16);
    eval 'sub PCI_BRIDGE_CONTROL_MABRT () { &__BIT(21);}' unless defined(&PCI_BRIDGE_CONTROL_MABRT);
    eval 'sub PCI_BRIDGE_CONTROL_SECBR () { &__BIT(22);}' unless defined(&PCI_BRIDGE_CONTROL_SECBR);
    eval 'sub PCI_BRIDGE_CONTROL_SECFASTB2B () { &__BIT(23);}' unless defined(&PCI_BRIDGE_CONTROL_SECFASTB2B);
    eval 'sub PCI_BRIDGE_CONTROL_PRI_DISC_TIMER () { &__BIT(24);}' unless defined(&PCI_BRIDGE_CONTROL_PRI_DISC_TIMER);
    eval 'sub PCI_BRIDGE_CONTROL_SEC_DISC_TIMER () { &__BIT(25);}' unless defined(&PCI_BRIDGE_CONTROL_SEC_DISC_TIMER);
    eval 'sub PCI_BRIDGE_CONTROL_DISC_TIMER_STAT () { &__BIT(26);}' unless defined(&PCI_BRIDGE_CONTROL_DISC_TIMER_STAT);
    eval 'sub PCI_BRIDGE_CONTROL_DISC_TIMER_SERR () { &__BIT(27);}' unless defined(&PCI_BRIDGE_CONTROL_DISC_TIMER_SERR);
    eval 'sub PCI_VPDRES_ISLARGE {
        my($x) = @_;
	    eval q((($x) & 0x80));
    }' unless defined(&PCI_VPDRES_ISLARGE);
    eval 'sub PCI_VPDRES_SMALL_LENGTH {
        my($x) = @_;
	    eval q((($x) & 0x7));
    }' unless defined(&PCI_VPDRES_SMALL_LENGTH);
    eval 'sub PCI_VPDRES_SMALL_NAME {
        my($x) = @_;
	    eval q(((($x) >> 3) & 0xf));
    }' unless defined(&PCI_VPDRES_SMALL_NAME);
    eval 'sub PCI_VPDRES_LARGE_NAME {
        my($x) = @_;
	    eval q((($x) & 0x7f));
    }' unless defined(&PCI_VPDRES_LARGE_NAME);
    eval 'sub PCI_VPDRES_TYPE_COMPATIBLE_DEVICE_ID () {0x3;}' unless defined(&PCI_VPDRES_TYPE_COMPATIBLE_DEVICE_ID);
    eval 'sub PCI_VPDRES_TYPE_VENDOR_DEFINED () {0xe;}' unless defined(&PCI_VPDRES_TYPE_VENDOR_DEFINED);
    eval 'sub PCI_VPDRES_TYPE_END_TAG () {0xf;}' unless defined(&PCI_VPDRES_TYPE_END_TAG);
    eval 'sub PCI_VPDRES_TYPE_IDENTIFIER_STRING () {0x2;}' unless defined(&PCI_VPDRES_TYPE_IDENTIFIER_STRING);
    eval 'sub PCI_VPDRES_TYPE_VPD () {0x10;}' unless defined(&PCI_VPDRES_TYPE_VPD);
    eval 'sub PCI_ROM_HEADER_MAGIC () {0xaa55;}' unless defined(&PCI_ROM_HEADER_MAGIC);
    eval 'sub PCI_ROM_SIGNATURE () {0x52494350;}' unless defined(&PCI_ROM_SIGNATURE);
    eval 'sub PCI_ROM_CODE_TYPE_X86 () {0;}' unless defined(&PCI_ROM_CODE_TYPE_X86);
    eval 'sub PCI_ROM_CODE_TYPE_OFW () {1;}' unless defined(&PCI_ROM_CODE_TYPE_OFW);
    eval 'sub PCI_ROM_CODE_TYPE_HPPA () {2;}' unless defined(&PCI_ROM_CODE_TYPE_HPPA);
    eval 'sub PCI_ROM_CODE_TYPE_EFI () {3;}' unless defined(&PCI_ROM_CODE_TYPE_EFI);
    eval 'sub PCI_ROM_INDICATOR_LAST () {0x80;}' unless defined(&PCI_ROM_INDICATOR_LAST);
    eval 'sub PCI32_DMA_BOUNCE_THRESHOLD () {4294967296;}' unless defined(&PCI32_DMA_BOUNCE_THRESHOLD);
    eval 'sub PCI_EXTCAPLIST_BASE () {0x100;}' unless defined(&PCI_EXTCAPLIST_BASE);
    eval 'sub PCI_EXTCAPLIST_CAP {
        my($ecr) = @_;
	    eval q((($ecr) & 0xffff));
    }' unless defined(&PCI_EXTCAPLIST_CAP);
    eval 'sub PCI_EXTCAPLIST_VERSION {
        my($ecr) = @_;
	    eval q(((($ecr) >> 16) & 0xf));
    }' unless defined(&PCI_EXTCAPLIST_VERSION);
    eval 'sub PCI_EXTCAPLIST_NEXT {
        my($ecr) = @_;
	    eval q(((($ecr) >> 20) & 0xfff));
    }' unless defined(&PCI_EXTCAPLIST_NEXT);
    eval 'sub PCI_EXTCAP_AER () {0x1;}' unless defined(&PCI_EXTCAP_AER);
    eval 'sub PCI_EXTCAP_VC () {0x2;}' unless defined(&PCI_EXTCAP_VC);
    eval 'sub PCI_EXTCAP_SERNUM () {0x3;}' unless defined(&PCI_EXTCAP_SERNUM);
    eval 'sub PCI_EXTCAP_PWRBDGT () {0x4;}' unless defined(&PCI_EXTCAP_PWRBDGT);
    eval 'sub PCI_EXTCAP_RCLINK_DCL () {0x5;}' unless defined(&PCI_EXTCAP_RCLINK_DCL);
    eval 'sub PCI_EXTCAP_RCLINK_CTL () {0x6;}' unless defined(&PCI_EXTCAP_RCLINK_CTL);
    eval 'sub PCI_EXTCAP_RCEC_ASSOC () {0x7;}' unless defined(&PCI_EXTCAP_RCEC_ASSOC);
    eval 'sub PCI_EXTCAP_MFVC () {0x8;}' unless defined(&PCI_EXTCAP_MFVC);
    eval 'sub PCI_EXTCAP_VC2 () {0x9;}' unless defined(&PCI_EXTCAP_VC2);
    eval 'sub PCI_EXTCAP_RCRB () {0xa;}' unless defined(&PCI_EXTCAP_RCRB);
    eval 'sub PCI_EXTCAP_VENDOR () {0xb;}' unless defined(&PCI_EXTCAP_VENDOR);
    eval 'sub PCI_EXTCAP_CAC () {0xc;}' unless defined(&PCI_EXTCAP_CAC);
    eval 'sub PCI_EXTCAP_ACS () {0xd;}' unless defined(&PCI_EXTCAP_ACS);
    eval 'sub PCI_EXTCAP_ARI () {0xe;}' unless defined(&PCI_EXTCAP_ARI);
    eval 'sub PCI_EXTCAP_ATS () {0xf;}' unless defined(&PCI_EXTCAP_ATS);
    eval 'sub PCI_EXTCAP_SRIOV () {0x10;}' unless defined(&PCI_EXTCAP_SRIOV);
    eval 'sub PCI_EXTCAP_MRIOV () {0x11;}' unless defined(&PCI_EXTCAP_MRIOV);
    eval 'sub PCI_EXTCAP_MCAST () {0x12;}' unless defined(&PCI_EXTCAP_MCAST);
    eval 'sub PCI_EXTCAP_PAGE_REQ () {0x13;}' unless defined(&PCI_EXTCAP_PAGE_REQ);
    eval 'sub PCI_EXTCAP_AMD () {0x14;}' unless defined(&PCI_EXTCAP_AMD);
    eval 'sub PCI_EXTCAP_RESIZBAR () {0x15;}' unless defined(&PCI_EXTCAP_RESIZBAR);
    eval 'sub PCI_EXTCAP_DPA () {0x16;}' unless defined(&PCI_EXTCAP_DPA);
    eval 'sub PCI_EXTCAP_TPH_REQ () {0x17;}' unless defined(&PCI_EXTCAP_TPH_REQ);
    eval 'sub PCI_EXTCAP_LTR () {0x18;}' unless defined(&PCI_EXTCAP_LTR);
    eval 'sub PCI_EXTCAP_SEC_PCIE () {0x19;}' unless defined(&PCI_EXTCAP_SEC_PCIE);
    eval 'sub PCI_EXTCAP_PMUX () {0x1a;}' unless defined(&PCI_EXTCAP_PMUX);
    eval 'sub PCI_EXTCAP_PASID () {0x1b;}' unless defined(&PCI_EXTCAP_PASID);
    eval 'sub PCI_EXTCAP_LNR () {0x1c;}' unless defined(&PCI_EXTCAP_LNR);
    eval 'sub PCI_EXTCAP_DPC () {0x1d;}' unless defined(&PCI_EXTCAP_DPC);
    eval 'sub PCI_EXTCAP_L1PM () {0x1e;}' unless defined(&PCI_EXTCAP_L1PM);
    eval 'sub PCI_EXTCAP_PTM () {0x1f;}' unless defined(&PCI_EXTCAP_PTM);
    eval 'sub PCI_EXTCAP_MPCIE () {0x20;}' unless defined(&PCI_EXTCAP_MPCIE);
    eval 'sub PCI_EXTCAP_FRSQ () {0x21;}' unless defined(&PCI_EXTCAP_FRSQ);
    eval 'sub PCI_EXTCAP_RTR () {0x22;}' unless defined(&PCI_EXTCAP_RTR);
    eval 'sub PCI_EXTCAP_DESIGVNDSP () {0x23;}' unless defined(&PCI_EXTCAP_DESIGVNDSP);
    eval 'sub PCI_EXTCAP_VF_RESIZBAR () {0x24;}' unless defined(&PCI_EXTCAP_VF_RESIZBAR);
    eval 'sub PCI_EXTCAP_DLF () {0x25;}' unless defined(&PCI_EXTCAP_DLF);
    eval 'sub PCI_EXTCAP_PYSLAY_16GT () {0x26;}' unless defined(&PCI_EXTCAP_PYSLAY_16GT);
    eval 'sub PCI_EXTCAP_LMR () {0x27;}' unless defined(&PCI_EXTCAP_LMR);
    eval 'sub PCI_EXTCAP_HIERARCHYID () {0x28;}' unless defined(&PCI_EXTCAP_HIERARCHYID);
    eval 'sub PCI_EXTCAP_NPEM () {0x29;}' unless defined(&PCI_EXTCAP_NPEM);
    eval 'sub PCI_AER_UC_STATUS () {0x4;}' unless defined(&PCI_AER_UC_STATUS);
    eval 'sub PCI_AER_UC_UNDEFINED () { &__BIT(0);}' unless defined(&PCI_AER_UC_UNDEFINED);
    eval 'sub PCI_AER_UC_DL_PROTOCOL_ERROR () { &__BIT(4);}' unless defined(&PCI_AER_UC_DL_PROTOCOL_ERROR);
    eval 'sub PCI_AER_UC_SURPRISE_DOWN_ERROR () { &__BIT(5);}' unless defined(&PCI_AER_UC_SURPRISE_DOWN_ERROR);
    eval 'sub PCI_AER_UC_POISONED_TLP () { &__BIT(12);}' unless defined(&PCI_AER_UC_POISONED_TLP);
    eval 'sub PCI_AER_UC_FC_PROTOCOL_ERROR () { &__BIT(13);}' unless defined(&PCI_AER_UC_FC_PROTOCOL_ERROR);
    eval 'sub PCI_AER_UC_COMPLETION_TIMEOUT () { &__BIT(14);}' unless defined(&PCI_AER_UC_COMPLETION_TIMEOUT);
    eval 'sub PCI_AER_UC_COMPLETER_ABORT () { &__BIT(15);}' unless defined(&PCI_AER_UC_COMPLETER_ABORT);
    eval 'sub PCI_AER_UC_UNEXPECTED_COMPLETION () { &__BIT(16);}' unless defined(&PCI_AER_UC_UNEXPECTED_COMPLETION);
    eval 'sub PCI_AER_UC_RECEIVER_OVERFLOW () { &__BIT(17);}' unless defined(&PCI_AER_UC_RECEIVER_OVERFLOW);
    eval 'sub PCI_AER_UC_MALFORMED_TLP () { &__BIT(18);}' unless defined(&PCI_AER_UC_MALFORMED_TLP);
    eval 'sub PCI_AER_UC_ECRC_ERROR () { &__BIT(19);}' unless defined(&PCI_AER_UC_ECRC_ERROR);
    eval 'sub PCI_AER_UC_UNSUPPORTED_REQUEST_ERROR () { &__BIT(20);}' unless defined(&PCI_AER_UC_UNSUPPORTED_REQUEST_ERROR);
    eval 'sub PCI_AER_UC_ACS_VIOLATION () { &__BIT(21);}' unless defined(&PCI_AER_UC_ACS_VIOLATION);
    eval 'sub PCI_AER_UC_INTERNAL_ERROR () { &__BIT(22);}' unless defined(&PCI_AER_UC_INTERNAL_ERROR);
    eval 'sub PCI_AER_UC_MC_BLOCKED_TLP () { &__BIT(23);}' unless defined(&PCI_AER_UC_MC_BLOCKED_TLP);
    eval 'sub PCI_AER_UC_ATOMIC_OP_EGRESS_BLOCKED () { &__BIT(24);}' unless defined(&PCI_AER_UC_ATOMIC_OP_EGRESS_BLOCKED);
    eval 'sub PCI_AER_UC_TLP_PREFIX_BLOCKED_ERROR () { &__BIT(25);}' unless defined(&PCI_AER_UC_TLP_PREFIX_BLOCKED_ERROR);
    eval 'sub PCI_AER_UC_POISONTLP_EGRESS_BLOCKED () { &__BIT(26);}' unless defined(&PCI_AER_UC_POISONTLP_EGRESS_BLOCKED);
    eval 'sub PCI_AER_UC_MASK () {0x8;}' unless defined(&PCI_AER_UC_MASK);
    eval 'sub PCI_AER_UC_SEVERITY () {0xc;}' unless defined(&PCI_AER_UC_SEVERITY);
    eval 'sub PCI_AER_COR_STATUS () {0x10;}' unless defined(&PCI_AER_COR_STATUS);
    eval 'sub PCI_AER_COR_RECEIVER_ERROR () { &__BIT(0);}' unless defined(&PCI_AER_COR_RECEIVER_ERROR);
    eval 'sub PCI_AER_COR_BAD_TLP () { &__BIT(6);}' unless defined(&PCI_AER_COR_BAD_TLP);
    eval 'sub PCI_AER_COR_BAD_DLLP () { &__BIT(7);}' unless defined(&PCI_AER_COR_BAD_DLLP);
    eval 'sub PCI_AER_COR_REPLAY_NUM_ROLLOVER () { &__BIT(8);}' unless defined(&PCI_AER_COR_REPLAY_NUM_ROLLOVER);
    eval 'sub PCI_AER_COR_REPLAY_TIMER_TIMEOUT () { &__BIT(12);}' unless defined(&PCI_AER_COR_REPLAY_TIMER_TIMEOUT);
    eval 'sub PCI_AER_COR_ADVISORY_NF_ERROR () { &__BIT(13);}' unless defined(&PCI_AER_COR_ADVISORY_NF_ERROR);
    eval 'sub PCI_AER_COR_INTERNAL_ERROR () { &__BIT(14);}' unless defined(&PCI_AER_COR_INTERNAL_ERROR);
    eval 'sub PCI_AER_COR_HEADER_LOG_OVERFLOW () { &__BIT(15);}' unless defined(&PCI_AER_COR_HEADER_LOG_OVERFLOW);
    eval 'sub PCI_AER_COR_MASK () {0x14;}' unless defined(&PCI_AER_COR_MASK);
    eval 'sub PCI_AER_CAP_CONTROL () {0x18;}' unless defined(&PCI_AER_CAP_CONTROL);
    eval 'sub PCI_AER_FIRST_ERROR_PTR () { &__BITS(4, 0);}' unless defined(&PCI_AER_FIRST_ERROR_PTR);
    eval 'sub PCI_AER_ECRC_GEN_CAPABLE () { &__BIT(5);}' unless defined(&PCI_AER_ECRC_GEN_CAPABLE);
    eval 'sub PCI_AER_ECRC_GEN_ENABLE () { &__BIT(6);}' unless defined(&PCI_AER_ECRC_GEN_ENABLE);
    eval 'sub PCI_AER_ECRC_CHECK_CAPABLE () { &__BIT(7);}' unless defined(&PCI_AER_ECRC_CHECK_CAPABLE);
    eval 'sub PCI_AER_ECRC_CHECK_ENABLE () { &__BIT(8);}' unless defined(&PCI_AER_ECRC_CHECK_ENABLE);
    eval 'sub PCI_AER_MULT_HDR_CAPABLE () { &__BIT(9);}' unless defined(&PCI_AER_MULT_HDR_CAPABLE);
    eval 'sub PCI_AER_MULT_HDR_ENABLE () { &__BIT(10);}' unless defined(&PCI_AER_MULT_HDR_ENABLE);
    eval 'sub PCI_AER_TLP_PREFIX_LOG_PRESENT () { &__BIT(11);}' unless defined(&PCI_AER_TLP_PREFIX_LOG_PRESENT);
    eval 'sub PCI_AER_COMPTOUTPRFXHDRLOG_CAP () { &__BIT(12);}' unless defined(&PCI_AER_COMPTOUTPRFXHDRLOG_CAP);
    eval 'sub PCI_AER_HEADER_LOG () {0x1c;}' unless defined(&PCI_AER_HEADER_LOG);
    eval 'sub PCI_AER_ROOTERR_CMD () {0x2c;}' unless defined(&PCI_AER_ROOTERR_CMD);
    eval 'sub PCI_AER_ROOTERR_COR_ENABLE () { &__BIT(0);}' unless defined(&PCI_AER_ROOTERR_COR_ENABLE);
    eval 'sub PCI_AER_ROOTERR_NF_ENABLE () { &__BIT(1);}' unless defined(&PCI_AER_ROOTERR_NF_ENABLE);
    eval 'sub PCI_AER_ROOTERR_F_ENABLE () { &__BIT(2);}' unless defined(&PCI_AER_ROOTERR_F_ENABLE);
    eval 'sub PCI_AER_ROOTERR_STATUS () {0x30;}' unless defined(&PCI_AER_ROOTERR_STATUS);
    eval 'sub PCI_AER_ROOTERR_COR_ERR () { &__BIT(0);}' unless defined(&PCI_AER_ROOTERR_COR_ERR);
    eval 'sub PCI_AER_ROOTERR_MULTI_COR_ERR () { &__BIT(1);}' unless defined(&PCI_AER_ROOTERR_MULTI_COR_ERR);
    eval 'sub PCI_AER_ROOTERR_UC_ERR () { &__BIT(2);}' unless defined(&PCI_AER_ROOTERR_UC_ERR);
    eval 'sub PCI_AER_ROOTERR_MULTI_UC_ERR () { &__BIT(3);}' unless defined(&PCI_AER_ROOTERR_MULTI_UC_ERR);
    eval 'sub PCI_AER_ROOTERR_FIRST_UC_FATAL () { &__BIT(4);}' unless defined(&PCI_AER_ROOTERR_FIRST_UC_FATAL);
    eval 'sub PCI_AER_ROOTERR_NF_ERR () { &__BIT(5);}' unless defined(&PCI_AER_ROOTERR_NF_ERR);
    eval 'sub PCI_AER_ROOTERR_F_ERR () { &__BIT(6);}' unless defined(&PCI_AER_ROOTERR_F_ERR);
    eval 'sub PCI_AER_ROOTERR_INT_MESSAGE () { &__BITS(31, 27);}' unless defined(&PCI_AER_ROOTERR_INT_MESSAGE);
    eval 'sub PCI_AER_ERRSRC_ID () {0x34;}' unless defined(&PCI_AER_ERRSRC_ID);
    eval 'sub PCI_AER_ERRSRC_ID_ERR_COR () { &__BITS(15, 0);}' unless defined(&PCI_AER_ERRSRC_ID_ERR_COR);
    eval 'sub PCI_AER_ERRSRC_ID_ERR_UC () { &__BITS(31, 16);}' unless defined(&PCI_AER_ERRSRC_ID_ERR_UC);
    eval 'sub PCI_AER_TLP_PREFIX_LOG () {0x38;}' unless defined(&PCI_AER_TLP_PREFIX_LOG);
    eval 'sub PCI_VC_CAP1 () {0x4;}' unless defined(&PCI_VC_CAP1);
    eval 'sub PCI_VC_CAP1_EXT_COUNT () { &__BITS(2, 0);}' unless defined(&PCI_VC_CAP1_EXT_COUNT);
    eval 'sub PCI_VC_CAP1_LOWPRI_EXT_COUNT () { &__BITS(6, 4);}' unless defined(&PCI_VC_CAP1_LOWPRI_EXT_COUNT);
    eval 'sub PCI_VC_CAP1_REFCLK () { &__BITS(9, 8);}' unless defined(&PCI_VC_CAP1_REFCLK);
    eval 'sub PCI_VC_CAP1_REFCLK_100NS () {0x;}' unless defined(&PCI_VC_CAP1_REFCLK_100NS);
    eval 'sub PCI_VC_CAP1_PORT_ARB_TABLE_SIZE () { &__BITS(11, 10);}' unless defined(&PCI_VC_CAP1_PORT_ARB_TABLE_SIZE);
    eval 'sub PCI_VC_CAP2 () {0x8;}' unless defined(&PCI_VC_CAP2);
    eval 'sub PCI_VC_CAP2_ARB_CAP_HW_FIXED_SCHEME () { &__BIT(0);}' unless defined(&PCI_VC_CAP2_ARB_CAP_HW_FIXED_SCHEME);
    eval 'sub PCI_VC_CAP2_ARB_CAP_WRR_32 () { &__BIT(1);}' unless defined(&PCI_VC_CAP2_ARB_CAP_WRR_32);
    eval 'sub PCI_VC_CAP2_ARB_CAP_WRR_64 () { &__BIT(2);}' unless defined(&PCI_VC_CAP2_ARB_CAP_WRR_64);
    eval 'sub PCI_VC_CAP2_ARB_CAP_WRR_128 () { &__BIT(3);}' unless defined(&PCI_VC_CAP2_ARB_CAP_WRR_128);
    eval 'sub PCI_VC_CAP2_ARB_TABLE_OFFSET () { &__BITS(31, 24);}' unless defined(&PCI_VC_CAP2_ARB_TABLE_OFFSET);
    eval 'sub PCI_VC_CONTROL () {0xc;}' unless defined(&PCI_VC_CONTROL);
    eval 'sub PCI_VC_CONTROL_LOAD_VC_ARB_TABLE () { &__BIT(0);}' unless defined(&PCI_VC_CONTROL_LOAD_VC_ARB_TABLE);
    eval 'sub PCI_VC_CONTROL_VC_ARB_SELECT () { &__BITS(3, 1);}' unless defined(&PCI_VC_CONTROL_VC_ARB_SELECT);
    eval 'sub PCI_VC_STATUS () {0xe;}' unless defined(&PCI_VC_STATUS);
    eval 'sub PCI_VC_STATUS_LOAD_VC_ARB_TABLE () { &__BIT(0);}' unless defined(&PCI_VC_STATUS_LOAD_VC_ARB_TABLE);
    eval 'sub PCI_VC_RESOURCE_CAP {
        my($n) = @_;
	    eval q((0x10 + (($n) * 0xc)));
    }' unless defined(&PCI_VC_RESOURCE_CAP);
    eval 'sub PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_HW_FIXED_SCHEME () { &__BIT(0);}' unless defined(&PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_HW_FIXED_SCHEME);
    eval 'sub PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_WRR_32 () { &__BIT(1);}' unless defined(&PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_WRR_32);
    eval 'sub PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_WRR_64 () { &__BIT(2);}' unless defined(&PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_WRR_64);
    eval 'sub PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_WRR_128 () { &__BIT(3);}' unless defined(&PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_WRR_128);
    eval 'sub PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_TWRR_128 () { &__BIT(4);}' unless defined(&PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_TWRR_128);
    eval 'sub PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_WRR_256 () { &__BIT(5);}' unless defined(&PCI_VC_RESOURCE_CAP_PORT_ARB_CAP_WRR_256);
    eval 'sub PCI_VC_RESOURCE_CAP_ADV_PKT_SWITCH () { &__BIT(14);}' unless defined(&PCI_VC_RESOURCE_CAP_ADV_PKT_SWITCH);
    eval 'sub PCI_VC_RESOURCE_CAP_REJCT_SNOOP_TRANS () { &__BIT(15);}' unless defined(&PCI_VC_RESOURCE_CAP_REJCT_SNOOP_TRANS);
    eval 'sub PCI_VC_RESOURCE_CAP_MAX_TIME_SLOTS () { &__BITS(22, 16);}' unless defined(&PCI_VC_RESOURCE_CAP_MAX_TIME_SLOTS);
    eval 'sub PCI_VC_RESOURCE_CAP_PORT_ARB_TABLE_OFFSET () { &__BITS(31, 24);}' unless defined(&PCI_VC_RESOURCE_CAP_PORT_ARB_TABLE_OFFSET);
    eval 'sub PCI_VC_RESOURCE_CTL {
        my($n) = @_;
	    eval q((0x14 + (($n) * 0xc)));
    }' unless defined(&PCI_VC_RESOURCE_CTL);
    eval 'sub PCI_VC_RESOURCE_CTL_TCVC_MAP () { &__BITS(7, 0);}' unless defined(&PCI_VC_RESOURCE_CTL_TCVC_MAP);
    eval 'sub PCI_VC_RESOURCE_CTL_LOAD_PORT_ARB_TABLE () { &__BIT(16);}' unless defined(&PCI_VC_RESOURCE_CTL_LOAD_PORT_ARB_TABLE);
    eval 'sub PCI_VC_RESOURCE_CTL_PORT_ARB_SELECT () { &__BITS(19, 17);}' unless defined(&PCI_VC_RESOURCE_CTL_PORT_ARB_SELECT);
    eval 'sub PCI_VC_RESOURCE_CTL_VC_ID () { &__BITS(26, 24);}' unless defined(&PCI_VC_RESOURCE_CTL_VC_ID);
    eval 'sub PCI_VC_RESOURCE_CTL_VC_ENABLE () { &__BIT(31);}' unless defined(&PCI_VC_RESOURCE_CTL_VC_ENABLE);
    eval 'sub PCI_VC_RESOURCE_STA {
        my($n) = @_;
	    eval q((0x18 + (($n) * 0xc)));
    }' unless defined(&PCI_VC_RESOURCE_STA);
    eval 'sub PCI_VC_RESOURCE_STA_PORT_ARB_TABLE () { &__BIT(0);}' unless defined(&PCI_VC_RESOURCE_STA_PORT_ARB_TABLE);
    eval 'sub PCI_VC_RESOURCE_STA_VC_NEG_PENDING () { &__BIT(1);}' unless defined(&PCI_VC_RESOURCE_STA_VC_NEG_PENDING);
    eval 'sub PCI_SERIAL_LOW () {0x4;}' unless defined(&PCI_SERIAL_LOW);
    eval 'sub PCI_SERIAL_HIGH () {0x8;}' unless defined(&PCI_SERIAL_HIGH);
    eval 'sub PCI_PWRBDGT_DSEL () {0x4;}' unless defined(&PCI_PWRBDGT_DSEL);
    eval 'sub PCI_PWRBDGT_DATA () {0x8;}' unless defined(&PCI_PWRBDGT_DATA);
    eval 'sub PCI_PWRBDGT_DATA_BASEPWR () { &__BITS(7, 0);}' unless defined(&PCI_PWRBDGT_DATA_BASEPWR);
    eval 'sub PCI_PWRBDGT_DATA_SCALE () { &__BITS(9, 8);}' unless defined(&PCI_PWRBDGT_DATA_SCALE);
    eval 'sub PCI_PWRBDGT_PM_SUBSTAT () { &__BITS(12, 10);}' unless defined(&PCI_PWRBDGT_PM_SUBSTAT);
    eval 'sub PCI_PWRBDGT_PM_STAT () { &__BITS(14, 13);}' unless defined(&PCI_PWRBDGT_PM_STAT);
    eval 'sub PCI_PWRBDGT_TYPE () { &__BITS(17, 15);}' unless defined(&PCI_PWRBDGT_TYPE);
    eval 'sub PCI_PWRBDGT_PWRRAIL () { &__BITS(20, 18);}' unless defined(&PCI_PWRBDGT_PWRRAIL);
    eval 'sub PCI_PWRBDGT_CAP () {0xc;}' unless defined(&PCI_PWRBDGT_CAP);
    eval 'sub PCI_PWRBDGT_CAP_SYSALLOC () { &__BIT(0);}' unless defined(&PCI_PWRBDGT_CAP_SYSALLOC);
    eval 'sub PCI_RCLINK_DCL_ESDESC () {0x4;}' unless defined(&PCI_RCLINK_DCL_ESDESC);
    eval 'sub PCI_RCLINK_DCL_ESDESC_ELMTYPE () { &__BITS(3, 0);}' unless defined(&PCI_RCLINK_DCL_ESDESC_ELMTYPE);
    eval 'sub PCI_RCLINK_DCL_ESDESC_NUMLINKENT () { &__BITS(15, 8);}' unless defined(&PCI_RCLINK_DCL_ESDESC_NUMLINKENT);
    eval 'sub PCI_RCLINK_DCL_ESDESC_COMPID () { &__BITS(23, 16);}' unless defined(&PCI_RCLINK_DCL_ESDESC_COMPID);
    eval 'sub PCI_RCLINK_DCL_ESDESC_PORTNUM () { &__BITS(31, 24);}' unless defined(&PCI_RCLINK_DCL_ESDESC_PORTNUM);
    eval 'sub PCI_RCLINK_DCL_LINKENTS () {0x10;}' unless defined(&PCI_RCLINK_DCL_LINKENTS);
    eval 'sub PCI_RCLINK_DCL_LINKDESC {
        my($x) = @_;
	    eval q(( &PCI_RCLINK_DCL_LINKENTS + (($x) * 16)));
    }' unless defined(&PCI_RCLINK_DCL_LINKDESC);
    eval 'sub PCI_RCLINK_DCL_LINKDESC_LVALID () { &__BIT(0);}' unless defined(&PCI_RCLINK_DCL_LINKDESC_LVALID);
    eval 'sub PCI_RCLINK_DCL_LINKDESC_LTYPE () { &__BIT(1);}' unless defined(&PCI_RCLINK_DCL_LINKDESC_LTYPE);
    eval 'sub PCI_RCLINK_DCL_LINKDESC_ARCRBH () { &__BIT(2);}' unless defined(&PCI_RCLINK_DCL_LINKDESC_ARCRBH);
    eval 'sub PCI_RCLINK_DCL_LINKDESC_TCOMPID () { &__BITS(23, 16);}' unless defined(&PCI_RCLINK_DCL_LINKDESC_TCOMPID);
    eval 'sub PCI_RCLINK_DCL_LINKDESC_TPNUM () { &__BITS(31, 24);}' unless defined(&PCI_RCLINK_DCL_LINKDESC_TPNUM);
    eval 'sub PCI_RCLINK_DCL_LINKADDR_LT0_LO {
        my($x) = @_;
	    eval q(( &PCI_RCLINK_DCL_LINKENTS + (($x) * 16) + 0x8));
    }' unless defined(&PCI_RCLINK_DCL_LINKADDR_LT0_LO);
    eval 'sub PCI_RCLINK_DCL_LINKADDR_LT0_HI {
        my($x) = @_;
	    eval q(( &PCI_RCLINK_DCL_LINKENTS + (($x) * 16) + 0xc));
    }' unless defined(&PCI_RCLINK_DCL_LINKADDR_LT0_HI);
    eval 'sub PCI_RCLINK_DCL_LINKADDR_LT1_LO {
        my($x) = @_;
	    eval q(( &PCI_RCLINK_DCL_LINKENTS + (($x) * 16) + 0x8));
    }' unless defined(&PCI_RCLINK_DCL_LINKADDR_LT1_LO);
    eval 'sub PCI_RCLINK_DCL_LINKADDR_LT1_N () { &__BITS(2, 0);}' unless defined(&PCI_RCLINK_DCL_LINKADDR_LT1_N);
    eval 'sub PCI_RCLINK_DCL_LINKADDR_LT1_FUNC () { &__BITS(14, 12);}' unless defined(&PCI_RCLINK_DCL_LINKADDR_LT1_FUNC);
    eval 'sub PCI_RCLINK_DCL_LINKADDR_LT1_DEV () { &__BITS(19, 15);}' unless defined(&PCI_RCLINK_DCL_LINKADDR_LT1_DEV);
    eval 'sub PCI_RCLINK_DCL_LINKADDR_LT1_BUS {
        my($N) = @_;
	    eval q( &__BITS(19+ ($N), 20));
    }' unless defined(&PCI_RCLINK_DCL_LINKADDR_LT1_BUS);
    eval 'sub PCI_RCLINK_DCL_LINKADDR_LT1_BAL {
        my($N) = @_;
	    eval q( &__BITS(31, 20+ ($N)));
    }' unless defined(&PCI_RCLINK_DCL_LINKADDR_LT1_BAL);
    eval 'sub PCI_RCLINK_DCL_LINKADDR_LT1_HI {
        my($x) = @_;
	    eval q(( &PCI_RCLINK_DCL_LINKENTS + (($x) * 16) + 0xc));
    }' unless defined(&PCI_RCLINK_DCL_LINKADDR_LT1_HI);
    eval 'sub PCI_RCEC_ASSOC_ASSOCBITMAP () {0x4;}' unless defined(&PCI_RCEC_ASSOC_ASSOCBITMAP);
    eval 'sub PCI_RCEC_ASSOC_ASSOCBUSNUM () {0x8;}' unless defined(&PCI_RCEC_ASSOC_ASSOCBUSNUM);
    eval 'sub PCI_RCEC_ASSOCBUSNUM_RCECNEXT () { &__BITS(15, 8);}' unless defined(&PCI_RCEC_ASSOCBUSNUM_RCECNEXT);
    eval 'sub PCI_RCEC_ASSOCBUSNUM_RCECLAST () { &__BITS(23, 16);}' unless defined(&PCI_RCEC_ASSOCBUSNUM_RCECLAST);
    eval 'sub PCI_ACS_CAP () {0x4;}' unless defined(&PCI_ACS_CAP);
    eval 'sub PCI_ACS_CAP_V () { &__BIT(0);}' unless defined(&PCI_ACS_CAP_V);
    eval 'sub PCI_ACS_CAP_B () { &__BIT(1);}' unless defined(&PCI_ACS_CAP_B);
    eval 'sub PCI_ACS_CAP_R () { &__BIT(2);}' unless defined(&PCI_ACS_CAP_R);
    eval 'sub PCI_ACS_CAP_C () { &__BIT(3);}' unless defined(&PCI_ACS_CAP_C);
    eval 'sub PCI_ACS_CAP_U () { &__BIT(4);}' unless defined(&PCI_ACS_CAP_U);
    eval 'sub PCI_ACS_CAP_E () { &__BIT(5);}' unless defined(&PCI_ACS_CAP_E);
    eval 'sub PCI_ACS_CAP_T () { &__BIT(6);}' unless defined(&PCI_ACS_CAP_T);
    eval 'sub PCI_ACS_CAP_ECVSIZE () { &__BITS(15, 8);}' unless defined(&PCI_ACS_CAP_ECVSIZE);
    eval 'sub PCI_ACS_CTL () {0x4;}' unless defined(&PCI_ACS_CTL);
    eval 'sub PCI_ACS_CTL_V () { &__BIT(0+ 16);}' unless defined(&PCI_ACS_CTL_V);
    eval 'sub PCI_ACS_CTL_B () { &__BIT(1+ 16);}' unless defined(&PCI_ACS_CTL_B);
    eval 'sub PCI_ACS_CTL_R () { &__BIT(2+ 16);}' unless defined(&PCI_ACS_CTL_R);
    eval 'sub PCI_ACS_CTL_C () { &__BIT(3+ 16);}' unless defined(&PCI_ACS_CTL_C);
    eval 'sub PCI_ACS_CTL_U () { &__BIT(4+ 16);}' unless defined(&PCI_ACS_CTL_U);
    eval 'sub PCI_ACS_CTL_E () { &__BIT(5+ 16);}' unless defined(&PCI_ACS_CTL_E);
    eval 'sub PCI_ACS_CTL_T () { &__BIT(6+ 16);}' unless defined(&PCI_ACS_CTL_T);
    eval 'sub PCI_ACS_ECV () {0x8;}' unless defined(&PCI_ACS_ECV);
    eval 'sub PCI_ARI_CAP () {0x4;}' unless defined(&PCI_ARI_CAP);
    eval 'sub PCI_ARI_CAP_M () { &__BIT(0);}' unless defined(&PCI_ARI_CAP_M);
    eval 'sub PCI_ARI_CAP_A () { &__BIT(1);}' unless defined(&PCI_ARI_CAP_A);
    eval 'sub PCI_ARI_CAP_NXTFN () { &__BITS(15, 8);}' unless defined(&PCI_ARI_CAP_NXTFN);
    eval 'sub PCI_ARI_CTL () {0x4;}' unless defined(&PCI_ARI_CTL);
    eval 'sub PCI_ARI_CTL_M () { &__BIT(16);}' unless defined(&PCI_ARI_CTL_M);
    eval 'sub PCI_ARI_CTL_A () { &__BIT(17);}' unless defined(&PCI_ARI_CTL_A);
    eval 'sub PCI_ARI_CTL_FUNCGRP () { &__BITS(22, 20);}' unless defined(&PCI_ARI_CTL_FUNCGRP);
    eval 'sub PCI_ATS_CAP () {0x4;}' unless defined(&PCI_ATS_CAP);
    eval 'sub PCI_ATS_CAP_INVQDEPTH () { &__BITS(4, 0);}' unless defined(&PCI_ATS_CAP_INVQDEPTH);
    eval 'sub PCI_ATS_CAP_PALIGNREQ () { &__BIT(5);}' unless defined(&PCI_ATS_CAP_PALIGNREQ);
    eval 'sub PCI_ATS_CAP_GLOBALINVL () { &__BIT(6);}' unless defined(&PCI_ATS_CAP_GLOBALINVL);
    eval 'sub PCI_ATS_CAP_RELAXORD () { &__BIT(7);}' unless defined(&PCI_ATS_CAP_RELAXORD);
    eval 'sub PCI_ATS_CTL () {0x4;}' unless defined(&PCI_ATS_CTL);
    eval 'sub PCI_ATS_CTL_STU () { &__BITS(20, 16);}' unless defined(&PCI_ATS_CTL_STU);
    eval 'sub PCI_ATS_CTL_EN () { &__BIT(31);}' unless defined(&PCI_ATS_CTL_EN);
    eval 'sub PCI_SRIOV_CAP () {0x4;}' unless defined(&PCI_SRIOV_CAP);
    eval 'sub PCI_SRIOV_CAP_VF_MIGRATION () { &__BIT(0);}' unless defined(&PCI_SRIOV_CAP_VF_MIGRATION);
    eval 'sub PCI_SRIOV_CAP_ARI_CAP_HIER_PRESERVED () { &__BIT(1);}' unless defined(&PCI_SRIOV_CAP_ARI_CAP_HIER_PRESERVED);
    eval 'sub PCI_SRIOV_CAP_VF_MIGRATION_INTMSG_N () { &__BITS(31, 21);}' unless defined(&PCI_SRIOV_CAP_VF_MIGRATION_INTMSG_N);
    eval 'sub PCI_SRIOV_CTL () {0x8;}' unless defined(&PCI_SRIOV_CTL);
    eval 'sub PCI_SRIOV_CTL_VF_ENABLE () { &__BIT(0);}' unless defined(&PCI_SRIOV_CTL_VF_ENABLE);
    eval 'sub PCI_SRIOV_CTL_VF_MIGRATION_SUPPORT () { &__BIT(1);}' unless defined(&PCI_SRIOV_CTL_VF_MIGRATION_SUPPORT);
    eval 'sub PCI_SRIOV_CTL_VF_MIGRATION_INT_ENABLE () { &__BIT(2);}' unless defined(&PCI_SRIOV_CTL_VF_MIGRATION_INT_ENABLE);
    eval 'sub PCI_SRIOV_CTL_VF_MSE () { &__BIT(3);}' unless defined(&PCI_SRIOV_CTL_VF_MSE);
    eval 'sub PCI_SRIOV_CTL_ARI_CAP_HIER () { &__BIT(4);}' unless defined(&PCI_SRIOV_CTL_ARI_CAP_HIER);
    eval 'sub PCI_SRIOV_STA () {0xa;}' unless defined(&PCI_SRIOV_STA);
    eval 'sub PCI_SRIOV_STA_VF_MIGRATION () { &__BIT(0);}' unless defined(&PCI_SRIOV_STA_VF_MIGRATION);
    eval 'sub PCI_SRIOV_INITIAL_VFS () {0xc;}' unless defined(&PCI_SRIOV_INITIAL_VFS);
    eval 'sub PCI_SRIOV_TOTAL_VFS () {0xe;}' unless defined(&PCI_SRIOV_TOTAL_VFS);
    eval 'sub PCI_SRIOV_NUM_VFS () {0x10;}' unless defined(&PCI_SRIOV_NUM_VFS);
    eval 'sub PCI_SRIOV_FUNC_DEP_LINK () {0x12;}' unless defined(&PCI_SRIOV_FUNC_DEP_LINK);
    eval 'sub PCI_SRIOV_VF_OFF () {0x14;}' unless defined(&PCI_SRIOV_VF_OFF);
    eval 'sub PCI_SRIOV_VF_STRIDE () {0x16;}' unless defined(&PCI_SRIOV_VF_STRIDE);
    eval 'sub PCI_SRIOV_VF_DID () {0x1a;}' unless defined(&PCI_SRIOV_VF_DID);
    eval 'sub PCI_SRIOV_PAGE_CAP () {0x1c;}' unless defined(&PCI_SRIOV_PAGE_CAP);
    eval 'sub PCI_SRIOV_PAGE_SIZE () {0x20;}' unless defined(&PCI_SRIOV_PAGE_SIZE);
    eval 'sub PCI_SRIOV_BASE_PAGE_SHIFT () {12;}' unless defined(&PCI_SRIOV_BASE_PAGE_SHIFT);
    eval 'sub PCI_SRIOV_BARS () {0x24;}' unless defined(&PCI_SRIOV_BARS);
    eval 'sub PCI_SRIOV_BAR {
        my($x) = @_;
	    eval q(( &PCI_SRIOV_BARS + (($x) * 4)));
    }' unless defined(&PCI_SRIOV_BAR);
    eval 'sub PCI_SRIOV_VF_MIG_STA_AR () {0x3c;}' unless defined(&PCI_SRIOV_VF_MIG_STA_AR);
    eval 'sub PCI_SRIOV_VF_MIG_STA_OFFSET () { &__BITS(31, 3);}' unless defined(&PCI_SRIOV_VF_MIG_STA_OFFSET);
    eval 'sub PCI_SRIOV_VF_MIG_STA_BIR () { &__BITS(2, 0);}' unless defined(&PCI_SRIOV_VF_MIG_STA_BIR);
    eval 'sub PCI_MCAST_CAP () {0x4;}' unless defined(&PCI_MCAST_CAP);
    eval 'sub PCI_MCAST_CAP_MAXGRP () { &__BITS(5, 0);}' unless defined(&PCI_MCAST_CAP_MAXGRP);
    eval 'sub PCI_MCAST_CAP_WINSIZEREQ () { &__BITS(13, 8);}' unless defined(&PCI_MCAST_CAP_WINSIZEREQ);
    eval 'sub PCI_MCAST_CAP_ECRCREGEN () { &__BIT(15);}' unless defined(&PCI_MCAST_CAP_ECRCREGEN);
    eval 'sub PCI_MCAST_CTL () {0x4;}' unless defined(&PCI_MCAST_CTL);
    eval 'sub PCI_MCAST_CTL_NUMGRP () { &__BITS(5+16, 16);}' unless defined(&PCI_MCAST_CTL_NUMGRP);
    eval 'sub PCI_MCAST_CTL_ENA () { &__BIT(15+16);}' unless defined(&PCI_MCAST_CTL_ENA);
    eval 'sub PCI_MCAST_BARL () {0x8;}' unless defined(&PCI_MCAST_BARL);
    eval 'sub PCI_MCAST_BARL_INDPOS () { &__BITS(5, 0);}' unless defined(&PCI_MCAST_BARL_INDPOS);
    eval 'sub PCI_MCAST_BARL_ADDR () { &__BITS(31, 12);}' unless defined(&PCI_MCAST_BARL_ADDR);
    eval 'sub PCI_MCAST_BARH () {0xc;}' unless defined(&PCI_MCAST_BARH);
    eval 'sub PCI_MCAST_RECVL () {0x10;}' unless defined(&PCI_MCAST_RECVL);
    eval 'sub PCI_MCAST_RECVH () {0x14;}' unless defined(&PCI_MCAST_RECVH);
    eval 'sub PCI_MCAST_BLOCKALLL () {0x18;}' unless defined(&PCI_MCAST_BLOCKALLL);
    eval 'sub PCI_MCAST_BLOCKALLH () {0x1c;}' unless defined(&PCI_MCAST_BLOCKALLH);
    eval 'sub PCI_MCAST_BLOCKUNTRNSL () {0x20;}' unless defined(&PCI_MCAST_BLOCKUNTRNSL);
    eval 'sub PCI_MCAST_BLOCKUNTRNSH () {0x24;}' unless defined(&PCI_MCAST_BLOCKUNTRNSH);
    eval 'sub PCI_MCAST_OVERLAYL () {0x28;}' unless defined(&PCI_MCAST_OVERLAYL);
    eval 'sub PCI_MCAST_OVERLAYL_SIZE () { &__BITS(5, 0);}' unless defined(&PCI_MCAST_OVERLAYL_SIZE);
    eval 'sub PCI_MCAST_OVERLAYL_ADDR () { &__BITS(31, 6);}' unless defined(&PCI_MCAST_OVERLAYL_ADDR);
    eval 'sub PCI_MCAST_OVERLAYH () {0x2c;}' unless defined(&PCI_MCAST_OVERLAYH);
    eval 'sub PCI_PAGE_REQ_CTL () {0x4;}' unless defined(&PCI_PAGE_REQ_CTL);
    eval 'sub PCI_PAGE_REQ_CTL_E () { &__BIT(0);}' unless defined(&PCI_PAGE_REQ_CTL_E);
    eval 'sub PCI_PAGE_REQ_CTL_R () { &__BIT(1);}' unless defined(&PCI_PAGE_REQ_CTL_R);
    eval 'sub PCI_PAGE_REQ_STA () {0x4;}' unless defined(&PCI_PAGE_REQ_STA);
    eval 'sub PCI_PAGE_REQ_STA_RF () { &__BIT(0+16);}' unless defined(&PCI_PAGE_REQ_STA_RF);
    eval 'sub PCI_PAGE_REQ_STA_UPRGI () { &__BIT(1+16);}' unless defined(&PCI_PAGE_REQ_STA_UPRGI);
    eval 'sub PCI_PAGE_REQ_STA_S () { &__BIT(8+16);}' unless defined(&PCI_PAGE_REQ_STA_S);
    eval 'sub PCI_PAGE_REQ_STA_PASIDR () { &__BIT(15+16);}' unless defined(&PCI_PAGE_REQ_STA_PASIDR);
    eval 'sub PCI_PAGE_REQ_OUTSTCAPA () {0x8;}' unless defined(&PCI_PAGE_REQ_OUTSTCAPA);
    eval 'sub PCI_PAGE_REQ_OUTSTALLOC () {0xc;}' unless defined(&PCI_PAGE_REQ_OUTSTALLOC);
    eval 'sub PCI_EA_CAP1 () {0x;}' unless defined(&PCI_EA_CAP1);
    eval 'sub PCI_EA_CAP1_NUMENTRIES () { &__BITS(21, 16);}' unless defined(&PCI_EA_CAP1_NUMENTRIES);
    eval 'sub PCI_EA_CAP2 () {0x4;}' unless defined(&PCI_EA_CAP2);
    eval 'sub PCI_EA_CAP2_SECONDARY () { &__BITS(7, 0);}' unless defined(&PCI_EA_CAP2_SECONDARY);
    eval 'sub PCI_EA_CAP2_SUBORDINATE () { &__BITS(15, 8);}' unless defined(&PCI_EA_CAP2_SUBORDINATE);
    eval 'sub PCI_EA_ES () { &__BITS(2, 0);}' unless defined(&PCI_EA_ES);
    eval 'sub PCI_EA_BEI () { &__BITS(7, 4);}' unless defined(&PCI_EA_BEI);
    eval 'sub PCI_EA_BEI_BAR0 () {0;}' unless defined(&PCI_EA_BEI_BAR0);
    eval 'sub PCI_EA_BEI_BAR1 () {1;}' unless defined(&PCI_EA_BEI_BAR1);
    eval 'sub PCI_EA_BEI_BAR2 () {2;}' unless defined(&PCI_EA_BEI_BAR2);
    eval 'sub PCI_EA_BEI_BAR3 () {3;}' unless defined(&PCI_EA_BEI_BAR3);
    eval 'sub PCI_EA_BEI_BAR4 () {4;}' unless defined(&PCI_EA_BEI_BAR4);
    eval 'sub PCI_EA_BEI_BAR5 () {5;}' unless defined(&PCI_EA_BEI_BAR5);
    eval 'sub PCI_EA_BEI_BEHIND () {6;}' unless defined(&PCI_EA_BEI_BEHIND);
    eval 'sub PCI_EA_BEI_NOTIND () {7;}' unless defined(&PCI_EA_BEI_NOTIND);
    eval 'sub PCI_EA_BEI_EXPROM () {8;}' unless defined(&PCI_EA_BEI_EXPROM);
    eval 'sub PCI_EA_BEI_VFBAR0 () {9;}' unless defined(&PCI_EA_BEI_VFBAR0);
    eval 'sub PCI_EA_BEI_VFBAR1 () {10;}' unless defined(&PCI_EA_BEI_VFBAR1);
    eval 'sub PCI_EA_BEI_VFBAR2 () {11;}' unless defined(&PCI_EA_BEI_VFBAR2);
    eval 'sub PCI_EA_BEI_VFBAR3 () {12;}' unless defined(&PCI_EA_BEI_VFBAR3);
    eval 'sub PCI_EA_BEI_VFBAR4 () {13;}' unless defined(&PCI_EA_BEI_VFBAR4);
    eval 'sub PCI_EA_BEI_VFBAR5 () {14;}' unless defined(&PCI_EA_BEI_VFBAR5);
    eval 'sub PCI_EA_BEI_RESERVED () {15;}' unless defined(&PCI_EA_BEI_RESERVED);
    eval 'sub PCI_EA_PP () { &__BITS(15, 8);}' unless defined(&PCI_EA_PP);
    eval 'sub PCI_EA_SP () { &__BITS(23, 16);}' unless defined(&PCI_EA_SP);
    eval 'sub PCI_EA_PROP_MEM_NONPREF () {0x;}' unless defined(&PCI_EA_PROP_MEM_NONPREF);
    eval 'sub PCI_EA_PROP_MEM_PREF () {0x1;}' unless defined(&PCI_EA_PROP_MEM_PREF);
    eval 'sub PCI_EA_PROP_IO () {0x2;}' unless defined(&PCI_EA_PROP_IO);
    eval 'sub PCI_EA_PROP_VF_MEM_NONPREF () {0x3;}' unless defined(&PCI_EA_PROP_VF_MEM_NONPREF);
    eval 'sub PCI_EA_PROP_VF_MEM_PREF () {0x4;}' unless defined(&PCI_EA_PROP_VF_MEM_PREF);
    eval 'sub PCI_EA_PROP_BB_MEM_NONPREF () {0x5;}' unless defined(&PCI_EA_PROP_BB_MEM_NONPREF);
    eval 'sub PCI_EA_PROP_BB_MEM_PREF () {0x6;}' unless defined(&PCI_EA_PROP_BB_MEM_PREF);
    eval 'sub PCI_EA_PROP_BB_IO () {0x7;}' unless defined(&PCI_EA_PROP_BB_IO);
    eval 'sub PCI_EA_PROP_MEM_UNAVAIL () {0xfd;}' unless defined(&PCI_EA_PROP_MEM_UNAVAIL);
    eval 'sub PCI_EA_PROP_IO_UNAVAIL () {0xfe;}' unless defined(&PCI_EA_PROP_IO_UNAVAIL);
    eval 'sub PCI_EA_PROP_UNAVAIL () {0xff;}' unless defined(&PCI_EA_PROP_UNAVAIL);
    eval 'sub PCI_EA_W () { &__BIT(30);}' unless defined(&PCI_EA_W);
    eval 'sub PCI_EA_E () { &__BIT(31);}' unless defined(&PCI_EA_E);
    eval 'sub PCI_EA_LOWMASK () { &__BITS(31, 2);}' unless defined(&PCI_EA_LOWMASK);
    eval 'sub PCI_EA_BASEMAXOFFSET_S () { &__BIT(1);}' unless defined(&PCI_EA_BASEMAXOFFSET_S);
    eval 'sub PCI_EA_BASEMAXOFFSET_64BIT () { &__BIT(1);}' unless defined(&PCI_EA_BASEMAXOFFSET_64BIT);
    eval 'sub PCI_EA_BASEMAXOFFSET_32BIT () {0;}' unless defined(&PCI_EA_BASEMAXOFFSET_32BIT);
    eval 'sub PCI_RESIZBAR_CAP0 () {0x4;}' unless defined(&PCI_RESIZBAR_CAP0);
    eval 'sub PCI_RESIZBAR_CAP {
        my($x) = @_;
	    eval q(( &PCI_RESIZBAR_CAP0 + (($x) * 8)));
    }' unless defined(&PCI_RESIZBAR_CAP);
    eval 'sub PCI_RESIZBAR_CAP_SIZEMASK () { &__BITS(23, 4);}' unless defined(&PCI_RESIZBAR_CAP_SIZEMASK);
    eval 'sub PCI_RESIZBAR_CTL0 () {0x8;}' unless defined(&PCI_RESIZBAR_CTL0);
    eval 'sub PCI_RESIZBAR_CTL {
        my($x) = @_;
	    eval q(( &PCI_RESIZBAR_CTL0 + (($x) * 8)));
    }' unless defined(&PCI_RESIZBAR_CTL);
    eval 'sub PCI_RESIZBAR_CTL_BARIDX () { &__BITS(2, 0);}' unless defined(&PCI_RESIZBAR_CTL_BARIDX);
    eval 'sub PCI_RESIZBAR_CTL_NUMBAR () { &__BITS(7, 5);}' unless defined(&PCI_RESIZBAR_CTL_NUMBAR);
    eval 'sub PCI_RESIZBAR_CTL_BARSIZ () { &__BITS(12, 8);}' unless defined(&PCI_RESIZBAR_CTL_BARSIZ);
    eval 'sub PCI_DPA_CAP () {0x4;}' unless defined(&PCI_DPA_CAP);
    eval 'sub PCI_DPA_CAP_SUBSTMAX () { &__BITS(4, 0);}' unless defined(&PCI_DPA_CAP_SUBSTMAX);
    eval 'sub PCI_DPA_CAP_TLUINT () { &__BITS(9, 8);}' unless defined(&PCI_DPA_CAP_TLUINT);
    eval 'sub PCI_DPA_CAP_PAS () { &__BITS(13, 12);}' unless defined(&PCI_DPA_CAP_PAS);
    eval 'sub PCI_DPA_CAP_XLCY0 () { &__BITS(23, 16);}' unless defined(&PCI_DPA_CAP_XLCY0);
    eval 'sub PCI_DPA_CAP_XLCY1 () { &__BITS(31, 24);}' unless defined(&PCI_DPA_CAP_XLCY1);
    eval 'sub PCI_DPA_LATIND () {0x8;}' unless defined(&PCI_DPA_LATIND);
    eval 'sub PCI_DPA_CS () {0xc;}' unless defined(&PCI_DPA_CS);
    eval 'sub PCI_DPA_CS_SUBSTSTAT () { &__BITS(4, 0);}' unless defined(&PCI_DPA_CS_SUBSTSTAT);
    eval 'sub PCI_DPA_CS_SUBSTCTLEN () { &__BIT(8);}' unless defined(&PCI_DPA_CS_SUBSTCTLEN);
    eval 'sub PCI_DPA_CS_SUBSTCTL () { &__BITS(20, 16);}' unless defined(&PCI_DPA_CS_SUBSTCTL);
    eval 'sub PCI_DPA_PWRALLOC () {0x10;}' unless defined(&PCI_DPA_PWRALLOC);
    eval 'sub PCI_DPA_SUBST_MAXNUM () {32;}' unless defined(&PCI_DPA_SUBST_MAXNUM);
    eval 'sub PCI_TPH_REQ_CAP () {0x4;}' unless defined(&PCI_TPH_REQ_CAP);
    eval 'sub PCI_TPH_REQ_CAP_NOST () { &__BIT(0);}' unless defined(&PCI_TPH_REQ_CAP_NOST);
    eval 'sub PCI_TPH_REQ_CAP_INTVEC () { &__BIT(1);}' unless defined(&PCI_TPH_REQ_CAP_INTVEC);
    eval 'sub PCI_TPH_REQ_CAP_DEVSPEC () { &__BIT(2);}' unless defined(&PCI_TPH_REQ_CAP_DEVSPEC);
    eval 'sub PCI_TPH_REQ_CAP_XTPHREQ () { &__BIT(8);}' unless defined(&PCI_TPH_REQ_CAP_XTPHREQ);
    eval 'sub PCI_TPH_REQ_CAP_STTBLLOC () { &__BITS(10, 9);}' unless defined(&PCI_TPH_REQ_CAP_STTBLLOC);
    eval 'sub PCI_TPH_REQ_STTBLLOC_NONE () {0;}' unless defined(&PCI_TPH_REQ_STTBLLOC_NONE);
    eval 'sub PCI_TPH_REQ_STTBLLOC_TPHREQ () {1;}' unless defined(&PCI_TPH_REQ_STTBLLOC_TPHREQ);
    eval 'sub PCI_TPH_REQ_STTBLLOC_MSIX () {2;}' unless defined(&PCI_TPH_REQ_STTBLLOC_MSIX);
    eval 'sub PCI_TPH_REQ_CAP_STTBLSIZ () { &__BITS(26, 16);}' unless defined(&PCI_TPH_REQ_CAP_STTBLSIZ);
    eval 'sub PCI_TPH_REQ_CTL () {0x8;}' unless defined(&PCI_TPH_REQ_CTL);
    eval 'sub PCI_TPH_REQ_CTL_STSEL () { &__BITS(2, 0);}' unless defined(&PCI_TPH_REQ_CTL_STSEL);
    eval 'sub PCI_TPH_REQ_CTL_STSEL_NO () {0;}' unless defined(&PCI_TPH_REQ_CTL_STSEL_NO);
    eval 'sub PCI_TPH_REQ_CTL_STSEL_IV () {1;}' unless defined(&PCI_TPH_REQ_CTL_STSEL_IV);
    eval 'sub PCI_TPH_REQ_CTL_STSEL_DS () {2;}' unless defined(&PCI_TPH_REQ_CTL_STSEL_DS);
    eval 'sub PCI_TPH_REQ_CTL_TPHREQEN () { &__BITS(9, 8);}' unless defined(&PCI_TPH_REQ_CTL_TPHREQEN);
    eval 'sub PCI_TPH_REQ_CTL_TPHREQEN_NO () {0;}' unless defined(&PCI_TPH_REQ_CTL_TPHREQEN_NO);
    eval 'sub PCI_TPH_REQ_CTL_TPHREQEN_TPH () {1;}' unless defined(&PCI_TPH_REQ_CTL_TPHREQEN_TPH);
    eval 'sub PCI_TPH_REQ_CTL_TPHREQEN_RSVD () {2;}' unless defined(&PCI_TPH_REQ_CTL_TPHREQEN_RSVD);
    eval 'sub PCI_TPH_REQ_CTL_TPHREQEN_ETPH () {3;}' unless defined(&PCI_TPH_REQ_CTL_TPHREQEN_ETPH);
    eval 'sub PCI_TPH_REQ_STTBL () {0xc;}' unless defined(&PCI_TPH_REQ_STTBL);
    eval 'sub PCI_LTR_MAXSNOOPLAT () {0x4;}' unless defined(&PCI_LTR_MAXSNOOPLAT);
    eval 'sub PCI_LTR_MAXSNOOPLAT_VAL () { &__BITS(9, 0);}' unless defined(&PCI_LTR_MAXSNOOPLAT_VAL);
    eval 'sub PCI_LTR_MAXSNOOPLAT_SCALE () { &__BITS(12, 10);}' unless defined(&PCI_LTR_MAXSNOOPLAT_SCALE);
    eval 'sub PCI_LTR_MAXNOSNOOPLAT () {0x4;}' unless defined(&PCI_LTR_MAXNOSNOOPLAT);
    eval 'sub PCI_LTR_MAXNOSNOOPLAT_VAL () { &__BITS(25, 16);}' unless defined(&PCI_LTR_MAXNOSNOOPLAT_VAL);
    eval 'sub PCI_LTR_MAXNOSNOOPLAT_SCALE () { &__BITS(28, 26);}' unless defined(&PCI_LTR_MAXNOSNOOPLAT_SCALE);
    eval 'sub PCI_LTR_SCALETONS {
        my($x) = @_;
	    eval q((1<< (($x) * 5)));
    }' unless defined(&PCI_LTR_SCALETONS);
    eval 'sub PCI_SECPCIE_LCTL3 () {0x4;}' unless defined(&PCI_SECPCIE_LCTL3);
    eval 'sub PCI_SECPCIE_LCTL3_PERFEQ () { &__BIT(0);}' unless defined(&PCI_SECPCIE_LCTL3_PERFEQ);
    eval 'sub PCI_SECPCIE_LCTL3_LINKEQREQ_IE () { &__BIT(1);}' unless defined(&PCI_SECPCIE_LCTL3_LINKEQREQ_IE);
    eval 'sub PCI_SECPCIE_LCTL3_ELSKPOSGENV () { &__BITS(15, 9);}' unless defined(&PCI_SECPCIE_LCTL3_ELSKPOSGENV);
    eval 'sub PCI_SECPCIE_LANEERR_STA () {0x8;}' unless defined(&PCI_SECPCIE_LANEERR_STA);
    eval 'sub PCI_SECPCIE_EQCTLS () {0xc;}' unless defined(&PCI_SECPCIE_EQCTLS);
    eval 'sub PCI_SECPCIE_EQCTL {
        my($x) = @_;
	    eval q(( &PCI_SECPCIE_EQCTLS + (($x) * 2)));
    }' unless defined(&PCI_SECPCIE_EQCTL);
    eval 'sub PCI_SECPCIE_EQCTL_DP_XMIT_PRESET () { &__BITS(3, 0);}' unless defined(&PCI_SECPCIE_EQCTL_DP_XMIT_PRESET);
    eval 'sub PCI_SECPCIE_EQCTL_DP_RCV_HINT () { &__BITS(6, 4);}' unless defined(&PCI_SECPCIE_EQCTL_DP_RCV_HINT);
    eval 'sub PCI_SECPCIE_EQCTL_UP_XMIT_PRESET () { &__BITS(11, 8);}' unless defined(&PCI_SECPCIE_EQCTL_UP_XMIT_PRESET);
    eval 'sub PCI_SECPCIE_EQCTL_UP_RCV_HINT () { &__BITS(14, 12);}' unless defined(&PCI_SECPCIE_EQCTL_UP_RCV_HINT);
    eval 'sub PCI_PASID_CAP () {0x4;}' unless defined(&PCI_PASID_CAP);
    eval 'sub PCI_PASID_CAP_XPERM () { &__BIT(1);}' unless defined(&PCI_PASID_CAP_XPERM);
    eval 'sub PCI_PASID_CAP_PRIVMODE () { &__BIT(2);}' unless defined(&PCI_PASID_CAP_PRIVMODE);
    eval 'sub PCI_PASID_CAP_MAXPASIDW () { &__BITS(12, 8);}' unless defined(&PCI_PASID_CAP_MAXPASIDW);
    eval 'sub PCI_PASID_CTL () {0x4;}' unless defined(&PCI_PASID_CTL);
    eval 'sub PCI_PASID_CTL_PASID_EN () { &__BIT(0+16);}' unless defined(&PCI_PASID_CTL_PASID_EN);
    eval 'sub PCI_PASID_CTL_XPERM_EN () { &__BIT(1+16);}' unless defined(&PCI_PASID_CTL_XPERM_EN);
    eval 'sub PCI_PASID_CTL_PRIVMODE_EN () { &__BIT(2+16);}' unless defined(&PCI_PASID_CTL_PRIVMODE_EN);
    eval 'sub PCI_LNR_CAP () {0x4;}' unless defined(&PCI_LNR_CAP);
    eval 'sub PCI_LNR_CAP_64 () { &__BIT(0);}' unless defined(&PCI_LNR_CAP_64);
    eval 'sub PCI_LNR_CAP_128 () { &__BIT(1);}' unless defined(&PCI_LNR_CAP_128);
    eval 'sub PCI_LNR_CAP_REGISTMAX () { &__BITS(12, 8);}' unless defined(&PCI_LNR_CAP_REGISTMAX);
    eval 'sub PCI_LNR_CTL () {0x4;}' unless defined(&PCI_LNR_CTL);
    eval 'sub PCI_LNR_CTL_EN () { &__BIT(0+16);}' unless defined(&PCI_LNR_CTL_EN);
    eval 'sub PCI_LNR_CTL_CLS () { &__BIT(1+16);}' unless defined(&PCI_LNR_CTL_CLS);
    eval 'sub PCI_LNR_CTL_REGISTLIM () { &__BITS(28, 24);}' unless defined(&PCI_LNR_CTL_REGISTLIM);
    eval 'sub PCI_DPC_CCR () {0x4;}' unless defined(&PCI_DPC_CCR);
    eval 'sub PCI_DPCCAP_IMSGN () { &__BITS(4, 0);}' unless defined(&PCI_DPCCAP_IMSGN);
    eval 'sub PCI_DPCCAP_RPEXT () { &__BIT(5);}' unless defined(&PCI_DPCCAP_RPEXT);
    eval 'sub PCI_DPCCAP_POISONTLPEB () { &__BIT(6);}' unless defined(&PCI_DPCCAP_POISONTLPEB);
    eval 'sub PCI_DPCCAP_SWTRIG () { &__BIT(7);}' unless defined(&PCI_DPCCAP_SWTRIG);
    eval 'sub PCI_DPCCAP_RPPIOLOGSZ () { &__BITS(11, 8);}' unless defined(&PCI_DPCCAP_RPPIOLOGSZ);
    eval 'sub PCI_DPCCAP_DLACTECORS () { &__BIT(12);}' unless defined(&PCI_DPCCAP_DLACTECORS);
    eval 'sub PCI_DPCCTL_TIRGEN () { &__BITS(17, 16);}' unless defined(&PCI_DPCCTL_TIRGEN);
    eval 'sub PCI_DPCCTL_COMPCTL () { &__BIT(18);}' unless defined(&PCI_DPCCTL_COMPCTL);
    eval 'sub PCI_DPCCTL_IE () { &__BIT(19);}' unless defined(&PCI_DPCCTL_IE);
    eval 'sub PCI_DPCCTL_ERRCOREN () { &__BIT(20);}' unless defined(&PCI_DPCCTL_ERRCOREN);
    eval 'sub PCI_DPCCTL_POISONTLPEB () { &__BIT(21);}' unless defined(&PCI_DPCCTL_POISONTLPEB);
    eval 'sub PCI_DPCCTL_SWTRIG () { &__BIT(22);}' unless defined(&PCI_DPCCTL_SWTRIG);
    eval 'sub PCI_DPCCTL_DLACTECOR () { &__BIT(23);}' unless defined(&PCI_DPCCTL_DLACTECOR);
    eval 'sub PCI_DPC_STATESID () {0x8;}' unless defined(&PCI_DPC_STATESID);
    eval 'sub PCI_DPCSTAT_TSTAT () { &__BIT(0);}' unless defined(&PCI_DPCSTAT_TSTAT);
    eval 'sub PCI_DPCSTAT_TREASON () { &__BITS(2, 1);}' unless defined(&PCI_DPCSTAT_TREASON);
    eval 'sub PCI_DPCSTAT_ISTAT () { &__BIT(3);}' unless defined(&PCI_DPCSTAT_ISTAT);
    eval 'sub PCI_DPCSTAT_RPBUSY () { &__BIT(4);}' unless defined(&PCI_DPCSTAT_RPBUSY);
    eval 'sub PCI_DPCSTAT_TRIGREXT () { &__BITS(6, 5);}' unless defined(&PCI_DPCSTAT_TRIGREXT);
    eval 'sub PCI_DPCSTAT_RPPIOFEP () { &__BITS(12, 8);}' unless defined(&PCI_DPCSTAT_RPPIOFEP);
    eval 'sub PCI_DPCESID () { &__BITS(31, 16);}' unless defined(&PCI_DPCESID);
    eval 'sub PCI_DPC_RPPIO_STAT () {0xc;}' unless defined(&PCI_DPC_RPPIO_STAT);
    eval 'sub PCI_DPC_RPPIO_CFGUR_CPL () { &__BIT(0);}' unless defined(&PCI_DPC_RPPIO_CFGUR_CPL);
    eval 'sub PCI_DPC_RPPIO_CFGCA_CPL () { &__BIT(1);}' unless defined(&PCI_DPC_RPPIO_CFGCA_CPL);
    eval 'sub PCI_DPC_RPPIO_CFG_CTO () { &__BIT(2);}' unless defined(&PCI_DPC_RPPIO_CFG_CTO);
    eval 'sub PCI_DPC_RPPIO_IOUR_CPL () { &__BIT(8);}' unless defined(&PCI_DPC_RPPIO_IOUR_CPL);
    eval 'sub PCI_DPC_RPPIO_IOCA_CPL () { &__BIT(9);}' unless defined(&PCI_DPC_RPPIO_IOCA_CPL);
    eval 'sub PCI_DPC_RPPIO_IO_CTO () { &__BIT(10);}' unless defined(&PCI_DPC_RPPIO_IO_CTO);
    eval 'sub PCI_DPC_RPPIO_MEMUR_CPL () { &__BIT(16);}' unless defined(&PCI_DPC_RPPIO_MEMUR_CPL);
    eval 'sub PCI_DPC_RPPIO_MEMCA_CPL () { &__BIT(17);}' unless defined(&PCI_DPC_RPPIO_MEMCA_CPL);
    eval 'sub PCI_DPC_RPPIO_MEM_CTO () { &__BIT(18);}' unless defined(&PCI_DPC_RPPIO_MEM_CTO);
    eval 'sub PCI_DPC_RPPIO_MASK () {0x10;}' unless defined(&PCI_DPC_RPPIO_MASK);
    eval 'sub PCI_DPC_RPPIO_SEVE () {0x14;}' unless defined(&PCI_DPC_RPPIO_SEVE);
    eval 'sub PCI_DPC_RPPIO_SYSERR () {0x18;}' unless defined(&PCI_DPC_RPPIO_SYSERR);
    eval 'sub PCI_DPC_RPPIO_EXCPT () {0x1c;}' unless defined(&PCI_DPC_RPPIO_EXCPT);
    eval 'sub PCI_DPC_RPPIO_HLOG () {0x20;}' unless defined(&PCI_DPC_RPPIO_HLOG);
    eval 'sub PCI_DPC_RPPIO_IMPSLOG () {0x30;}' unless defined(&PCI_DPC_RPPIO_IMPSLOG);
    eval 'sub PCI_DPC_RPPIO_TLPPLOG () {0x34;}' unless defined(&PCI_DPC_RPPIO_TLPPLOG);
    eval 'sub PCI_L1PM_CAP () {0x4;}' unless defined(&PCI_L1PM_CAP);
    eval 'sub PCI_L1PM_CAP_PCIPM12 () { &__BIT(0);}' unless defined(&PCI_L1PM_CAP_PCIPM12);
    eval 'sub PCI_L1PM_CAP_PCIPM11 () { &__BIT(1);}' unless defined(&PCI_L1PM_CAP_PCIPM11);
    eval 'sub PCI_L1PM_CAP_ASPM12 () { &__BIT(2);}' unless defined(&PCI_L1PM_CAP_ASPM12);
    eval 'sub PCI_L1PM_CAP_ASPM11 () { &__BIT(3);}' unless defined(&PCI_L1PM_CAP_ASPM11);
    eval 'sub PCI_L1PM_CAP_L1PM () { &__BIT(4);}' unless defined(&PCI_L1PM_CAP_L1PM);
    eval 'sub PCI_L1PM_CAP_LA () { &__BIT(5);}' unless defined(&PCI_L1PM_CAP_LA);
    eval 'sub PCI_L1PM_CAP_PCMRT () { &__BITS(15, 8);}' unless defined(&PCI_L1PM_CAP_PCMRT);
    eval 'sub PCI_L1PM_CAP_PTPOSCALE () { &__BITS(17, 16);}' unless defined(&PCI_L1PM_CAP_PTPOSCALE);
    eval 'sub PCI_L1PM_CAP_PTPOVAL () { &__BITS(23, 19);}' unless defined(&PCI_L1PM_CAP_PTPOVAL);
    eval 'sub PCI_L1PM_CTL1 () {0x8;}' unless defined(&PCI_L1PM_CTL1);
    eval 'sub PCI_L1PM_CTL1_PCIPM12_EN () { &__BIT(0);}' unless defined(&PCI_L1PM_CTL1_PCIPM12_EN);
    eval 'sub PCI_L1PM_CTL1_PCIPM11_EN () { &__BIT(1);}' unless defined(&PCI_L1PM_CTL1_PCIPM11_EN);
    eval 'sub PCI_L1PM_CTL1_ASPM12_EN () { &__BIT(2);}' unless defined(&PCI_L1PM_CTL1_ASPM12_EN);
    eval 'sub PCI_L1PM_CTL1_ASPM11_EN () { &__BIT(3);}' unless defined(&PCI_L1PM_CTL1_ASPM11_EN);
    eval 'sub PCI_L1PM_CTL1_LAIE () { &__BIT(4);}' unless defined(&PCI_L1PM_CTL1_LAIE);
    eval 'sub PCI_L1PM_CTL1_LA () { &__BIT(5);}' unless defined(&PCI_L1PM_CTL1_LA);
    eval 'sub PCI_L1PM_CTL1_CMRT () { &__BITS(15, 8);}' unless defined(&PCI_L1PM_CTL1_CMRT);
    eval 'sub PCI_L1PM_CTL1_LTRTHVAL () { &__BITS(25, 16);}' unless defined(&PCI_L1PM_CTL1_LTRTHVAL);
    eval 'sub PCI_L1PM_CTL1_LTRTHSCALE () { &__BITS(31, 29);}' unless defined(&PCI_L1PM_CTL1_LTRTHSCALE);
    eval 'sub PCI_L1PM_CTL2 () {0xc;}' unless defined(&PCI_L1PM_CTL2);
    eval 'sub PCI_L1PM_CTL2_TPOSCALE () { &__BITS(1, 0);}' unless defined(&PCI_L1PM_CTL2_TPOSCALE);
    eval 'sub PCI_L1PM_CTL2_TPOVAL () { &__BITS(7, 3);}' unless defined(&PCI_L1PM_CTL2_TPOVAL);
    eval 'sub PCI_L1PM_STAT () {0x10;}' unless defined(&PCI_L1PM_STAT);
    eval 'sub PCI_L1PM_STAT_LA () { &__BIT(0);}' unless defined(&PCI_L1PM_STAT_LA);
    eval 'sub PCI_PTM_CAP () {0x4;}' unless defined(&PCI_PTM_CAP);
    eval 'sub PCI_PTM_CAP_REQ () { &__BIT(0);}' unless defined(&PCI_PTM_CAP_REQ);
    eval 'sub PCI_PTM_CAP_RESP () { &__BIT(1);}' unless defined(&PCI_PTM_CAP_RESP);
    eval 'sub PCI_PTM_CAP_ROOT () { &__BIT(2);}' unless defined(&PCI_PTM_CAP_ROOT);
    eval 'sub PCI_PTM_CAP_LCLCLKGRNL () { &__BITS(15, 8);}' unless defined(&PCI_PTM_CAP_LCLCLKGRNL);
    eval 'sub PCI_PTM_CTL () {0x8;}' unless defined(&PCI_PTM_CTL);
    eval 'sub PCI_PTM_CTL_EN () { &__BIT(0);}' unless defined(&PCI_PTM_CTL_EN);
    eval 'sub PCI_PTM_CTL_ROOTSEL () { &__BIT(1);}' unless defined(&PCI_PTM_CTL_ROOTSEL);
    eval 'sub PCI_PTM_CTL_EFCTGRNL () { &__BITS(15, 8);}' unless defined(&PCI_PTM_CTL_EFCTGRNL);
    eval 'sub PCI_DLF_CAP () {0x4;}' unless defined(&PCI_DLF_CAP);
    eval 'sub PCI_DLF_LFEAT () { &__BITS(22, 0);}' unless defined(&PCI_DLF_LFEAT);
    eval 'sub PCI_DLF_LFEAT_SCLFCTL () { &__BIT(0);}' unless defined(&PCI_DLF_LFEAT_SCLFCTL);
    eval 'sub PCI_DLF_CAP_XCHG () { &__BIT(31);}' unless defined(&PCI_DLF_CAP_XCHG);
    eval 'sub PCI_DLF_STAT () {0x8;}' unless defined(&PCI_DLF_STAT);
    eval 'sub PCI_DLF_STAT_RMTVALID () { &__BIT(31);}' unless defined(&PCI_DLF_STAT_RMTVALID);
}
1;
