/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util.list;

import org.apache.activemq.apollo.util.list.SortedLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SortedLinkedListNode<T extends SortedLinkedListNode<T>> {
    protected SortedLinkedList<T> list;
    protected T next;
    protected T prev;

    private T getThis() {
        return (T)this;
    }

    public T getHeadNode() {
        return this.list.head;
    }

    public T getTailNode() {
        return ((SortedLinkedListNode)this.list.head).prev;
    }

    public T getNext() {
        return this.isTailNode() ? null : (T)this.next;
    }

    public T getPrevious() {
        return this.isHeadNode() ? null : (T)this.prev;
    }

    public T getNextCircular() {
        return this.next;
    }

    public T getPreviousCircular() {
        return this.prev;
    }

    public boolean isHeadNode() {
        return this.list.head == this;
    }

    public boolean isTailNode() {
        return ((SortedLinkedListNode)this.list.head).prev == this;
    }

    public boolean unlink() {
        if (this.list == null) {
            return false;
        }
        if (this.getThis() == this.prev) {
            this.list.head = null;
        } else {
            ((SortedLinkedListNode)this.next).prev = this.prev;
            ((SortedLinkedListNode)this.prev).next = this.next;
            if (this.isHeadNode()) {
                this.list.head = this.next;
            }
        }
        this.list.index.remove(this.getSequence());
        --this.list.size;
        this.list = null;
        return true;
    }

    private void addToIndex(T node, SortedLinkedList<T> list) {
        if (((SortedLinkedListNode)node).list != null) {
            throw new IllegalArgumentException("You only insert nodes that are not in a list");
        }
        SortedLinkedListNode old = (SortedLinkedListNode)list.index.put(((SortedLinkedListNode)node).getSequence(), node);
        if (old != null) {
            list.index.put(old.getSequence(), old);
            throw new IllegalArgumentException("A node with this key is already in the list");
        }
        ((SortedLinkedListNode)node).list = list;
        ++list.size;
    }

    private final void checkLinkOk(T toLink) {
        if (toLink == this) {
            throw new IllegalArgumentException("You cannot link to yourself");
        }
        if (this.list == null) {
            throw new IllegalArgumentException("This node is not yet in a list");
        }
    }

    protected void linkToHead(SortedLinkedList<T> target) {
        if (target.head == null) {
            this.addToIndex(this.getThis(), target);
            target.head = this.getThis();
            this.prev = target.head;
            this.next = target.head;
        } else {
            ((SortedLinkedListNode)target.head).linkBefore(this.getThis());
        }
    }

    protected void linkAfter(T node) {
        this.checkLinkOk(node);
        this.addToIndex(node, this.list);
        ((SortedLinkedListNode)node).prev = this.getThis();
        ((SortedLinkedListNode)node).next = this.next;
        ((SortedLinkedListNode)this.next).prev = node;
        this.next = node;
    }

    protected void linkBefore(T node) {
        this.checkLinkOk(node);
        this.addToIndex(node, this.list);
        ((SortedLinkedListNode)node).next = this.getThis();
        ((SortedLinkedListNode)node).prev = this.prev;
        ((SortedLinkedListNode)this.prev).next = node;
        this.prev = node;
        if (this == this.list.head) {
            this.list.head = node;
        }
    }

    public abstract long getSequence();

    public boolean isLinked() {
        return this.list != null;
    }

    public SortedLinkedList<T> getList() {
        return this.list;
    }
}

