/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.net.URLDecoder;
import java.util.HashSet;

public class OCFHandler
implements XMLHandler {
    XMLParser parser;
    static String rootPath;
    String rootBase = new String("");
    HashSet encryptedItemsSet = new HashSet();
    private boolean populateEncryptedItems = false;

    OCFHandler(XMLParser parser) {
        this.parser = parser;
    }

    public String getRootPath() {
        return rootPath;
    }

    public HashSet getEncryptedItems() {
        return this.encryptedItemsSet;
    }

    public void setPopulateEnryptedItems(boolean populateEncryptedItems) {
        this.populateEncryptedItems = populateEncryptedItems;
    }

    public void setRootBase(String rootBase) {
        this.rootBase = rootBase;
    }

    public void startElement() {
        String mediaType;
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        if (e.getName().equals("rootfile") && ns != null && ns.equals("urn:oasis:names:tc:opendocument:xmlns:container") && (mediaType = e.getAttribute("media-type")) != null && mediaType.equals("application/oebps-package+xml")) {
            rootPath = e.getAttribute("full-path");
        }
        if (this.populateEncryptedItems && e.getName().equals("CipherReference")) {
            try {
                String entryName = e.getAttribute("URI");
                entryName = this.stripPathFromURI(entryName);
                entryName = URLDecoder.decode(entryName, "UTF-8");
                this.encryptedItemsSet.add(entryName);
            }
            catch (Exception ex) {
                System.err.println("Error URL-decoding CipherReference entry");
                ex.printStackTrace();
            }
        }
    }

    public String stripPathFromURI(String URI2) {
        if (URI2.startsWith(this.rootBase)) {
            return URI2.substring(this.rootBase.length());
        }
        return URI2;
    }

    public void endElement() {
    }

    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    public void characters(char[] chars, int arg1, int arg2) {
    }

    public void processingInstruction(String arg0, String arg1) {
    }
}

