/*
 * Decompiled with CFR 0.152.
 */
package imp;

import ints.IndexArray;
import ints.IntArray;
import java.util.Arrays;
import vcf.GT;
import vcf.RefGT;
import vcf.RefGTRec;

public class HaplotypeCoder {
    private final int nRefHaps;
    private final int nHaps;
    private final RefGT ref;
    private final GT targ;

    public HaplotypeCoder(RefGT refGT, GT gT) {
        if (!refGT.markers().equals(gT.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        this.nRefHaps = refGT.nHaps();
        this.nHaps = this.nRefHaps + gT.nHaps();
        this.ref = refGT;
        this.targ = gT;
    }

    public RefGT refHapPairs() {
        return this.ref;
    }

    public GT targHapPairs() {
        return this.targ;
    }

    public IndexArray run(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException("start >= end");
        }
        if (HaplotypeCoder.isHapCoded(this.ref, n, n2)) {
            return this.codeSeqCodedRef(n, n2);
        }
        return this.codeSeq(n, n2);
    }

    private static boolean isHapCoded(RefGT refGT, int n, int n2) {
        RefGTRec refGTRec = refGT.get(n);
        if (refGTRec.isAlleleCoded()) {
            return false;
        }
        IntArray intArray = refGT.get(n).map(0);
        for (int i = n + 1; i < n2; ++i) {
            RefGTRec refGTRec2 = refGT.get(i);
            if (!refGTRec2.isAlleleCoded() && refGTRec2.map(0) == intArray) continue;
            return false;
        }
        return true;
    }

    private IndexArray codeTarg(int n, int[][] nArray) {
        int n2 = this.targ.nHaps();
        int[] nArray2 = new int[n2];
        Arrays.fill(nArray2, 1);
        int n3 = 2;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = n + i;
            int n5 = this.ref.marker(n4).nAlleles();
            nArray[i] = new int[n3 * n5];
            n3 = 1;
            for (int j = 0; j < n2; ++j) {
                int n6 = n5 * nArray2[j] + this.targ.allele(n4, j);
                if (nArray[i][n6] == 0) {
                    nArray[i][n6] = n3++;
                }
                nArray2[j] = nArray[i][n6];
            }
        }
        IntArray intArray = IntArray.create(nArray2, n3);
        return new IndexArray(intArray, n3);
    }

    private IndexArray codeSeqCodedRef(int n, int n2) {
        int[][] nArrayArray = new int[n2 - n][];
        IndexArray indexArray = this.codeTarg(n, nArrayArray);
        RefGTRec refGTRec = this.ref.get(n);
        assert (refGTRec.nMaps() == 2);
        IntArray intArray = refGTRec.map(1);
        int[] nArray = new int[intArray.size()];
        Arrays.fill(nArray, 1);
        for (int i = 0; i < nArrayArray.length; ++i) {
            int n3 = n + i;
            int n4 = this.ref.marker(n3).nAlleles();
            refGTRec = this.ref.get(n3);
            assert (refGTRec.nMaps() == 2);
            intArray = refGTRec.map(1);
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] <= 0) continue;
                int n5 = nArray[j] * n4 + intArray.get(j);
                nArray[j] = nArrayArray[i][n5];
            }
        }
        return this.combine(this.ref.get(n).map(0), nArray, indexArray);
    }

    private IndexArray combine(final IntArray intArray, final int[] nArray, IndexArray indexArray) {
        final IntArray intArray2 = indexArray.intArray();
        IntArray intArray3 = new IntArray(){

            @Override
            public int size() {
                return HaplotypeCoder.this.nHaps;
            }

            @Override
            public int get(int n) {
                if (n < HaplotypeCoder.this.nRefHaps) {
                    return nArray[intArray.get(n)];
                }
                return intArray2.get(n - HaplotypeCoder.this.nRefHaps);
            }
        };
        return new IndexArray(intArray3, indexArray.valueSize());
    }

    private IndexArray codeSeq(int n, int n2) {
        int[][] nArrayArray = new int[n2 - n][];
        IndexArray indexArray = this.codeTarg(n, nArrayArray);
        int[] nArray = new int[this.nRefHaps];
        Arrays.fill(nArray, 1);
        for (int i = 0; i < nArrayArray.length; ++i) {
            int n3 = n + i;
            int n4 = this.ref.marker(n3).nAlleles();
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] <= 0) continue;
                int n5 = nArray[j] * n4 + this.ref.allele(n3, j);
                nArray[j] = nArrayArray[i][n5];
            }
        }
        return this.combine(nArray, indexArray);
    }

    private IndexArray combine(final int[] nArray, IndexArray indexArray) {
        final IntArray intArray = indexArray.intArray();
        IntArray intArray2 = new IntArray(){

            @Override
            public int size() {
                return HaplotypeCoder.this.nHaps;
            }

            @Override
            public int get(int n) {
                if (n < HaplotypeCoder.this.nRefHaps) {
                    return nArray[n];
                }
                return intArray.get(n - HaplotypeCoder.this.nRefHaps);
            }
        };
        return new IndexArray(intArray2, indexArray.valueSize());
    }
}

