/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.DefaultSecurity;
import com.sun.media.DisabledSecurity;
import com.sun.media.IESecurity;
import com.sun.media.JDK12Security;
import com.sun.media.JMFSecurity;
import com.sun.media.NetscapeSecurity;
import com.sun.media.util.Registry;

public class JMFSecurityManager {
    private static JMFSecurity security = null;
    private static JMFSecurity enabledSecurity = null;
    private static SecurityManager securityManager;
    private static int count;
    public static final boolean DEBUG = false;
    private static boolean jdk12;
    private static final String STR_NOPERMCAPTURE = "No permission to capture from applets";
    private static final String STR_NOPERMFILE = "No permission to write files from applets";

    public static JMFSecurity getJMFSecurity() throws SecurityException {
        return security;
    }

    public static boolean isLinkPermissionEnabled() {
        if (security == null) {
            return true;
        }
        return security.isLinkPermissionEnabled();
    }

    public static void loadLibrary(String name) throws UnsatisfiedLinkError {
        try {
            JMFSecurity s = JMFSecurityManager.getJMFSecurity();
            if (s != null) {
                s.loadLibrary(name);
            } else {
                System.loadLibrary(name);
            }
        }
        catch (Throwable t) {
            throw new UnsatisfiedLinkError("JMFSecurityManager: " + t);
        }
    }

    public static synchronized void disableSecurityFeatures() {
        security = DisabledSecurity.security;
        ++count;
    }

    public static synchronized void enableSecurityFeatures() {
        if (--count <= 0) {
            security = enabledSecurity;
        }
    }

    public static void checkCapture() {
        if (security == null) {
            return;
        }
        Object captureFromApplets = Registry.get("secure.allowCaptureFromApplets");
        if (captureFromApplets == null || !(captureFromApplets instanceof Boolean) || !((Boolean)captureFromApplets).booleanValue()) {
            throw new RuntimeException(STR_NOPERMCAPTURE);
        }
    }

    public static void checkFileSave() {
        if (security == null) {
            return;
        }
        Object saveFromApplets = Registry.get("secure.allowSaveFileFromApplets");
        if (saveFromApplets == null || !(saveFromApplets instanceof Boolean) || !((Boolean)saveFromApplets).booleanValue()) {
            throw new RuntimeException(STR_NOPERMFILE);
        }
    }

    public static boolean isJDK12() {
        return jdk12;
    }

    static {
        count = 0;
        jdk12 = false;
        securityManager = System.getSecurityManager();
        boolean jdk11 = false;
        boolean msjvm = false;
        try {
            String javaVendor;
            String javaVersion = System.getProperty("java.version");
            if (!javaVersion.equals("")) {
                if (javaVersion.startsWith("1.1")) {
                    jdk11 = true;
                } else {
                    char c2 = javaVersion.charAt(0);
                    if (c2 >= '0' && c2 <= '9' && javaVersion.compareTo("1.2") >= 0) {
                        jdk12 = true;
                    }
                }
            }
            if ((javaVendor = System.getProperty("java.vendor", "Sun").toLowerCase()).indexOf("icrosoft") > 0) {
                msjvm = true;
            }
        }
        catch (Throwable t) {
            System.out.println(t);
        }
        if (securityManager != null) {
            if (securityManager.toString().indexOf("netscape") != -1) {
                security = NetscapeSecurity.security;
            } else if (securityManager.toString().indexOf("com.ms.security") != -1 || msjvm) {
                security = IESecurity.security;
            } else if (securityManager.toString().indexOf("sun.applet.AppletSecurity") != -1 || securityManager.toString().indexOf("sun.plugin.ActivatorSecurityManager") != -1) {
                if (jdk11) {
                    security = DefaultSecurity.security;
                }
                if (jdk12) {
                    security = JDK12Security.security;
                }
            } else if (securityManager.toString().indexOf("java.lang.SecurityManager") != -1) {
                if (jdk12) {
                    security = JDK12Security.security;
                }
            } else {
                security = jdk12 ? JDK12Security.security : DefaultSecurity.security;
            }
        }
        enabledSecurity = security;
    }
}

