/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import com.google.common.base.Strings;
import java.util.List;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.jvm.inspection.JavaInstallationCapability;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmToolchainMetadata;
import org.gradle.internal.logging.text.StyledTextOutput;

public class ToolchainReportRenderer
extends TextReportRenderer {
    private static final String DETECTED_TOOLCHAIN_INDENT = Strings.repeat((String)" ", (int)5);
    private static final String TOOLCHAIN_METADATA_INDENT = Strings.repeat((String)" ", (int)2);
    private static final int INVALID_TOOLCHAIN_ERROR_CAUSE_LIMIT = 5;

    public void printDetectedToolchain(JvmToolchainMetadata toolchain) {
        StyledTextOutput output = this.getTextOutput();
        JvmInstallationMetadata metadata = toolchain.metadata;
        String displayName = metadata.getDisplayName();
        output.withStyle(StyledTextOutput.Style.Identifier).println((Object)(" + " + displayName + " " + metadata.getRuntimeVersion()));
        this.printMetadata(DETECTED_TOOLCHAIN_INDENT, metadata);
        this.printAttribute(DETECTED_TOOLCHAIN_INDENT, "Detected by", toolchain.location.getSource());
        output.println();
    }

    public void printToolchainMetadata(JvmInstallationMetadata metadata) {
        StyledTextOutput output = this.getTextOutput();
        String displayName = metadata.getDisplayName();
        output.withStyle(StyledTextOutput.Style.Identifier).println((Object)(displayName + " " + metadata.getRuntimeVersion()));
        this.printMetadata(TOOLCHAIN_METADATA_INDENT, metadata);
        output.println();
    }

    private void printMetadata(String indent, JvmInstallationMetadata metadata) {
        this.printAttribute(indent, "Location", metadata.getJavaHome().toString());
        this.printAttribute(indent, "Language Version", metadata.getLanguageVersion().getMajorVersion());
        this.printAttribute(indent, "Vendor", metadata.getVendor().getDisplayName());
        this.printAttribute(indent, "Architecture", metadata.getArchitecture());
        this.printAttribute(indent, "Is JDK", String.valueOf(metadata.getCapabilities().containsAll(JavaInstallationCapability.JDK_CAPABILITIES)));
    }

    private void printAttribute(String indent, String key, String value) {
        String paddedKey = Strings.padEnd((String)(key + ":"), (int)20, (char)' ');
        this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("%s| %s", new Object[]{indent, paddedKey});
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println((Object)value);
    }

    public void printInvalidToolchains(List<JvmToolchainMetadata> invalidToolchains) {
        if (!invalidToolchains.isEmpty()) {
            StyledTextOutput output = this.getTextOutput();
            output.withStyle(StyledTextOutput.Style.Identifier).println((Object)" + Invalid toolchains");
            for (JvmToolchainMetadata toolchain : invalidToolchains) {
                JvmInstallationMetadata metadata = toolchain.metadata;
                output.withStyle(StyledTextOutput.Style.Identifier).println((Object)("     + " + metadata.getJavaHome()));
                this.printInvalidToolchainErrorLines(toolchain);
            }
            output.println();
        }
    }

    private void printInvalidToolchainErrorLines(JvmToolchainMetadata invalidToolchain) {
        this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("       | %s", new Object[]{Strings.padEnd((String)"Error:", (int)20, (char)' ')});
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println((Object)invalidToolchain.metadata.getErrorMessage());
        Throwable errorCause = invalidToolchain.metadata.getErrorCause();
        int reportedCauseLines = 0;
        for (Throwable cause = errorCause != null ? errorCause.getCause() : null; cause != null; cause = cause.getCause()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("       | %s", new Object[]{Strings.padEnd((String)"    Caused by:", (int)20, (char)' ')});
            this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println((Object)cause.getMessage());
            if (++reportedCauseLines != 5 || cause == null) continue;
            this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("       | %s", new Object[]{Strings.padEnd((String)"", (int)20, (char)' ')});
            this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println((Object)"...");
            break;
        }
    }
}

