/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiQualifiedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiThisExpression;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public final class ExpressionUtil {
    public static boolean isEffectivelyUnqualified(PsiReferenceExpression refExpression) {
        PsiExpression qualifier2 = PsiUtil.deparenthesizeExpression(refExpression.getQualifierExpression());
        if (qualifier2 == null) {
            return true;
        }
        if (qualifier2 instanceof PsiThisExpression || qualifier2 instanceof PsiSuperExpression) {
            PsiJavaCodeReferenceElement thisQualifier = ((PsiQualifiedExpression)qualifier2).getQualifier();
            if (thisQualifier == null) {
                return true;
            }
            PsiClass innerMostClass = PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiClass.class);
            return innerMostClass == thisQualifier.resolve();
        }
        return false;
    }
}

