/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.parosproxy.paros.common.AbstractParam;

public class ScannerParam
extends AbstractParam {
    private static final String SCANNER = "scanner";
    private static final String HOST_PER_SCAN = "scanner.hostPerScan";
    private static final String THREAD_PER_HOST = "scanner.threadPerHost";
    private int hostPerScan = 2;
    private int threadPerHost = 1;

    protected void parse() {
        try {
            this.setThreadPerHost(this.getConfig().getInt(THREAD_PER_HOST, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setHostPerScan(this.getConfig().getInt(HOST_PER_SCAN, 2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getThreadPerHost() {
        return this.threadPerHost;
    }

    public void setThreadPerHost(int n) {
        this.threadPerHost = n;
        this.getConfig().setProperty(THREAD_PER_HOST, Integer.toString(this.threadPerHost));
    }

    public int getHostPerScan() {
        return this.hostPerScan;
    }

    public void setHostPerScan(int n) {
        this.hostPerScan = n;
        this.getConfig().setProperty(HOST_PER_SCAN, Integer.toString(this.hostPerScan));
    }
}

