#   Copyright (C) 1987-2007 by Jeffery P. Hansen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Last edit by hansen on Tue Feb 24 14:06:55 2004
#

#############################################################################
#
# Drag-and-drop functions
#
namespace eval Dragger {
  variable drag_w
  variable W
  variable H
  variable command
  variable absolute
  variable grabpoint

  proc setGeometry {X Y} {
    variable drag_w
    variable W
    variable H
    variable grabpoint

    if { [llength $grabpoint] < 2 } {
      wm geometry $drag_w +[expr ${X} - $W/2]+[expr ${Y} - 3*$H/4]
    } else {
      set dx [lindex $grabpoint 0]
      set dy [lindex $grabpoint 1]
      wm geometry $drag_w +[expr ${X} - $dx]+[expr ${Y} - $dy]
    }
  }


  proc windowConfigure {} {
    variable drag_w
    variable W
    variable H

    scan [winfo pointerxy .] "%d %d" X Y

    set W [winfo width $drag_w]
    set H [winfo height $drag_w]

    updatePosition $X $Y
  }

  proc updatePosition {X Y} {
    setGeometry $X $Y
  }

  proc drop {w x y} {
    variable command
    variable absolute

    destroy $w
    if { $command != "" } {
      update
      set w [winfo containing $x $y]

      if { $w == "" } {
	eval "$command \"\" $x $y"
      } else {
	if { ! $absolute } {
	  set x [expr $x - [winfo rootx $w]]
	  set y [expr $y - [winfo rooty $w]]
	}
	eval "$command $w $x $y"
      }
    }
  }

  proc make {args} {
    variable drag_w
    variable W
    variable H
    variable command
    variable absolute
    variable grabpoint

    set command ""
    set absolute 0
    set grabpoint 0
    parseargs $args {-command -absolute -grabpoint}

    set W 10
    set H 10

    set drag_w .dragger
    set w $drag_w
    if {[catch { toplevel $w -cursor arrow } xx]} {
      return ""
    }

    scan [winfo pointerxy .] "%d %d" X Y

    setGeometry $X $Y
    wm overrideredirect $w 1

    bind $w <ButtonRelease-1> "Dragger::drop $w %X %Y"
    bind $w <B1-Motion> { Dragger::updatePosition %X %Y}
    bind $w <Configure> { Dragger::windowConfigure }

    update
    if {[catch { grab -global $w } xx]} {
      destroy $w
      return ""
    }

    return $w
  }
}
