<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xt="http://www.jclark.com/xt"
		version="1.0"
                extension-element-prefixes="xt">

<xsl:template match="slides">
  <xsl:apply-templates select="slide"/>
</xsl:template>

<xsl:output method="text"/>

<xsl:template match="slide">
  <xsl:text>Created file </xsl:text>
  <xsl:value-of select="concat(@name,'.htm')"/>
  <xsl:text>&#xA;</xsl:text>
  <xt:document method="html" href="{concat(@name,'.htm')}">
    <html>
      <head>
	<title><xsl:value-of select="@name"/></title>
      </head>
      <body>
	 <xsl:apply-templates/>
	 <xsl:if test="preceding-sibling::slide">
	   <p><a href="{preceding-sibling::slide[1]/@name}.htm">Prev</a></p>
	 </xsl:if>
	 <xsl:if test="following-sibling::slide">
	   <p><a href="{following-sibling::slide[1]/@name}.htm">Next</a></p>
	 </xsl:if>
      </body>
    </html>
  </xt:document>
</xsl:template>

<xsl:template match="*|@*">
  <xsl:copy>
    <xsl:apply-templates select="@*"/>
    <xsl:apply-templates select="node()"/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>
