# Copyright (C) 2009 Canonical Ltd
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

from PyQt4 import QtCore, QtGui

from bzrlib.plugins.qbzr.lib import getnew
from bzrlib.plugins.qbzr.lib.util import get_qbzr_config


class QCheckoutExplorerStyleDialog(getnew.GetNewWorkingTreeWindow):
    """A custom checkout dialog for Bazaar Explorer.

    The implementation reuses the dialog used for "qgetnew" so it's
    rather fragile. It would be good to move this down into QBzr
    assuming the UI design was acceptable to the QBzr developers.
    """

    def __init__(self, branch_location=None, to_location=None, revision=None,
        dialog=True, ui_mode=True, parent=None):
        config = get_qbzr_config()
        checkout_basedir = config.get_option("checkout_basedir")
        branchsource_basedir = config.get_option("branchsource_basedir")
        if to_location is None:
            to_location = checkout_basedir or u'.'
        super(QCheckoutExplorerStyleDialog, self).__init__(
            to_location, ui_mode=ui_mode, parent=parent)

        # Hide the options group box - checkouts are always lightweight in
        # explorer. If users want a heavyweight checkout, they need to use
        # the Branch dialog and bind the branch instead.
        self.ui.groupBox_3.setVisible(False)
        self.ui.but_lightweight.setChecked(True)

        # Init the controls
        if branch_location:
            # XXX: We really shouldn't set this via the lineEdit control but
            # insertItem isn't working as I expected. Maybe a different
            # QComboBox API is required instead?
            #self.ui.from_location.insertItem(0, branch_location)
            self.ui.from_location.lineEdit().setText(branch_location)
            self.ui.to_location.setFocus()
        elif branchsource_basedir is not None:
            self.ui.from_location.lineEdit().setText(branchsource_basedir)
            self.ui.to_location.setFocus()
        else:
            self.ui.from_location.setFocus()
        if revision:
            self.ui.but_rev_specific.setChecked(True)
            self.ui.revision.setText(revision)

    def get_to_location(self):
        """The path the checkout was created in."""
        # This is used by explorer to find the location to open on completion
        # TODO: return None if the command failed
        return unicode(self.ui.to_location.text())
