/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.maximizing;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.flexdock.demos.maximizing.DockableSimpleInternalFrame;
import org.flexdock.demos.maximizing.MyDockingPort;
import org.flexdock.demos.maximizing.SimpleInternalFrame;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.util.SwingUtility;

public class MaximizationDemo {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
        boolean loaded = MaximizationDemo.configureDocking();
        JFrame frame = new JFrame("FlexPortalMaximized");
        frame.setContentPane(MaximizationDemo.createContentPane(loaded));
        DemoUtility.setCloseOperation(frame);
        frame.setSize(500, 500);
        SwingUtility.centerOnScreen(frame);
        frame.setVisible(true);
    }

    private static boolean configureDocking() {
        DockingManager.setFloatingEnabled(false);
        return false;
    }

    private static JComponent createContentPane(boolean loaded) {
        MyDockingPort dockingPort = new MyDockingPort();
        Dockable topComp = MaximizationDemo.createFramePanel("Top");
        DockingManager.registerDockable(topComp);
        DockingManager.dock(topComp, (DockingPort)dockingPort, "CENTER");
        Dockable south = MaximizationDemo.createFramePanel("South");
        DockingManager.registerDockable(south);
        DockingManager.dock(south, topComp, "SOUTH", 0.3f);
        Dockable west = MaximizationDemo.createFramePanel("West");
        DockingManager.registerDockable(west);
        DockingManager.dock(west, topComp, "WEST", 0.5f);
        Dockable l2South = MaximizationDemo.createFramePanel("South of West");
        DockingManager.registerDockable(l2South);
        DockingManager.dock(l2South, west, "SOUTH", 0.33f);
        Dockable east = MaximizationDemo.createFramePanel("East");
        DockingManager.registerDockable(east);
        DockingManager.dock(east, topComp, "EAST", 0.2f);
        return dockingPort;
    }

    private static Dockable createFramePanel(String title) {
        JLabel label = new JLabel("Content of " + title);
        JButton maxButton = MaximizationDemo.createButton(MaximizationDemo.createIcon("maximize.gif"));
        JToolBar toolbar = MaximizationDemo.createPortletToolbar(maxButton);
        SimpleInternalFrame sif = new SimpleInternalFrame(title, toolbar, label);
        final DockableSimpleInternalFrame dockable = new DockableSimpleInternalFrame(sif);
        maxButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DockingManager.toggleMaximized(dockable);
            }
        });
        return dockable;
    }

    private static JButton createButton(Icon icon) {
        JButton button = new JButton(icon);
        button.setFocusable(false);
        return button;
    }

    private static JToolBar createPortletToolbar(JButton maxButton) {
        JToolBar toolbar = new JToolBar();
        toolbar.add(maxButton);
        toolbar.setFloatable(false);
        toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        return toolbar;
    }

    private static Icon createIcon(String icon) {
        return new ImageIcon(MaximizationDemo.createImageImpl(icon));
    }

    private static Image createImageImpl(String resourceName) {
        URL iconURL = MaximizationDemo.class.getResource(resourceName);
        if (iconURL == null) {
            throw new RuntimeException("Could not find: " + resourceName);
        }
        return Toolkit.getDefaultToolkit().createImage(iconURL);
    }
}

