/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.AddFileDialog;
import com.gallery.GalleryRemote.CoreUtils;
import com.gallery.GalleryRemote.DroppableList;
import com.gallery.GalleryRemote.GRApplet;
import com.gallery.GalleryRemote.GalleryComm2_5;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.GalleryRemoteCore;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusBar;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.ThumbnailCache;
import com.gallery.GalleryRemote.UploadProgress;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GRAppletMini
extends GRApplet
implements GalleryRemoteCore,
ActionListener,
DocumentListener,
ListSelectionListener,
PreferenceNames {
    public static final String MODULE = "AppletMini";
    JButton jUpload;
    JButton jAdd;
    StatusBar jStatusBar;
    JScrollPane jScrollPane;
    DroppableList jPicturesList;
    JCheckBox jResize;
    JCheckBox jThumbnails;
    JPanel jInspector;
    JLabel captionLabel;
    JTextArea jCaption;
    JSplitPane jDivider;
    ArrayList jExtrafields;
    DefaultComboBoxModel galleries = null;
    Album album = null;
    Gallery gallery = null;
    boolean inProgress = false;
    boolean hasHadPictures = false;
    Method call;
    Object window;
    ThumbnailCache thumbnailCache = null;
    static /* synthetic */ Class class$java$applet$Applet;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public GRAppletMini() {
        this.coreClass = "com.gallery.GalleryRemote.GalleryRemoteMini";
    }

    public void initUI() {
        SwingUtilities.updateComponentTreeUI(this);
        int appletFontSize = GalleryRemote._().properties.getIntProperty("appletFontSize", 0);
        if (appletFontSize != 0) {
            Log.log(3, MODULE, "Overriding font size to " + appletFontSize);
            Log.log(3, MODULE, "Default font size " + UIManager.getFont("TitledBorder.font").getSize());
            Font f = UIManager.getFont("TitledBorder.font").deriveFont((float)appletFontSize);
            Log.log(3, MODULE, "Checking font size " + f.getSize());
            UIManager.put("Label.font", f);
            UIManager.put("TextField.font", f);
            UIManager.put("Button.font", f);
            UIManager.put("CheckBox.font", f);
            UIManager.put("ComboBox.font", f);
            UIManager.put("TitledBorder.font", f);
            UIManager.put("TabbedPane.font", f);
        }
        this.jbInit();
    }

    public void startup() {
        this.galleries = new DefaultComboBoxModel();
        GRApplet.AppletInfo info = this.getGRAppletInfo();
        this.gallery = info.gallery;
        this.galleries.addElement(this.gallery);
        ImageUtils.deferredTasks();
        this.album = new Album(this.gallery);
        this.album.setName(info.albumName);
        this.gallery.createRootAlbum().add(this.album);
        this.album.fetchAlbumProperties(this.getMainStatusUpdate());
        this.jbUpdate();
        this.jPicturesList.setModel(this.album);
        this.jPicturesList.setInputMap(1, null);
        this.jPicturesList.setInputMap(0, null);
        this.jPicturesList.setInputMap(2, null);
        this.jPicturesList.setCellRenderer(new CoreUtils.FileCellRenderer());
        this.jResize.setSelected(GalleryRemote._().properties.getBooleanProperty("resizeBeforeUpload"));
        this.jThumbnails.setSelected(GalleryRemote._().properties.getShowThumbnails());
        this.setShowThumbnails(GalleryRemote._().properties.getShowThumbnails());
        this.jStatusBar.setStatus(GRI18n.getString("MainFrame", "selPicToAdd"));
    }

    public void shutdown() {
        if (this.hasStarted && GalleryRemote._() != null) {
            if (this.jDivider != null) {
                GalleryRemote._().properties.setIntProperty("appletDividerLocation", this.jDivider.getDividerLocation());
            }
            ImageUtils.purgeTemp();
            GalleryRemote._().properties.write();
            GalleryRemote.shutdownInstance();
        }
    }

    public void shutdown(boolean shutdownOs) {
        this.shutdown();
    }

    public void flushMemory() {
    }

    public void preloadThumbnails(Iterator pictures) {
        if (this.thumbnailCache != null) {
            this.thumbnailCache.preloadThumbnails(pictures);
        }
    }

    public Image getThumbnail(Picture p) {
        if (p == null) {
            return null;
        }
        Image thumb = this.thumbnailCache.getThumbnail(p);
        thumb = thumb == null ? ImageUtils.defaultThumbnail : ImageUtils.rotateImage(thumb, p.getAngle(), p.isFlipped(), this.getGlassPane());
        return thumb;
    }

    public StatusUpdate getMainStatusUpdate() {
        return this.jStatusBar;
    }

    public DefaultComboBoxModel getGalleries() {
        return this.galleries;
    }

    public void thumbnailLoadedNotify() {
        this.jPicturesList.repaint();
    }

    public void setInProgress(boolean inProgress) {
        this.jUpload.setEnabled(!inProgress);
        this.jAdd.setEnabled(!inProgress);
        this.jPicturesList.setEnabled(!inProgress);
        this.jCaption.setEnabled(!inProgress);
        this.jResize.setEnabled(!inProgress);
        this.jThumbnails.setEnabled(!inProgress);
        this.inProgress = inProgress;
        if (!inProgress && this.hasHadPictures) {
            try {
                if (!(this.gallery.getComm(null) instanceof GalleryComm2_5) && this.gallery.getType() != 99) {
                    this.getAppletContext().showDocument(new URL(this.getCodeBase().toString() + "add_photos_refresh.php"), "hack");
                }
                this.g2Feedback("doneUploading", new Object[0]);
            }
            catch (MalformedURLException e) {
                Log.logException(1, MODULE, e);
            }
            this.hasHadPictures = false;
        }
    }

    public void addPictures(File[] files, int index, boolean select) {
        ArrayList newPictures = null;
        newPictures = index == -1 ? this.album.addPictures(files) : this.album.addPictures(files, index);
        this.preloadThumbnails(newPictures.iterator());
    }

    public void addPictures(Picture[] pictures, int index, boolean select) {
        this.album.addPictures(Arrays.asList(pictures), index);
    }

    public Album getCurrentAlbum() {
        return this.album;
    }

    public JList getPicturesList() {
        return this.jPicturesList;
    }

    protected void jbInit() {
        this.jUpload = new JButton();
        this.jAdd = new JButton();
        this.jStatusBar = new StatusBar(75);
        this.jScrollPane = new JScrollPane();
        this.jPicturesList = new DroppableList();
        this.jResize = new JCheckBox();
        this.jThumbnails = new JCheckBox();
        this.jInspector = new JPanel(new GridBagLayout());
        this.captionLabel = new JLabel();
        this.jCaption = new JTextArea();
        this.jDivider = new JSplitPane(1);
        this.jScrollPane.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), GRI18n.getString(MODULE, "pictures")));
        this.jUpload.setText(GRI18n.getString(MODULE, "Upload"));
        this.jAdd.setText(GRI18n.getString(MODULE, "Add"));
        JPanel jButtonPanel = new JPanel();
        jButtonPanel.setLayout(new GridLayout(2, 2, 5, 0));
        jButtonPanel.add(this.jThumbnails);
        jButtonPanel.add(this.jResize);
        jButtonPanel.add(this.jAdd);
        jButtonPanel.add(this.jUpload);
        this.jResize.setToolTipText(GRI18n.getString(MODULE, "ResizeBeforeUploadHelp"));
        this.jResize.setText(GRI18n.getString(MODULE, "ResizeBeforeUpload"));
        this.jThumbnails.setToolTipText(GRI18n.getString(MODULE, "ThumbnailsHelp"));
        this.jThumbnails.setText(GRI18n.getString(MODULE, "Thumbnails"));
        this.captionLabel.setText(GRI18n.getString(MODULE, "Caption") + "            ");
        this.jScrollPane.getViewport().add((Component)this.jPicturesList, null);
        if (!GalleryRemote._().properties.getBooleanProperty("appletShowResize", true)) {
            this.jResize.setVisible(false);
        }
        this.jCaption.setLineWrap(true);
        this.jCaption.setEditable(false);
        this.jCaption.setFont(UIManager.getFont("Label.font"));
        this.jCaption.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jDivider.setBorder(null);
        this.jDivider.setOneTouchExpandable(true);
        this.jDivider.setDividerLocation(GalleryRemote._().properties.getIntProperty("appletDividerLocation"));
        this.jScrollPane.setMinimumSize(new Dimension(100, 0));
        this.jInspector.setMinimumSize(new Dimension(0, 0));
        this.jDivider.setLeftComponent(this.jScrollPane);
        this.jDivider.setRightComponent(this.jInspector);
        this.jInspector.add((Component)this.captionLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.jInspector.add((Component)this.jCaption, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.jDivider, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)jButtonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.jStatusBar, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jAdd.addActionListener(this);
        this.jUpload.addActionListener(this);
        this.jCaption.getDocument().addDocumentListener(this);
        this.jPicturesList.addListSelectionListener(this);
        this.jResize.addActionListener(this);
        this.jThumbnails.addActionListener(this);
        this.jPicturesList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                GRAppletMini.this.jListKeyPressed(e);
            }
        });
        try {
            Class<?> jsObject = Class.forName("netscape.javascript.JSObject");
            Method getWindow = jsObject.getMethod("getWindow", class$java$applet$Applet == null ? (class$java$applet$Applet = GRAppletMini.class$("java.applet.Applet")) : class$java$applet$Applet);
            this.call = jsObject.getMethod("call", class$java$lang$String == null ? (class$java$lang$String = GRAppletMini.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = GRAppletMini.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            this.window = getWindow.invoke(null, this);
        }
        catch (ClassNotFoundException e) {
            Log.logException(1, MODULE, e);
        }
        catch (IllegalAccessException e) {
            Log.logException(1, MODULE, e);
        }
        catch (NoSuchMethodException e) {
            Log.logException(1, MODULE, e);
        }
        catch (InvocationTargetException e) {
            Log.logException(1, MODULE, e);
        }
        this.thumbnailCache = new ThumbnailCache();
    }

    public void jbUpdate() {
        ArrayList extrafields = this.album.getExtraFields();
        if (extrafields != null) {
            this.jExtrafields = new ArrayList(extrafields.size());
            Iterator i = extrafields.iterator();
            int j = 2;
            while (i.hasNext()) {
                String name = (String)i.next();
                JTextArea jExtrafield = new JTextArea();
                jExtrafield.setName(name);
                this.jExtrafields.add(jExtrafield);
                jExtrafield.setLineWrap(true);
                jExtrafield.setEditable(false);
                jExtrafield.setFont(UIManager.getFont("Label.font"));
                jExtrafield.setBackground(UIManager.getColor("TextField.inactiveBackground"));
                this.jInspector.add((Component)new JLabel(name + ":"), new GridBagConstraints(0, j++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
                this.jInspector.add((Component)jExtrafield, new GridBagConstraints(0, j++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
                jExtrafield.getDocument().addDocumentListener(this);
            }
        }
    }

    public void jListKeyPressed(KeyEvent e) {
        if (!this.inProgress) {
            int vKey = e.getKeyCode();
            Log.log(3, MODULE, "Key pressed: " + vKey);
            switch (vKey) {
                case 8: 
                case 127: {
                    CoreUtils.deleteSelectedPictures();
                    break;
                }
                case 37: {
                    CoreUtils.movePicturesUp();
                    break;
                }
                case 39: {
                    CoreUtils.movePicturesDown();
                    break;
                }
                case 38: {
                    CoreUtils.selectPrevPicture();
                    break;
                }
                case 40: {
                    CoreUtils.selectNextPicture();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.jAdd) {
            this.jStatusBar.setStatus(GRI18n.getString("MainFrame", "selPicToAdd"));
            File[] files = AddFileDialog.addFiles(this);
            if (files != null) {
                this.addPictures(files, -1, false);
                this.hasHadPictures = true;
            }
        } else if (source == this.jUpload) {
            this.g2Feedback("startingUpload", new Object[0]);
            this.gallery.doUploadFiles(new UploadProgress(DialogUtil.findParentWindow(this)){

                public void doneUploading(String newItemName, Picture picture) {
                    GRAppletMini.this.g2Feedback("uploadedOne", new Object[]{newItemName, picture.toString()});
                }
            });
        } else if (source == this.jResize) {
            GalleryRemote._().properties.setBooleanProperty("resizeBeforeUpload", this.jResize.isSelected());
        } else if (source == this.jThumbnails) {
            this.setShowThumbnails(this.jThumbnails.isSelected());
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.textUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textUpdate(e);
    }

    public void textUpdate(DocumentEvent e) {
        Picture p = (Picture)this.jPicturesList.getSelectedValue();
        if (p != null) {
            if (e.getDocument() == this.jCaption.getDocument()) {
                p.setCaption(this.jCaption.getText());
            } else {
                Iterator i = this.jExtrafields.iterator();
                while (i.hasNext()) {
                    JTextArea jExtrafield = (JTextArea)i.next();
                    if (e.getDocument() != jExtrafield.getDocument()) continue;
                    p.setExtraField(jExtrafield.getName(), jExtrafield.getText());
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Picture p = (Picture)this.jPicturesList.getSelectedValue();
        if (p == null) {
            this.jCaption.setText("");
            this.jCaption.setEditable(false);
            this.jCaption.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            Iterator i = this.jExtrafields.iterator();
            while (i.hasNext()) {
                JTextArea jExtrafield = (JTextArea)i.next();
                jExtrafield.setText("");
                jExtrafield.setEditable(false);
                jExtrafield.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            }
        } else {
            this.jCaption.setText(p.getCaption());
            this.jCaption.setEditable(true);
            this.jCaption.setBackground(UIManager.getColor("TextField.background"));
            Iterator i = this.jExtrafields.iterator();
            while (i.hasNext()) {
                JTextArea jExtrafield;
                String extrafield = p.getExtraField((jExtrafield = (JTextArea)i.next()).getName());
                jExtrafield.setText(extrafield == null ? "" : extrafield);
                jExtrafield.setEditable(true);
                jExtrafield.setBackground(UIManager.getColor("TextField.background"));
            }
        }
    }

    public void setShowThumbnails(boolean show) {
        if (show != GalleryRemote._().properties.getShowThumbnails()) {
            GalleryRemote._().properties.setShowThumbnails(show);
        }
        if (show) {
            this.preloadThumbnails(this.album.getPictures());
            this.jPicturesList.setFixedCellHeight(GalleryRemote._().properties.getThumbnailSize().height + 4);
        } else {
            if (this.thumbnailCache != null) {
                this.thumbnailCache.cancelLoad();
            }
            this.jPicturesList.setFixedCellHeight(-1);
        }
        this.jPicturesList.repaint();
    }

    public void g2Feedback(String method, Object[] params) {
        if (this.gallery.getGalleryVersion() == 2) {
            try {
                Log.log(3, MODULE, "Invoking Javascript method '" + method + "' with " + Arrays.asList(params) + " on " + this.window);
                this.call.invoke(this.window, method, params);
            }
            catch (Throwable e) {
                Log.logException(1, MODULE, e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

