/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.PlatformUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AWTUtilities {
    public static void centerWindow(Window window, Component component) {
        window.pack();
        Dimension dimension = window.getSize();
        Rectangle rectangle = component == null || !component.isShowing() ? AWTUtilities.getUsableScreenBounds() : new Rectangle(component.getLocationOnScreen(), component.getSize());
        window.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
        AWTUtilities.forceToScreen(window);
    }

    public static void forceToScreen(Window window) {
        Dimension dimension = window.getToolkit().getScreenSize();
        Rectangle rectangle = window.getBounds();
        rectangle.width = Math.min(rectangle.width, dimension.width);
        rectangle.height = Math.min(rectangle.height, dimension.height);
        rectangle.x = Math.min(Math.max(rectangle.x, 0), dimension.width - rectangle.width);
        rectangle.y = Math.min(Math.max(rectangle.y, 0), dimension.height - rectangle.height);
        window.setBounds(rectangle);
    }

    public static Frame frameForComponent(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static String[] getAvailableFontNames() {
        if (PlatformUtils.isJavaBetterThan("1.2")) {
            try {
                Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
                Method method = clazz.getMethod("getLocalGraphicsEnvironment", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Method method2 = clazz.getMethod("getAvailableFontFamilyNames", new Class[0]);
                String[] stringArray = (String[])method2.invoke(object, new Object[0]);
                return stringArray;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            return null;
        }
        return Toolkit.getDefaultToolkit().getFontList();
    }

    public static int getExtendedFrameState(Frame frame) {
        if (PlatformUtils.isJavaBetterThan("1.4")) {
            try {
                Class<?> clazz = Class.forName("java.awt.Frame");
                Method method = clazz.getMethod("getExtendedState", new Class[0]);
                Integer n = (Integer)method.invoke((Object)frame, new Object[0]);
                return n;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return 0;
    }

    public static void setExtendedFrameState(Frame frame, int n) {
        if (PlatformUtils.isJavaBetterThan("1.4")) {
            try {
                Class<?> clazz = Class.forName("java.awt.Frame");
                Method method = clazz.getMethod("setExtendedState", Integer.TYPE);
                method.invoke((Object)frame, new Integer(n));
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public static Rectangle getUsableScreenBounds() {
        if (PlatformUtils.isJavaBetterThan("1.4")) {
            try {
                Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
                Class<?> clazz2 = Class.forName("java.awt.GraphicsDevice");
                Class<?> clazz3 = Class.forName("java.awt.GraphicsConfiguration");
                Class[] classArray = new Class[]{};
                Method method = clazz.getMethod("getLocalGraphicsEnvironment", classArray);
                Method method2 = clazz.getMethod("getDefaultScreenDevice", classArray);
                Method method3 = clazz2.getMethod("getDefaultConfiguration", classArray);
                Method method4 = clazz3.getMethod("getBounds", classArray);
                Method method5 = Toolkit.class.getMethod("getScreenInsets", clazz3);
                Object[] objectArray = new Object[]{};
                Object object = method.invoke(null, objectArray);
                Object object2 = method2.invoke(object, objectArray);
                Object object3 = method3.invoke(object2, objectArray);
                Rectangle rectangle = (Rectangle)method4.invoke(object3, objectArray);
                Insets insets = (Insets)method5.invoke((Object)Toolkit.getDefaultToolkit(), object3);
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
                return rectangle;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
    }

    public static void setContainerEnabled(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            component.setEnabled(bl);
            if (!(component instanceof Container)) continue;
            AWTUtilities.setContainerEnabled((Container)component, bl);
        }
    }
}

