/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class CheckedInputStream
extends FilterInputStream {
    private Checksum sum;

    public Checksum getChecksum() {
        return this.sum;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            this.sum.update(n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1) {
            this.sum.update(byArray, n, n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        if (l == 0L) {
            return 0L;
        }
        int n = (int)Math.min(l, 1024L);
        byte[] byArray = new byte[n];
        long l2 = 0L;
        while (l > 0L) {
            int n2 = this.in.read(byArray, 0, n);
            if (n2 == -1) break;
            l2 += (long)n2;
            n = (int)Math.min(l -= (long)n2, 1024L);
            this.sum.update(byArray, 0, n2);
        }
        return l2;
    }

    public CheckedInputStream(InputStream inputStream, Checksum checksum) {
        super(inputStream);
        this.sum = checksum;
    }
}

